/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.accessibility;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ObjectInsertedEvent;
import ilog.views.event.ObjectRemovedEvent;
import ilog.views.event.ObjectVisibilityChangedEvent;
import ilog.views.util.collections.IlvSelectiveIterator;
import ilog.views.util.collections.IlvUnaryPredicate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleRole;
import oracle.diagram.core.util.AccessibilityPredicate;
import oracle.diagram.framework.accessibility.AccessibleGraphic;
import oracle.diagram.framework.accessibility.AccessibleManager;
import oracle.diagram.framework.accessibility.AccessibleManagerView;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.manager.VisibleObjectsIterator;

public class AccessibleDiagramManager
extends AccessibleManager {
    private final ManagerContentChangedListener _mgrListener = new ManagerChangeListener();
    private final Map<IlvGraphic, AccessibleGraphic> _cache = new HashMap<IlvGraphic, AccessibleGraphic>(1365);
    private final LinkedList<AccessibleGraphic> _children = new LinkedList();
    private boolean _childrenDirty;

    public AccessibleDiagramManager(AccessibleManagerView view, IlvManager manager) {
        super(view, manager);
        manager.addManagerTreeContentChangedListener(this._mgrListener);
        this._childrenDirty = true;
    }

    public AccessibleGraphic getAccessibleGraphic(IlvGraphic g) {
        this.update();
        return this._cache.get(g);
    }

    private void update() {
        if (this._childrenDirty) {
            this._cache.clear();
            this._children.clear();
            IlvSelectiveIterator iterator = new IlvSelectiveIterator((Iterator)new VisibleObjectsIterator(this.getManager()), (IlvUnaryPredicate)new AccessibilityPredicate());
            while (iterator.hasNext()) {
                IlvGraphic child = (IlvGraphic)iterator.next();
                AccessibleDiagramGraphic achild = new AccessibleDiagramGraphic(this.getView(), child);
                this._cache.put(child, achild);
                this._children.add(achild);
            }
            this._childrenDirty = false;
        }
    }

    @Override
    public int getAccessibleChildrenCount() {
        this.update();
        return this._children.size();
    }

    @Override
    public Accessible getAccessibleChild(int indexInParent) {
        this.update();
        if (indexInParent < this._children.size()) {
            return this._children.get(indexInParent);
        }
        return null;
    }

    @Override
    public Accessible getAccessibleParent() {
        return this.getView();
    }

    @Override
    public int getAccessibleIndexInParent() {
        return 0;
    }

    @Override
    protected boolean isSelected() {
        return false;
    }

    @Override
    protected boolean isSelectable() {
        return false;
    }

    private class ManagerChangeListener
    implements ManagerContentChangedListener {
        private boolean _dirty = false;

        private ManagerChangeListener() {
        }

        public void contentsChanged(ManagerContentChangedEvent event) {
            if (!this._dirty) {
                if (event.getType() == 1 && !Boolean.TRUE.equals(((ObjectInsertedEvent)event).getGraphicObject().getProperty("Interaction.temporaryGraphic"))) {
                    this._dirty = true;
                } else if (event.getType() == 2 && !Boolean.TRUE.equals(((ObjectRemovedEvent)event).getGraphicObject().getProperty("Interaction.temporaryGraphic"))) {
                    this._dirty = true;
                } else if (event.getType() == 8 && !Boolean.TRUE.equals(((ObjectVisibilityChangedEvent)event).getGraphicObject().getProperty("Interaction.temporaryGraphic"))) {
                    this._dirty = true;
                }
            }
            if ((!event.isAdjusting() || event.getType() == 32) && this._dirty) {
                AccessibleDiagramManager.this._childrenDirty = true;
                this._dirty = false;
            }
        }
    }

    private class AccessibleDiagramGraphic
    extends AccessibleGraphic {
        public AccessibleDiagramGraphic(AccessibleManagerView view, IlvGraphic graphic) {
            super(view, graphic);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        @Override
        public Accessible getAccessibleParent() {
            return this.getView();
        }

        @Override
        public int getAccessibleIndexInParent() {
            for (int i = 0; i < AccessibleDiagramManager.this._children.size(); ++i) {
                if (this.getGraphic() != AccessibleDiagramManager.this._children.get(i).getGraphic()) continue;
                return i;
            }
            return -1;
        }

        @Override
        protected boolean isSelected() {
            IlvGraphic g = this.getGraphic();
            IlvManager mgr = ManagerUtil.getManager(g);
            return mgr != null && mgr.isVisible(g) && (mgr.isSelected(g) || ManagerUtil.getTopManager(g).isSelected(g));
        }

        @Override
        protected boolean isSelectable() {
            IlvGraphic g = this.getGraphic();
            IlvManager mgr = (IlvManager)g.getGraphicBag();
            return mgr != null && mgr.isVisible(g) && mgr.isSelectable(g);
        }
    }
}

