/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.dif;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.diagram.dif.CoreSemanticModelBridge;
import oracle.diagram.dif.Diagram;
import oracle.diagram.dif.DiagramElement;
import oracle.diagram.dif.DiagramElementVisitor;
import oracle.diagram.dif.GraphElement;
import oracle.diagram.dif.SemanticModelBridge;

public class DIFUtils {
    private DIFUtils() {
    }

    public static void checkValidFloat(float value) {
        if (Float.isInfinite(value) || Float.isNaN(value)) {
            throw new IllegalArgumentException("Invalid float value");
        }
    }

    public static void checkValidDouble(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new IllegalArgumentException("Invalid double value");
        }
    }

    public static void visitDiagram(Diagram diagram, DiagramElementVisitor visitor) {
        if (diagram == null) {
            throw new IllegalArgumentException("diagram is null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor is null");
        }
        try {
            ElementVisitor diagramNodeVisitor = new ElementVisitor();
            diagramNodeVisitor.visitNode(diagram, visitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Set<String> getCoreSemanticBridgeElements(Diagram diagram) {
        HashSet<String> elements = new HashSet<String>(20);
        SemanticElementCollector sec = new SemanticElementCollector(elements);
        DIFUtils.visitDiagram(diagram, sec);
        return elements;
    }

    private static class ElementVisitor {
        private ElementVisitor() {
        }

        public void visitNode(DiagramElement element, DiagramElementVisitor visitor) {
            if (element != null) {
                visitor.visit(element);
                if (element instanceof GraphElement) {
                    GraphElement graphElement = (GraphElement)element;
                    Iterator<DiagramElement> elements = graphElement.getContained();
                    while (elements.hasNext()) {
                        DiagramElement diagramElement = elements.next();
                        this.visitNode(diagramElement, visitor);
                    }
                }
            }
        }
    }

    private static class SemanticElementCollector
    implements DiagramElementVisitor {
        private Set<String> m_elements;

        SemanticElementCollector(Set<String> elements) {
            this.m_elements = elements;
        }

        @Override
        public void visit(DiagramElement diagramElement) {
            String element;
            GraphElement ge;
            SemanticModelBridge sm;
            if (diagramElement instanceof GraphElement && (sm = (ge = (GraphElement)diagramElement).getSemanticModel()) != null && sm instanceof CoreSemanticModelBridge && (element = ((CoreSemanticModelBridge)sm).getElement()) != null) {
                this.m_elements.add(element);
            }
        }
    }
}

