/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.Vector;
import oracle.aurora.server.tools.shell.CommandLineParser;
import oracle.aurora.server.tools.shell.JDBCShellConnection;
import oracle.aurora.server.tools.shell.ShellClientOptions;
import oracle.aurora.server.tools.shell.ToolImpl;
import oracle.aurora.util.tools.JdbcOptions;
import oracle.aurora.util.tools.ToolException;
import oracle.aurora.util.tools.ToolLog;

public class ShellClient
extends ToolImpl {
    boolean batch = false;
    boolean echo = false;
    String oschema = null;
    String script;
    String command;
    String[] commandArgs = null;
    JDBCShellConnection connection = null;
    ToolLog log = null;
    boolean runjava_on;
    boolean runjava_use_server_filesystem;
    int jdwpPort = -1;
    String jdwpHost = "localhost";
    private ShellClientOptions scops = null;
    private JdbcOptions jops = null;

    public static void main(String[] args) {
        String command;
        String passwd;
        int len = args.length;
        String user = System.getenv("OJUSER");
        if (user != null) {
            len += 2;
        }
        if ((passwd = System.getenv("OJPASS")) != null) {
            len += 2;
        }
        if ((command = System.getenv("OJCOM")) != null) {
            len += 2;
        }
        String[] allargs = new String[len];
        int pos = 0;
        if (user != null) {
            System.arraycopy(user.split(" "), 0, allargs, pos, 2);
            pos += 2;
        }
        if (passwd != null) {
            String[] r = passwd.split(" ");
            if (r[1].equals("\"\"")) {
                r[1] = "";
            }
            System.arraycopy(r, 0, allargs, pos, 2);
            pos += 2;
        }
        if (command != null) {
            String[] c = new String[]{command.substring(0, command.indexOf(" ")), command.substring(command.indexOf("\"") + 1, command.lastIndexOf("\""))};
            System.arraycopy(c, 0, allargs, pos, 2);
            pos += 2;
        }
        System.arraycopy(args, 0, allargs, pos, args.length);
        try {
            new ShellClient().invoke(allargs);
        }
        catch (ToolException te) {
            String em = te.getMessage();
            if (te.getChain() != (Exception)null) {
                em = em + te.getChain().getMessage();
            }
            System.out.println(em);
            System.exit(1);
        }
        System.exit(0);
    }

    public void connect(JdbcOptions jdo) throws ToolException {
        if (this.connection != null && this.connection.isClosed()) {
            this.connection = null;
        }
        JDBCShellConnection newConn = null;
        if (jdo.getString("-user") == null) {
            System.out.println("-user required");
        } else {
            newConn = new JDBCShellConnection(jdo);
        }
        if (newConn == null) {
            System.out.println("failed to connect using " + jdo);
        } else {
            String conmsg = jdo.getString("-user");
            int slash = conmsg.indexOf("/");
            if (slash > 0) {
                conmsg = conmsg.substring(0, slash);
            }
            System.out.println("connected to " + conmsg);
            JDBCShellConnection oldConn = this.connection;
            this.connection = newConn;
            this.jdwpPort = this.connection.jdwpConnect(this.jdwpPort, this.jdwpHost);
            if (oldConn != null) {
                try {
                    oldConn.close();
                }
                catch (ToolException e) {
                    System.out.println("Error occurred closing old connection:\n" + e);
                }
            }
        }
    }

    public void invoke(String[] argv) throws ToolException {
        this.parseArgs(this.parseStdArgs(argv, true));
        this.invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() throws ToolException {
        try {
            if (this.script != null) {
                this.batch(this.script, this.commandArgs);
            } else if (this.command != null) {
                this.invokeBatch(new BufferedReader(new StringReader(this.command)), this.commandArgs);
            } else {
                this.invoke(new BufferedReader(new InputStreamReader(System.in), 1));
            }
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void invoke(BufferedReader in) throws ToolException {
        CommandLineParser input = new CommandLineParser(in, System.out);
        if (!this.batch) {
            System.out.println(this.msg("WELCOME_MESSAGE"));
        }
        try {
            while (true) {
                if (!this.batch) {
                    System.out.print("$ ");
                }
                try {
                    if (!this.invoke_command(input.tokens(), input.fileRedirected())) continue;
                }
                catch (IOException e) {
                }
                catch (ToolException e) {
                    System.err.println(e.getMessage());
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new ToolException(e.toString());
        }
    }

    protected boolean invoke_command(String[] argv) throws ToolException {
        if (argv.length == 0) {
            return false;
        }
        if (argv[0].equals("@")) {
            String[] theArgs = new String[argv.length - 1];
            System.arraycopy(argv, 1, theArgs, 0, theArgs.length);
            argv = theArgs;
            if (argv.length > 0) {
                argv[0] = "@" + argv[0];
            } else {
                return false;
            }
        }
        if (argv[0].charAt(0) == '@') {
            this.batch(argv[0].substring(1), argv);
            return false;
        }
        if (this.echo) {
            for (int i = 0; i < argv.length; ++i) {
                System.out.print(argv[i] + " ");
            }
            System.out.println();
        }
        if (argv[0].equals("exit")) {
            return true;
        }
        if (argv[0].equalsIgnoreCase("runjava")) {
            if (argv.length < 2 || !this.processRunjavaArg(argv.length == 2 ? argv[1] : "??", false)) {
                System.out.println("runjava mode " + (argv.length > 1 ? "set to " : "is ") + (this.runjava_on ? (this.runjava_use_server_filesystem ? "server_file_system" : "on") : "off"));
            }
            return false;
        }
        if (argv[0].equalsIgnoreCase("jdwp")) {
            if (argv.length < 2 || !this.processJdwpArgs(argv, false)) {
                System.out.println("jdwp mode " + (argv.length > 1 ? "set to " : "is ") + (this.jdwpPort == -1 ? "off" : "listen on port " + this.jdwpPort + " on " + this.jdwpHost));
            }
            return false;
        }
        if (argv[0].equals("connect")) {
            JdbcOptions jops = null;
            if (argv.length > 1) {
                String[] theArgs = new String[argv.length - 1];
                System.arraycopy(argv, 1, theArgs, 0, theArgs.length);
                jops = new JdbcOptions();
                String[] unused = jops.parseArgs(theArgs);
                this.connect(jops);
            } else if (this.connection != null) {
                this.connection.reconnect();
            } else {
                System.out.println("connect command requires arguments");
            }
            return false;
        }
        if (this.connection != null && this.connection.isClosed()) {
            this.connection.reconnect();
            if (this.connection.isClosed()) {
                this.connection = null;
            }
        }
        if (this.connection == null) {
            this.fail0("NOT_CONNECTED");
        }
        if (this.oschema != null) {
            String[] tmp = new String[]{"java", "setschema", this.oschema};
            this.connection.invoke_command(tmp, false);
            this.oschema = null;
        }
        return this.runjava_on && argv[0].equals("java") ? this.connection.invoke_runjava(argv, this.runjava_use_server_filesystem) : this.connection.invoke_command(argv, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invoke_command(String[] argv, String outFile) throws ToolException {
        boolean bl;
        if (outFile == null) {
            return this.invoke_command(argv);
        }
        PrintStream out = new PrintStream(new FileOutputStream(outFile));
        PrintStream oldOut = System.out;
        try {
            System.setOut(out);
            bl = this.invoke_command(argv);
        }
        catch (Throwable throwable) {
            try {
                System.setOut(oldOut);
                out.flush();
                out.close();
                throw throwable;
            }
            catch (IOException io) {
                throw new ToolException(io.toString(), io);
            }
            catch (SecurityException se) {
                throw new ToolException(se.toString(), se);
            }
        }
        System.setOut(oldOut);
        out.flush();
        out.close();
        return bl;
    }

    protected void batch(String filename, String[] args) throws ToolException {
        FileInputStream file = null;
        try {
            file = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            this.fail1("NOT_FOUND", new File(filename).getAbsolutePath());
        }
        BufferedReader inputStream = new BufferedReader(new InputStreamReader(file), 1);
        this.invokeBatch(inputStream, args);
    }

    public void invokeBatch(BufferedReader in, String[] args) throws ToolException {
        CommandLineParser input = new CommandLineParser(in, null, args);
        try {
            try {
                String[] tokens;
                while (!this.invoke_command(tokens = input.tokens(), input.fileRedirected())) {
                }
            }
            catch (IOException e) {}
        }
        catch (Exception e) {
            ToolException te = new ToolException(e.getMessage(), e);
            throw te;
        }
    }

    private boolean processRunjavaArg(String runjava_arg, boolean forCmdline) {
        if (runjava_arg.equalsIgnoreCase("off")) {
            this.runjava_on = false;
            this.runjava_use_server_filesystem = false;
        } else if (runjava_arg.equalsIgnoreCase("on")) {
            this.runjava_on = true;
            this.runjava_use_server_filesystem = false;
        } else if (runjava_arg.equalsIgnoreCase("server_file_system")) {
            this.runjava_on = true;
            this.runjava_use_server_filesystem = true;
        } else {
            if (forCmdline) {
                return true;
            }
            if (runjava_arg.equalsIgnoreCase("-describe") || runjava_arg.length() > 1 && runjava_arg.substring(0, 2).equalsIgnoreCase("-h")) {
                System.out.println("runjava [off|on|server_file_system]");
                System.out.println("Query or set runjava mode, which controls how");
                System.out.println("the java command runs java classes.");
                System.out.println("No argument means query current setting.");
                System.out.println("runjava mode off : run database resident classes");
                System.out.println("runjava mode on : use DBMS_JAVA.RUNJAVA,");
                System.out.println("  interpreting -classpath using the current filesystem");
                System.out.println("runjava mode server_file_system : use DBMS_JAVA.RUNJAVA,");
                System.out.println("  interpreting -classpath using the filesystem of");
                System.out.println("  the machine running the Oracle server.");
            } else {
                System.out.println("Usage: runjava [off|on|server_file_system]");
                return true;
            }
        }
        return false;
    }

    private boolean processJdwpArgs(String[] jdwp_args, boolean forCmdline) {
        if (jdwp_args == null) {
            return false;
        }
        if (jdwp_args.length > 3 || jdwp_args.length < 2) {
            if (!forCmdline) {
                System.out.println("Usage: jdwp [port [host]]");
            }
            return true;
        }
        String jdwp_arg = jdwp_args[1];
        if (jdwp_arg.equalsIgnoreCase("off")) {
            if (jdwp_args.length != 2) {
                if (!forCmdline) {
                    System.out.println("Usage: jdwp [port [host]]");
                }
                return true;
            }
            this.jdwpPort = -1;
        } else {
            if (!forCmdline && (jdwp_arg.equalsIgnoreCase("-describe") || jdwp_arg.length() > 1 && jdwp_arg.substring(0, 2).equalsIgnoreCase("-h"))) {
                System.out.println("jdwp [port [host]]");
                System.out.println("Query or set jdwp mode, which controls how");
                System.out.println("the java command listens for a debugger.");
                System.out.println("No argument means query current setting.");
                System.out.println("off means do not listen");
                System.out.println("otherwise listen on port on host,");
                System.out.println("where host defaults to localhost.");
                return true;
            }
            int n = -1;
            try {
                n = Integer.parseInt(jdwp_arg);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (n <= 0) {
                if (!forCmdline) {
                    System.out.println("Usage: jdwp [port [host]]");
                }
                System.out.println("jdwp port number to listen on must be positive");
                return true;
            }
            this.jdwpPort = n;
            if (jdwp_args.length == 3) {
                this.jdwpHost = jdwp_args[2];
            }
        }
        if (this.connection != null) {
            this.jdwpPort = this.connection.jdwpConnect(this.jdwpPort, this.jdwpHost);
        }
        return false;
    }

    protected void parseArgs(String[] argv) throws ToolException {
        String rjArg;
        String outfile;
        Vector<String> shellArgs = new Vector<String>();
        this.jops = new JdbcOptions();
        this.scops = new ShellClientOptions();
        String[] leftover = null;
        leftover = this.jops.parseArgs(argv);
        leftover = this.scops.parseArgs(leftover);
        String user = this.jops.getString("-user");
        if (user == null || user.startsWith("-")) {
            this.error(this.usage());
        }
        if ((outfile = this.scops.getString("-fileout")) != null) {
            try {
                PrintStream out = new PrintStream(new FileOutputStream(outfile));
                System.setOut(out);
                System.setErr(out);
            }
            catch (IOException io) {
                System.out.println("can not set " + outfile + "to System.out");
            }
        }
        this.oschema = this.scops.getString("-oschema");
        if (this.scops.getBoolean("-echo")) {
            this.echo = true;
        }
        if (this.scops.getBoolean("-batch")) {
            this.batch = true;
        }
        if (this.scops.getBoolean("-command")) {
            this.command = this.scops.getString("-command");
            if (this.command.startsWith("-")) {
                this.error(this.usage());
            }
            shellArgs.insertElementAt(this.command, 0);
        }
        if ((rjArg = this.scops.getString("-runjava")) != null && this.processRunjavaArg(rjArg, true)) {
            this.error(this.usage());
        }
        if (this.processJdwpArgs((String[])this.scops.get("-jdwp"), true)) {
            this.error(this.usage());
        }
        for (int i = 0; i < leftover.length; ++i) {
            if (leftover[i].startsWith("@")) {
                if (this.script != null) {
                    this.error(this.usage());
                }
                if (leftover[i].equals("@")) {
                    if (++i >= leftover.length || leftover[i].startsWith("-")) {
                        this.error(this.usage());
                    }
                    this.script = leftover[i];
                } else {
                    this.script = leftover[i].substring(1);
                }
                shellArgs.insertElementAt(this.script, 0);
                continue;
            }
            if (this.command == null && this.script == null && leftover[i].startsWith("-")) {
                this.error(this.usage());
                continue;
            }
            if (this.command != null || this.script != null) {
                shellArgs.addElement(leftover[i]);
                continue;
            }
            this.error(this.usage());
        }
        if (this.command != null && this.script != null) {
            this.error(this.usage());
        }
        this.commandArgs = new String[shellArgs.size()];
        shellArgs.copyInto(this.commandArgs);
        this.connect(this.jops);
    }
}

