/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.liquibase;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.LiquibaseException;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.extension.apex.command.ApexOptions;
import oracle.dbtools.raptor.liquibase.core.ActiveCommand;
import oracle.dbtools.raptor.liquibase.core.CommandGenerator;
import oracle.dbtools.raptor.liquibase.exception.NoRollbackException;
import oracle.dbtools.raptor.liquibase.util.LbFileUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.newscriptrunner.commands.SetDDLSettings;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;
import oracle.dbtools.util.Logger;

public class LbCommand
extends CommandListener
implements IHelp,
SQLCLService,
Connected {
    private static final String LF = System.lineSeparator();

    public String getCommand() {
        return "Liquibase".toUpperCase();
    }

    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        return this.createHelpPages(ctx).get(pagePath);
    }

    public boolean isSqlPlus() {
        return false;
    }

    private HelpPages createHelpPages(ScriptRunnerContext ctx) {
        return new HelpPagesBuilder(ctx.getEnvironment()).alphaSort().addHelpContainerFor((Object)this).addPages((Iterable)new CommandPageAssemblers(LBOptions.commandType, new Type[0])).build();
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return Messages.getString("LB_EXTENTION_DESC");
    }

    public String getExtensionName() {
        return "Liquibase";
    }

    public String getExtensionVersion() {
        return Messages.getString("SQLclVersion.VERSION");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!(cmd.getLoweredTrimmedSQL().replaceAll("^\"|\"$", "").startsWith("lb ") || cmd.getLoweredTrimmedSQL().replaceAll("^\"|\"$", "").toLowerCase().startsWith("liquibase") || "lb".equals(cmd.getLoweredTrimmedSQL()))) {
            return false;
        }
        LbUtils.getConfig().setContext(ctx);
        try {
            String result;
            ActiveCommand ac;
            Parser parser = new Parser(LBOptions.commandType, ctx.getEnvironment());
            ArrayList errors = new ArrayList();
            Optional optParsedCommand = parser.parse(ScriptUtils.checkforContinuationChars((String)cmd.getSql()), errors::add);
            if (!errors.isEmpty()) {
                for (String error : errors) {
                    ctx.write(error + System.lineSeparator());
                }
                boolean bl = true;
                return bl;
            }
            if (optParsedCommand.isPresent()) {
                try {
                    ac = ActiveCommand.createActiveCommand((ParsedCommand)optParsedCommand.get(), ctx, conn);
                    LbUtils.setCommand(ac);
                }
                catch (Exception rx) {
                    throw new CommandExecutionException(LbUtils.getRoot(rx).getMessage(), (Throwable)rx);
                }
            } else {
                throw new CommandExecutionException("Command failed parsing please log a bug");
            }
            ac.setOptionValue(LBOptions.Options.SQLCLVERSION, LbUtils.getSqlClVersion());
            System.setProperty(LBOptions.Options.SQLCLVERSION.toString(), Messages.getString("SQLclVersion.VERSION"));
            try {
                if (LbUtils.getCommand().isFlagSet(LBOptions.Options.LOG)) {
                    Level logLevel = Level.INFO;
                    if (LbUtils.getCommand().isFlagSet(LBOptions.Options.DEBUG)) {
                        logLevel = Level.FINEST;
                    }
                    LbFileUtils.configureLogging(logLevel, LbFileUtils.getLogFile(false));
                }
            }
            catch (IllegalArgumentException logLevel) {
                // empty catch block
            }
            String commandName = ac.getParsedCommand().getType().getName();
            if (null != conn && "SYS".equals(conn.getSchema())) {
                throw new LiquibaseException(Messages.getString("SYS_UNSUPPORTED"));
            }
            if (null != conn) {
                LbUtils.getCommand().setOptionValue(LBOptions.Options.IS_SCLCL, true);
                if (null == ctx.getParameterInstance().getParameters("ddl.parms")) {
                    SetDDLSettings.resetDDLParameters((ScriptRunnerContext)ctx);
                }
            }
            LbUtils.resetErrors();
            ctx.write("--" + LbUtils.getBanner() + LF);
            this.flushBuffer();
            Logger.info(LbCommand.class, (String)("Starting LB command: " + commandName));
            if (LBOptions.Commands.CALCULATE_CHECKSUM.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.calculateCheckSumCommand();
            } else if (LBOptions.Commands.CLEAR_CHECKSUMS.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.clearCheckSumsCommand();
            } else if (LBOptions.Commands.VERSION.getName().equalsIgnoreCase(commandName)) {
                ctx.write(LbUtils.getVersion());
            } else if (LBOptions.Commands.HISTORY.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.historyCommand();
            } else if (LBOptions.Commands.STATUS.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.statusCommand();
            } else if (LBOptions.Commands.VALIDATE.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.validateCommand();
            } else if (LBOptions.Commands.CHANGELOG_SYNC.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.changeLogSyncCommand();
            } else if (LBOptions.Commands.CHANGELOG_SYNC_SQL.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.changeLogSyncSqlCommand();
            } else if (LBOptions.Commands.CHANGELOG_SYNC_TO_TAG.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.changeLogSyncToTagCommand();
            } else if (LBOptions.Commands.CHANGELOG_SYNC_TO_TAG_SQL.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.changeLogSyncToTagSqlCommand();
            } else if (LBOptions.Commands.DATA.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.dataCommand();
            } else if (LBOptions.Commands.DIFF.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.diffCommand();
            } else if (LBOptions.Commands.DIFF_CHANGELOG.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.diffChangelogCommand();
            } else if (LBOptions.Commands.DB_DOC.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.dbDocCommand();
            } else if (LBOptions.Commands.FUTURE_ROLLBACK_COUNT_SQL.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.futureRollbackCountSqlCommand();
            } else if (LBOptions.Commands.FUTURE_ROLLBACK_FROM_TAG_SQL.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.futureRollbackTagSqlCommand();
            } else if (LBOptions.Commands.FUTURE_ROLLBACK_SQL.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.futureRollbackSqlCommand();
            } else if (LBOptions.Commands.GENERATE_CHANGELOG.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.generateChangelogCommand();
            } else if (LBOptions.Commands.GENERATE_CONTROLFILE.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.generateControlFileCommand();
            } else if (LBOptions.Commands.GENERATE_DB_OBJECT.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                ctx.write(Messages.format("CHANGELOG_CREATED", CommandGenerator.generateDbObjectCommand()));
            } else if (LBOptions.Commands.GENERATE_APEX_OBJECT.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                this.sortExpType();
                ctx.write(CommandGenerator.generateApexObjectCommand(conn));
            } else if (LBOptions.Commands.GENERATE_ORDS_MODULE.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                result = CommandGenerator.generateOrdsModuleCommand();
                if (null != result && !result.isEmpty()) {
                    ctx.write(Messages.format("CHANGELOG_CREATED", result));
                }
            } else if (LBOptions.Commands.GENERATE_ORDS_SCHEMA.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                result = CommandGenerator.generateOrdsSchemaCommand();
                if (null != result && !result.isEmpty()) {
                    ctx.write(Messages.format("CHANGELOG_CREATED", result));
                }
            } else if (LBOptions.Commands.GENERATE_SCHEMA.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.generateSchemaCommand();
                ctx.write(Messages.format("CHANGELOG_CREATED", LbUtils.getCommand().getOptionValue(LBOptions.Options.CHANGELOG_FILE).toString()));
            } else if (LBOptions.Commands.LIST_LOCKS.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.listLocksCommand();
            } else if (LBOptions.Commands.RELEASE_LOCKS.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.releaseLocksCommand();
            } else if (LBOptions.Commands.MARK_NEXT_CHANGESET_RAN.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.markNextChangesetRanCommand();
            } else if (LBOptions.Commands.MARK_NEXT_CHANGESET_RAN_SQL.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.markNextChangesetRanSqlCommand();
            } else if (LBOptions.Commands.ROLLBACK.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.rollbackCommand();
            } else if (LBOptions.Commands.ROLLBACK_COUNT.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.rollbackCountCommand();
            } else if (LBOptions.Commands.ROLLBACK_COUNT_SQL.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.rollbackCountSqlCommand();
            } else if (LBOptions.Commands.ROLLBACK_SQL.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.rollbackSqlCommand();
            } else if (LBOptions.Commands.ROLLBACK_TO_DATE.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.rollbackToDateCommand();
            } else if (LBOptions.Commands.ROLLBACK_TO_DATE_SQL.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.rollbackToDateSqlCommand();
            } else if (LBOptions.Commands.SHOW.getName().equalsIgnoreCase(commandName)) {
                CommandGenerator.showCommand();
            } else if (LBOptions.Commands.SET.getName().equalsIgnoreCase(commandName)) {
                CommandGenerator.setCommand();
            } else if (LBOptions.Commands.SNAPSHOT_REFERENCE.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.snapShotReferenceCommand();
            } else if (LBOptions.Commands.SNAPSHOT.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.snapShotCommand();
            } else if (LBOptions.Commands.TAG_EXISTS.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.tagExistsCommand();
            } else if (LBOptions.Commands.TAG.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.tagCommand();
            } else if (LBOptions.Commands.UNEXPECTED_CHANGESETS.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.unexpectedChangessetsCommand();
            } else if (LBOptions.Commands.UPDATE.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.updateCommand();
            } else if (LBOptions.Commands.UPDATE_SQL.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.updateSqlCommand();
            } else if (LBOptions.Commands.UPDATE_COUNT.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.updateCountCommand();
            } else if (LBOptions.Commands.UPDATE_COUNT_SQL.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.updateCountSqlCommand();
            } else if (LBOptions.Commands.UPDATE_TO_TAG.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.updateToTagCommand();
            } else if (LBOptions.Commands.UPDATE_TO_TAG_SQL.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.updateToTagSqlCommand();
            } else if (LBOptions.Commands.UPDATE_TESTING_ROLLBACK.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.updateTestingRollbackCommand();
            } else if (LBOptions.Commands.DROP_ALL.getName().equalsIgnoreCase(commandName)) {
                LbUtils.checkConnection(conn);
                CommandGenerator.dropAllCommand();
            } else {
                ctx.write(Messages.getString("COMMAND_ERROR"));
            }
            this.flushBuffer();
            Logger.info(LbCommand.class, (String)("Ending LB command: " + commandName));
            if (0 == LbUtils.getErrCount()) {
                this.write_success(ctx);
            } else {
                ctx.write(LF);
                ctx.write("Process Completed. " + LbUtils.getErrCount() + " errors encountered.");
                ctx.write(LF);
            }
            String eLog = LbUtils.writeErrorLog();
            if (null != eLog && !eLog.isEmpty()) {
                ctx.write(Messages.format("LB_ERROR", eLog));
                ctx.write(LF);
            }
        }
        catch (Exception e) {
            String eLog = LbUtils.writeErrorLog();
            if (null != eLog && !eLog.isEmpty()) {
                ctx.write(Messages.format("LB_ERROR", eLog));
                ctx.write(LF);
            }
            if (LbUtils.getRoot(e) instanceof NoRollbackException) {
                ctx.write(Messages.format("NO_ROLLBACK", new Object[0]) + LF);
            } else if (LbUtils.getRoot(e) instanceof NullPointerException || e instanceof NullPointerException) {
                ctx.write("Null Pointer please log a bug.\n" + Throwables.getStackTraceAsString((Throwable)e));
                ctx.write(LF);
            } else if (LbUtils.getRoot(e) instanceof ChangeLogParseException) {
                ctx.write(Messages.format("LB_GENERIC_ERROR", e.getMessage()));
                ctx.write(LF);
            } else {
                ctx.write("An error has occurred: ");
                ctx.write(LF);
                String rootMsg = LbUtils.getRoot(e).getMessage();
                String lastMsg = e.getMessage();
                if (!rootMsg.equals(lastMsg)) {
                    ctx.write(lastMsg);
                }
                ctx.write(LF);
                ctx.write(rootMsg);
                ctx.write(LF);
                if (LbUtils.getCommand().isFlagSet(LBOptions.Options.DEBUG)) {
                    ctx.write("DEBUG:\n" + Throwables.getStackTraceAsString((Throwable)e));
                }
            }
            if (LbUtils.getCommand() != null && LbUtils.getCommand().isFlagSet(LBOptions.Options.DEBUG) && !(LbUtils.getRoot(e) instanceof NullPointerException)) {
                ctx.write("DEBUG:\n" + Throwables.getStackTraceAsString((Throwable)e));
            }
            ScriptUtils.doWhenever((ScriptRunnerContext)ctx, (ISQLCommand)cmd, (Connection)conn, (boolean)true);
            Logger.info(LbCommand.class, (String)"Logging Ended");
        }
        finally {
            LbFileUtils.cleanup();
            LbUtils.setCommand(null);
            LbUtils.setContext(null);
        }
        return true;
    }

    public void beginEvent(Connection arg0, ScriptRunnerContext arg1, ISQLCommand arg2) {
    }

    public void endEvent(Connection arg0, ScriptRunnerContext arg1, ISQLCommand arg2) {
    }

    public Type getParserType() {
        return LBOptions.commandType;
    }

    private void flushBuffer() {
        try {
            if (LbUtils.getContext() != null && LbUtils.getContext().getOutputStream() != null) {
                LbUtils.getContext().getOutputStream().flush();
            }
        }
        catch (IOException Ignored) {
            LbUtils.log(((Object)((Object)this)).getClass(), Ignored);
        }
    }

    private void sortExpType() {
        if (null != LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.EXPTYPE) && !Objects.requireNonNull(LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.EXPTYPE)).toString().isEmpty()) {
            List<String> types = Arrays.asList(LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.EXPTYPE).toString().split(","));
            List sortedList = types.stream().sorted((lhs, rhs) -> {
                if ("APPLICATION_SOURCE".equals(lhs)) {
                    return 1;
                }
                if ("APPLICATION_SOURCE".equals(rhs)) {
                    return -1;
                }
                return 0;
            }).collect(Collectors.toList());
            LbUtils.getCommand().setOptionValue((Id)ApexOptions.Symbol.EXPTYPE, String.join((CharSequence)",", sortedList));
        }
    }

    private void write_success(ScriptRunnerContext ctx) {
        ctx.write(LF);
        if (LbUtils.getCommand().isFlagSet(LBOptions.Options.LOG)) {
            ctx.write("Produced logfile: " + LbFileUtils.getLog().getName() + LF);
        }
        ctx.write(Messages.getString("LB_OPERATION_SUCCESS"));
        ctx.write(LF);
        this.flushBuffer();
    }

    public boolean needsConnection() {
        return false;
    }
}

