/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.ext.ora.statement;

import java.nio.file.Paths;
import liquibase.change.Change;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import lombok.Generated;
import oracle.dbtools.raptor.liquibase.ext.ora.change.AbstractOracleChange;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.AbstractOracleBaseStatement;

public abstract class AbstractOracleStatement
extends AbstractOracleBaseStatement {
    private String relativeToChangelogFile;
    private String file;
    private String id;
    private String author;
    private String objectName;
    private String ownerName;
    private String objectType;
    private boolean replaceIfExists = true;
    private String source;
    private String sourceType;
    private Change change;
    private ValidationErrors validation;
    private Sql[] sqls;

    protected AbstractOracleStatement() {
    }

    protected AbstractOracleStatement(AbstractOracleChange change) {
        if (change != null) {
            this.objectName = change.getObjectName();
            this.ownerName = change.getOwnerName();
            this.objectType = change.getObjectType();
            this.replaceIfExists = change.getReplaceIfExists();
            this.source = change.getSource();
            this.sourceType = change.getSourceType();
            this.relativeToChangelogFile = change.getRelativeToChangelogFile();
            this.change = change;
        }
        if (change != null && change.getChangeSet() != null) {
            this.id = change.getChangeSet().getId();
            this.author = change.getChangeSet().getAuthor();
            if (change.getChangeSet().getFailOnError() != null) {
                this.setContinueOnError(change.getChangeSet().getFailOnError() == false);
            } else {
                this.setContinueOnError(false);
            }
        }
        if (change != null && change.getChangeSet() != null && change.getChangeSet().getFilePath() != null) {
            String path = Paths.get(change.getChangeSet().getFilePath(), new String[0]).normalize().toString();
            change.getChangeSet().setFilePath(path);
            this.file = path;
        }
        this.validation = null;
        this.sqls = null;
    }

    protected AbstractOracleStatement(AbstractOracleStatement stmt) {
        if (stmt.getId() == null) {
            if (stmt.getChange() != null && stmt.getChange().getChangeSet() != null && stmt.getChange().getChangeSet().getFilePath() != null) {
                this.file = Paths.get(stmt.getChange().getChangeSet().getFilePath(), new String[0]).normalize().toString();
                stmt.getChange().getChangeSet().setFilePath(this.file);
            }
            if (stmt.getChange() != null && stmt.getChange().getChangeSet() != null) {
                this.id = stmt.getChange().getChangeSet().getId();
                this.author = stmt.getChange().getChangeSet().getAuthor();
                this.objectName = ((AbstractOracleChange)stmt.getChange()).getObjectName();
                this.ownerName = ((AbstractOracleChange)stmt.getChange()).getOwnerName();
                this.objectType = ((AbstractOracleChange)stmt.getChange()).getObjectType();
                this.source = ((AbstractOracleChange)stmt.getChange()).getSource();
                this.sourceType = ((AbstractOracleChange)stmt.getChange()).getSourceType();
            }
        } else {
            this.file = Paths.get(stmt.getFile(), new String[0]).normalize().toString();
            this.id = stmt.getId();
            this.author = stmt.getAuthor();
            this.objectName = stmt.getObjectName();
            this.ownerName = stmt.getOwnerName();
            this.objectType = stmt.getObjectType();
            this.source = stmt.getSource();
            this.sourceType = stmt.getSourceType();
        }
        this.replaceIfExists = stmt.getReplaceIfExists();
        this.relativeToChangelogFile = stmt.getRelativeToChangelogFile();
        this.change = stmt.getChange();
        this.validation = stmt.getValidation();
        this.sqls = stmt.sqls;
        super.setContinueOnError(stmt.getChange().getChangeSet().getFailOnError() == false);
    }

    @Override
    public void setId(String id) {
        this.id = id;
        this.sqls = null;
    }

    @Override
    public void setChange(Change change) {
        this.change = change;
        this.sqls = null;
    }

    @Override
    public void setAuthor(String author) {
        this.author = author;
        this.sqls = null;
    }

    @Override
    public void setObjectName(String objectName) {
        this.objectName = objectName;
        this.sqls = null;
    }

    @Override
    public String getObjectType() {
        if (null != this.objectType) {
            return this.objectType.toUpperCase();
        }
        return null;
    }

    @Override
    public void setObjectType(String objectType) {
        this.objectType = objectType;
        this.sqls = null;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
        this.sqls = null;
    }

    @Override
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
        this.sqls = null;
    }

    public boolean isRelative() {
        return this.relativeToChangelogFile.equalsIgnoreCase("true");
    }

    @Override
    public void setValidation(ValidationErrors validation) {
        this.validation = validation;
    }

    @Override
    public void setFile(String file) {
        this.file = file != null ? Paths.get(file, new String[0]).normalize().toString() : null;
        this.sqls = null;
    }

    @Override
    public void setObjectOwner(String ownerName) {
        this.ownerName = ownerName;
        this.sqls = null;
    }

    @Override
    @Generated
    public String getRelativeToChangelogFile() {
        return this.relativeToChangelogFile;
    }

    @Generated
    public void setRelativeToChangelogFile(String relativeToChangelogFile) {
        this.relativeToChangelogFile = relativeToChangelogFile;
    }

    @Override
    @Generated
    public String getFile() {
        return this.file;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getAuthor() {
        return this.author;
    }

    @Override
    @Generated
    public String getObjectName() {
        return this.objectName;
    }

    @Override
    @Generated
    public String getOwnerName() {
        return this.ownerName;
    }

    @Generated
    public boolean isReplaceIfExists() {
        return this.replaceIfExists;
    }

    @Override
    @Generated
    public void setReplaceIfExists(boolean replaceIfExists) {
        this.replaceIfExists = replaceIfExists;
    }

    @Override
    @Generated
    public String getSource() {
        return this.source;
    }

    @Override
    @Generated
    public String getSourceType() {
        return this.sourceType;
    }

    @Override
    @Generated
    public Change getChange() {
        return this.change;
    }

    @Override
    @Generated
    public ValidationErrors getValidation() {
        return this.validation;
    }

    @Override
    @Generated
    public Sql[] getSqls() {
        return this.sqls;
    }

    @Override
    @Generated
    public void setSqls(Sql[] sqls) {
        this.sqls = sqls;
    }
}

