/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.common.regex.xerces;

import java.io.Serializable;
import java.text.CharacterIterator;
import oracle.xml.common.regex.xerces.BMPattern;
import oracle.xml.common.regex.xerces.Match;
import oracle.xml.common.regex.xerces.Op;
import oracle.xml.common.regex.xerces.ParseException;
import oracle.xml.common.regex.xerces.ParserForXMLSchema;
import oracle.xml.common.regex.xerces.REUtil;
import oracle.xml.common.regex.xerces.RangeToken;
import oracle.xml.common.regex.xerces.RegexParser;
import oracle.xml.common.regex.xerces.Token;

public class RegularExpression
implements Serializable {
    private static final long serialVersionUID = 6242499334195006401L;
    static final boolean DEBUG = false;
    String regex;
    int options;
    int nofparen;
    Token tokentree;
    boolean hasBackReferences = false;
    boolean backcompat = false;
    transient int minlength;
    transient Op operations = null;
    transient int numberOfClosures;
    transient Context context = null;
    transient RangeToken firstChar = null;
    transient String fixedString = null;
    transient int fixedStringOptions;
    transient BMPattern fixedStringTable = null;
    transient boolean fixedStringOnly = false;
    static final int IGNORE_CASE = 2;
    static final int SINGLE_LINE = 4;
    static final int MULTIPLE_LINES = 8;
    static final int EXTENDED_COMMENT = 16;
    static final int USE_UNICODE_CATEGORY = 32;
    static final int UNICODE_WORD_BOUNDARY = 64;
    static final int PROHIBIT_HEAD_CHARACTER_OPTIMIZATION = 128;
    static final int PROHIBIT_FIXED_STRING_OPTIMIZATION = 256;
    static final int XMLSCHEMA_MODE = 512;
    static final int SPECIAL_COMMA = 1024;
    public static final int XQ_LITERAL = 2048;
    private static final int WT_IGNORE = 0;
    private static final int WT_LETTER = 1;
    private static final int WT_OTHER = 2;
    static final int LINE_FEED = 10;
    static final int CARRIAGE_RETURN = 13;
    static final int LINE_SEPARATOR = 8232;
    static final int PARAGRAPH_SEPARATOR = 8233;

    private synchronized void compile(Token token) {
        if (this.operations != null) {
            return;
        }
        this.numberOfClosures = 0;
        this.operations = this.compile(token, null, false);
    }

    private Op compile(Token token, Op op, boolean bl) {
        Op op2;
        switch (token.type) {
            case 11: {
                op2 = Op.createDot();
                op2.next = op;
                break;
            }
            case 0: {
                op2 = Op.createChar(token.getChar());
                op2.next = op;
                break;
            }
            case 8: {
                op2 = Op.createAnchor(token.getChar());
                op2.next = op;
                break;
            }
            case 4: 
            case 5: {
                op2 = Op.createRange(token);
                op2.next = op;
                break;
            }
            case 1: {
                op2 = op;
                if (!bl) {
                    for (int i = token.size() - 1; i >= 0; --i) {
                        op2 = this.compile(token.getChild(i), op2, false);
                    }
                } else {
                    for (int i = 0; i < token.size(); ++i) {
                        op2 = this.compile(token.getChild(i), op2, true);
                    }
                }
                break;
            }
            case 2: {
                Op.UnionOp unionOp = Op.createUnion(token.size());
                for (int i = 0; i < token.size(); ++i) {
                    unionOp.addElement(this.compile(token.getChild(i), op, bl));
                }
                op2 = unionOp;
                break;
            }
            case 3: 
            case 9: {
                Token token2 = token.getChild(0);
                int n = token.getMin();
                int n2 = token.getMax();
                if (n >= 0 && n == n2) {
                    op2 = op;
                    for (int i = 0; i < n; ++i) {
                        op2 = this.compile(token2, op2, bl);
                    }
                } else {
                    if (n > 0 && n2 > 0) {
                        n2 -= n;
                    }
                    if (n2 > 0) {
                        op2 = op;
                        for (int i = 0; i < n2; ++i) {
                            Op.ChildOp childOp = Op.createQuestion(token.type == 9);
                            childOp.next = op;
                            childOp.setChild(this.compile(token2, op2, bl));
                            op2 = childOp;
                        }
                    } else {
                        Op.ChildOp childOp = token.type == 9 ? Op.createNonGreedyClosure() : (token2.getMinLength() == 0 ? Op.createClosure(this.numberOfClosures++) : Op.createClosure(-1));
                        childOp.next = op;
                        childOp.setChild(this.compile(token2, childOp, bl));
                        op2 = childOp;
                    }
                    if (n <= 0) break;
                    for (int i = 0; i < n; ++i) {
                        op2 = this.compile(token2, op2, bl);
                    }
                }
                break;
            }
            case 7: {
                op2 = op;
                break;
            }
            case 10: {
                op2 = Op.createString(token.getString());
                op2.next = op;
                break;
            }
            case 12: {
                op2 = Op.createBackReference(token.getReferenceNumber());
                op2.next = op;
                break;
            }
            case 6: {
                if (token.getParenNumber() == 0) {
                    op2 = this.compile(token.getChild(0), op, bl);
                    break;
                }
                if (bl) {
                    op = Op.createCapture(token.getParenNumber(), op);
                    op = this.compile(token.getChild(0), op, bl);
                    op2 = Op.createCapture(-token.getParenNumber(), op);
                    break;
                }
                op = Op.createCapture(-token.getParenNumber(), op);
                op = this.compile(token.getChild(0), op, bl);
                op2 = Op.createCapture(token.getParenNumber(), op);
                break;
            }
            case 20: {
                op2 = Op.createLook(20, op, this.compile(token.getChild(0), null, false));
                break;
            }
            case 21: {
                op2 = Op.createLook(21, op, this.compile(token.getChild(0), null, false));
                break;
            }
            case 22: {
                op2 = Op.createLook(22, op, this.compile(token.getChild(0), null, true));
                break;
            }
            case 23: {
                op2 = Op.createLook(23, op, this.compile(token.getChild(0), null, true));
                break;
            }
            case 24: {
                op2 = Op.createIndependent(op, this.compile(token.getChild(0), null, bl));
                break;
            }
            case 25: {
                op2 = Op.createModifier(op, this.compile(token.getChild(0), null, bl), ((Token.ModifierToken)token).getOptions(), ((Token.ModifierToken)token).getOptionsMask());
                break;
            }
            case 26: {
                Token.ConditionToken conditionToken = (Token.ConditionToken)token;
                int n = conditionToken.refNumber;
                Op op3 = conditionToken.condition == null ? null : this.compile(conditionToken.condition, null, bl);
                Op op4 = this.compile(conditionToken.yes, op, bl);
                Op op5 = conditionToken.no == null ? null : this.compile(conditionToken.no, op, bl);
                op2 = Op.createCondition(op, n, op3, op4, op5);
                break;
            }
            default: {
                throw new RuntimeException("Unknown token type: " + token.type);
            }
        }
        return op2;
    }

    public boolean matches(char[] cArray) {
        return this.matches(cArray, 0, cArray.length, (Match)null);
    }

    public boolean matches(char[] cArray, int n, int n2) {
        return this.matches(cArray, n, n2, (Match)null);
    }

    public boolean matches(char[] cArray, Match match) {
        return this.matches(cArray, 0, cArray.length, match);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(char[] cArray, int n, int n2, Match match) {
        int n3;
        int n4;
        Object object = this;
        synchronized (object) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new Context();
            }
        }
        object = null;
        Context context = this.context;
        synchronized (context) {
            object = this.context.inuse ? new Context() : this.context;
            ((Context)object).reset(cArray, n, n2, this.numberOfClosures);
        }
        if (match != null) {
            match.setNumberOfGroups(this.nofparen);
            match.setSource(cArray);
        } else if (this.hasBackReferences) {
            match = new Match();
            match.setNumberOfGroups(this.nofparen);
        }
        ((Context)object).match = match;
        if (this.fixedStringOnly) {
            int n5 = this.fixedStringTable.matches(cArray, ((Context)object).start, ((Context)object).limit);
            if (n5 >= 0) {
                if (((Context)object).match != null) {
                    ((Context)object).match.setBeginning(0, n5);
                    ((Context)object).match.setEnd(0, n5 + this.fixedString.length());
                }
                ((Context)object).inuse = false;
                return true;
            }
            ((Context)object).inuse = false;
            return false;
        }
        if (this.fixedString != null && (n4 = this.fixedStringTable.matches(cArray, ((Context)object).start, ((Context)object).limit)) < 0) {
            ((Context)object).inuse = false;
            return false;
        }
        int n6 = ((Context)object).limit - this.minlength;
        int n7 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n3 = ((Context)object).start;
                n7 = this.matchCharArray((Context)object, this.operations, ((Context)object).start, 1, this.options);
            } else {
                boolean bl = true;
                for (n3 = ((Context)object).start; n3 <= n6; ++n3) {
                    char c = cArray[n3];
                    if (RegularExpression.isEOLChar(c)) {
                        bl = true;
                        continue;
                    }
                    if (!bl || 0 > (n7 = this.matchCharArray((Context)object, this.operations, n3, 1, this.options))) {
                        bl = false;
                        continue;
                    }
                    break;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            for (n3 = ((Context)object).start; n3 <= n6; ++n3) {
                int n8 = cArray[n3];
                if (REUtil.isHighSurrogate(n8) && n3 + 1 < ((Context)object).limit) {
                    n8 = REUtil.composeFromSurrogates(n8, cArray[n3 + 1]);
                }
                if (!rangeToken.match(n8) || 0 > (n7 = this.matchCharArray((Context)object, this.operations, n3, 1, this.options))) {
                    continue;
                }
                break;
            }
        } else {
            for (n3 = ((Context)object).start; n3 <= n6 && 0 > (n7 = this.matchCharArray((Context)object, this.operations, n3, 1, this.options)); ++n3) {
            }
        }
        if (n7 >= 0) {
            if (((Context)object).match != null) {
                ((Context)object).match.setBeginning(0, n3);
                ((Context)object).match.setEnd(0, n7);
            }
            ((Context)object).inuse = false;
            return true;
        }
        ((Context)object).inuse = false;
        return false;
    }

    private int matchCharArray(Context context, Op op, int n, int n2, int n3) {
        char[] cArray = context.charTarget;
        while (op != null) {
            if (n > context.limit || n < context.start) {
                return -1;
            }
            switch (op.type) {
                case 1: {
                    int n4;
                    if (RegularExpression.isSet(n3, 2)) {
                        n4 = op.getData();
                        if (n2 > 0) {
                            if (n >= context.limit || !RegularExpression.matchIgnoreCase(n4, cArray[n])) {
                                return -1;
                            }
                            ++n;
                        } else {
                            int n5 = n - 1;
                            if (n5 >= context.limit || n5 < 0 || !RegularExpression.matchIgnoreCase(n4, cArray[n5])) {
                                return -1;
                            }
                            n = n5;
                        }
                    } else {
                        n4 = op.getData();
                        if (n2 > 0) {
                            if (n >= context.limit || n4 != cArray[n]) {
                                return -1;
                            }
                            ++n;
                        } else {
                            int n6 = n - 1;
                            if (n6 >= context.limit || n6 < 0 || n4 != cArray[n6]) {
                                return -1;
                            }
                            n = n6;
                        }
                    }
                    op = op.next;
                    break;
                }
                case 0: {
                    int n4;
                    if (n2 > 0) {
                        if (n >= context.limit) {
                            return -1;
                        }
                        n4 = cArray[n];
                        if (RegularExpression.isSet(n3, 4)) {
                            if (REUtil.isHighSurrogate(n4) && n + 1 < context.limit) {
                                ++n;
                            }
                        } else {
                            if (REUtil.isHighSurrogate(n4) && n + 1 < context.limit) {
                                n4 = REUtil.composeFromSurrogates(n4, cArray[++n]);
                            }
                            if (RegularExpression.isEOLChar(n4)) {
                                return -1;
                            }
                        }
                        ++n;
                    } else {
                        n4 = n - 1;
                        if (n4 >= context.limit || n4 < 0) {
                            return -1;
                        }
                        int n7 = cArray[n4];
                        if (RegularExpression.isSet(n3, 4)) {
                            if (REUtil.isLowSurrogate(n7) && n4 - 1 >= 0) {
                                // empty if block
                            }
                        } else {
                            if (REUtil.isLowSurrogate(n7) && n4 - 1 >= 0) {
                                n7 = REUtil.composeFromSurrogates(cArray[--n4], n7);
                            }
                            if (!RegularExpression.isEOLChar(n7)) {
                                return -1;
                            }
                        }
                        n = --n4;
                    }
                    op = op.next;
                    break;
                }
                case 3: 
                case 4: {
                    Object object;
                    int n4;
                    if (n2 > 0) {
                        RangeToken rangeToken;
                        if (n >= context.limit) {
                            return -1;
                        }
                        n4 = cArray[n];
                        if (REUtil.isHighSurrogate(n4) && n + 1 < context.limit) {
                            n4 = REUtil.composeFromSurrogates(n4, cArray[++n]);
                        }
                        if (!(rangeToken = op.getToken()).match(n4)) {
                            return -1;
                        }
                        ++n;
                    } else {
                        n4 = n - 1;
                        if (n4 >= context.limit || n4 < 0) {
                            return -1;
                        }
                        int n8 = cArray[n4];
                        if (REUtil.isLowSurrogate(n8) && n4 - 1 >= 0) {
                            n8 = REUtil.composeFromSurrogates(cArray[--n4], n8);
                        }
                        if (!((RangeToken)(object = op.getToken())).match(n8)) {
                            return -1;
                        }
                        n = n4;
                    }
                    op = op.next;
                    break;
                }
                case 5: {
                    int n4 = 0;
                    switch (op.getData()) {
                        case 94: {
                            if (!(RegularExpression.isSet(n3, 8) ? n != 0 && (n <= 0 || !RegularExpression.isEOLChar(cArray[n - 1]) || n >= context.strTarget.length()) : n != 0)) break;
                            return -1;
                        }
                        case 64: {
                            if (n == 0 || n > 0 && RegularExpression.isEOLChar(cArray[n - 1])) break;
                            return -1;
                        }
                        case 36: {
                            if (!(RegularExpression.isSet(n3, 8) ? n != context.strTarget.length() && (n >= context.strTarget.length() || !RegularExpression.isEOLChar(cArray[n])) : (this.backcompat ? !(n == context.strTarget.length() || n + 1 == context.strTarget.length() && RegularExpression.isEOLChar(cArray[n]) || n + 2 == context.strTarget.length() && cArray[n] == '\r' && cArray[n + 1] == '\n') : n != context.strTarget.length()))) break;
                            return -1;
                        }
                        case 65: {
                            if (n == context.start) break;
                            return -1;
                        }
                        case 90: {
                            if (n == context.limit || n + 1 == context.limit && RegularExpression.isEOLChar(cArray[n]) || n + 2 == context.limit && cArray[n] == '\r' && cArray[n + 1] == '\n') break;
                            return -1;
                        }
                        case 122: {
                            if (n == context.limit) break;
                            return -1;
                        }
                        case 98: {
                            if (context.length == 0) {
                                return -1;
                            }
                            int n9 = RegularExpression.getWordType(cArray, context.start, context.limit, n, n3);
                            if (n9 == 0) {
                                return -1;
                            }
                            int n10 = RegularExpression.getPreviousWordType(cArray, context.start, context.limit, n, n3);
                            if (n9 != n10) break;
                            return -1;
                        }
                        case 66: {
                            if (context.length == 0) {
                                n4 = 1;
                            } else {
                                int n11 = RegularExpression.getWordType(cArray, context.start, context.limit, n, n3);
                                int n12 = n4 = n11 == 0 || n11 == RegularExpression.getPreviousWordType(cArray, context.start, context.limit, n, n3) ? 1 : 0;
                            }
                            if (n4 != 0) break;
                            return -1;
                        }
                        case 60: {
                            if (context.length == 0 || n == context.limit) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(cArray, context.start, context.limit, n, n3) == 1 && RegularExpression.getPreviousWordType(cArray, context.start, context.limit, n, n3) == 2) break;
                            return -1;
                        }
                        case 62: {
                            if (context.length == 0 || n == context.start) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(cArray, context.start, context.limit, n, n3) == 2 && RegularExpression.getPreviousWordType(cArray, context.start, context.limit, n, n3) == 1) break;
                            return -1;
                        }
                    }
                    op = op.next;
                    break;
                }
                case 16: {
                    int n13 = op.getData();
                    if (n13 <= 0 || n13 >= this.nofparen) {
                        throw new RuntimeException("Internal Error: Reference number must be more than zero: " + n13);
                    }
                    if (context.match.getBeginning(n13) < 0 || context.match.getEnd(n13) < 0) {
                        return -1;
                    }
                    int n14 = context.match.getBeginning(n13);
                    int n15 = context.match.getEnd(n13) - n14;
                    if (!RegularExpression.isSet(n3, 2)) {
                        if (n2 > 0) {
                            if (!RegularExpression.regionMatches(cArray, n, context.limit, n14, n15)) {
                                return -1;
                            }
                            n += n15;
                        } else {
                            if (!RegularExpression.regionMatches(cArray, n - n15, context.limit, n14, n15)) {
                                return -1;
                            }
                            n -= n15;
                        }
                    } else if (n2 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n, context.limit, n14, n15)) {
                            return -1;
                        }
                        n += n15;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n - n15, context.limit, n14, n15)) {
                            return -1;
                        }
                        n -= n15;
                    }
                    op = op.next;
                    break;
                }
                case 6: {
                    String string = op.getString();
                    int n16 = string.length();
                    if (!RegularExpression.isSet(n3, 2)) {
                        if (n2 > 0) {
                            if (!RegularExpression.regionMatches(cArray, n, context.limit, string, n16)) {
                                return -1;
                            }
                            n += n16;
                        } else {
                            if (!RegularExpression.regionMatches(cArray, n - n16, context.limit, string, n16)) {
                                return -1;
                            }
                            n -= n16;
                        }
                    } else if (n2 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n, context.limit, string, n16)) {
                            return -1;
                        }
                        n += n16;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n - n16, context.limit, string, n16)) {
                            return -1;
                        }
                        n -= n16;
                    }
                    op = op.next;
                    break;
                }
                case 7: {
                    int n17 = op.getData();
                    if (n17 >= 0) {
                        int n18 = context.offsets[n17];
                        if (n18 < 0 || n18 != n) {
                            context.offsets[n17] = n;
                        } else {
                            context.offsets[n17] = -1;
                            op = op.next;
                            break;
                        }
                    }
                    int n19 = this.matchCharArray(context, op.getChild(), n, n2, n3);
                    if (n17 >= 0) {
                        context.offsets[n17] = -1;
                    }
                    if (n19 >= 0) {
                        return n19;
                    }
                    op = op.next;
                    break;
                }
                case 9: {
                    int n20 = this.matchCharArray(context, op.getChild(), n, n2, n3);
                    if (n20 >= 0) {
                        return n20;
                    }
                    op = op.next;
                    break;
                }
                case 8: 
                case 10: {
                    int n21 = this.matchCharArray(context, op.next, n, n2, n3);
                    if (n21 >= 0) {
                        return n21;
                    }
                    op = op.getChild();
                    break;
                }
                case 11: {
                    for (int i = 0; i < op.size(); ++i) {
                        int n22 = this.matchCharArray(context, op.elementAt(i), n, n2, n3);
                        if (n22 < 0) continue;
                        return n22;
                    }
                    return -1;
                }
                case 15: {
                    int n15;
                    int n23 = op.getData();
                    if (context.match != null && n23 > 0) {
                        int n24 = context.match.getBeginning(n23);
                        context.match.setBeginning(n23, n);
                        n15 = this.matchCharArray(context, op.next, n, n2, n3);
                        if (n15 < 0) {
                            context.match.setBeginning(n23, n24);
                        }
                        return n15;
                    }
                    if (context.match != null && n23 < 0) {
                        int n25 = -n23;
                        n15 = context.match.getEnd(n25);
                        context.match.setEnd(n25, n);
                        int n26 = this.matchCharArray(context, op.next, n, n2, n3);
                        if (n26 < 0) {
                            context.match.setEnd(n25, n15);
                        }
                        return n26;
                    }
                    op = op.next;
                    break;
                }
                case 20: {
                    if (0 > this.matchCharArray(context, op.getChild(), n, 1, n3)) {
                        return -1;
                    }
                    op = op.next;
                    break;
                }
                case 21: {
                    if (0 <= this.matchCharArray(context, op.getChild(), n, 1, n3)) {
                        return -1;
                    }
                    op = op.next;
                    break;
                }
                case 22: {
                    if (0 > this.matchCharArray(context, op.getChild(), n, -1, n3)) {
                        return -1;
                    }
                    op = op.next;
                    break;
                }
                case 23: {
                    if (0 <= this.matchCharArray(context, op.getChild(), n, -1, n3)) {
                        return -1;
                    }
                    op = op.next;
                    break;
                }
                case 24: {
                    int n27 = this.matchCharArray(context, op.getChild(), n, n2, n3);
                    if (n27 < 0) {
                        return n27;
                    }
                    n = n27;
                    op = op.next;
                    break;
                }
                case 25: {
                    int n28 = n3;
                    n28 |= op.getData();
                    int n15 = this.matchCharArray(context, op.getChild(), n, n2, n28 &= ~op.getData2());
                    if (n15 < 0) {
                        return n15;
                    }
                    n = n15;
                    op = op.next;
                    break;
                }
                case 26: {
                    Object object = (Op.ConditionOp)op;
                    int n15 = 0;
                    if (((Op.ConditionOp)object).refNumber > 0) {
                        if (((Op.ConditionOp)object).refNumber >= this.nofparen) {
                            throw new RuntimeException("Internal Error: Reference number must be more than zero: " + ((Op.ConditionOp)object).refNumber);
                        }
                        n15 = context.match.getBeginning(((Op.ConditionOp)object).refNumber) >= 0 && context.match.getEnd(((Op.ConditionOp)object).refNumber) >= 0 ? 1 : 0;
                    } else {
                        int n29 = n15 = 0 <= this.matchCharArray(context, ((Op.ConditionOp)object).condition, n, n2, n3) ? 1 : 0;
                    }
                    if (n15 != 0) {
                        op = ((Op.ConditionOp)object).yes;
                        break;
                    }
                    if (((Op.ConditionOp)object).no != null) {
                        op = ((Op.ConditionOp)object).no;
                        break;
                    }
                    op = ((Op.ConditionOp)object).next;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown operation type: " + op.type);
                }
            }
        }
        return n;
    }

    private static final int getPreviousWordType(char[] cArray, int n, int n2, int n3, int n4) {
        int n5 = RegularExpression.getWordType(cArray, n, n2, --n3, n4);
        while (n5 == 0) {
            n5 = RegularExpression.getWordType(cArray, n, n2, --n3, n4);
        }
        return n5;
    }

    private static final int getWordType(char[] cArray, int n, int n2, int n3, int n4) {
        if (n3 < n || n3 >= n2) {
            return 2;
        }
        return RegularExpression.getWordType0(cArray[n3], n4);
    }

    private static final boolean regionMatches(char[] cArray, int n, int n2, String string, int n3) {
        if (n < 0) {
            return false;
        }
        if (n2 - n < n3) {
            return false;
        }
        int n4 = 0;
        while (n3-- > 0) {
            if (cArray[n++] == string.charAt(n4++)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatches(char[] cArray, int n, int n2, int n3, int n4) {
        if (n < 0) {
            return false;
        }
        if (n2 - n < n4) {
            return false;
        }
        int n5 = n3;
        while (n4-- > 0) {
            if (cArray[n++] == cArray[n5++]) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(char[] cArray, int n, int n2, String string, int n3) {
        if (n < 0) {
            return false;
        }
        if (n2 - n < n3) {
            return false;
        }
        int n4 = 0;
        while (n3-- > 0) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = cArray[n++]) == (c3 = string.charAt(n4++)) || (c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(char[] cArray, int n, int n2, int n3, int n4) {
        if (n < 0) {
            return false;
        }
        if (n2 - n < n4) {
            return false;
        }
        int n5 = n3;
        while (n4-- > 0) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = cArray[n++]) == (c3 = cArray[n5++]) || (c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(String string) {
        return this.matches(string, 0, string.length(), (Match)null);
    }

    public boolean matches(String string, int n, int n2) {
        return this.matches(string, n, n2, (Match)null);
    }

    public boolean matches(String string, Match match) {
        return this.matches(string, 0, string.length(), match);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(String string, int n, int n2, Match match) {
        int n3;
        int n4;
        Object object = this;
        synchronized (object) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new Context();
            }
        }
        object = null;
        Context context = this.context;
        synchronized (context) {
            object = this.context.inuse ? new Context() : this.context;
            ((Context)object).reset(string, n, n2, this.numberOfClosures);
        }
        if (match != null) {
            match.setNumberOfGroups(this.nofparen);
            match.setSource(string);
        } else if (this.hasBackReferences) {
            match = new Match();
            match.setNumberOfGroups(this.nofparen);
        }
        ((Context)object).match = match;
        if (this.fixedStringOnly) {
            int n5 = this.fixedStringTable.matches(string, ((Context)object).start, ((Context)object).limit);
            if (n5 >= 0) {
                if (((Context)object).match != null) {
                    ((Context)object).match.setBeginning(0, n5);
                    ((Context)object).match.setEnd(0, n5 + this.fixedString.length());
                }
                ((Context)object).inuse = false;
                return true;
            }
            ((Context)object).inuse = false;
            return false;
        }
        if (this.fixedString != null && (n4 = this.fixedStringTable.matches(string, ((Context)object).start, ((Context)object).limit)) < 0) {
            ((Context)object).inuse = false;
            return false;
        }
        int n6 = ((Context)object).limit - this.minlength;
        int n7 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n3 = ((Context)object).start;
                n7 = this.matchString((Context)object, this.operations, ((Context)object).start, 1, this.options);
            } else {
                boolean bl = true;
                for (n3 = ((Context)object).start; n3 <= n6; ++n3) {
                    char c = string.charAt(n3);
                    if (RegularExpression.isEOLChar(c)) {
                        bl = true;
                        continue;
                    }
                    if (!bl || 0 > (n7 = this.matchString((Context)object, this.operations, n3, 1, this.options))) {
                        bl = false;
                        continue;
                    }
                    break;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            for (n3 = ((Context)object).start; n3 <= n6; ++n3) {
                int n8 = string.charAt(n3);
                if (REUtil.isHighSurrogate(n8) && n3 + 1 < ((Context)object).limit) {
                    n8 = REUtil.composeFromSurrogates(n8, string.charAt(n3 + 1));
                }
                if (!rangeToken.match(n8) || 0 > (n7 = this.matchString((Context)object, this.operations, n3, 1, this.options))) {
                    continue;
                }
                break;
            }
        } else {
            for (n3 = ((Context)object).start; n3 <= n6 && 0 > (n7 = this.matchString((Context)object, this.operations, n3, 1, this.options)); ++n3) {
            }
        }
        if (n7 >= 0) {
            if (((Context)object).match != null) {
                ((Context)object).match.setBeginning(0, n3);
                ((Context)object).match.setEnd(0, n7);
            }
            ((Context)object).inuse = false;
            return true;
        }
        ((Context)object).inuse = false;
        return false;
    }

    private int matchString(Context context, Op op, int n, int n2, int n3) {
        String string = context.strTarget;
        while (op != null) {
            if (n > context.limit || n < context.start) {
                return -1;
            }
            switch (op.type) {
                case 1: {
                    int n4;
                    if (RegularExpression.isSet(n3, 2)) {
                        n4 = op.getData();
                        if (n2 > 0) {
                            if (n >= context.limit || !RegularExpression.matchIgnoreCase(n4, string.charAt(n))) {
                                return -1;
                            }
                            ++n;
                        } else {
                            int n5 = n - 1;
                            if (n5 >= context.limit || n5 < 0 || !RegularExpression.matchIgnoreCase(n4, string.charAt(n5))) {
                                return -1;
                            }
                            n = n5;
                        }
                    } else {
                        n4 = op.getData();
                        if (n2 > 0) {
                            if (n >= context.limit || n4 != string.charAt(n)) {
                                return -1;
                            }
                            ++n;
                        } else {
                            int n6 = n - 1;
                            if (n6 >= context.limit || n6 < 0 || n4 != string.charAt(n6)) {
                                return -1;
                            }
                            n = n6;
                        }
                    }
                    op = op.next;
                    break;
                }
                case 0: {
                    int n4;
                    if (n2 > 0) {
                        if (n >= context.limit) {
                            return -1;
                        }
                        n4 = string.charAt(n);
                        if (RegularExpression.isSet(n3, 4)) {
                            if (REUtil.isHighSurrogate(n4) && n + 1 < context.limit) {
                                ++n;
                            }
                        } else {
                            if (REUtil.isHighSurrogate(n4) && n + 1 < context.limit) {
                                n4 = REUtil.composeFromSurrogates(n4, string.charAt(++n));
                            }
                            if (RegularExpression.isEOLChar(n4)) {
                                return -1;
                            }
                        }
                        ++n;
                    } else {
                        n4 = n - 1;
                        if (n4 >= context.limit || n4 < 0) {
                            return -1;
                        }
                        int n7 = string.charAt(n4);
                        if (RegularExpression.isSet(n3, 4)) {
                            if (REUtil.isLowSurrogate(n7) && n4 - 1 >= 0) {
                                // empty if block
                            }
                        } else {
                            if (REUtil.isLowSurrogate(n7) && n4 - 1 >= 0) {
                                n7 = REUtil.composeFromSurrogates(string.charAt(--n4), n7);
                            }
                            if (!RegularExpression.isEOLChar(n7)) {
                                return -1;
                            }
                        }
                        n = --n4;
                    }
                    op = op.next;
                    break;
                }
                case 3: 
                case 4: {
                    Object object;
                    int n4;
                    if (n2 > 0) {
                        RangeToken rangeToken;
                        if (n >= context.limit) {
                            return -1;
                        }
                        n4 = string.charAt(n);
                        if (REUtil.isHighSurrogate(n4) && n + 1 < context.limit) {
                            n4 = REUtil.composeFromSurrogates(n4, string.charAt(++n));
                        }
                        if (!(rangeToken = op.getToken()).match(n4)) {
                            return -1;
                        }
                        ++n;
                    } else {
                        n4 = n - 1;
                        if (n4 >= context.limit || n4 < 0) {
                            return -1;
                        }
                        int n8 = string.charAt(n4);
                        if (REUtil.isLowSurrogate(n8) && n4 - 1 >= 0) {
                            n8 = REUtil.composeFromSurrogates(string.charAt(--n4), n8);
                        }
                        if (!((RangeToken)(object = op.getToken())).match(n8)) {
                            return -1;
                        }
                        n = n4;
                    }
                    op = op.next;
                    break;
                }
                case 5: {
                    int n4 = 0;
                    switch (op.getData()) {
                        case 94: {
                            if (!(RegularExpression.isSet(n3, 8) ? n != 0 && (n <= 0 || !RegularExpression.isEOLChar(string.charAt(n - 1)) || n >= context.strTarget.length()) : n != 0)) break;
                            return -1;
                        }
                        case 64: {
                            if (n == 0 || n > 0 && RegularExpression.isEOLChar(string.charAt(n - 1))) break;
                            return -1;
                        }
                        case 36: {
                            if (!(RegularExpression.isSet(n3, 8) ? n != context.strTarget.length() && (n >= context.strTarget.length() || string.charAt(n) != '\n') : (this.backcompat ? !(n == context.strTarget.length() || n + 1 == context.strTarget.length() && RegularExpression.isEOLChar(string.charAt(n)) || n + 2 == context.strTarget.length() && string.charAt(n) == '\r' && string.charAt(n + 1) == '\n') : n != context.strTarget.length()))) break;
                            return -1;
                        }
                        case 65: {
                            if (n == context.start) break;
                            return -1;
                        }
                        case 90: {
                            if (n == context.limit || n + 1 == context.limit && RegularExpression.isEOLChar(string.charAt(n)) || n + 2 == context.limit && string.charAt(n) == '\r' && string.charAt(n + 1) == '\n') break;
                            return -1;
                        }
                        case 122: {
                            if (n == context.limit) break;
                            return -1;
                        }
                        case 98: {
                            if (context.length == 0) {
                                return -1;
                            }
                            int n9 = RegularExpression.getWordType(string, context.start, context.limit, n, n3);
                            if (n9 == 0) {
                                return -1;
                            }
                            int n10 = RegularExpression.getPreviousWordType(string, context.start, context.limit, n, n3);
                            if (n9 != n10) break;
                            return -1;
                        }
                        case 66: {
                            if (context.length == 0) {
                                n4 = 1;
                            } else {
                                int n11 = RegularExpression.getWordType(string, context.start, context.limit, n, n3);
                                int n12 = n4 = n11 == 0 || n11 == RegularExpression.getPreviousWordType(string, context.start, context.limit, n, n3) ? 1 : 0;
                            }
                            if (n4 != 0) break;
                            return -1;
                        }
                        case 60: {
                            if (context.length == 0 || n == context.limit) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(string, context.start, context.limit, n, n3) == 1 && RegularExpression.getPreviousWordType(string, context.start, context.limit, n, n3) == 2) break;
                            return -1;
                        }
                        case 62: {
                            if (context.length == 0 || n == context.start) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(string, context.start, context.limit, n, n3) == 2 && RegularExpression.getPreviousWordType(string, context.start, context.limit, n, n3) == 1) break;
                            return -1;
                        }
                    }
                    op = op.next;
                    break;
                }
                case 16: {
                    int n13 = op.getData();
                    if (n13 <= 0 || n13 >= this.nofparen) {
                        throw new RuntimeException("Internal Error: Reference number must be more than zero: " + n13);
                    }
                    if (context.match.getBeginning(n13) < 0 || context.match.getEnd(n13) < 0) {
                        return -1;
                    }
                    int n14 = context.match.getBeginning(n13);
                    int n15 = context.match.getEnd(n13) - n14;
                    if (!RegularExpression.isSet(n3, 2)) {
                        if (n2 > 0) {
                            if (!RegularExpression.regionMatches(string, n, context.limit, n14, n15)) {
                                return -1;
                            }
                            n += n15;
                        } else {
                            if (!RegularExpression.regionMatches(string, n - n15, context.limit, n14, n15)) {
                                return -1;
                            }
                            n -= n15;
                        }
                    } else if (n2 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(string, n, context.limit, n14, n15)) {
                            return -1;
                        }
                        n += n15;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(string, n - n15, context.limit, n14, n15)) {
                            return -1;
                        }
                        n -= n15;
                    }
                    op = op.next;
                    break;
                }
                case 6: {
                    String string2 = op.getString();
                    int n16 = string2.length();
                    if (!RegularExpression.isSet(n3, 2)) {
                        if (n2 > 0) {
                            if (!RegularExpression.regionMatches(string, n, context.limit, string2, n16)) {
                                return -1;
                            }
                            n += n16;
                        } else {
                            if (!RegularExpression.regionMatches(string, n - n16, context.limit, string2, n16)) {
                                return -1;
                            }
                            n -= n16;
                        }
                    } else if (n2 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(string, n, context.limit, string2, n16)) {
                            return -1;
                        }
                        n += n16;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(string, n - n16, context.limit, string2, n16)) {
                            return -1;
                        }
                        n -= n16;
                    }
                    op = op.next;
                    break;
                }
                case 7: {
                    int n17 = op.getData();
                    if (n17 >= 0) {
                        int n18 = context.offsets[n17];
                        if (n18 < 0 || n18 != n) {
                            context.offsets[n17] = n;
                        } else {
                            context.offsets[n17] = -1;
                            op = op.next;
                            break;
                        }
                    }
                    int n19 = this.matchString(context, op.getChild(), n, n2, n3);
                    if (n17 >= 0) {
                        context.offsets[n17] = -1;
                    }
                    if (n19 >= 0) {
                        return n19;
                    }
                    op = op.next;
                    break;
                }
                case 9: {
                    int n20 = this.matchString(context, op.getChild(), n, n2, n3);
                    if (n20 >= 0) {
                        return n20;
                    }
                    op = op.next;
                    break;
                }
                case 8: 
                case 10: {
                    int n21 = this.matchString(context, op.next, n, n2, n3);
                    if (n21 >= 0) {
                        return n21;
                    }
                    op = op.getChild();
                    break;
                }
                case 11: {
                    for (int i = 0; i < op.size(); ++i) {
                        int n22 = this.matchString(context, op.elementAt(i), n, n2, n3);
                        if (n22 < 0) continue;
                        return n22;
                    }
                    return -1;
                }
                case 15: {
                    int n15;
                    int n23 = op.getData();
                    if (context.match != null && n23 > 0) {
                        int n24 = context.match.getBeginning(n23);
                        context.match.setBeginning(n23, n);
                        n15 = this.matchString(context, op.next, n, n2, n3);
                        if (n15 < 0) {
                            context.match.setBeginning(n23, n24);
                        }
                        return n15;
                    }
                    if (context.match != null && n23 < 0) {
                        int n25 = -n23;
                        n15 = context.match.getEnd(n25);
                        context.match.setEnd(n25, n);
                        int n26 = this.matchString(context, op.next, n, n2, n3);
                        if (n26 < 0) {
                            context.match.setEnd(n25, n15);
                        }
                        return n26;
                    }
                    op = op.next;
                    break;
                }
                case 20: {
                    if (0 > this.matchString(context, op.getChild(), n, 1, n3)) {
                        return -1;
                    }
                    op = op.next;
                    break;
                }
                case 21: {
                    if (0 <= this.matchString(context, op.getChild(), n, 1, n3)) {
                        return -1;
                    }
                    op = op.next;
                    break;
                }
                case 22: {
                    if (0 > this.matchString(context, op.getChild(), n, -1, n3)) {
                        return -1;
                    }
                    op = op.next;
                    break;
                }
                case 23: {
                    if (0 <= this.matchString(context, op.getChild(), n, -1, n3)) {
                        return -1;
                    }
                    op = op.next;
                    break;
                }
                case 24: {
                    int n27 = this.matchString(context, op.getChild(), n, n2, n3);
                    if (n27 < 0) {
                        return n27;
                    }
                    n = n27;
                    op = op.next;
                    break;
                }
                case 25: {
                    int n28 = n3;
                    n28 |= op.getData();
                    int n15 = this.matchString(context, op.getChild(), n, n2, n28 &= ~op.getData2());
                    if (n15 < 0) {
                        return n15;
                    }
                    n = n15;
                    op = op.next;
                    break;
                }
                case 26: {
                    Object object = (Op.ConditionOp)op;
                    int n15 = 0;
                    if (((Op.ConditionOp)object).refNumber > 0) {
                        if (((Op.ConditionOp)object).refNumber >= this.nofparen) {
                            throw new RuntimeException("Internal Error: Reference number must be more than zero: " + ((Op.ConditionOp)object).refNumber);
                        }
                        n15 = context.match.getBeginning(((Op.ConditionOp)object).refNumber) >= 0 && context.match.getEnd(((Op.ConditionOp)object).refNumber) >= 0 ? 1 : 0;
                    } else {
                        int n29 = n15 = 0 <= this.matchString(context, ((Op.ConditionOp)object).condition, n, n2, n3) ? 1 : 0;
                    }
                    if (n15 != 0) {
                        op = ((Op.ConditionOp)object).yes;
                        break;
                    }
                    if (((Op.ConditionOp)object).no != null) {
                        op = ((Op.ConditionOp)object).no;
                        break;
                    }
                    op = ((Op.ConditionOp)object).next;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown operation type: " + op.type);
                }
            }
        }
        return n;
    }

    private static final int getPreviousWordType(String string, int n, int n2, int n3, int n4) {
        int n5 = RegularExpression.getWordType(string, n, n2, --n3, n4);
        while (n5 == 0) {
            n5 = RegularExpression.getWordType(string, n, n2, --n3, n4);
        }
        return n5;
    }

    private static final int getWordType(String string, int n, int n2, int n3, int n4) {
        if (n3 < n || n3 >= n2) {
            return 2;
        }
        return RegularExpression.getWordType0(string.charAt(n3), n4);
    }

    private static final boolean regionMatches(String string, int n, int n2, String string2, int n3) {
        if (n2 - n < n3) {
            return false;
        }
        return string.regionMatches(n, string2, 0, n3);
    }

    private static final boolean regionMatches(String string, int n, int n2, int n3, int n4) {
        if (n2 - n < n4) {
            return false;
        }
        return string.regionMatches(n, string, n3, n4);
    }

    private static final boolean regionMatchesIgnoreCase(String string, int n, int n2, String string2, int n3) {
        return string.regionMatches(true, n, string2, 0, n3);
    }

    private static final boolean regionMatchesIgnoreCase(String string, int n, int n2, int n3, int n4) {
        if (n2 - n < n4) {
            return false;
        }
        return string.regionMatches(true, n, string, n3, n4);
    }

    public boolean matches(CharacterIterator characterIterator) {
        return this.matches(characterIterator, (Match)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(CharacterIterator characterIterator, Match match) {
        int n;
        int n2;
        int n3 = characterIterator.getBeginIndex();
        int n4 = characterIterator.getEndIndex();
        Object object = this;
        synchronized (object) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new Context();
            }
        }
        object = null;
        Context context = this.context;
        synchronized (context) {
            object = this.context.inuse ? new Context() : this.context;
            ((Context)object).reset(characterIterator, n3, n4, this.numberOfClosures);
        }
        if (match != null) {
            match.setNumberOfGroups(this.nofparen);
            match.setSource(characterIterator);
        } else if (this.hasBackReferences) {
            match = new Match();
            match.setNumberOfGroups(this.nofparen);
        }
        ((Context)object).match = match;
        if (this.fixedStringOnly) {
            int n5 = this.fixedStringTable.matches(characterIterator, ((Context)object).start, ((Context)object).limit);
            if (n5 >= 0) {
                if (((Context)object).match != null) {
                    ((Context)object).match.setBeginning(0, n5);
                    ((Context)object).match.setEnd(0, n5 + this.fixedString.length());
                }
                ((Context)object).inuse = false;
                return true;
            }
            ((Context)object).inuse = false;
            return false;
        }
        if (this.fixedString != null && (n2 = this.fixedStringTable.matches(characterIterator, ((Context)object).start, ((Context)object).limit)) < 0) {
            ((Context)object).inuse = false;
            return false;
        }
        int n6 = ((Context)object).limit - this.minlength;
        int n7 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n = ((Context)object).start;
                n7 = this.matchCharacterIterator((Context)object, this.operations, ((Context)object).start, 1, this.options);
            } else {
                boolean bl = true;
                for (n = ((Context)object).start; n <= n6; ++n) {
                    char c = characterIterator.setIndex(n);
                    if (RegularExpression.isEOLChar(c)) {
                        bl = true;
                        continue;
                    }
                    if (!bl || 0 > (n7 = this.matchCharacterIterator((Context)object, this.operations, n, 1, this.options))) {
                        bl = false;
                        continue;
                    }
                    break;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            for (n = ((Context)object).start; n <= n6; ++n) {
                int n8 = characterIterator.setIndex(n);
                if (REUtil.isHighSurrogate(n8) && n + 1 < ((Context)object).limit) {
                    n8 = REUtil.composeFromSurrogates(n8, characterIterator.setIndex(n + 1));
                }
                if (!rangeToken.match(n8) || 0 > (n7 = this.matchCharacterIterator((Context)object, this.operations, n, 1, this.options))) {
                    continue;
                }
                break;
            }
        } else {
            for (n = ((Context)object).start; n <= n6 && 0 > (n7 = this.matchCharacterIterator((Context)object, this.operations, n, 1, this.options)); ++n) {
            }
        }
        if (n7 >= 0) {
            if (((Context)object).match != null) {
                ((Context)object).match.setBeginning(0, n);
                ((Context)object).match.setEnd(0, n7);
            }
            ((Context)object).inuse = false;
            return true;
        }
        ((Context)object).inuse = false;
        return false;
    }

    private int matchCharacterIterator(Context context, Op op, int n, int n2, int n3) {
        CharacterIterator characterIterator = context.ciTarget;
        while (op != null) {
            if (n > context.limit || n < context.start) {
                return -1;
            }
            switch (op.type) {
                case 1: {
                    int n4;
                    if (RegularExpression.isSet(n3, 2)) {
                        n4 = op.getData();
                        if (n2 > 0) {
                            if (n >= context.limit || !RegularExpression.matchIgnoreCase(n4, characterIterator.setIndex(n))) {
                                return -1;
                            }
                            ++n;
                        } else {
                            int n5 = n - 1;
                            if (n5 >= context.limit || n5 < 0 || !RegularExpression.matchIgnoreCase(n4, characterIterator.setIndex(n5))) {
                                return -1;
                            }
                            n = n5;
                        }
                    } else {
                        n4 = op.getData();
                        if (n2 > 0) {
                            if (n >= context.limit || n4 != characterIterator.setIndex(n)) {
                                return -1;
                            }
                            ++n;
                        } else {
                            int n6 = n - 1;
                            if (n6 >= context.limit || n6 < 0 || n4 != characterIterator.setIndex(n6)) {
                                return -1;
                            }
                            n = n6;
                        }
                    }
                    op = op.next;
                    break;
                }
                case 0: {
                    int n4;
                    if (n2 > 0) {
                        if (n >= context.limit) {
                            return -1;
                        }
                        n4 = characterIterator.setIndex(n);
                        if (RegularExpression.isSet(n3, 4)) {
                            if (REUtil.isHighSurrogate(n4) && n + 1 < context.limit) {
                                ++n;
                            }
                        } else {
                            if (REUtil.isHighSurrogate(n4) && n + 1 < context.limit) {
                                n4 = REUtil.composeFromSurrogates(n4, characterIterator.setIndex(++n));
                            }
                            if (RegularExpression.isEOLChar(n4)) {
                                return -1;
                            }
                        }
                        ++n;
                    } else {
                        n4 = n - 1;
                        if (n4 >= context.limit || n4 < 0) {
                            return -1;
                        }
                        int n7 = characterIterator.setIndex(n4);
                        if (RegularExpression.isSet(n3, 4)) {
                            if (REUtil.isLowSurrogate(n7) && n4 - 1 >= 0) {
                                // empty if block
                            }
                        } else {
                            if (REUtil.isLowSurrogate(n7) && n4 - 1 >= 0) {
                                n7 = REUtil.composeFromSurrogates(characterIterator.setIndex(--n4), n7);
                            }
                            if (!RegularExpression.isEOLChar(n7)) {
                                return -1;
                            }
                        }
                        n = --n4;
                    }
                    op = op.next;
                    break;
                }
                case 3: 
                case 4: {
                    Object object;
                    int n4;
                    if (n2 > 0) {
                        RangeToken rangeToken;
                        if (n >= context.limit) {
                            return -1;
                        }
                        n4 = characterIterator.setIndex(n);
                        if (REUtil.isHighSurrogate(n4) && n + 1 < context.limit) {
                            n4 = REUtil.composeFromSurrogates(n4, characterIterator.setIndex(++n));
                        }
                        if (!(rangeToken = op.getToken()).match(n4)) {
                            return -1;
                        }
                        ++n;
                    } else {
                        n4 = n - 1;
                        if (n4 >= context.limit || n4 < 0) {
                            return -1;
                        }
                        int n8 = characterIterator.setIndex(n4);
                        if (REUtil.isLowSurrogate(n8) && n4 - 1 >= 0) {
                            n8 = REUtil.composeFromSurrogates(characterIterator.setIndex(--n4), n8);
                        }
                        if (!((RangeToken)(object = op.getToken())).match(n8)) {
                            return -1;
                        }
                        n = n4;
                    }
                    op = op.next;
                    break;
                }
                case 5: {
                    int n4 = 0;
                    switch (op.getData()) {
                        case 94: {
                            if (!(RegularExpression.isSet(n3, 8) ? n != 0 && (n <= 0 || !RegularExpression.isEOLChar(characterIterator.setIndex(n - 1)) || n >= context.strTarget.length()) : n != 0)) break;
                            return -1;
                        }
                        case 64: {
                            if (n == 0 || n > 0 && RegularExpression.isEOLChar(characterIterator.setIndex(n - 1))) break;
                            return -1;
                        }
                        case 36: {
                            if (!(RegularExpression.isSet(n3, 8) ? n != context.strTarget.length() && (n >= context.strTarget.length() || !RegularExpression.isEOLChar(characterIterator.setIndex(n))) : (this.backcompat ? !(n == context.strTarget.length() || n + 1 == context.strTarget.length() && RegularExpression.isEOLChar(characterIterator.setIndex(n)) || n + 2 == context.strTarget.length() && characterIterator.setIndex(n) == '\r' && characterIterator.setIndex(n + 1) == '\n') : n != context.strTarget.length()))) break;
                            return -1;
                        }
                        case 65: {
                            if (n == context.start) break;
                            return -1;
                        }
                        case 90: {
                            if (n == context.limit || n + 1 == context.limit && RegularExpression.isEOLChar(characterIterator.setIndex(n)) || n + 2 == context.limit && characterIterator.setIndex(n) == '\r' && characterIterator.setIndex(n + 1) == '\n') break;
                            return -1;
                        }
                        case 122: {
                            if (n == context.limit) break;
                            return -1;
                        }
                        case 98: {
                            if (context.length == 0) {
                                return -1;
                            }
                            int n9 = RegularExpression.getWordType(characterIterator, context.start, context.limit, n, n3);
                            if (n9 == 0) {
                                return -1;
                            }
                            int n10 = RegularExpression.getPreviousWordType(characterIterator, context.start, context.limit, n, n3);
                            if (n9 != n10) break;
                            return -1;
                        }
                        case 66: {
                            if (context.length == 0) {
                                n4 = 1;
                            } else {
                                int n11 = RegularExpression.getWordType(characterIterator, context.start, context.limit, n, n3);
                                int n12 = n4 = n11 == 0 || n11 == RegularExpression.getPreviousWordType(characterIterator, context.start, context.limit, n, n3) ? 1 : 0;
                            }
                            if (n4 != 0) break;
                            return -1;
                        }
                        case 60: {
                            if (context.length == 0 || n == context.limit) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(characterIterator, context.start, context.limit, n, n3) == 1 && RegularExpression.getPreviousWordType(characterIterator, context.start, context.limit, n, n3) == 2) break;
                            return -1;
                        }
                        case 62: {
                            if (context.length == 0 || n == context.start) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(characterIterator, context.start, context.limit, n, n3) == 2 && RegularExpression.getPreviousWordType(characterIterator, context.start, context.limit, n, n3) == 1) break;
                            return -1;
                        }
                    }
                    op = op.next;
                    break;
                }
                case 16: {
                    int n13 = op.getData();
                    if (n13 <= 0 || n13 >= this.nofparen) {
                        throw new RuntimeException("Internal Error: Reference number must be more than zero: " + n13);
                    }
                    if (context.match.getBeginning(n13) < 0 || context.match.getEnd(n13) < 0) {
                        return -1;
                    }
                    int n14 = context.match.getBeginning(n13);
                    int n15 = context.match.getEnd(n13) - n14;
                    if (!RegularExpression.isSet(n3, 2)) {
                        if (n2 > 0) {
                            if (!RegularExpression.regionMatches(characterIterator, n, context.limit, n14, n15)) {
                                return -1;
                            }
                            n += n15;
                        } else {
                            if (!RegularExpression.regionMatches(characterIterator, n - n15, context.limit, n14, n15)) {
                                return -1;
                            }
                            n -= n15;
                        }
                    } else if (n2 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n, context.limit, n14, n15)) {
                            return -1;
                        }
                        n += n15;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n - n15, context.limit, n14, n15)) {
                            return -1;
                        }
                        n -= n15;
                    }
                    op = op.next;
                    break;
                }
                case 6: {
                    String string = op.getString();
                    int n16 = string.length();
                    if (!RegularExpression.isSet(n3, 2)) {
                        if (n2 > 0) {
                            if (!RegularExpression.regionMatches(characterIterator, n, context.limit, string, n16)) {
                                return -1;
                            }
                            n += n16;
                        } else {
                            if (!RegularExpression.regionMatches(characterIterator, n - n16, context.limit, string, n16)) {
                                return -1;
                            }
                            n -= n16;
                        }
                    } else if (n2 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n, context.limit, string, n16)) {
                            return -1;
                        }
                        n += n16;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n - n16, context.limit, string, n16)) {
                            return -1;
                        }
                        n -= n16;
                    }
                    op = op.next;
                    break;
                }
                case 7: {
                    int n17 = op.getData();
                    if (n17 >= 0) {
                        int n18 = context.offsets[n17];
                        if (n18 < 0 || n18 != n) {
                            context.offsets[n17] = n;
                        } else {
                            context.offsets[n17] = -1;
                            op = op.next;
                            break;
                        }
                    }
                    int n19 = this.matchCharacterIterator(context, op.getChild(), n, n2, n3);
                    if (n17 >= 0) {
                        context.offsets[n17] = -1;
                    }
                    if (n19 >= 0) {
                        return n19;
                    }
                    op = op.next;
                    break;
                }
                case 9: {
                    int n20 = this.matchCharacterIterator(context, op.getChild(), n, n2, n3);
                    if (n20 >= 0) {
                        return n20;
                    }
                    op = op.next;
                    break;
                }
                case 8: 
                case 10: {
                    int n21 = this.matchCharacterIterator(context, op.next, n, n2, n3);
                    if (n21 >= 0) {
                        return n21;
                    }
                    op = op.getChild();
                    break;
                }
                case 11: {
                    for (int i = 0; i < op.size(); ++i) {
                        int n22 = this.matchCharacterIterator(context, op.elementAt(i), n, n2, n3);
                        if (n22 < 0) continue;
                        return n22;
                    }
                    return -1;
                }
                case 15: {
                    int n15;
                    int n23 = op.getData();
                    if (context.match != null && n23 > 0) {
                        int n24 = context.match.getBeginning(n23);
                        context.match.setBeginning(n23, n);
                        n15 = this.matchCharacterIterator(context, op.next, n, n2, n3);
                        if (n15 < 0) {
                            context.match.setBeginning(n23, n24);
                        }
                        return n15;
                    }
                    if (context.match != null && n23 < 0) {
                        int n25 = -n23;
                        n15 = context.match.getEnd(n25);
                        context.match.setEnd(n25, n);
                        int n26 = this.matchCharacterIterator(context, op.next, n, n2, n3);
                        if (n26 < 0) {
                            context.match.setEnd(n25, n15);
                        }
                        return n26;
                    }
                    op = op.next;
                    break;
                }
                case 20: {
                    if (0 > this.matchCharacterIterator(context, op.getChild(), n, 1, n3)) {
                        return -1;
                    }
                    op = op.next;
                    break;
                }
                case 21: {
                    if (0 <= this.matchCharacterIterator(context, op.getChild(), n, 1, n3)) {
                        return -1;
                    }
                    op = op.next;
                    break;
                }
                case 22: {
                    if (0 > this.matchCharacterIterator(context, op.getChild(), n, -1, n3)) {
                        return -1;
                    }
                    op = op.next;
                    break;
                }
                case 23: {
                    if (0 <= this.matchCharacterIterator(context, op.getChild(), n, -1, n3)) {
                        return -1;
                    }
                    op = op.next;
                    break;
                }
                case 24: {
                    int n27 = this.matchCharacterIterator(context, op.getChild(), n, n2, n3);
                    if (n27 < 0) {
                        return n27;
                    }
                    n = n27;
                    op = op.next;
                    break;
                }
                case 25: {
                    int n28 = n3;
                    n28 |= op.getData();
                    int n15 = this.matchCharacterIterator(context, op.getChild(), n, n2, n28 &= ~op.getData2());
                    if (n15 < 0) {
                        return n15;
                    }
                    n = n15;
                    op = op.next;
                    break;
                }
                case 26: {
                    Object object = (Op.ConditionOp)op;
                    int n15 = 0;
                    if (((Op.ConditionOp)object).refNumber > 0) {
                        if (((Op.ConditionOp)object).refNumber >= this.nofparen) {
                            throw new RuntimeException("Internal Error: Reference number must be more than zero: " + ((Op.ConditionOp)object).refNumber);
                        }
                        n15 = context.match.getBeginning(((Op.ConditionOp)object).refNumber) >= 0 && context.match.getEnd(((Op.ConditionOp)object).refNumber) >= 0 ? 1 : 0;
                    } else {
                        int n29 = n15 = 0 <= this.matchCharacterIterator(context, ((Op.ConditionOp)object).condition, n, n2, n3) ? 1 : 0;
                    }
                    if (n15 != 0) {
                        op = ((Op.ConditionOp)object).yes;
                        break;
                    }
                    if (((Op.ConditionOp)object).no != null) {
                        op = ((Op.ConditionOp)object).no;
                        break;
                    }
                    op = ((Op.ConditionOp)object).next;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown operation type: " + op.type);
                }
            }
        }
        return n;
    }

    private static final int getPreviousWordType(CharacterIterator characterIterator, int n, int n2, int n3, int n4) {
        int n5 = RegularExpression.getWordType(characterIterator, n, n2, --n3, n4);
        while (n5 == 0) {
            n5 = RegularExpression.getWordType(characterIterator, n, n2, --n3, n4);
        }
        return n5;
    }

    private static final int getWordType(CharacterIterator characterIterator, int n, int n2, int n3, int n4) {
        if (n3 < n || n3 >= n2) {
            return 2;
        }
        return RegularExpression.getWordType0(characterIterator.setIndex(n3), n4);
    }

    private static final boolean regionMatches(CharacterIterator characterIterator, int n, int n2, String string, int n3) {
        if (n < 0) {
            return false;
        }
        if (n2 - n < n3) {
            return false;
        }
        int n4 = 0;
        while (n3-- > 0) {
            if (characterIterator.setIndex(n++) == string.charAt(n4++)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatches(CharacterIterator characterIterator, int n, int n2, int n3, int n4) {
        if (n < 0) {
            return false;
        }
        if (n2 - n < n4) {
            return false;
        }
        int n5 = n3;
        while (n4-- > 0) {
            if (characterIterator.setIndex(n++) == characterIterator.setIndex(n5++)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(CharacterIterator characterIterator, int n, int n2, String string, int n3) {
        if (n < 0) {
            return false;
        }
        if (n2 - n < n3) {
            return false;
        }
        int n4 = 0;
        while (n3-- > 0) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = characterIterator.setIndex(n++)) == (c3 = string.charAt(n4++)) || (c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(CharacterIterator characterIterator, int n, int n2, int n3, int n4) {
        if (n < 0) {
            return false;
        }
        if (n2 - n < n4) {
            return false;
        }
        int n5 = n3;
        while (n4-- > 0) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = characterIterator.setIndex(n++)) == (c3 = characterIterator.setIndex(n5++)) || (c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    void prepare() {
        Object object;
        int n;
        this.compile(this.tokentree);
        this.minlength = this.tokentree.getMinLength();
        this.firstChar = null;
        if (!RegularExpression.isSet(this.options, 128) && !RegularExpression.isSet(this.options, 512) && (n = this.tokentree.analyzeFirstCharacter((RangeToken)(object = Token.createRange()), this.options)) == 1) {
            ((RangeToken)object).compactRanges();
            this.firstChar = object;
        }
        if (this.operations != null && (this.operations.type == 6 || this.operations.type == 1) && this.operations.next == null) {
            this.fixedStringOnly = true;
            if (this.operations.type == 6) {
                this.fixedString = this.operations.getString();
            } else if (this.operations.getData() >= 65536) {
                this.fixedString = REUtil.decomposeToSurrogates(this.operations.getData());
            } else {
                object = new char[1];
                object[0] = (char)this.operations.getData();
                this.fixedString = new String((char[])object);
            }
            this.fixedStringOptions = this.options;
            this.fixedStringTable = new BMPattern(this.fixedString, 256, RegularExpression.isSet(this.fixedStringOptions, 2));
        } else if (!RegularExpression.isSet(this.options, 256) && !RegularExpression.isSet(this.options, 512)) {
            object = new Token.FixedStringContainer();
            this.tokentree.findFixedString((Token.FixedStringContainer)object, this.options);
            this.fixedString = ((Token.FixedStringContainer)object).token == null ? null : ((Token.FixedStringContainer)object).token.getString();
            this.fixedStringOptions = ((Token.FixedStringContainer)object).options;
            if (this.fixedString != null && this.fixedString.length() < 2) {
                this.fixedString = null;
            }
            if (this.fixedString != null) {
                this.fixedStringTable = new BMPattern(this.fixedString, 256, RegularExpression.isSet(this.fixedStringOptions, 2));
            }
        }
    }

    private static final boolean isSet(int n, int n2) {
        return (n & n2) == n2;
    }

    public RegularExpression(String string, boolean bl) throws ParseException {
        this.setPattern(string, null, bl);
    }

    public RegularExpression(String string, String string2, boolean bl) throws ParseException {
        this.setPattern(string, string2, bl);
        this.backcompat = bl;
    }

    RegularExpression(String string, Token token, int n, boolean bl, int n2) {
        this.regex = string;
        this.tokentree = token;
        this.nofparen = n;
        this.options = n2;
        this.hasBackReferences = bl;
    }

    public void setPattern(String string, boolean bl) throws ParseException {
        this.setPattern(string, this.options, bl);
    }

    private void setPattern(String string, int n, boolean bl) throws ParseException {
        this.regex = string;
        this.options = n;
        if (RegularExpression.isSet(this.options, 2048)) {
            this.tokentree = Token.createString(this.regex);
            this.nofparen = 1;
        } else {
            RegexParser regexParser = RegularExpression.isSet(this.options, 512) ? new ParserForXMLSchema(bl) : new RegexParser(bl);
            this.tokentree = regexParser.parse(this.regex, this.options);
            this.nofparen = regexParser.parennumber;
            this.hasBackReferences = regexParser.hasBackReferences;
        }
        this.operations = null;
        this.context = null;
    }

    public void setPattern(String string, String string2, boolean bl) throws ParseException {
        this.setPattern(string, REUtil.parseOptions(string2), bl);
    }

    public String getPattern() {
        return this.regex;
    }

    public String toString() {
        return this.tokentree.toString(this.options);
    }

    public String getOptions() {
        return REUtil.createOptionString(this.options);
    }

    public boolean isOptionSet(int n) {
        return (this.options & n) == n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RegularExpression)) {
            return false;
        }
        RegularExpression regularExpression = (RegularExpression)object;
        return this.regex.equals(regularExpression.regex) && this.options == regularExpression.options;
    }

    boolean equals(String string, int n) {
        return this.regex.equals(string) && this.options == n;
    }

    public int hashCode() {
        return (this.regex + "/" + this.getOptions()).hashCode();
    }

    public int getNumberOfGroups() {
        return this.nofparen;
    }

    public int[] getGroupParentIndex() {
        int[] nArray = new int[this.nofparen];
        nArray[0] = -1;
        this.getGroupParentIndex(this.tokentree, 0, nArray);
        return nArray;
    }

    private void getGroupParentIndex(Token token, int n, int[] nArray) {
        int n2;
        if (token.type == 6) {
            n2 = token.getParenNumber();
            nArray[n2] = n;
            n = n2;
        }
        for (n2 = 0; n2 < token.size(); ++n2) {
            this.getGroupParentIndex(token.getChild(n2), n, nArray);
        }
    }

    private static final int getWordType0(char c, int n) {
        if (!RegularExpression.isSet(n, 64)) {
            if (RegularExpression.isSet(n, 32)) {
                return Token.getRange("IsWord", true).match(c) ? 1 : 2;
            }
            return RegularExpression.isWordChar(c) ? 1 : 2;
        }
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return 1;
            }
            case 6: 
            case 7: 
            case 16: {
                return 0;
            }
            case 15: {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': {
                        return 2;
                    }
                }
                return 0;
            }
        }
        return 2;
    }

    private static final boolean isEOLChar(int n) {
        return n == 10 || n == 13 || n == 8232 || n == 8233;
    }

    private static final boolean isWordChar(int n) {
        if (n == 95) {
            return true;
        }
        if (n < 48) {
            return false;
        }
        if (n > 122) {
            return false;
        }
        if (n <= 57) {
            return true;
        }
        if (n < 65) {
            return false;
        }
        if (n <= 90) {
            return true;
        }
        return n >= 97;
    }

    private static final boolean matchIgnoreCase(int n, int n2) {
        char c;
        if (n == n2) {
            return true;
        }
        if (n > 65535 || n2 > 65535) {
            return false;
        }
        char c2 = Character.toUpperCase((char)n);
        if (c2 == (c = Character.toUpperCase((char)n2))) {
            return true;
        }
        return Character.toLowerCase(c2) == Character.toLowerCase(c);
    }

    static final class Context {
        CharacterIterator ciTarget;
        String strTarget;
        char[] charTarget;
        int start;
        int limit;
        int length;
        Match match;
        boolean inuse = false;
        int[] offsets;

        Context() {
        }

        private void resetCommon(int n) {
            this.length = this.limit - this.start;
            this.inuse = true;
            this.match = null;
            if (this.offsets == null || this.offsets.length != n) {
                this.offsets = new int[n];
            }
            for (int i = 0; i < n; ++i) {
                this.offsets[i] = -1;
            }
        }

        void reset(CharacterIterator characterIterator, int n, int n2, int n3) {
            this.ciTarget = characterIterator;
            this.start = n;
            this.limit = n2;
            this.resetCommon(n3);
        }

        void reset(String string, int n, int n2, int n3) {
            this.strTarget = string;
            this.start = n;
            this.limit = n2;
            this.resetCommon(n3);
        }

        void reset(char[] cArray, int n, int n2, int n3) {
            this.charTarget = cArray;
            this.start = n;
            this.limit = n2;
            this.resetCommon(n3);
        }
    }
}

