/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.common.config;

import java.io.File;
import oracle.dss.util.xdo.common.log.Logger;

public class ConfigLocation {
    public static final int CORE = 0;
    public static final int DELIVERY = 1;
    public static final int DEBUG = 2;
    private static final String NAME_CORE = "xdo.cfg";
    private static final String NAME_DELIVERY = "xdodelivery.cfg";
    private static final String NAME_DEBUG = "xdodebug.cfg";

    public static String getPath(int type) {
        String sep = File.separator;
        String fname = null;
        String path = null;
        switch (type) {
            case 0: {
                fname = NAME_CORE;
                break;
            }
            case 1: {
                fname = NAME_DELIVERY;
                break;
            }
            case 2: {
                fname = NAME_DEBUG;
                break;
            }
            default: {
                Logger.log("ConfigLocation:Unknown type specified.", 5);
                return null;
            }
        }
        String xdoConfigFile = System.getProperty("xdo.ConfigFile");
        if (xdoConfigFile != null && type == 0) {
            return xdoConfigFile;
        }
        String xdoDeliveryConfigFile = System.getProperty("xdo.DeliveryConfigFile");
        if (xdoDeliveryConfigFile != null && type == 1) {
            return xdoDeliveryConfigFile;
        }
        String xdoTop = ConfigLocation.getXDOTOP();
        if (xdoTop != null && ConfigLocation.exists(path = xdoTop + "resource" + sep + fname)) {
            return path;
        }
        String javaHome = ConfigLocation.getJavaHome();
        if (javaHome != null && ConfigLocation.exists(path = javaHome + "lib" + sep + fname)) {
            return path;
        }
        return null;
    }

    private static boolean exists(String path) {
        File f = new File(path);
        return f.exists();
    }

    public static String getXDOTOP() {
        Object path = System.getProperty("XDO_TOP");
        if (path == null || ((String)path).equals("")) {
            return path;
        }
        if (!((String)path).endsWith(File.separator)) {
            path = (String)path + File.separator;
        }
        return path;
    }

    public static String getJavaHome() {
        Object path = System.getProperty("java.home");
        if (path == null || ((String)path).equals("")) {
            return path;
        }
        if (!((String)path).endsWith(File.separator)) {
            path = (String)path + File.separator;
        }
        return path;
    }

    public static String getXDOFontDir() {
        Object path = System.getProperty("XDO_FONT_DIR");
        if (path != null) {
            if (!((String)path).endsWith(File.separator)) {
                path = (String)path + File.separator;
            }
        } else {
            String sep = File.separator;
            path = System.getProperty("java.home");
            if (!((String)path).endsWith(sep)) {
                path = (String)path + sep;
            }
            path = (String)path + "lib" + sep + "fonts" + sep;
        }
        return path;
    }
}

