/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.adf.share.mt.util.MultiTenantStorage;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public class TimerInternal {
    public static final boolean ON = false;
    public static final int INDENT_LEVEL_APP = 0;
    public static final int INDENT_LEVEL_BIBEANS = 1;
    public static final int INDENT_LEVEL_OLAPI = 2;
    public static final int INDENT_LEVEL_DEFAULT = 0;
    public static final String TIMER_DELIMITER = ",";
    public static final String BIBEANS_TIMER_DEFAULT = "BIBEANS";
    public static final String OLAPI_TIMER_DEFAULT = "OLAPI";
    public static final String ALL = "all";
    public static final boolean SUPPRESS_OUTPUT = true;
    public static final boolean SUPPRESS_ZERO = true;
    public static final boolean SUPPRESS_ZERO_FALSE = false;
    public static final boolean METHOD_TIMER = true;
    public static final boolean METHOD_TIMER_FALSE = false;
    public static final int STATE_START = 0;
    public static final int STATE_INTERVAL = 1;
    public static final int STATE_STOP = 2;
    public static final int STATE_RESTART = 3;
    public static final int OPTION_DATE = 1;
    public static final int OPTION_TIME = 2;
    public static final int OPTION_INTERVAL = 4;
    public static final int OPTION_TOTAL = 8;
    public static final int OPTION_NAME = 16;
    public static final int OPTION_ALL = 31;
    public static final int OPTION_DATE_TIME = 3;
    public static final int OPTION_DEFAULT = 20;
    public static final int INDENT_SPACES = 3;
    public static final String TIME_MS = "ms";
    public static final int TIME_FIELD_WIDTH = 10;
    private static final String OUTPUT_NEWLINE = "\n";
    private static final String OUTPUT_INTERVAL = "Interval ";
    private static final String OUTPUT_PAREN_OPEN = "[";
    private static final String OUTPUT_PAREN_CLOSE = "]";
    private static final String OUTPUT_RESTART = "Restart  ";
    private static final String OUTPUT_SPACE = " ";
    private static final String OUTPUT_START = "Start    ";
    private static final String OUTPUT_STOP = "Stop     ";
    private static final String OUTPUT_TAB = " ";
    private static final String OUTPUT_TIME_TOTAL = "Total    ";
    private static final String OUTPUT_TIMER = "Timing:";
    private static final String OUTPUT_TIMER_UNIT = " ms";
    private static final String OUTPUT_TOTAL = "Total ";
    private static final String OUTPUT_METHOD = "Method ";
    private static final String OUTPUT_COLON = ":";
    private static final String OUTPUT_QUOTE = "'";
    private static final String DEFAULT_TIMER_NAME = "DVT";
    private static MultiTenantStorage<String> m_strFileTimerOutput = new MultiTenantStorage();
    private String m_strName = null;
    private Date m_dateLast = null;
    private long m_lTotal = 0L;
    private boolean m_bStarted = false;
    private int m_nIndentLevel = 0;
    private int m_nIndentSpaces = 3;
    private long m_lOptions = 20L;
    private int m_intStartStack = 0;
    @CodeSharingSafe(value="StaticField")
    private static TimerInternal m_timer = null;
    private static MultiTenantStorage<AtomicBoolean> m_bEnable = new MultiTenantStorage<AtomicBoolean>(){

        protected AtomicBoolean initialValue() {
            return new AtomicBoolean(false);
        }
    };
    private static MultiTenantStorage<PrintStream> m_printStream = new MultiTenantStorage<PrintStream>(){

        protected PrintStream initialValue() {
            return System.out;
        }
    };
    private static MultiTenantStorage<Hashtable> m_hashtableTimers = new MultiTenantStorage();
    private static MultiTenantStorage<Hashtable> m_hashtableTimersEnabled = new MultiTenantStorage();
    private static MultiTenantStorage<Connection> m_connection = new MultiTenantStorage();
    private static MultiTenantStorage<AtomicBoolean> m_bSQLenabled = new MultiTenantStorage<AtomicBoolean>(){

        protected AtomicBoolean initialValue() {
            return new AtomicBoolean(false);
        }
    };

    public TimerInternal(String strName) {
        this(strName, 20L, 0);
    }

    public TimerInternal(String strName, long lOptions) {
        this(strName, lOptions, 0);
    }

    public TimerInternal(String strName, long lOptions, int nIndentLevel) {
        this.setName(strName);
        TimerInternal.addTimer(strName);
        this.setOptions(lOptions);
        this.setIndentLevel(nIndentLevel);
    }

    public static TimerInternal getTimer(String strName) {
        return TimerInternal.getTimer(strName, 20L, 0);
    }

    public static TimerInternal getTimer(String strName, long lOptions) {
        return TimerInternal.getTimer(strName, lOptions, 0);
    }

    public static TimerInternal getTimer(String strName, long lOptions, int nIndentLevel) {
        TimerInternal timer = null;
        if (TimerInternal.getTimers() == null) {
            TimerInternal.setTimers(new Hashtable());
        }
        if (TimerInternal.getTimers() != null && (timer = (TimerInternal)TimerInternal.getTimers().get(strName)) == null && (timer = new TimerInternal(strName, lOptions, nIndentLevel)) != null) {
            TimerInternal.getTimers().put(strName, timer);
        }
        return timer;
    }

    public static TimerInternal getTimer() {
        if (m_timer == null) {
            m_timer = new TimerInternal(TimerInternal.getDefaultTimerName(), 20L);
        }
        return m_timer;
    }

    public String getName() {
        return this.m_strName;
    }

    public void setName(String strName) {
        this.m_strName = strName;
    }

    public static boolean getEnable() {
        return ((AtomicBoolean)m_bEnable.get()).get();
    }

    public static void setEnable(boolean bEnable) {
        m_bEnable.set((Object)new AtomicBoolean(bEnable));
    }

    public static boolean isSQLenabled() {
        return ((AtomicBoolean)m_bSQLenabled.get()).get();
    }

    public static void setSQLenabled(boolean bSQLenabled) {
        m_bSQLenabled.set((Object)new AtomicBoolean(bSQLenabled));
    }

    public static Connection getConnection() {
        return (Connection)m_connection.get();
    }

    public static void setConnection(Connection connection) {
        m_connection.set((Object)connection);
    }

    public static boolean getEnable(String strTimer) {
        boolean bEnable = false;
        if (!TimerInternal.getEnable()) {
            if (TimerInternal.getTimersEnabled() != null) {
                bEnable = TimerInternal.getTimersEnabled().containsKey(strTimer);
            }
        } else {
            bEnable = TimerInternal.getEnable();
        }
        return bEnable;
    }

    public static void addTimers(String strTimers) {
        if (strTimers != null) {
            Vector vstrTimers = TimerInternal.parseDelimitedStringVector(strTimers, TIMER_DELIMITER);
            TimerInternal.addTimers(vstrTimers);
        }
    }

    public static void addTimers(Vector vstrTimers) {
        if (vstrTimers != null && !vstrTimers.isEmpty()) {
            for (int nIndex = 0; nIndex < vstrTimers.size(); ++nIndex) {
                TimerInternal.addTimer((String)vstrTimers.get(nIndex));
            }
        }
    }

    public static void addTimer(String strTimer) {
        if (strTimer != null) {
            if (ALL.equalsIgnoreCase(strTimer)) {
                TimerInternal.setEnable(true);
            } else {
                Hashtable hashtableTimersEnabled = TimerInternal.getTimersEnabled();
                if (hashtableTimersEnabled == null) {
                    TimerInternal.setTimersEnabled(new Hashtable());
                }
                TimerInternal.getTimersEnabled().put(strTimer, "");
            }
        }
    }

    public static void removeTimer(String strTimer) {
        if (strTimer != null && TimerInternal.getTimersEnabled() != null) {
            TimerInternal.getTimersEnabled().remove(strTimer);
        }
    }

    public int getIndentLevel() {
        return this.m_nIndentLevel;
    }

    public void setIndentLevel(int nIndentLevel) {
        this.m_nIndentLevel = nIndentLevel;
    }

    public int getIndentSpaces() {
        return this.m_nIndentSpaces;
    }

    public void setIndentSpaces(int nIndentSpaces) {
        this.m_nIndentSpaces = nIndentSpaces;
    }

    public long getOptions() {
        return this.m_lOptions;
    }

    public void setOptions(long lOptions) {
        this.m_lOptions = lOptions;
    }

    public Date getLastDate() {
        return this.m_dateLast;
    }

    public long getTotal() {
        return this.m_lTotal;
    }

    public void setTotal(long lTime) {
        this.m_lTotal = lTime;
    }

    public boolean getStarted() {
        return this.m_bStarted;
    }

    public void message(String strMessage) {
        this.message(strMessage, 0);
    }

    public void date() {
        this.message("\nTimerInternal (in ms): " + DateFormat.getDateTimeInstance(1, 1).format(new Date()));
    }

    public void message(String strMessage, int nIndentLevel) {
        this.addIndentation(strMessage, nIndentLevel, this.getIndentSpaces());
        TimerInternal.getPrintStream().print(strMessage);
    }

    public void method(String strMessage, long lInterval) {
        this.method(strMessage, lInterval, false);
    }

    public void method(String strMessage, long lInterval, boolean bSuppressZero) {
        if (!bSuppressZero || lInterval != 0L) {
            this.formatOutput(OUTPUT_METHOD, lInterval, strMessage, this.getLastDate());
        }
    }

    public boolean start(String strDescription) {
        return this.start(strDescription, false);
    }

    public boolean start(String strDescription, boolean bSuppressOutput) {
        ++this.m_intStartStack;
        if (!this.getStarted()) {
            this.setLastDate(new Date());
            this.setTotal(0L);
            this.setStarted(true);
            if (!bSuppressOutput) {
                this.formatOutput(OUTPUT_START, 0L, strDescription, this.getLastDate());
            }
            return true;
        }
        this.processError("Cannot perform start operation on timer that has already been started.");
        return false;
    }

    public boolean interval(String strDescription) {
        if (!this.getStarted()) {
            this.processError("Cannot perform interval operation on timer that has not been started.");
            return false;
        }
        long lInterval = this.updateTimer();
        this.setTotal(this.getTotal() + lInterval);
        this.formatOutput(OUTPUT_INTERVAL, lInterval, strDescription, this.getLastDate());
        return true;
    }

    public boolean stop(String strDescription) {
        --this.m_intStartStack;
        if (this.m_intStartStack < 0) {
            this.m_intStartStack = 0;
        }
        if (this.getStarted() && this.m_intStartStack == 0) {
            long lInterval = this.updateTimer();
            this.setTotal(this.getTotal() + lInterval);
            this.formatOutput(OUTPUT_STOP, lInterval, strDescription, this.getLastDate());
            this.formatOutput(OUTPUT_TOTAL, this.getTotal(), strDescription, this.getLastDate());
            this.setStarted(false);
            return true;
        }
        this.processError("Cannot perform stop operation on timer that has not been started.");
        return false;
    }

    public boolean stop(String strDescription, boolean bMethodTimer, boolean bSuppressZero) {
        --this.m_intStartStack;
        if (this.m_intStartStack < 0) {
            this.m_intStartStack = 0;
        }
        if (this.getStarted() && this.m_intStartStack == 0) {
            long lInterval = this.updateTimer();
            this.setTotal(this.getTotal() + lInterval);
            if (!bSuppressZero || lInterval != 0L) {
                if (bMethodTimer) {
                    this.formatOutput(OUTPUT_METHOD, lInterval, strDescription, this.getLastDate());
                } else {
                    this.formatOutput(OUTPUT_STOP, lInterval, strDescription, this.getLastDate());
                    this.formatOutput(OUTPUT_TOTAL, this.getTotal(), strDescription, this.getLastDate());
                }
            }
            this.setStarted(false);
            return true;
        }
        this.processError("Cannot perform stop operation on timer that has not been started.");
        return false;
    }

    public boolean restart(String strDescription) {
        long lInterval = this.updateTimer();
        this.formatOutput(OUTPUT_RESTART, lInterval, strDescription, this.getLastDate());
        this.setStarted(true);
        return true;
    }

    public String formatDateTime(Date date, int nStyle, Locale locale) {
        StringBuffer strOutput = new StringBuffer();
        long lDateUsed = 3L & this.getOptions();
        if (date != null && lDateUsed != 0L) {
            DateFormat dateFormat = null;
            switch ((int)lDateUsed) {
                case 3: {
                    dateFormat = DateFormat.getDateTimeInstance(nStyle, nStyle, locale);
                    break;
                }
                case 1: {
                    dateFormat = DateFormat.getDateInstance(nStyle, locale);
                    break;
                }
                case 2: {
                    dateFormat = DateFormat.getTimeInstance(nStyle, locale);
                }
            }
            dateFormat.setTimeZone(TimeZone.getTimeZone("EST"));
            strOutput.append(OUTPUT_QUOTE);
            strOutput.append(OUTPUT_PAREN_OPEN);
            strOutput.append(dateFormat.format(date));
            strOutput.append(OUTPUT_PAREN_CLOSE);
            strOutput.append(OUTPUT_QUOTE);
            strOutput.append(" ");
        }
        return strOutput.toString();
    }

    public static void setFileTimerOutput(String strFileTimerOutput) {
        m_strFileTimerOutput.set((Object)strFileTimerOutput);
        try {
            if (strFileTimerOutput != null) {
                TimerInternal.setPrintStream(new PrintStream(new FileOutputStream(new File(strFileTimerOutput))));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String getFileTimerOutput() {
        return (String)m_strFileTimerOutput.get();
    }

    public static void setPrintStream(PrintStream printStream) {
        m_printStream.set((Object)printStream);
    }

    public static PrintStream getPrintStream() {
        return (PrintStream)m_printStream.get();
    }

    public static void main(String[] strArguments) {
        int i;
        TimerInternal timer = new TimerInternal("Loops!", 20L);
        timer.start("Loop1 is starting.");
        for (i = 0; i < 20000; ++i) {
            if (i != 10000) continue;
            timer.interval("Loop1 has gone half way!");
        }
        timer.stop("Loop1 has ended.");
        timer.setIndentLevel(2);
        timer.setIndentSpaces(2);
        timer.setOptions(10L);
        timer.restart("Loop2 is starting.");
        for (i = 0; i < 50000; ++i) {
            if (i != 25000) continue;
            timer.interval("Loop2 has gone half way!");
        }
        timer.stop("Loop2 has ended.");
    }

    public static void cleanup() {
        if (TimerInternal.getTimers() != null) {
            TimerInternal.getTimers().clear();
            TimerInternal.setTimers(null);
        }
        if (TimerInternal.getTimersEnabled() != null) {
            TimerInternal.getTimersEnabled().clear();
            TimerInternal.setTimersEnabled(null);
        }
    }

    public static boolean executeSQL(String strCommand) throws SQLException {
        boolean bResult = false;
        CallableStatement callableStatement = null;
        if (TimerInternal.getConnection() != null && strCommand != null) {
            try {
                callableStatement = TimerInternal.getConnection().prepareCall(strCommand);
                bResult = callableStatement.execute(strCommand);
                callableStatement.close();
            }
            catch (SQLException sqlException) {
                bResult = false;
                try {
                    callableStatement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw sqlException;
            }
        }
        return bResult;
    }

    public static void outputSQL(StringBuffer strBufferOutput) {
        StringBuffer stringBuffer = new StringBuffer(" SELECT ");
        stringBuffer.append(OUTPUT_QUOTE);
        stringBuffer.append(strBufferOutput);
        stringBuffer.append(OUTPUT_QUOTE);
        stringBuffer.append(" FROM dual ");
        try {
            TimerInternal.executeSQL(stringBuffer.toString());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected static void setTimers(Hashtable hashtableTimers) {
        m_hashtableTimers.set((Object)hashtableTimers);
    }

    protected static Hashtable getTimers() {
        return (Hashtable)m_hashtableTimers.get();
    }

    protected static Hashtable getTimersEnabled() {
        return (Hashtable)m_hashtableTimersEnabled.get();
    }

    protected static void setTimersEnabled(Hashtable hashtableTimersEnabled) {
        m_hashtableTimersEnabled.set((Object)hashtableTimersEnabled);
    }

    protected void addIndentation(String strText, int nIndentLevel, int nIndentSpaces) {
        if (strText != null) {
            int nSpaces = nIndentLevel * nIndentSpaces;
            for (int nIndex = 0; nIndex < nSpaces; ++nIndex) {
                strText = (String)strText + " ";
            }
        }
    }

    protected void addIndentation(StringBuffer strBufferText, int nIndentLevel, int nIndentCount, String strIndent) {
        if (strBufferText != null) {
            int nSpaces = nIndentLevel * nIndentCount;
            for (int nIndex = 0; nIndex < nSpaces; ++nIndex) {
                strBufferText.append(strIndent);
            }
        }
    }

    protected int getIndentLevel(String strOutputType) {
        int nIndentLevel = 1;
        if (OUTPUT_METHOD.equals(strOutputType)) {
            nIndentLevel = 4;
        } else if (OUTPUT_INTERVAL.equals(strOutputType)) {
            nIndentLevel = 3;
        } else if (OUTPUT_TOTAL.equals(strOutputType)) {
            nIndentLevel = 2;
        }
        return nIndentLevel;
    }

    protected void processError(String strError) {
        if (TimerInternal.getPrintStream() != null) {
            TimerInternal.getPrintStream().println("TimerInternal Error [" + this.getName() + "]: " + strError);
        }
    }

    protected boolean formatOutput(String strState, long lInterval, String strDescription, Date date) {
        long lOptions = this.getOptions();
        StringBuffer strOutput = new StringBuffer();
        if (TimerInternal.getEnable(this.getName())) {
            this.addIndentation(strOutput, this.getIndentLevel(), this.getIndentSpaces(), " ");
            if (date != null) {
                strOutput.append(this.formatDateTime(date, 2, Locale.US));
            }
            strOutput.append(OUTPUT_TIMER);
            strOutput.append(" ");
            if ((lOptions & 4L) != 0L) {
                strOutput.append(this.formatTime(lInterval, 10));
                strOutput.append(" ");
            }
            if ((lOptions & 8L) != 0L) {
                strOutput.append(this.formatTime(this.getTotal(), 10));
                strOutput.append(" ");
                strOutput.append(OUTPUT_TIME_TOTAL);
                strOutput.append(" ");
            }
            if (this.getName() != null && (lOptions & 0x10L) != 0L) {
                strOutput.append(this.getName());
                strOutput.append(OUTPUT_COLON);
                strOutput.append(" ");
            }
            if (strDescription != null) {
                strOutput.append(OUTPUT_QUOTE);
                strOutput.append(strDescription);
                strOutput.append(OUTPUT_QUOTE);
            }
            strOutput.append(OUTPUT_NEWLINE);
            TimerInternal.getPrintStream().print(strOutput);
            if (TimerInternal.isSQLenabled()) {
                TimerInternal.outputSQL(strOutput);
            }
        }
        return true;
    }

    protected static String getDefaultTimerName() {
        return DEFAULT_TIMER_NAME;
    }

    protected String formatTime(long lValue, int nSize) {
        StringBuffer strOutput = new StringBuffer();
        strOutput.append(OUTPUT_PAREN_OPEN);
        strOutput.append(lValue);
        strOutput.append(TIME_MS);
        strOutput.append(OUTPUT_PAREN_CLOSE);
        int nLength = nSize - strOutput.length();
        if (nLength > 0) {
            StringBuffer strIndent = new StringBuffer();
            for (int nIndex = 0; nIndex < nLength; ++nIndex) {
                strIndent.append(" ");
            }
            strOutput = strIndent.append(strOutput);
        }
        return strOutput.toString();
    }

    private void setLastDate(Date date) {
        this.m_dateLast = date;
    }

    private void setStarted(boolean bStarted) {
        this.m_bStarted = bStarted;
    }

    private long updateTimer() {
        Date dateCurrent = new Date();
        Date dateLast = this.getLastDate();
        long lInterval = dateCurrent.getTime() - dateLast.getTime();
        this.setLastDate(dateCurrent);
        return lInterval;
    }

    protected static Vector parseDelimitedStringVector(String str, String delim) {
        if (str == null || delim == null) {
            return null;
        }
        Vector<String> result = new Vector<String>();
        StringTokenizer st = new StringTokenizer(str, delim);
        while (st.hasMoreTokens()) {
            result.addElement(st.nextToken());
        }
        return result;
    }

    public static native long getProcessCPUTime();

    public static CPUUsageSnapshot makeCPUUsageSnapshot() {
        return new CPUUsageSnapshot(System.currentTimeMillis(), TimerInternal.getProcessCPUTime());
    }

    public static double getProcessCPUUsage(CPUUsageSnapshot start, CPUUsageSnapshot end) {
        return (double)(end.m_CPUTime - start.m_CPUTime) / (double)(end.m_time - start.m_time);
    }

    public static final class CPUUsageSnapshot {
        public final long m_time;
        public final long m_CPUTime;

        private CPUUsageSnapshot(long time, long CPUTime) {
            this.m_time = time;
            this.m_CPUTime = CPUTime;
        }
    }
}

