/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform.total;

import oracle.adf.model.dvt.util.transform.total.AggLocation;
import oracle.adfinternal.model.dvt.util.transform.total.DefaultDistributor;
import oracle.adfinternal.model.dvt.util.transform.total.Distributor;
import oracle.adfinternal.model.dvt.util.transform.total.TotalData;
import oracle.javatools.annotations.Concealed;

@Concealed
public class AggOptions {
    @Concealed
    private AggLocation m_loc = AggLocation.REPLACE;
    @Concealed
    private boolean m_allowSingleTotals = true;
    @Concealed
    private boolean m_totalDuplicates = false;
    @Concealed
    private TotalData m_totalData = null;
    @Concealed
    private Distributor m_distributor = null;

    public AggOptions() {
    }

    public AggOptions(AggLocation loc) {
        this();
        if (loc != null) {
            this.m_loc = loc;
        }
    }

    public AggOptions(TotalData totalData) {
        this();
        this.m_totalData = totalData;
    }

    public AggOptions(AggLocation loc, TotalData totalData) {
        this(loc);
        this.m_totalData = totalData;
    }

    public AggOptions(AggLocation loc, boolean allowSingleTotals) {
        this(loc);
        this.m_allowSingleTotals = allowSingleTotals;
    }

    public AggOptions(AggLocation loc, boolean allowSingleTotals, boolean totalDuplicates) {
        this(loc, allowSingleTotals);
        this.m_totalDuplicates = totalDuplicates;
    }

    public AggOptions(AggLocation loc, boolean allowSingleTotals, boolean totalDuplicates, TotalData totalData) {
        this(loc, allowSingleTotals, totalDuplicates);
        this.m_totalData = totalData;
    }

    public AggOptions(AggLocation loc, boolean allowSingleTotals, boolean totalDuplicates, TotalData totalData, Distributor distributor) {
        this(loc, allowSingleTotals, totalDuplicates, totalData);
        this.m_distributor = distributor;
    }

    public AggLocation getAggLocation() {
        return this.m_loc;
    }

    public boolean allowSingleTotals() {
        return this.m_allowSingleTotals;
    }

    public boolean totalDuplicates() {
        return this.m_totalDuplicates;
    }

    public TotalData getTotalData() {
        return this.m_totalData;
    }

    protected Distributor getDistributor() {
        if (this.m_distributor != null) {
            return this.m_distributor;
        }
        return DefaultDistributor.getInstance();
    }
}

