/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.cmp.EncryptedValue;
import oracle.security.crypto.cmp.attribute.InfoTypeAndValue;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.Utils;

public class RevPassphraseInfo
extends InfoTypeAndValue {
    private static final ASN1ObjectID TYPE = CMP.id_it_RevPassphrase;
    private EncryptedValue encValue;

    public RevPassphraseInfo() {
        super(TYPE);
        this.decoded = true;
    }

    public RevPassphraseInfo(EncryptedValue encValue) {
        this();
        this.encValue = encValue;
        this.encoded = false;
    }

    public RevPassphraseInfo(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public EncryptedValue getEncValue() {
        this.decodeValue();
        return this.encValue;
    }

    @Override
    public String toString() {
        return "RevocationPassphrase { " + this.getEncValue() + " }";
    }

    @Override
    protected void encodeValue() {
        if (!this.encoded) {
            this.setValue(this.encValue);
            this.encoded = true;
            this.decoded = true;
        }
    }

    @Override
    protected void decodeValue() {
        if (!this.decoded) {
            if (this.getValue() != null) {
                try {
                    this.encValue = new EncryptedValue(Utils.toStream((Streamable)this.getValue()));
                }
                catch (IOException ex) {
                    throw new StreamableOutputException(ex.toString());
                }
            } else {
                this.encValue = null;
            }
            this.decoded = true;
        }
    }
}

