/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cmp.PKIMessageBody;
import oracle.security.crypto.cmp.RevDetails;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class RevocationRequest
extends PKIMessageBody {
    private static final PKIMessageBody.Type TYPE = PKIMessageBody.Type.REVOCATION_REQUEST;
    private Vector certRevDetails = new Vector();
    private transient ASN1Object contents;

    public RevocationRequest() {
    }

    public RevocationRequest(RevDetails details) {
        this.addRevDetails(details);
    }

    public RevocationRequest(InputStream is) throws IOException {
        this.input(is);
    }

    public void addRevDetails(RevDetails details) {
        this.certRevDetails.addElement(details);
        this.update();
    }

    public Vector getRevDetails() {
        return this.certRevDetails;
    }

    @Override
    public PKIMessageBody.Type getType() {
        return TYPE;
    }

    public String toString() {
        return TYPE + " { certRevDetails = " + Utils.toString((Vector)this.certRevDetails) + " }";
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        this.certRevDetails.removeAllElements();
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        while (sis.hasMoreData()) {
            this.certRevDetails.addElement(new RevDetails((InputStream)sis));
        }
        sis.terminate();
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            this.contents = new ASN1Sequence(this.certRevDetails);
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

