/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.adfdtinternal.model.dvt.util.help.HelpContext;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.gridView.ConditionElement;
import oracle.dss.gridView.UIGridView;
import oracle.dss.gridView.gui.DimensionShuttlePanel;
import oracle.dss.gridView.gui.MemberPanel;
import oracle.dss.rules.discriminator.DateValueDiscriminator;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.NumberValueDiscriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MemberListAccess;
import oracle.dss.util.QDR;
import oracle.dss.util.SliceOutOfRangeException;

public abstract class RulesPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
ListDataListener,
ItemListener,
FocusListener {
    public static final String PROPERTY_BACKGROUND_SELECTED = "BackgroundColor";
    public static final String PROPERTY_DATABARS_SELECTED = "Databars";
    public static final String PROPERTY_BORDERS_SELECTED = "Borders";
    public static final String PROPERTY_FONT_NAME_SELECTED = "FontName";
    public static final String PROPERTY_FONT_STYLE_SELECTED = "FontStyle";
    public static final String PROPERTY_FONT_SIZE_SELECTED = "FontSize";
    public static final String PROPERTY_FONT_COLOR_SELECTED = "FontColor";
    public static final String PROPERTY_FONT_BACKGROUND_SELECTED = "FontBackground";
    public static final String PROPERTY_FONT_ALIGNMENT_SELECTED = "FontAlignment";
    public static final String PROPERTY_WORD_WRAP_SELECTED = "WordWrap";
    public static final String PROPERTY_NUMBER_FORMAT_SELECTED = "NumberFormat";
    public static final String PROPERTY_DATE_FORMAT_SELECTED = "DateFormat";
    public String dimLabelType = "dimShortName";
    public String memberLabelType = "shortName";
    public static final String dimNameType = "layerName";
    public static final String memberNameType = "value";
    public static final int BACKGROUND = 0;
    public static final int DATABARS = 1;
    public static final int BORDERS = 2;
    public static final int FONTNAME = 3;
    public static final int FONTSTYLE = 4;
    public static final int FONTSIZE = 5;
    public static final int FONTCOLOR = 6;
    public static final int FONTALIGNMENT = 7;
    public static final int WORDWRAP = 8;
    public static final int NUMBERFORMAT = 9;
    public static final int DATEFORMAT = 10;
    public static final int HEADER_BORDERS = 1;
    public static final int HEADER_FONTNAME = 2;
    public static final int HEADER_FONTSTYLE = 3;
    public static final int HEADER_FONTSIZE = 4;
    public static final int HEADER_FONTCOLOR = 5;
    public static final int HEADER_FONTALIGNMENT = 6;
    public static final int HEADER_WORDWRAP = 7;
    protected static final String PROPERTY_FORMULA_CHANGED = "formulaChanged";
    protected UIGridView m_gridView = null;
    protected DataAccess dataAccess = null;
    protected MemberListAccess memberAccess = null;
    public boolean m_isHeaderFormat = false;
    protected Vector m_conditions = null;
    protected Discriminator m_valueDisc = null;
    protected ConditionList conditionList;
    protected JButton m_editButton;
    private JScrollPane conditionPane;
    private JScrollPane formatPane;
    private JLabel conditionLabel;
    private MultiLineLabel formatLabel;
    private JPanel conditionsPanel;
    private JPanel buttonsPanel;
    private JPanel valueConditionPanel;
    protected ResourceBundle rBundle = null;
    protected String m_currentMeasure = null;
    protected static final String[] operators = new String[]{"=", "<", "<=", ">", ">="};
    private static final String[] operatorDesc = new String[]{"EqualsAny", "Equals", "Less than", "Less than or equal", "Greater than", "Greater than or equal"};
    protected static final String DimSep = ": ";
    protected static final String MemSep = ", ";
    protected static final String ANY = "Any";
    protected int panelWidth = 240;
    protected int panelHeight = 88;
    protected String m_measureDim = null;
    protected boolean m_isTable = false;
    protected int m_measureIndex = -1;
    protected int m_valueIndex = -1;
    private Locale m_locale;
    private JPanel bottomPanel;
    private JPanel topPanel;
    protected boolean hideValueCondition = false;
    protected JComboBox m_measureBox;
    protected JComboBox m_operatorBox;
    protected JTextField m_valueField;
    protected JPanel measurePanel;
    protected JPanel operatorPanel;
    protected JPanel valuePanel;
    protected HelpProvider m_helpProvider;
    protected String m_strHelpContextID;
    private boolean m_bSuperCalled = true;
    private String m_oldValueFieldText;
    private String m_oldAndFieldText;
    private JLabel m_measureLabel;
    private JLabel m_operatorLabel;
    private JLabel m_valueLabel;
    private NumberFormat m_numberFormat;
    protected JRadioButton m_entireRowButton;
    protected JRadioButton m_selectedCellsButton;
    protected JList m_selectedCellsList;
    protected QDRDiscriminator m_qdrDisc;
    protected Vector m_measureVector;
    protected MemberPanel m_memberPanel;

    public RulesPanel() {
        this.m_isHeaderFormat = false;
        this.m_gridView = null;
        this.m_conditions = null;
        this.m_locale = Locale.getDefault();
        this.updateResourceBundle(null);
        this.constructPanel();
    }

    public RulesPanel(UIGridView gridView) {
        this(gridView, null);
    }

    public RulesPanel(UIGridView gridView, String header, boolean isDefault) {
        this(gridView, header);
    }

    public RulesPanel(UIGridView gridView, String header) {
        this(gridView, header != null);
    }

    public RulesPanel(UIGridView gridView, boolean header) {
        this.m_gridView = gridView;
        if (this.m_gridView != null) {
            this.m_locale = this.m_gridView.getLocale();
        }
        this.updateResourceBundle(this.m_locale);
        this.m_isHeaderFormat = header;
        this.dataAccess = this.m_gridView.getModel().getDataAccess();
        this.setDefaultConditions();
    }

    public RulesPanel(UIGridView gridView, Discriminator disc, ConditionElement valueCondition, boolean header) {
        this.m_gridView = gridView;
        if (this.m_gridView != null) {
            this.m_locale = this.m_gridView.getLocale();
        }
        this.updateResourceBundle(this.m_locale);
        this.dataAccess = this.m_gridView.getModel().getDataAccess();
        this.m_isHeaderFormat = header;
        this.initFromDisc(disc, valueCondition);
    }

    public void setGridView(UIGridView gridView) {
        this.setGridView(gridView, null);
    }

    public void setGridView(UIGridView gridView, String header) {
        if (header != null) {
            this.setGridView(gridView, true);
        } else {
            this.setGridView(gridView, false);
        }
    }

    public void setGridView(UIGridView gridView, boolean header) {
        this.m_isHeaderFormat = header;
        this.m_gridView = gridView;
        if (this.m_gridView != null) {
            this.m_locale = this.m_gridView.getLocale();
            this.dataAccess = this.m_gridView.getModel().getDataAccess();
        }
        this.m_currentMeasure = null;
        this.m_measureIndex = -1;
        this.m_measureDim = null;
        this.m_valueIndex = -1;
        this.m_qdrDisc = null;
        this.m_valueDisc = null;
        if (!header) {
            this.setDefaultConditions();
        }
        this._init();
    }

    public void setGridView(UIGridView gridView, Discriminator disc, ConditionElement valueCondition, boolean header) {
        this.m_isHeaderFormat = header;
        this.m_gridView = gridView;
        if (this.m_gridView != null) {
            this.m_locale = this.m_gridView.getLocale();
        }
        this.dataAccess = this.m_gridView.getModel().getDataAccess();
        this.m_conditions = null;
        this.m_currentMeasure = null;
        this.m_measureIndex = -1;
        this.m_measureDim = null;
        this.m_valueIndex = -1;
        this.m_qdrDisc = null;
        this.m_valueDisc = null;
        this.initFromDisc(disc, valueCondition);
        this._init();
    }

    public void setDataAccess(DataAccess access) {
        if (access != null) {
            this.dataAccess = access;
        }
        this.memberAccess = null;
    }

    public void setMemberListAccess(MemberListAccess access) {
        if (access != null) {
            this.memberAccess = access;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        String text;
        if (e.getSource() == this.m_valueField && !(text = this.m_valueField.getText()).equals(this.m_oldValueFieldText)) {
            this.firePropertyChange(PROPERTY_FORMULA_CHANGED, "", this.getValueDescription());
            this.m_oldValueFieldText = text;
        }
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
    }

    public void setFormatElementsUsed(boolean[] selected) {
    }

    public boolean[] getFormatElementsUsed() {
        return null;
    }

    public boolean isFormatElementSelected(int i) {
        return true;
    }

    public void setMemberLabelType(String s) {
        if (s.equals("label") || s.equals("mediumName") || s.equals("shortName")) {
            this.memberLabelType = s;
        }
    }

    public String getMemberLabelType() {
        return this.memberLabelType;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.m_isHeaderFormat) {
            return new Dimension(Integer.parseInt(this.rBundle.getString("MemberPanelWidth")), Integer.parseInt(this.rBundle.getString("MemberPanelHeight")));
        }
        if (!this.hideValueCondition || this.m_isTable) {
            return new Dimension(Integer.parseInt(this.rBundle.getString("RulesPanelWidth")), Integer.parseInt(this.rBundle.getString("RulesPanelHeight")));
        }
        return new Dimension(Integer.parseInt(this.rBundle.getString("RulesPanelWidth")), Integer.parseInt(this.rBundle.getString("RulesPanelHeight")) - this.topPanel.getPreferredSize().height);
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        this.updateTextUsingCorrectLocale();
        this.m_locale = loc;
        this.m_numberFormat = this.m_locale != null ? NumberFormat.getInstance(this.m_locale) : NumberFormat.getInstance();
        this.m_numberFormat.setGroupingUsed(true);
    }

    @Override
    public Locale getLocale() {
        return this.m_locale;
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (this.conditionList != null) {
            this.conditionList.repaint();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_operatorBox) {
            if (this.m_operatorBox.getSelectedIndex() == 0) {
                this.m_valueField.setEnabled(false);
                this.m_valueLabel.setEnabled(false);
            } else {
                this.m_valueField.setEnabled(true);
                this.m_valueLabel.setEnabled(true);
            }
            this.firePropertyChange(PROPERTY_FORMULA_CHANGED, "", this.getValueDescription());
        } else if (e.getSource() == this.m_measureBox) {
            if (this.m_measureBox.getSelectedIndex() == -1) {
                return;
            }
            if (this.m_measureBox.getSelectedIndex() > 0) {
                String member = this.m_measureVector.elementAt(this.m_measureBox.getSelectedIndex() - 1).toString();
                this.conditionList.setElementAt(new ConditionElement(this.m_measureDim, member), this.m_measureIndex);
                this.m_currentMeasure = member;
            } else {
                this.m_currentMeasure = null;
            }
            this.firePropertyChange(PROPERTY_FORMULA_CHANGED, "", this.getValueDescription());
        } else if (e.getSource() == this.m_entireRowButton && this.m_entireRowButton.isSelected()) {
            this.m_selectedCellsList.setSelectedIndices(new int[0]);
        }
    }

    public abstract Discriminator getDiscriminator();

    public void cleanUp() {
        if (this.conditionPane != null) {
            this.conditionPane.setViewportView(null);
            this.conditionList.cleanUp();
            this.conditionList = null;
        }
        if (this.m_conditions != null) {
            for (int i = 0; i < this.m_conditions.size(); ++i) {
                this.m_conditions.removeElementAt(i);
            }
            this.m_conditions = null;
        }
    }

    protected abstract void initFromDisc(Discriminator var1, ConditionElement var2);

    protected void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle");
    }

    private void updateTextUsingCorrectLocale() {
        String translatedText = this.m_isHeaderFormat ? this.rBundle.getString("FormatHeaderLabel") : this.rBundle.getString("FormatLabel");
        if (this.formatLabel != null) {
            this.formatLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        }
        translatedText = this.rBundle.getString("ConditionLabel");
        if (this.conditionLabel != null) {
            this.conditionLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        }
        if (this.m_editButton != null) {
            translatedText = this.rBundle.getString("EditDimension");
            this.m_editButton.setText(StringUtils.stripMnemonic((String)translatedText));
            this.m_editButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        }
        if (this.m_measureLabel != null) {
            translatedText = this.rBundle.getString("Measure");
            this.m_measureLabel.setText(StringUtils.stripMnemonic((String)translatedText));
            this.m_measureLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        }
        if (this.m_operatorLabel != null) {
            translatedText = this.rBundle.getString("Operator");
            this.m_operatorLabel.setText(StringUtils.stripMnemonic((String)translatedText));
            this.m_operatorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        }
        if (this.m_valueLabel != null) {
            translatedText = this.rBundle.getString("Value");
            this.m_valueLabel.setText(StringUtils.stripMnemonic((String)translatedText));
            this.m_valueLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        }
    }

    protected DateFormat getDateInstance() {
        DateFormat df = DateFormat.getDateInstance(3, this.m_locale);
        if (this.m_locale.getLanguage().compareTo("th") == 0 && this.m_locale.getCountry().compareTo("TH") == 0) {
            df.setCalendar(new GregorianCalendar(this.m_locale));
        }
        return df;
    }

    protected String getLayerLabel(String dimension) {
        if (dimension == null) {
            return null;
        }
        try {
            for (int i = 0; i < this.dataAccess.getEdgeCount(); ++i) {
                int layerCount = this.dataAccess.getLayerCount(i);
                for (int j = 0; j < layerCount; ++j) {
                    Object dimVal = this.dataAccess.getLayerMetadata(i, j, dimNameType);
                    String dim = null;
                    if (dimVal != null) {
                        dim = dimVal.toString();
                    }
                    if (dim == null || !dim.equals(dimension)) continue;
                    dimVal = this.dataAccess.getLayerMetadata(i, j, this.dimLabelType);
                    if (dimVal != null) {
                        dim = dimVal.toString();
                    }
                    if (dim != null) {
                        return dim;
                    }
                    return dimension;
                }
            }
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
        return dimension;
    }

    protected void _init() {
        this.m_numberFormat = this.m_locale != null ? NumberFormat.getInstance(this.m_locale) : NumberFormat.getInstance();
        this.m_numberFormat.setGroupingUsed(true);
        this.constructPanel();
        if (!this.m_isHeaderFormat && !this.m_isTable) {
            this.setValueCondition();
        }
    }

    protected abstract String getMemberLabel(String var1, String var2);

    protected abstract void setDefaultConditions();

    protected void setValueCondition() {
        Object data;
        if (this.m_valueIndex == -1) {
            return;
        }
        ConditionElement valueCondition = (ConditionElement)((Object)this.m_conditions.elementAt(this.m_valueIndex));
        if (valueCondition.getData() == null) {
            if (this.m_currentMeasure != null) {
                this.m_measureBox.setSelectedItem(this.getMemberLabel(this.m_measureDim, this.m_currentMeasure));
                this.m_operatorBox.setSelectedIndex(0);
            }
            return;
        }
        if (valueCondition.getDimension() != null) {
            this.m_measureBox.setSelectedItem(this.getMemberLabel(this.m_measureDim, valueCondition.getDimension()));
        }
        if ((data = valueCondition.getData()) != null) {
            Vector condition = (Vector)data;
            try {
                String val1;
                if (condition.elementAt(2) instanceof Date) {
                    val1 = this.getDateInstance().format(condition.elementAt(2));
                } else {
                    Double d = (Double)condition.elementAt(2);
                    val1 = this.m_numberFormat.format(d);
                }
                this.m_valueField.setText(val1);
                this.m_oldValueFieldText = val1;
                String operator = condition.elementAt(1).toString();
                for (int i = 0; i < operators.length; ++i) {
                    if (operator != operators[i]) continue;
                    this.m_operatorBox.setSelectedIndex(i + 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected ConditionElement getValueCondition() {
        if (this.m_valueIndex == -1 || ((ConditionElement)((Object)this.m_conditions.elementAt(this.m_valueIndex))).getData() == null) {
            return null;
        }
        return (ConditionElement)((Object)this.m_conditions.elementAt(this.m_valueIndex));
    }

    protected String getValueDescription() {
        Object s = this.m_measureBox.getSelectedIndex() == 0 ? this.rBundle.getString("DefaultValue") : (String)this.m_measureBox.getSelectedItem();
        String data1 = this.m_valueField.getText();
        if (data1 == null || data1.length() == 0 || this.m_operatorBox.getSelectedIndex() == 0) {
            return null;
        }
        String op = null;
        op = operators[this.m_operatorBox.getSelectedIndex() - 1];
        s = (String)s + " " + op + data1;
        return s;
    }

    protected void processValueCondition() {
        int idx = this.m_operatorBox.getSelectedIndex();
        this.m_valueDisc = null;
        if (this.m_operatorBox.getSelectedIndex() == 0 || this.m_valueField.getText().length() == 0) {
            this.m_conditions.setElementAt(new ConditionElement(this.m_currentMeasure, (String)null), this.m_valueIndex);
            return;
        }
        Double number = null;
        Date date = null;
        try {
            try {
                String val = this.m_valueField.getText().trim();
                number = this.m_numberFormat.parse(val).doubleValue();
            }
            catch (Exception val) {}
        }
        catch (NumberFormatException e) {
            try {
                date = new Date(this.getDateInstance().parse(this.m_valueField.getText().trim()).getTime());
            }
            catch (ParseException e2) {
                return;
            }
        }
        if (number != null) {
            this.m_conditions.setElementAt(new ConditionElement(this.m_currentMeasure, idx - 1, number, null, true), this.m_valueIndex);
        } else if (date != null) {
            this.m_conditions.setElementAt(new ConditionElement(this.m_currentMeasure, idx - 1, date, null, true), this.m_valueIndex);
        }
        int op = 0;
        if (idx == 1) {
            op = 0;
        } else if (idx == 2) {
            op = 1;
        } else if (idx == 3) {
            op = 2;
        } else if (idx == 4) {
            op = 3;
        } else if (idx == 5) {
            op = 4;
        }
        this.m_valueDisc = number != null ? new NumberValueDiscriminator(number.doubleValue(), op) : (date != null ? new DateValueDiscriminator(date, op) : null);
    }

    protected abstract String printCondition(ConditionElement var1);

    protected void editDimensions(Vector members, int idx) {
        String dimension = this.conditionList.getDimension(idx);
        if (members == null) {
            this.conditionList.setElementAt(new ConditionElement(dimension, (String)null), idx);
        } else if (members.size() == 1) {
            this.conditionList.setElementAt(new ConditionElement(dimension, members.elementAt(0).toString(), 0), idx);
        } else {
            this.conditionList.setElementAt(new ConditionElement(dimension, members, 1), idx);
        }
    }

    protected Vector getDimMembers(String dimension, String type) {
        if (dimension == null) {
            return null;
        }
        try {
            Vector<Object> members = new Vector<Object>();
            List list = this.dataAccess.getUniqueMemberMetadata(dimension, new String[]{type}, 0, -1);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i) == null || ((Object[])list.get(i)).length <= 0) continue;
                    members.addElement(((Object[])list.get(i))[0]);
                }
                return members;
            }
            for (int i = 0; i < this.dataAccess.getEdgeCount(); ++i) {
                int layerCount = this.dataAccess.getLayerCount(i);
                int endslice = this.dataAccess.getEdgeExtent(i);
                for (int j = 0; j < layerCount; ++j) {
                    Object dimObj = this.dataAccess.getLayerMetadata(i, j, dimNameType);
                    String dim = null;
                    if (dimObj != null) {
                        dim = dimObj.toString();
                    }
                    if (dim == null || !dimension.equals(dim)) continue;
                    if (this.memberAccess != null) {
                        Object[] allmembers = this.memberAccess.getAllMembers(i, j, memberNameType);
                        for (int k = 0; k < allmembers.length; ++k) {
                            members.addElement(allmembers[k]);
                        }
                        return members;
                    }
                    for (int startslice = 0; startslice != endslice; startslice += this.dataAccess.getMemberExtent(i, j, startslice)) {
                        if (this.dataAccess.getMemberStartLayer(i, j, startslice) != j) continue;
                        Object objValue = this.dataAccess.getMemberMetadata(i, j, startslice, type);
                        String value = null;
                        if (objValue != null) {
                            value = objValue.toString();
                        }
                        if (value == null || members.indexOf(value) != -1) continue;
                        members.addElement(value);
                    }
                }
            }
            if (members.size() > 0) {
                return members;
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
        }
        catch (SliceOutOfRangeException sliceOutOfRangeException) {
            // empty catch block
        }
        return null;
    }

    public void hideValueCondition() {
        if (this.valueConditionPanel != null) {
            this.valueConditionPanel.setVisible(false);
        }
        this.formatLabel.setText(this.rBundle.getString("SpecifyCellsLabel"));
        this.hideValueCondition = true;
    }

    boolean showErrorDialog() {
        if (!this.m_isTable && this.m_isHeaderFormat && this.m_memberPanel != null) {
            return this.m_memberPanel.showErrorDialog();
        }
        return true;
    }

    private void constructPanel() {
        String translatedText;
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.formatLabel = this.m_isHeaderFormat ? new MultiLineLabel(WordWrapper.getTextWrapper(), this.rBundle.getString("FormatHeaderLabel")) : new MultiLineLabel(WordWrapper.getTextWrapper(), this.rBundle.getString("FormatLabel"));
        double textwidth = this.getToolkit().getFontMetrics(this.formatLabel.getFont()).stringWidth(this.formatLabel.getText());
        int rows = (int)Math.ceil(textwidth / (double)(this.getPreferredSize().width - 20));
        this.formatLabel.setPreferredRows(rows);
        this.formatLabel.setMinimumRows(rows);
        this.formatLabel.setMaximumRows(rows);
        this.formatLabel.setAlignmentX(0.0f);
        this.add((Component)this.formatLabel);
        if (!this.m_isHeaderFormat && !this.m_isTable) {
            this.add(Box.createVerticalStrut(10));
        } else {
            this.add(Box.createVerticalStrut(5));
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        mainPanel.setAlignmentX(0.0f);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        rightPanel.setAlignmentX(0.0f);
        if (this.m_isTable && !this.m_isHeaderFormat) {
            JPanel targetPanel = new JPanel();
            targetPanel.setLayout(new BoxLayout(targetPanel, 0));
            targetPanel.setAlignmentX(0.0f);
            translatedText = this.m_isTable ? this.rBundle.getString("ApplyFormat") : this.rBundle.getString("ApplyFormatToDimensions");
            JLabel label = new JLabel(StringUtils.stripMnemonic((String)translatedText));
            label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            JPanel targetLeft = new JPanel();
            targetLeft.setLayout(new BoxLayout(targetLeft, 1));
            targetLeft.setAlignmentX(0.0f);
            targetLeft.add(label);
            targetLeft.add(Box.createVerticalGlue());
            JPanel targetRight = new JPanel();
            targetRight.setLayout(new BoxLayout(targetRight, 1));
            targetRight.setAlignmentX(0.0f);
            if (this.m_isTable && !this.m_isHeaderFormat) {
                translatedText = this.rBundle.getString("EntireRow");
                this.m_entireRowButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
                this.m_entireRowButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
                targetRight.add(this.m_entireRowButton);
                translatedText = this.rBundle.getString("SelectedCells");
                this.m_selectedCellsButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
                this.m_selectedCellsButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
                this.m_selectedCellsButton.setAlignmentX(0.0f);
                this.m_selectedCellsButton.setMaximumSize(this.m_selectedCellsButton.getPreferredSize());
                this.m_selectedCellsButton.setMinimumSize(this.m_selectedCellsButton.getPreferredSize());
            }
            JPanel tmpPanel = new JPanel();
            tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
            tmpPanel.setAlignmentX(0.0f);
            this.m_selectedCellsList = new JList();
            QDR m_qdr = null;
            Vector<Integer> selectedIndices = new Vector<Integer>();
            Vector<String> data = new Vector<String>();
            if (this.m_qdrDisc != null) {
                m_qdr = this.m_qdrDisc.getQDR();
            }
            if (this.m_isTable && !this.m_isHeaderFormat) {
                if (m_qdr != null && m_qdr.getTarget() == null) {
                    this.m_entireRowButton.setSelected(true);
                } else {
                    this.m_selectedCellsButton.setSelected(true);
                }
                this.m_entireRowButton.addItemListener(this);
                this.m_selectedCellsList.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (RulesPanel.this.m_selectedCellsList.getSelectedIndices().length > 0) {
                            RulesPanel.this.m_selectedCellsButton.setSelected(true);
                        }
                    }
                });
            }
            try {
                for (int i = 0; i < this.dataAccess.getEdgeCount(); ++i) {
                    if (this.m_isTable && i == 1) continue;
                    int layerCount = this.dataAccess.getLayerCount(i);
                    for (int j = 0; j < layerCount; ++j) {
                        Object dimObj = this.dataAccess.getLayerMetadata(i, j, this.dimLabelType);
                        Object dimension = this.dataAccess.getLayerMetadata(i, j, dimNameType);
                        data.addElement(dimObj.toString());
                        if (m_qdr == null || m_qdr.getTarget() == null || (m_qdr.getTarget().getType() != 3 || ((Vector)m_qdr.getTarget().getData()).indexOf(dimension) == -1) && (m_qdr.getTarget().getType() != 0 || !m_qdr.getTarget().getData().equals(dimension))) continue;
                        selectedIndices.addElement(data.size() - 1);
                    }
                }
            }
            catch (EdgeOutOfRangeException i) {
            }
            catch (LayerOutOfRangeException i) {
                // empty catch block
            }
            this.m_selectedCellsList.setListData(data.toArray());
            int[] indices = new int[selectedIndices.size()];
            for (int i = 0; i < selectedIndices.size(); ++i) {
                indices[i] = (Integer)selectedIndices.elementAt(i);
            }
            this.m_selectedCellsList.setSelectedIndices(indices);
            JScrollPane selectedCellsListPane = new JScrollPane(this.m_selectedCellsList);
            selectedCellsListPane.setVerticalScrollBarPolicy(20);
            selectedCellsListPane.setHorizontalScrollBarPolicy(30);
            selectedCellsListPane.setAlignmentX(0.0f);
            if (this.m_selectedCellsList.getModel().getSize() > 4) {
                selectedCellsListPane.setPreferredSize(new Dimension(selectedCellsListPane.getPreferredSize().width + 20, 80));
            } else {
                selectedCellsListPane.setPreferredSize(new Dimension(selectedCellsListPane.getPreferredSize().width, 80));
            }
            selectedCellsListPane.setMaximumSize(selectedCellsListPane.getPreferredSize());
            selectedCellsListPane.setMinimumSize(selectedCellsListPane.getPreferredSize());
            if (this.m_isTable && !this.m_isHeaderFormat) {
                JPanel buttonPanel = new JPanel();
                buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
                buttonPanel.add(this.m_selectedCellsButton);
                buttonPanel.add(Box.createVerticalGlue());
                buttonPanel.setPreferredSize(new Dimension(buttonPanel.getPreferredSize().width, 80));
                buttonPanel.setMaximumSize(buttonPanel.getPreferredSize());
                buttonPanel.setMinimumSize(buttonPanel.getPreferredSize());
                tmpPanel.add(buttonPanel);
            }
            tmpPanel.add(selectedCellsListPane);
            targetRight.add(tmpPanel);
            targetRight.add(Box.createVerticalGlue());
            targetRight.setMaximumSize(targetRight.getPreferredSize());
            targetRight.setMinimumSize(targetRight.getPreferredSize());
            targetLeft.setMaximumSize(targetRight.getPreferredSize());
            targetLeft.setMinimumSize(targetRight.getPreferredSize());
            targetPanel.add(targetLeft);
            targetPanel.add(Box.createHorizontalStrut(5));
            targetPanel.add(targetRight);
            targetPanel.add(Box.createHorizontalGlue());
            targetPanel.setMaximumSize(targetPanel.getPreferredSize());
            targetPanel.setMinimumSize(targetPanel.getPreferredSize());
            rightPanel.add(targetPanel);
            rightPanel.add(Box.createVerticalStrut(10));
            if (this.m_isTable) {
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(this.m_entireRowButton);
                buttonGroup.add(this.m_selectedCellsButton);
            }
        }
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 1));
        this.bottomPanel.setAlignmentX(0.0f);
        if (!this.m_isHeaderFormat) {
            if (!this.m_isTable) {
                this.valueConditionPanel = new JPanel();
                this.valueConditionPanel.setLayout(new BoxLayout(this.valueConditionPanel, 1));
                this.valueConditionPanel.setAlignmentX(0.0f);
                this.topPanel = new JPanel();
                this.topPanel.setLayout(new BoxLayout(this.topPanel, 0));
                this.topPanel.setAlignmentX(0.0f);
                this.measurePanel = new JPanel();
                this.measurePanel.setLayout(new BoxLayout(this.measurePanel, 1));
                translatedText = this.rBundle.getString("Measure");
                this.m_measureLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
                this.m_measureLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
                this.m_measureLabel.setAlignmentX(0.0f);
                this.measurePanel.add(this.m_measureLabel);
                boolean maxwidth = false;
                Vector vector = this.getDimMembers(this.m_measureDim, this.memberLabelType);
                this.m_measureVector = this.getDimMembers(this.m_measureDim, memberNameType);
                if (vector == null) {
                    vector = new Vector();
                }
                String[] labels = new String[vector.size() + 1];
                labels[0] = this.rBundle.getString(ANY);
                for (int i = 1; i < labels.length; ++i) {
                    labels[i] = vector.elementAt(i - 1).toString();
                }
                this.m_measureBox = new JComboBox<String>(labels);
                this.m_measureBox.setAlignmentX(0.0f);
                this.m_measureBox.setPreferredSize(new Dimension(Math.max(this.m_measureBox.getPreferredSize().width, this.m_measureLabel.getPreferredSize().width + 5), this.m_measureBox.getPreferredSize().height));
                this.m_measureBox.setMaximumSize(this.m_measureBox.getPreferredSize());
                this.m_measureBox.setMinimumSize(this.m_measureBox.getPreferredSize());
                this.m_measureBox.addItemListener(this);
                this.m_measureLabel.setLabelFor(this.m_measureBox);
                this.measurePanel.add(this.m_measureBox);
                this.topPanel.add(this.measurePanel);
                this.topPanel.add(Box.createHorizontalStrut(10));
                this.operatorPanel = new JPanel();
                this.operatorPanel.setLayout(new BoxLayout(this.operatorPanel, 1));
                translatedText = this.rBundle.getString("Operator");
                this.m_operatorLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
                this.m_operatorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
                this.m_operatorLabel.setAlignmentX(0.0f);
                this.operatorPanel.add(this.m_operatorLabel);
                String[] op = new String[operatorDesc.length];
                for (int i = 0; i < operatorDesc.length; ++i) {
                    op[i] = this.rBundle.getString(operatorDesc[i]);
                }
                this.m_operatorBox = new JComboBox<String>(op);
                this.m_operatorBox.addItemListener(this);
                this.m_operatorBox.setAlignmentX(0.0f);
                this.m_operatorBox.setPreferredSize(new Dimension(160, this.m_operatorBox.getPreferredSize().height));
                this.m_operatorBox.setMaximumSize(this.m_operatorBox.getPreferredSize());
                this.m_operatorBox.setMinimumSize(this.m_operatorBox.getPreferredSize());
                this.m_operatorLabel.setLabelFor(this.m_operatorBox);
                this.operatorPanel.add(this.m_operatorBox);
                this.topPanel.add(this.operatorPanel);
                this.topPanel.add(Box.createHorizontalStrut(10));
                this.valuePanel = new JPanel();
                this.valuePanel.setLayout(new BoxLayout(this.valuePanel, 1));
                translatedText = this.rBundle.getString("Value");
                this.m_valueLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
                this.m_valueLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
                this.m_valueLabel.setAlignmentX(0.0f);
                this.m_valueLabel.setEnabled(false);
                this.valuePanel.add(this.m_valueLabel);
                this.m_valueField = new JTextField();
                this.m_valueField.setAlignmentX(0.0f);
                this.m_valueField.setPreferredSize(new Dimension(92, 22));
                this.m_valueField.setMinimumSize(this.m_valueField.getPreferredSize());
                this.m_valueField.setMaximumSize(this.m_valueField.getPreferredSize());
                this.m_valueField.setHorizontalAlignment(2);
                this.m_valueField.setEnabled(false);
                this.m_valueLabel.setLabelFor(this.m_valueField);
                this.valuePanel.add(this.m_valueField);
                this.topPanel.add(this.valuePanel);
                this.valueConditionPanel.add(this.topPanel);
                this.valueConditionPanel.add(Box.createRigidArea(new Dimension(0, 15)));
                rightPanel.add(this.valueConditionPanel);
                this.m_valueField.addFocusListener(this);
            }
            translatedText = this.rBundle.getString("ConditionLabel");
            this.conditionLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
            this.conditionLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.conditionLabel.setAlignmentX(0.0f);
            this.bottomPanel.add(this.conditionLabel);
            this.bottomPanel.add(Box.createRigidArea(new Dimension(0, 3)));
            this.conditionsPanel = new JPanel();
            this.conditionsPanel.setLayout(new BoxLayout(this.conditionsPanel, 0));
            this.conditionsPanel.setAlignmentX(0.0f);
            this.conditionsPanel.setPreferredSize(new Dimension(this.getPreferredSize().width, this.panelHeight));
            translatedText = this.rBundle.getString("EditDimension");
            this.m_editButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this.m_editButton.setName("EditDimensionMembers");
            this.m_editButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_editButton.setMargin(new Insets(0, 13, 0, 13));
            this.m_editButton.addActionListener(this);
            this.m_editButton.setAlignmentX(0.0f);
            this.m_editButton.setAlignmentY(0.0f);
            this.m_editButton.setMaximumSize(this.m_editButton.getPreferredSize());
            this.m_editButton.setMinimumSize(this.m_editButton.getPreferredSize());
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(new BoxLayout(this.buttonsPanel, 1));
            this.buttonsPanel.setAlignmentX(0.0f);
            this.buttonsPanel.add(this.m_editButton);
            this.buttonsPanel.add(Box.createVerticalGlue());
            this.conditionList = new ConditionList();
            this.conditionList.setName("DimensionMembersList");
            this.conditionList.setSelectionMode(0);
            this.conditionList.setAlignmentX(0.0f);
            if (this.m_conditions != null) {
                this.conditionList.setListData(this.m_conditions);
                this.conditionList.setSelectedIndex(0);
                this.conditionList.requestDefaultFocus();
            }
            this.conditionLabel.setLabelFor(this.conditionList);
            this.conditionPane = new JScrollPane(this.conditionList);
            this.conditionPane.setVerticalScrollBarPolicy(20);
            this.conditionPane.setHorizontalScrollBarPolicy(30);
            this.conditionPane.setAlignmentX(0.0f);
            this.conditionsPanel.add(this.conditionPane);
            this.conditionsPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.conditionsPanel.add(this.buttonsPanel);
            this.bottomPanel.add(this.conditionsPanel);
            rightPanel.add(this.bottomPanel);
            if (this.topPanel != null) {
                this.topPanel.setPreferredSize(new Dimension(this.bottomPanel.getPreferredSize().width, this.topPanel.getPreferredSize().height));
                this.topPanel.setMinimumSize(this.topPanel.getPreferredSize());
                this.topPanel.setMaximumSize(this.topPanel.getPreferredSize());
            }
            rightPanel.setPreferredSize(new Dimension(this.getPreferredSize().width - 30, rightPanel.getPreferredSize().height));
        } else {
            this.m_memberPanel = new MemberPanel(this.m_gridView, this.m_qdrDisc, this.m_isHeaderFormat);
            this.bottomPanel.add(this.m_memberPanel);
            rightPanel.add(this.bottomPanel);
            rightPanel.add(Box.createVerticalGlue());
        }
        mainPanel.add(rightPanel);
        this.add(mainPanel);
    }

    protected DimensionDialog createDimensionDialog(String title, String dimension, Vector members, int idx, boolean modal, boolean isTable) {
        DimensionDialog d = null;
        Container owner = this;
        while (owner != null) {
            if (owner instanceof Dialog) {
                d = new DimensionDialog((Dialog)owner, title, dimension, members, idx, modal, isTable);
                break;
            }
            if (owner instanceof Frame) {
                d = new DimensionDialog((Frame)owner, title, dimension, members, idx, modal, isTable);
                break;
            }
            owner = SwingUtilities.getWindowAncestor(owner);
        }
        if (d == null) {
            d = new DimensionDialog((Frame)null, title, dimension, members, idx, modal, isTable);
        }
        return d;
    }

    protected class ConditionList
    extends JList {
        private ConditionListModel checkListModel = null;
        private ConditionListRenderer m_conditionListRenderer = null;
        private boolean[] m_changed = null;

        public ConditionList() {
            this.setEnabled(true);
        }

        public ConditionList(Vector data) {
            this.setEnabled(true);
            this.setListData(data);
        }

        public void setListData(Vector data) {
            Vector listData;
            if (RulesPanel.this.m_valueIndex != -1) {
                listData = new Vector();
                for (int i = 0; i < data.size() - 1; ++i) {
                    listData.addElement(data.elementAt(i));
                }
            } else {
                listData = data;
            }
            this.checkListModel = new ConditionListModel(listData);
            if (listData != null) {
                this.m_changed = new boolean[listData.size()];
            }
            this.setModel(this.checkListModel);
            this.m_conditionListRenderer = new ConditionListRenderer();
            this.setCellRenderer(this.m_conditionListRenderer);
        }

        public void cleanUp() {
            this.checkListModel = null;
            this.setCellRenderer(null);
            this.m_conditionListRenderer = null;
        }

        public Object getElementAt(int index) {
            return this.checkListModel.getElementAt(index);
        }

        public void setElementAt(ConditionElement listItem, int index) {
            if (index >= 0 && index < this.getListSize()) {
                this.checkListModel.setElementAt(listItem, index);
                this.m_changed[index] = true;
            }
        }

        public int getType(int index) {
            return this.checkListModel.getType(index);
        }

        public String getDimension(int index) {
            return this.checkListModel.getDimension(index);
        }

        public Object getMemberData(int index) {
            return this.checkListModel.getMemberData(index);
        }

        public void setSelected(int index, boolean b) {
            this.checkListModel.setSelected(index, b);
        }

        public int getListSize() {
            if (this.checkListModel == null) {
                return 0;
            }
            return this.checkListModel.getSize();
        }

        public Vector getAllData() {
            return this.checkListModel.getAllData();
        }

        public boolean isChanged(int i) {
            if (i >= 0 && i < this.getListSize()) {
                return this.m_changed[i];
            }
            return false;
        }
    }

    protected class DimensionDialog
    extends JDialog
    implements ActionListener,
    HelpContext {
        private int m_index;
        private String m_dimension;
        private DimensionShuttlePanel listPanel;
        private JButton okButton;
        private JButton cancelButton;
        private JButton helpButton;
        private boolean m_bHelpEnabled;

        public DimensionDialog(Frame owner, String title, String dimension, Vector members, int index, boolean modal, boolean isTable) {
            super(owner, title, modal);
            this.m_index = -1;
            this.listPanel = null;
            this.m_bHelpEnabled = true;
            this._initDialog(dimension, members, index, isTable);
        }

        public DimensionDialog(Dialog owner, String title, String dimension, Vector members, int index, boolean modal, boolean isTable) {
            super(owner, title, modal);
            this.m_index = -1;
            this.listPanel = null;
            this.m_bHelpEnabled = true;
            this._initDialog(dimension, members, index, isTable);
        }

        private void _initDialog(String dimension, Vector members, int index, boolean isTable) {
            this.m_index = index;
            this.m_dimension = dimension;
            this.init(members, isTable);
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        }

        public void init(Vector members, boolean isTable) {
            JComponent content = (JComponent)this.getContentPane();
            content.setLayout(new BoxLayout(content, 1));
            if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                content.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
            }
            content.setBorder(BorderFactory.createEmptyBorder(6, 6, 10, 6));
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BoxLayout(mainPanel, 0));
            this.listPanel = new DimensionShuttlePanel(this, RulesPanel.this.dataAccess, RulesPanel.this.memberAccess, this.m_dimension, RulesPanel.this.memberLabelType, isTable, (Vector)null);
            this.listPanel.setLocale(RulesPanel.this.m_locale);
            this.listPanel.setSelectedMembers(members);
            this.listPanel.setAlignmentX(0.0f);
            mainPanel.add(this.listPanel);
            mainPanel.setPreferredSize(new Dimension(355, 240));
            content.add(mainPanel);
            GrayPane gp = new GrayPane((Component)mainPanel);
            content.add((Component)gp);
            DialogButtonBar buttonPanel = new DialogButtonBar();
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
            String translatedText = "";
            if (this.m_bHelpEnabled) {
                translatedText = RulesPanel.this.rBundle.getString("Help");
                this.helpButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
                this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
                this.helpButton.setMinimumSize(this.helpButton.getPreferredSize());
                buttonPanel.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
                this.helpButton.addActionListener(this);
                this.helpButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(112, 0), 2);
            }
            translatedText = RulesPanel.this.rBundle.getString("OK");
            this.okButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this.okButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            buttonPanel.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_YES);
            this.okButton.addActionListener(this);
            this.okButton.setMinimumSize(this.okButton.getPreferredSize());
            this.getRootPane().setDefaultButton(this.okButton);
            translatedText = RulesPanel.this.rBundle.getString("Cancel");
            this.cancelButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this.cancelButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            buttonPanel.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
            this.cancelButton.setMinimumSize(this.cancelButton.getPreferredSize());
            this.cancelButton.addActionListener(this);
            this.cancelButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
            content.add((Component)buttonPanel);
            this.setResizable(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cancelButton) {
                this.setVisible(false);
                this.listPanel.cleanUp();
                this.dispose();
                this.getParent().repaint();
            } else if (e.getSource() == this.okButton) {
                boolean ret = this.listPanel.showErrorDialog();
                if (ret) {
                    RulesPanel.this.editDimensions(this.listPanel.getSelectedMembers(), this.m_index);
                    this.setVisible(false);
                    this.listPanel.cleanUp();
                    this.dispose();
                }
            } else if (e.getSource() == this.helpButton) {
                try {
                    if (RulesPanel.this.getHelpProvider() != null) {
                        RulesPanel.this.getHelpProvider().showHelp((Component)this);
                    } else if (HelpUtils.getDefaultHelpProvider() != null) {
                        HelpUtils.getDefaultHelpProvider().showHelp((Component)this);
                    }
                }
                catch (HelpUnavailableException helpUnavailableException) {
                    // empty catch block
                }
            }
        }

        public String getHelpContextID() {
            return this.getClass().getName();
        }

        public void setHelpContextID(String strHelpContextID) {
            RulesPanel.this.m_strHelpContextID = strHelpContextID;
        }
    }

    private class ConditionListRenderer
    extends JLabel
    implements ListCellRenderer {
        public ConditionListRenderer() {
            this.setOpaque(true);
            this.setLayout(new BoxLayout(this, 0));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            int width = this.getToolkit().getFontMetrics(list.getFont()).stringWidth(value.toString()) + 28;
            this.setPreferredSize(new Dimension(width, 18));
            this.getAccessibleContext().setAccessibleName(value.toString());
            this.setText(value.toString());
            if (selected) {
                this.setForeground(Color.white);
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setForeground(Color.black);
                this.setBackground(list.getBackground());
            }
            return this;
        }
    }

    private class ConditionListModel
    implements ListModel {
        private String[] labels = null;
        private Vector m_dataListeners = new Vector();
        private Vector m_data;

        public ConditionListModel(Vector data) {
            this.m_data = data;
            if (data != null) {
                this.labels = new String[data.size()];
                for (int i = 0; i < this.labels.length; ++i) {
                    this.labels[i] = RulesPanel.this.printCondition((ConditionElement)((Object)data.elementAt(i)));
                }
            }
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.m_dataListeners.addElement(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.m_dataListeners.removeElement(l);
        }

        @Override
        public int getSize() {
            if (this.m_data != null) {
                return this.m_data.size();
            }
            return 0;
        }

        public void setElementAt(ConditionElement listItem, int index) {
            if (index >= 0 && index < this.m_data.size()) {
                this.m_data.setElementAt(listItem, index);
                this.labels[index] = RulesPanel.this.printCondition((ConditionElement)((Object)this.m_data.elementAt(index)));
                for (int i = 0; i < this.m_dataListeners.size(); ++i) {
                    ((ListDataListener)this.m_dataListeners.elementAt(i)).contentsChanged(null);
                }
            }
        }

        public void setAllData(Vector data) {
            if (data != null) {
                this.m_data = data;
                this.labels = new String[data.size()];
                for (int i = 0; i < this.labels.length; ++i) {
                    this.labels[i] = RulesPanel.this.printCondition((ConditionElement)((Object)data.elementAt(i)));
                }
            }
        }

        public Object getElementAt(int index) {
            if (this.labels != null && index >= 0 && index < this.labels.length) {
                return this.labels[index];
            }
            return null;
        }

        public int getType(int index) {
            if (index >= 0 && index < this.m_data.size()) {
                return ((ConditionElement)((Object)this.m_data.elementAt(index))).getType();
            }
            return 0;
        }

        public String getDimension(int index) {
            if (index >= 0 && index < this.m_data.size()) {
                return ((ConditionElement)((Object)this.m_data.elementAt(index))).getDimension();
            }
            return null;
        }

        public Object getMemberData(int index) {
            if (index >= 0 && index < this.m_data.size()) {
                return ((ConditionElement)((Object)this.m_data.elementAt(index))).getData();
            }
            return null;
        }

        public Vector getAllData() {
            return this.m_data;
        }

        public void setSelected(int index, boolean b) {
            ((ConditionElement)((Object)this.m_data.elementAt(index))).setSelected(b);
        }
    }
}

