/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import oracle.adfdtinternal.model.dvt.util.help.HelpContext;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.ConditionElement;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.gui.DimensionShuttlePanel;
import oracle.dss.rules.discriminator.CompositeDiscriminator;
import oracle.dss.rules.discriminator.DateValueDiscriminator;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.NumberValueDiscriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MemberListAccess;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.SliceOutOfRangeException;

public class BaseConditionalFormatPanel
extends JPanel
implements ActionListener,
ItemListener {
    public String m_dimLabelType = "dimShortName";
    public String m_memberLabelType = "shortName";
    public static final String m_dimNameType = "layerName";
    public static final String m_memberNameType = "value";
    protected String m_measureDim = null;
    protected DataAccess m_dataAccess = null;
    protected MemberListAccess m_memberAccess = null;
    protected QDRDiscriminator m_qdrDisc;
    protected QDR m_qdr = new QDR();
    protected Discriminator m_valueDisc = null;
    protected Vector m_conditions = null;
    protected Vector m_memberVector = null;
    protected ConditionElement m_valueCondition = null;
    protected ErrorHandler m_eh = null;
    protected String m_currentMeasure = null;
    protected NumberFormat m_numberFormat;
    protected static final String[] operators = new String[]{"=", "<", "<=", ">", ">="};
    private static final String[] operatorDesc = new String[]{"EqualsAny", "= Equals", "< Less than", "<= Less than or equal", "> Greater than", ">= Greater than or equal"};
    protected Vector m_dimensionVector;
    protected Vector m_measureVector;
    protected int m_measureIndex = -1;
    private Locale m_locale;
    protected HelpProvider m_helpProvider;
    protected ResourceBundle rBundle = null;
    protected static final int INSET_TOP_SPACING = 10;
    protected static final int INSET_LEFT_SPACING = 10;
    protected static final int INSET_BOTTOM_SPACING = 10;
    protected static final int INSET_RIGHT_SPACING = 10;
    protected UIDataview m_view;
    protected JLabel m_name;
    protected JTextField m_nameField;
    protected JLabel m_blank;
    protected JCheckBox m_nameBox;
    protected JLabel m_applyTo;
    protected FormatJTable m_applyToTable;
    protected JLabel m_label;
    protected JLabel m_item;
    protected JComboBox m_itemBox;
    protected JLabel m_operator;
    protected JComboBox m_operatorBox;
    protected JLabel m_value;
    protected JTextField m_valueBox;
    protected JButton m_compoundCondition;
    protected JLabel m_sample;
    protected JButton m_editFormat;
    protected JLabel m_descriptionLabel;
    protected MultiLineLabel m_description;
    protected JTable m_formatSample;
    protected JPanel m_tmpPanel;
    protected JPanel m_applyToPanel;
    protected int m_index = -1;
    protected boolean m_isTable = false;
    private boolean editorFocus = false;

    public BaseConditionalFormatPanel(Dataview dataview) {
        this.m_view = dataview;
        this.updateResourceBundle(dataview.getLocale());
        this.m_dataAccess = dataview.getModel().getDataAccess();
    }

    public void constructPanel() {
        this.m_name = new JLabel(this.rBundle.getString("name"), 4);
        this.m_nameField = new JTextField();
        this.m_nameField.setName("NameTextfield");
        this.m_blank = new JLabel("", 4);
        this.m_nameBox = new JCheckBox(this.rBundle.getString("autoName"));
        this.m_nameBox.setSelected(true);
        this.m_nameField.setEnabled(false);
        this.m_nameField.setText(this.getDefaultConditionName());
        this.m_nameBox.setName("GenerateNameAutomatically");
        this.m_applyTo = new JLabel(this.rBundle.getString("apply"), 4);
        Object[] headers = new String[]{this.rBundle.getString("Item"), this.rBundle.getString("Members")};
        this.m_label = new JLabel(this.rBundle.getString("condition label"));
        this.m_item = new JLabel(this.rBundle.getString("item"), 4);
        this.m_compoundCondition = new JButton(this.rBundle.getString("compound button"));
        this.m_compoundCondition.setName("CompoundCondition");
        this.m_sample = new JLabel(this.rBundle.getString("format sample"), 4);
        this.m_editFormat = new JButton(this.rBundle.getString("edit format"));
        this.m_editFormat.setName("EditFormat");
        this.m_descriptionLabel = new JLabel(this.rBundle.getString("description"), 4);
        this.m_description = new MultiLineLabel(this.getAttributeLabel());
        this.m_description.setTextWrapper(WordWrapper.getTextWrapper());
        CustomPanel namePanel1 = new CustomPanel();
        namePanel1.add(this.m_name);
        namePanel1.addWithHorizGap(this.m_nameField);
        CustomPanel namePanel2 = new CustomPanel();
        namePanel2.add(this.m_blank);
        namePanel2.addWithHorizGap(this.m_nameBox);
        Object[][] data = new String[this.m_dimensionVector.size()][2];
        for (int i = 0; i < this.m_dimensionVector.size(); ++i) {
            data[i][0] = (String)this.m_dimensionVector.elementAt(i);
            data[i][1] = this.m_memberVector.elementAt(i).toString();
        }
        this.m_applyToTable = new FormatJTable(data, headers);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        labelPanel.add(this.m_applyTo);
        labelPanel.add(Box.createVerticalGlue());
        this.m_applyToPanel = new JPanel();
        this.m_applyToPanel.setLayout(new BoxLayout(this.m_applyToPanel, 1));
        JScrollPane pane = new JScrollPane(this.m_applyToTable);
        this.m_applyToPanel.add(pane);
        CustomPanel applyToPanel = new CustomPanel();
        applyToPanel.add(labelPanel);
        applyToPanel.addWithHorizGap(this.m_applyToPanel);
        pane.setAlignmentX(0.0f);
        Vector vector = this.getDimMembers(this.m_measureDim, this.m_memberLabelType);
        this.m_measureVector = this.getDimMembers(this.m_measureDim, m_memberNameType);
        if (vector == null) {
            vector = new Vector();
        }
        String[] labels = new String[vector.size() + 1];
        labels[0] = "Any";
        for (int i = 1; i < labels.length; ++i) {
            labels[i] = vector.elementAt(i - 1).toString();
        }
        this.m_itemBox = new JComboBox<String>(labels);
        this.m_itemBox.setName("ItemCombo");
        this.m_operator = new JLabel(this.rBundle.getString("operator"), 4);
        this.m_operatorBox = new JComboBox<String>(operatorDesc);
        this.m_operatorBox.setName("OperatorCombo");
        this.m_value = new JLabel(this.rBundle.getString(m_memberNameType), 4);
        this.m_valueBox = new JTextField();
        this.m_valueBox.setName("ValueTextfield");
        CustomPanel itemPanel = new CustomPanel();
        itemPanel.add(this.m_item);
        itemPanel.addWithHorizGap(this.m_itemBox);
        this.setValueCondition();
        CustomPanel operatorPanel = new CustomPanel();
        operatorPanel.add(this.m_operator);
        operatorPanel.addWithHorizGap(this.m_operatorBox);
        CustomPanel valuePanel = new CustomPanel();
        valuePanel.add(this.m_value);
        valuePanel.addWithHorizGap(this.m_valueBox);
        JPanel compoundConditionPanel = new JPanel();
        compoundConditionPanel.setLayout(new FlowLayout(0, 0, 0));
        compoundConditionPanel.add(this.m_compoundCondition);
        JPanel samplePanel = new JPanel();
        samplePanel.setLayout(new BoxLayout(samplePanel, 1));
        samplePanel.add(this.m_sample);
        samplePanel.add(Box.createVerticalGlue());
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new BoxLayout(editPanel, 1));
        editPanel.add(this.m_editFormat);
        editPanel.add(Box.createVerticalGlue());
        this.m_tmpPanel = new JPanel(new BorderLayout());
        CustomPanel formatPanel = new CustomPanel();
        formatPanel.add(samplePanel);
        formatPanel.addWithHorizGap(this.m_tmpPanel);
        formatPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        formatPanel.add(editPanel);
        JPanel dPanel = new JPanel();
        dPanel.setLayout(new BoxLayout(dPanel, 1));
        dPanel.add(this.m_descriptionLabel);
        dPanel.add(Box.createVerticalGlue());
        CustomPanel descriptionPanel = new CustomPanel();
        descriptionPanel.add(dPanel);
        descriptionPanel.addWithHorizGap((Component)this.m_description);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.add(namePanel1);
        this.add(namePanel2);
        this.addWithVertGap(applyToPanel, 15);
        this.addWithVertGap(this.m_label, 5);
        this.addWithVertGap(itemPanel, 4);
        this.addWithVertGap(operatorPanel, 4);
        this.addWithVertGap(valuePanel, 4);
        this.addWithVertGap(compoundConditionPanel, 4);
        this.addWithVertGap(formatPanel, 20);
        this.addWithVertGap(descriptionPanel, 15);
        this.add(Box.createVerticalGlue());
        namePanel1.setAlignmentX(0.0f);
        namePanel2.setAlignmentX(0.0f);
        applyToPanel.setAlignmentX(0.0f);
        itemPanel.setAlignmentX(0.0f);
        operatorPanel.setAlignmentX(0.0f);
        valuePanel.setAlignmentX(0.0f);
        compoundConditionPanel.setAlignmentX(0.0f);
        formatPanel.setAlignmentX(0.0f);
        descriptionPanel.setAlignmentX(0.0f);
        this.setPreferredSizeForAll();
        this.init();
        this.m_compoundCondition.setEnabled(false);
    }

    protected void init() {
        this.m_nameBox.addItemListener(this);
        this.m_itemBox.addItemListener(this);
        this.m_operatorBox.addItemListener(this);
        this.m_editFormat.addActionListener(this);
        this.m_compoundCondition.addActionListener(this);
    }

    public String getAttributeLabel() {
        return this.rBundle.getString("no format");
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(410, 450);
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_compoundCondition) {
            // empty if block
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.m_nameBox) {
                this.m_nameField.setEnabled(false);
                this.m_nameField.setText(this.getDefaultConditionName());
            } else if (e.getSource() == this.m_itemBox) {
                if (this.m_itemBox.getSelectedIndex() == -1) {
                    return;
                }
                if (this.m_itemBox.getSelectedIndex() > 0) {
                    String member = this.m_measureVector.elementAt(this.m_itemBox.getSelectedIndex() - 1).toString();
                    this.m_conditions.setElementAt(new ConditionElement(this.m_measureDim, member), this.m_measureIndex);
                    this.m_currentMeasure = member;
                } else {
                    this.m_currentMeasure = null;
                }
            } else if (e.getSource() == this.m_operatorBox) {
                if (this.m_operatorBox.getSelectedIndex() == 0) {
                    this.m_valueBox.setEnabled(false);
                } else {
                    this.m_valueBox.setEnabled(true);
                }
            }
        } else if (e.getStateChange() == 2 && e.getSource() == this.m_nameBox) {
            this.m_nameField.setEnabled(true);
        }
    }

    protected String getDefaultConditionName() {
        Object name = "";
        boolean isAdded = false;
        Object data = ((ConditionElement)this.m_conditions.elementAt(0)).getData();
        if (data != null) {
            if (data instanceof Vector) {
                Vector v = (Vector)data;
                String members = "";
                for (int j = 0; j < v.size() - 1; ++j) {
                    name = (String)name + v.elementAt(j) + ",";
                }
                name = (String)name + v.elementAt(v.size() - 1);
            } else {
                name = (String)name + data;
            }
        }
        for (int i = 1; i < this.m_conditions.size(); ++i) {
            String dimension = ((ConditionElement)this.m_conditions.elementAt(i)).getDimension();
            data = ((ConditionElement)this.m_conditions.elementAt(i)).getData();
            if (data == null) continue;
            if (data instanceof Vector) {
                Vector v = (Vector)data;
                if (v.size() > 0) {
                    if (!isAdded) {
                        name = (String)name + "(";
                        isAdded = true;
                    } else if (i > 1) {
                        name = (String)name + ";";
                    }
                }
                for (int j = 0; j < v.size() - 1; ++j) {
                    name = (String)name + v.elementAt(j) + ",";
                }
                name = (String)name + v.elementAt(v.size() - 1);
                continue;
            }
            if (!isAdded) {
                name = (String)name + "(";
                isAdded = true;
            } else if (i > 1) {
                name = (String)name + ";";
            }
            name = (String)name + data;
        }
        if (isAdded) {
            name = (String)name + ")";
        }
        if (((String)name).equals("")) {
            name = "ANY";
        }
        return name;
    }

    public Discriminator getDiscriminator() {
        if (this.m_dataAccess == null) {
            return null;
        }
        Vector pairs = new Vector();
        this.m_qdr = new QDR();
        for (int i = 0; i < this.m_conditions.size(); ++i) {
            String dimension = ((ConditionElement)this.m_conditions.elementAt(i)).getDimension();
            Object data = ((ConditionElement)this.m_conditions.elementAt(i)).getData();
            if (data == null) continue;
            QDRMember member = data instanceof Vector ? new QDRMember(3, data) : new QDRMember(0, data);
            this.m_qdr.addDimMemberPair(dimension, member);
        }
        this.processValueCondition();
        this.m_qdrDisc.setQDR(this.m_qdr);
        if (this.m_valueDisc != null) {
            return new CompositeDiscriminator((Discriminator)this.m_qdrDisc, this.m_valueDisc, 0);
        }
        return this.m_qdrDisc;
    }

    protected void setValueCondition() {
        Object data;
        if (this.m_valueCondition == null) {
            return;
        }
        if (this.m_valueCondition.getData() == null) {
            if (this.m_currentMeasure != null) {
                this.m_itemBox.setSelectedItem(this.getMemberLabel(this.m_measureDim, this.m_currentMeasure));
                this.m_operatorBox.setSelectedIndex(0);
            }
            return;
        }
        if (this.m_valueCondition.getDimension() != null) {
            this.m_itemBox.setSelectedItem(this.getMemberLabel(this.m_measureDim, this.m_valueCondition.getDimension()));
        }
        if ((data = this.m_valueCondition.getData()) != null) {
            Vector condition = (Vector)data;
            try {
                String val1;
                if (condition.elementAt(2) instanceof Date) {
                    val1 = this.getDateInstance().format(condition.elementAt(2));
                } else {
                    Double d = (Double)condition.elementAt(2);
                    val1 = this.m_numberFormat.format(d);
                }
                this.m_valueBox.setText(val1);
                String operator = condition.elementAt(1).toString();
                for (int i = 0; i < operators.length; ++i) {
                    if (operator != operators[i]) continue;
                    this.m_operatorBox.setSelectedIndex(i + 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void processValueCondition() {
        int idx = this.m_operatorBox.getSelectedIndex();
        this.m_valueDisc = null;
        if (this.m_operatorBox.getSelectedIndex() == 0 || this.m_valueBox.getText().length() == 0) {
            this.m_valueCondition = new ConditionElement(this.m_currentMeasure, (String)null);
            return;
        }
        Double number = null;
        Date date = null;
        try {
            try {
                String val = this.m_valueBox.getText().trim();
                number = this.m_numberFormat.parse(val).doubleValue();
            }
            catch (Exception val) {}
        }
        catch (NumberFormatException e) {
            try {
                date = new Date(this.getDateInstance().parse(this.m_valueBox.getText().trim()).getTime());
            }
            catch (ParseException e2) {
                return;
            }
        }
        if (number != null) {
            this.m_valueCondition = new ConditionElement(this.m_currentMeasure, idx - 1, number, null, true);
        } else if (date != null) {
            this.m_valueCondition = new ConditionElement(this.m_currentMeasure, idx - 1, date, null, true);
        }
        int op = 0;
        if (idx == 1) {
            op = 0;
        } else if (idx == 2) {
            op = 1;
        } else if (idx == 3) {
            op = 2;
        } else if (idx == 4) {
            op = 3;
        } else if (idx == 5) {
            op = 4;
        }
        this.m_valueDisc = number != null ? new NumberValueDiscriminator(number.doubleValue(), op) : (date != null ? new DateValueDiscriminator(date, op) : null);
    }

    protected DateFormat getDateInstance() {
        DateFormat df = DateFormat.getDateInstance(3, this.m_locale);
        if (this.m_locale.getLanguage().compareTo("th") == 0 && this.m_locale.getCountry().compareTo("TH") == 0) {
            df.setCalendar(new GregorianCalendar(this.m_locale));
        }
        return df;
    }

    protected String getMemberLabel(String dimension, String member) {
        if (dimension == null) {
            return null;
        }
        try {
            List list = this.m_dataAccess.getCorrespondingMemberMetadata(dimension, new String[]{member}, new String[]{this.m_memberLabelType}, true);
            if (list != null) {
                if (list != null && list.size() > 0 && list.get(0) != null && ((Object[])list.get(0)).length > 0) {
                    return (String)((Object[])list.get(0))[0];
                }
                return member;
            }
            for (int i = 0; i < this.m_dataAccess.getEdgeCount(); ++i) {
                int layerCount = this.m_dataAccess.getLayerCount(i);
                int endslice = this.m_dataAccess.getEdgeExtent(i);
                for (int j = 0; j < layerCount; ++j) {
                    Object dimObj = this.m_dataAccess.getLayerMetadata(i, j, m_dimNameType);
                    String dim = null;
                    if (dimObj != null) {
                        dim = dimObj.toString();
                    }
                    if (!dimension.equals(dim)) continue;
                    for (int startslice = 0; startslice != endslice; startslice += this.m_dataAccess.getMemberExtent(i, j, startslice)) {
                        if (this.m_dataAccess.getMemberStartLayer(i, j, startslice) != j) continue;
                        Object objValue = this.m_dataAccess.getMemberMetadata(i, j, startslice, m_memberNameType);
                        String value = null;
                        if (objValue != null) {
                            value = objValue.toString();
                        }
                        if (value == null || !value.equals(member)) continue;
                        objValue = this.m_dataAccess.getMemberMetadata(i, j, startslice, this.m_memberLabelType);
                        if (objValue != null) {
                            value = objValue.toString();
                        }
                        if (value == null) {
                            return member;
                        }
                        return value;
                    }
                }
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
        }
        catch (SliceOutOfRangeException sliceOutOfRangeException) {
            // empty catch block
        }
        return member;
    }

    protected void addWithVertGap(Component c, int gap) {
        this.add(Box.createRigidArea(new Dimension(0, gap)));
        this.add(c);
    }

    private int getLengthOfLongestLabel() {
        int length = this.getLength(this.m_name);
        length = this.getLength(this.m_applyTo) > length ? this.getLength(this.m_applyTo) : length;
        length = this.getLength(this.m_item) > length ? this.getLength(this.m_item) : length;
        length = this.getLength(this.m_operator) > length ? this.getLength(this.m_operator) : length;
        length = this.getLength(this.m_value) > length ? this.getLength(this.m_value) : length;
        length = this.getLength(this.m_sample) > length ? this.getLength(this.m_sample) : length;
        length = this.getLength(this.m_descriptionLabel) > length ? this.getLength(this.m_descriptionLabel) : length;
        return length;
    }

    private int getLength(JComponent c) {
        String str = "";
        if (c instanceof JLabel) {
            str = ((JLabel)c).getText();
        } else if (c instanceof JButton) {
            str = ((JButton)c).getText();
        }
        return this.getToolkit().getFontMetrics(c.getFont()).stringWidth(str);
    }

    private void setPreferredSizeForAll() {
        int width = this.getLengthOfLongestLabel();
        this.m_name.setPreferredSize(new Dimension(width, this.m_name.getPreferredSize().height));
        this.m_applyTo.setPreferredSize(new Dimension(width, 15));
        this.m_item.setPreferredSize(new Dimension(width, this.m_item.getPreferredSize().height));
        this.m_operator.setPreferredSize(new Dimension(width, this.m_operator.getPreferredSize().height));
        this.m_value.setPreferredSize(new Dimension(width, this.m_value.getPreferredSize().height));
        this.m_sample.setPreferredSize(new Dimension(width, this.m_sample.getPreferredSize().height));
        this.m_descriptionLabel.setPreferredSize(new Dimension(width, this.m_descriptionLabel.getPreferredSize().height));
        this.m_descriptionLabel.setMinimumSize(new Dimension(width, this.m_descriptionLabel.getPreferredSize().height));
        this.m_descriptionLabel.setMaximumSize(new Dimension(width, this.m_descriptionLabel.getPreferredSize().height));
        this.m_blank.setPreferredSize(new Dimension(width, this.m_blank.getPreferredSize().height));
        this.m_blank.setMinimumSize(new Dimension(width, this.m_blank.getPreferredSize().height));
        this.m_blank.setMaximumSize(new Dimension(width, this.m_blank.getPreferredSize().height));
    }

    protected void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
        this.m_locale = loc;
        this.m_numberFormat = this.m_locale != null ? NumberFormat.getInstance(this.m_locale) : NumberFormat.getInstance();
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.m_eh = eh;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    protected Vector getDimMembers(String dimension, String type) {
        if (dimension == null) {
            return null;
        }
        try {
            Vector<Object> members = new Vector<Object>();
            List list = this.m_dataAccess.getUniqueMemberMetadata(dimension, new String[]{type}, 0, -1);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i) == null || ((Object[])list.get(i)).length <= 0) continue;
                    members.addElement(((Object[])list.get(i))[0]);
                }
                return members;
            }
            for (int i = 0; i < this.m_dataAccess.getEdgeCount(); ++i) {
                int layerCount = this.m_dataAccess.getLayerCount(i);
                int endslice = this.m_dataAccess.getEdgeExtent(i);
                for (int j = 0; j < layerCount; ++j) {
                    Object dimObj = this.m_dataAccess.getLayerMetadata(i, j, m_dimNameType);
                    String dim = null;
                    if (dimObj != null) {
                        dim = dimObj.toString();
                    }
                    if (dim == null || !dimension.equals(dim)) continue;
                    if (this.m_memberAccess != null) {
                        Object[] allmembers = this.m_memberAccess.getAllMembers(i, j, m_memberNameType);
                        for (int k = 0; k < allmembers.length; ++k) {
                            members.addElement(allmembers[k]);
                        }
                        return members;
                    }
                    for (int startslice = 0; startslice != endslice; startslice += this.m_dataAccess.getMemberExtent(i, j, startslice)) {
                        if (this.m_dataAccess.getMemberStartLayer(i, j, startslice) != j) continue;
                        Object objValue = this.m_dataAccess.getMemberMetadata(i, j, startslice, type);
                        String value = null;
                        if (objValue != null) {
                            value = objValue.toString();
                        }
                        if (value == null || members.indexOf(value) != -1) continue;
                        members.addElement(value);
                    }
                }
            }
            if (members.size() > 0) {
                return members;
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
        }
        catch (SliceOutOfRangeException sliceOutOfRangeException) {
            // empty catch block
        }
        return null;
    }

    protected DimensionDialog createDimensionDialog(String title, String dimension, Vector members, int idx, boolean modal, boolean isTable) {
        DimensionDialog d = null;
        Container owner = this;
        while (owner != null) {
            if (owner instanceof Dialog) {
                d = new DimensionDialog((Dialog)owner, title, dimension, members, idx, modal, isTable);
                break;
            }
            if (owner instanceof Frame) {
                d = new DimensionDialog((Frame)owner, title, dimension, members, idx, modal, isTable);
                break;
            }
            owner = SwingUtilities.getWindowAncestor(owner);
        }
        if (d == null) {
            d = new DimensionDialog((Frame)null, title, dimension, members, idx, modal, isTable);
        }
        return d;
    }

    public void setDataAccess(DataAccess access) {
        if (access != null) {
            this.m_dataAccess = access;
        }
        this.m_memberAccess = null;
    }

    public void setMemberListAccess(MemberListAccess access) {
        if (access != null) {
            this.m_memberAccess = access;
        }
    }

    public void setMemberLabelType(String s) {
        if (s.equals("label") || s.equals("mediumName") || s.equals("shortName")) {
            this.m_memberLabelType = s;
        }
    }

    protected void setDefaultConditions() {
        this.m_dimensionVector = new Vector();
        this.m_memberVector = new Vector();
        this.m_conditions = new Vector();
        try {
            QDR qdr = this.m_dataAccess.getValueQDR(0, 0, 0);
            if (qdr != null) {
                this.m_measureDim = qdr.getMeasureDim();
            }
            if (this.m_measureDim != null && this.m_measureDim.equals("")) {
                this.m_measureDim = null;
            }
            for (int i = 0; i < this.m_dataAccess.getEdgeCount(); ++i) {
                int layerCount = this.m_dataAccess.getLayerCount(i);
                for (int j = 0; j < layerCount; ++j) {
                    Object dimObj = this.m_dataAccess.getLayerMetadata(i, j, m_dimNameType);
                    String dimension = null;
                    if (dimObj != null) {
                        dimension = dimObj.toString();
                    }
                    this.m_dimensionVector.addElement(dimension);
                    this.m_memberVector.addElement(this.rBundle.getString("<Any>"));
                    this.m_conditions.addElement(new ConditionElement(dimension, (String)null));
                    if (this.m_measureDim == null || !dimension.equals(this.m_measureDim)) continue;
                    this.m_measureIndex = this.m_conditions.size() - 1;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_qdr = new QDR();
        this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
    }

    protected void initFromDisc(Discriminator disc, ConditionElement valueCondition) {
        if (disc == null) {
            this.setDefaultConditions();
        } else {
            try {
                QDR qdr = this.m_dataAccess.getValueQDR(0, 0, 0);
                if (qdr != null) {
                    this.m_measureDim = qdr.getMeasureDim();
                }
                if (this.m_measureDim != null && this.m_measureDim.equals("")) {
                    this.m_measureDim = null;
                }
            }
            catch (Exception qdr) {
                // empty catch block
            }
            if (disc instanceof QDRDiscriminator) {
                this.m_qdrDisc = (QDRDiscriminator)disc;
                this.m_valueDisc = null;
            } else if (disc instanceof NumberValueDiscriminator) {
                this.m_qdrDisc = null;
                this.m_valueDisc = (NumberValueDiscriminator)disc;
            } else if (disc instanceof DateValueDiscriminator) {
                this.m_qdrDisc = null;
                this.m_valueDisc = (DateValueDiscriminator)disc;
            } else if (disc instanceof CompositeDiscriminator) {
                if (((CompositeDiscriminator)disc).getLeft() instanceof QDRDiscriminator) {
                    this.m_qdrDisc = (QDRDiscriminator)((CompositeDiscriminator)disc).getLeft();
                    this.m_valueDisc = ((CompositeDiscriminator)disc).getRight();
                } else {
                    this.m_valueDisc = (CompositeDiscriminator)disc;
                }
            }
            this.m_qdr = this.m_qdrDisc == null ? new QDR() : this.m_qdrDisc.getQDR();
            this.m_dimensionVector = new Vector();
            this.m_memberVector = new Vector();
            this.m_conditions = new Vector();
            try {
                for (int i = 0; i < this.m_dataAccess.getEdgeCount(); ++i) {
                    int layerCount = this.m_dataAccess.getLayerCount(i);
                    for (int j = 0; j < layerCount; ++j) {
                        QDRMember member;
                        Object dimObj = this.m_dataAccess.getLayerMetadata(i, j, m_dimNameType);
                        String dimension = null;
                        if (dimObj != null) {
                            dimension = dimObj.toString();
                        }
                        if ((member = this.m_qdr.getDimMember(dimension)) == null) {
                            this.m_dimensionVector.addElement(dimension);
                            this.m_memberVector.addElement(this.rBundle.getString("<Any>"));
                            this.m_conditions.addElement(new ConditionElement(dimension, null));
                        } else {
                            this.m_dimensionVector.addElement(dimension);
                            this.m_memberVector.addElement(member.getData());
                            this.m_conditions.addElement(new ConditionElement(dimension, member.getData()));
                        }
                        if (this.m_measureDim == null || !dimension.equals(this.m_measureDim)) continue;
                        this.m_measureIndex = this.m_conditions.size() - 1;
                        if (member == null || member.getType() != 0) continue;
                        this.m_currentMeasure = (String)member.getData();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (valueCondition != null) {
            this.m_valueCondition = valueCondition;
        }
    }

    protected void editDimensions(Vector members, int idx) {
        String dimension = ((ConditionElement)this.m_conditions.elementAt(idx)).getDimension();
        if (members == null) {
            this.m_conditions.setElementAt(new ConditionElement(dimension, (String)null), idx);
        } else if (members.size() == 1) {
            this.m_conditions.setElementAt(new ConditionElement(dimension, members.elementAt(0).toString(), 0), idx);
        } else {
            this.m_conditions.setElementAt(new ConditionElement(dimension, members, 1), idx);
        }
    }

    public ComboBoxCellEditor getMemberEditor(int row) {
        String[] str;
        this.m_index = row;
        if (this.m_memberVector.elementAt(row) instanceof Vector) {
            Vector v = (Vector)this.m_memberVector.elementAt(row);
            int size = v.size();
            str = new String[size + 1];
            for (int j = 0; j < size; ++j) {
                str[j] = (String)v.elementAt(j);
            }
            str[size] = "Select members...";
        } else {
            str = new String[]{this.rBundle.getString("<Any>"), this.rBundle.getString("Select members...")};
        }
        LightCombo combo = new LightCombo(str);
        ComboBoxCellEditor editor = new ComboBoxCellEditor(combo);
        return editor;
    }

    protected class CustomPanel
    extends JPanel {
        public CustomPanel() {
            this.setLayout(new BoxLayout(this, 0));
        }

        public void addWithHorizGap(Component c) {
            this.add(Box.createRigidArea(new Dimension(10, 0)));
            this.add(c);
        }
    }

    protected class FormatJTable
    extends JTable {
        public FormatJTable(Object[][] rowData, Object[] columnNames) {
            super(rowData, columnNames);
            this.getTableHeader().setReorderingAllowed(false);
        }

        @Override
        public boolean editCellAt(int row, int column) {
            if (!BaseConditionalFormatPanel.this.editorFocus) {
                return false;
            }
            return super.editCellAt(row, column);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 1) {
                return BaseConditionalFormatPanel.this.getMemberEditor(row);
            }
            return super.getCellEditor(row, col);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column != 0 && column <= 1;
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            int anchorRow = this.getSelectionModel().getAnchorSelectionIndex();
            int anchorColumn = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (e.getKeyCode() == 9 || e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                if (e.getKeyCode() == 9) {
                    if (anchorColumn == this.getColumnCount() - 1 && anchorRow == this.getRowCount() - 1 && !e.isShiftDown() && e.getID() != 402) {
                        this.getCellEditor(anchorRow, anchorColumn).stopCellEditing();
                        this.requestFocus();
                        if (FocusManager.isFocusManagerEnabled()) {
                            FocusManager.getCurrentManager().focusNextComponent(this);
                            e.consume();
                        }
                        return;
                    }
                    if (anchorColumn == 0 && anchorRow == 0 && e.isShiftDown() && e.getID() != 402) {
                        if (FocusManager.isFocusManagerEnabled()) {
                            FocusManager.getCurrentManager().focusPreviousComponent(this);
                            e.consume();
                        }
                        return;
                    }
                }
            } else if (e.getKeyCode() == 32 && anchorColumn != 0 && this.isCellEditable(anchorRow, anchorColumn)) {
                BaseConditionalFormatPanel.this.editorFocus = true;
                this.editCellAt(anchorRow, anchorColumn);
                this.getEditorComponent().requestFocus();
                if (this.getEditorComponent() instanceof JComboBox) {
                    this.getEditorComponent().setVisible(true);
                    ((JComboBox)this.getEditorComponent()).showPopup();
                }
            }
            super.processKeyEvent(e);
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            if (e.getID() == 1005 && !e.isTemporary() && BaseConditionalFormatPanel.this.editorFocus) {
                BaseConditionalFormatPanel.this.editorFocus = false;
            }
            super.processFocusEvent(e);
        }
    }

    protected class DimensionDialog
    extends JDialog
    implements ActionListener,
    HelpContext {
        private String m_dimension;
        private DimensionShuttlePanel listPanel;
        private JButton okButton;
        private JButton cancelButton;
        private JButton helpButton;
        private boolean m_bHelpEnabled;

        public DimensionDialog(Frame owner, String title, String dimension, Vector members, int index, boolean modal, boolean isTable) {
            super(owner, title, modal);
            this.listPanel = null;
            this.m_bHelpEnabled = true;
            this._initDialog(dimension, members, index, isTable);
        }

        public DimensionDialog(Dialog owner, String title, String dimension, Vector members, int index, boolean modal, boolean isTable) {
            super(owner, title, modal);
            this.listPanel = null;
            this.m_bHelpEnabled = true;
            this._initDialog(dimension, members, index, isTable);
        }

        private void _initDialog(String dimension, Vector members, int index, boolean isTable) {
            BaseConditionalFormatPanel.this.m_index = index;
            this.m_dimension = dimension;
            this.init(members, isTable);
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        }

        public void init(Vector members, boolean isTable) {
            JComponent content = (JComponent)this.getContentPane();
            content.setLayout(new BoxLayout(content, 1));
            if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                content.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
            }
            content.setBorder(BorderFactory.createEmptyBorder(6, 6, 10, 6));
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BoxLayout(mainPanel, 0));
            this.listPanel = new DimensionShuttlePanel(this, BaseConditionalFormatPanel.this.m_dataAccess, BaseConditionalFormatPanel.this.m_memberAccess, this.m_dimension, BaseConditionalFormatPanel.this.m_memberLabelType, isTable, (Vector)null);
            this.listPanel.setLocale(BaseConditionalFormatPanel.this.m_locale);
            this.listPanel.setSelectedMembers(members);
            this.listPanel.setAlignmentX(0.0f);
            mainPanel.add(this.listPanel);
            mainPanel.setPreferredSize(new Dimension(355, 240));
            content.add(mainPanel);
            GrayPane gp = new GrayPane((Component)mainPanel);
            content.add((Component)gp);
            DialogButtonBar buttonPanel = new DialogButtonBar();
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
            String translatedText = "";
            if (this.m_bHelpEnabled) {
                translatedText = BaseConditionalFormatPanel.this.rBundle.getString("help");
                this.helpButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
                this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
                this.helpButton.setMinimumSize(this.helpButton.getPreferredSize());
                buttonPanel.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
                this.helpButton.addActionListener(this);
                this.helpButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(112, 0), 2);
            }
            translatedText = BaseConditionalFormatPanel.this.rBundle.getString("OK");
            this.okButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this.okButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            buttonPanel.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_YES);
            this.okButton.addActionListener(this);
            this.okButton.setMinimumSize(this.okButton.getPreferredSize());
            this.getRootPane().setDefaultButton(this.okButton);
            translatedText = BaseConditionalFormatPanel.this.rBundle.getString("cancel");
            this.cancelButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this.cancelButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            buttonPanel.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
            this.cancelButton.setMinimumSize(this.cancelButton.getPreferredSize());
            this.cancelButton.addActionListener(this);
            this.cancelButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
            content.add((Component)buttonPanel);
            this.setResizable(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cancelButton) {
                this.setVisible(false);
                this.listPanel.cleanUp();
                this.dispose();
                this.getParent().repaint();
            } else if (e.getSource() == this.okButton) {
                boolean ret = this.listPanel.showErrorDialog();
                if (ret) {
                    BaseConditionalFormatPanel.this.editDimensions(this.listPanel.getSelectedMembers(), BaseConditionalFormatPanel.this.m_index);
                    if (BaseConditionalFormatPanel.this.m_nameBox.isSelected()) {
                        BaseConditionalFormatPanel.this.m_nameField.setText(BaseConditionalFormatPanel.this.getDefaultConditionName());
                    }
                    this.setVisible(false);
                    this.listPanel.cleanUp();
                    this.dispose();
                }
            } else if (e.getSource() == this.helpButton) {
                try {
                    if (BaseConditionalFormatPanel.this.getHelpProvider() != null) {
                        BaseConditionalFormatPanel.this.getHelpProvider().showHelp((Component)this);
                    } else if (HelpUtils.getDefaultHelpProvider() != null) {
                        HelpUtils.getDefaultHelpProvider().showHelp((Component)this);
                    }
                }
                catch (HelpUnavailableException helpUnavailableException) {
                    // empty catch block
                }
            }
        }

        public String getHelpContextID() {
            return this.getClass().getName();
        }

        public void setHelpContextID(String strHelpContextID) {
        }
    }

    private class LightCombo
    extends JComboBox {
        Vector member;
        String dimension;
        int size;
        private ActionListener enterAction;

        public LightCombo(String[] str) {
            super(str);
            this.member = null;
            this.dimension = "";
            this.size = 100;
            this._init(str.length);
        }

        @Override
        public Object getSelectedItem() {
            if (this.getSelectedIndex() == -1) {
                return "";
            }
            return super.getSelectedItem();
        }

        private void _init(int s) {
            this.dimension = (String)BaseConditionalFormatPanel.this.m_dimensionVector.elementAt(BaseConditionalFormatPanel.this.m_index);
            Object data = BaseConditionalFormatPanel.this.m_memberVector.elementAt(BaseConditionalFormatPanel.this.m_index);
            this.member = data instanceof String ? null : (Vector)data;
            this.size = s;
            this.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
            this.enterAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LightCombo.this.getSelectedIndex() == LightCombo.this.size - 1) {
                        DimensionDialog dialog = BaseConditionalFormatPanel.this.createDimensionDialog(BaseConditionalFormatPanel.this.rBundle.getString("Select Members"), LightCombo.this.dimension, LightCombo.this.member, BaseConditionalFormatPanel.this.m_index, true, BaseConditionalFormatPanel.this.m_isTable);
                        dialog.show();
                    }
                }
            };
            this.addActionListener(this.enterAction);
            this.registerKeyboardAction(this.enterAction, KeyStroke.getKeyStroke(10, 0), 1);
        }

        public void cleanUp() {
            this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
            this.enterAction = null;
        }
    }

    private class ComboBoxCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        public ComboBoxCellEditor(final JComboBox comboBox) {
            super(comboBox);
            comboBox.addFocusListener(this);
            comboBox.removeActionListener(this.delegate);
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ComboBoxCellEditor.this.fireEditingStopped();
                }

                @Override
                public void setValue(Object value) {
                    if (value instanceof Integer) {
                        value = value.toString();
                    }
                    if (value == "") {
                        comboBox.setSelectedIndex(-1);
                    } else {
                        comboBox.setSelectedItem(value);
                    }
                }

                @Override
                public Object getCellEditorValue() {
                    return comboBox.getSelectedItem();
                }
            };
            comboBox.addActionListener(this.delegate);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.delegate.setValue(value);
            return this.editorComponent;
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!e.isTemporary()) {
                BaseConditionalFormatPanel.this.editorFocus = true;
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary() && BaseConditionalFormatPanel.this.editorFocus) {
                BaseConditionalFormatPanel.this.editorFocus = false;
                this.stopCellEditing();
            }
        }
    }

    protected class CustomGluePanel
    extends JPanel {
        public void addWithGlue(Component comp) {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.add(comp);
            p.add(Box.createVerticalGlue());
            this.add(Box.createRigidArea(new Dimension(10, 0)));
            this.add(p);
        }
    }
}

