/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.solver;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import mb.flowspec.runtime.solver.MapType;
import mb.flowspec.runtime.solver.Type;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="MapType", generator="Immutables")
@Immutable
public final class ImmutableMapType
extends MapType {
    private final Type key;
    private final Type value;
    private final transient int hashCode;

    private ImmutableMapType(Type key, Type value) {
        this.key = Objects.requireNonNull(key, "key");
        this.value = Objects.requireNonNull(value, "value");
        this.hashCode = this.computeHashCode();
    }

    private ImmutableMapType(ImmutableMapType original, Type key, Type value) {
        this.key = key;
        this.value = value;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public Type key() {
        return this.key;
    }

    @Override
    public Type value() {
        return this.value;
    }

    public final ImmutableMapType withKey(Type value) {
        if (this.key == value) {
            return this;
        }
        Type newValue = Objects.requireNonNull(value, "key");
        return new ImmutableMapType(this, newValue, this.value);
    }

    public final ImmutableMapType withValue(Type value) {
        if (this.value == value) {
            return this;
        }
        Type newValue = Objects.requireNonNull(value, "value");
        return new ImmutableMapType(this, this.key, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMapType && this.equalTo((ImmutableMapType)another);
    }

    private boolean equalTo(ImmutableMapType another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.key.equals(another.key) && this.value.equals(another.value);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MapType").omitNullValues().add("key", (Object)this.key).add("value", (Object)this.value).toString();
    }

    public static ImmutableMapType of(Type key, Type value) {
        return new ImmutableMapType(key, value);
    }

    public static ImmutableMapType copyOf(MapType instance) {
        if (instance instanceof ImmutableMapType) {
            return (ImmutableMapType)instance;
        }
        return ImmutableMapType.of(instance.key(), instance.value());
    }
}

