/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.core;

import java.util.List;
import oracle.security.xmlsec.saml2.core.BaseID;
import oracle.security.xmlsec.saml2.core.EncryptedID;
import oracle.security.xmlsec.saml2.core.NameID;
import oracle.security.xmlsec.saml2.core.SAML2NameIdentifier;
import oracle.security.xmlsec.saml2.core.SubjectConfirmation;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Subject
extends XMLElement {
    private static final String[] nsList = new String[]{"urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:assertion"};
    private static final String[] tagList = new String[]{"BaseID", "NameID", "EncryptedID", "SubjectConfirmation"};

    public Subject(Element element) throws DOMException {
        super(element);
    }

    public Subject(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public Subject(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:assertion", "Subject");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:assertion");
    }

    public Subject(Document owner, SAML2NameIdentifier name) throws DOMException {
        this(owner);
        this.appendChild(name.getNode());
    }

    public Subject(Document owner, SAML2NameIdentifier name, SubjectConfirmation sc) throws DOMException {
        this(owner, name);
        this.appendChild(sc.getNode());
    }

    public void setSubjectNameIdentifier(SAML2NameIdentifier nid) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"NameID");
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"EncryptedID");
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"BaseID");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)((XMLElement)nid), (String[])nsList, (String[])tagList);
    }

    public SAML2NameIdentifier getSubjectNameIdentifier() {
        XMLElement nid = null;
        nid = (NameID)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "NameID");
        if (nid != null) {
            return nid;
        }
        nid = (EncryptedID)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedID");
        if (nid != null) {
            return nid;
        }
        nid = (BaseID)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "BaseID");
        if (nid != null) {
            return nid;
        }
        return null;
    }

    public void addSubjectConfirmation(SubjectConfirmation subjectConfirmation) {
        this.appendChild(subjectConfirmation.getNode());
    }

    public List getSubjectConfirmations() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:assertion", "SubjectConfirmation");
    }

    static {
        SAML2Initializer.initialize();
    }
}

