/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import java.math.BigDecimal;
import java.time.Instant;
import oracle.json.util.ScalarValue;

public class DistinctValue
extends ScalarValue {
    public final int count;

    private DistinctValue(BigDecimal bigDecimal, int n) {
        super(bigDecimal);
        this.count = n;
    }

    private DistinctValue(String string, int n) {
        super(string);
        this.count = n;
    }

    private DistinctValue(Instant instant, int n) {
        super(instant);
        this.count = n;
    }

    private DistinctValue(int n) {
        this.count = n;
    }

    private DistinctValue(boolean bl, int n) {
        super(bl);
        this.count = n;
    }

    private DistinctValue(ScalarValue scalarValue, int n) {
        super(scalarValue);
        this.count = n;
    }

    private static int datatypeFrom(ScalarValue scalarValue) {
        if (scalarValue.isString()) {
            return 9;
        }
        if (scalarValue.isNumber()) {
            return 11;
        }
        if (scalarValue.isNull()) {
            return 0;
        }
        if (scalarValue.isBoolean()) {
            return 1;
        }
        if (scalarValue.isDateTime()) {
            return 12;
        }
        return 10;
    }

    public int datatype() {
        return DistinctValue.datatypeFrom(this);
    }

    public static DistinctValue createString(String string, int n) {
        return new DistinctValue(string, n);
    }

    public static DistinctValue createNumber(BigDecimal bigDecimal, int n) {
        return new DistinctValue(ScalarValue.numberFrom(bigDecimal), n);
    }

    public static DistinctValue createDateTime(String string, int n) {
        return new DistinctValue(ScalarValue.timestampFrom(string), n);
    }

    public static DistinctValue createBoolean(boolean bl, int n) {
        return new DistinctValue(bl, n);
    }

    public static DistinctValue createNull(int n) {
        return new DistinctValue(n);
    }

    public Object getNativeValue() {
        if (this.isString()) {
            return this.stringValue();
        }
        if (this.isBoolean()) {
            return this.booleanValue();
        }
        if (this.isDate()) {
            return this.timestampValue();
        }
        if (this.isDateTime()) {
            return this.timestampValue();
        }
        if (this.isBinary()) {
            return this.binaryValue();
        }
        if (this.isNull()) {
            return null;
        }
        if (this.isInteger()) {
            return this.val;
        }
        if (this.isLong()) {
            return this.val;
        }
        if (this.isDouble()) {
            return this.val;
        }
        if (this.isFloat()) {
            return this.val;
        }
        if (this.isDecimalNumber()) {
            return this.val;
        }
        if (!this.isNumber()) {
            return null;
        }
        BigDecimal bigDecimal = this.numberValue();
        try {
            if (this.subType == 6) {
                return bigDecimal;
            }
            if (this.subType == 2) {
                return new Integer(bigDecimal.intValueExact());
            }
            if (this.subType == 3) {
                return new Long(bigDecimal.longValueExact());
            }
            if (this.subType == 4) {
                return new Float(bigDecimal.floatValue());
            }
            if (this.subType == 5) {
                return new Double(bigDecimal.doubleValue());
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        BigDecimal bigDecimal2 = bigDecimal.stripTrailingZeros();
        int n = bigDecimal2.precision();
        int n2 = bigDecimal2.scale();
        if (n2 > 0 || n > 34) {
            double d;
            if ((n <= 15 || n > 34) && (d = bigDecimal.doubleValue()) != Double.NEGATIVE_INFINITY && d != Double.POSITIVE_INFINITY) {
                return new Double(d);
            }
        } else {
            int n3 = n - n2;
            if (n3 <= 10) {
                try {
                    int n4 = bigDecimal.intValueExact();
                    return new Integer(n4);
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
            }
            if (n3 <= 19) {
                try {
                    long l = bigDecimal.longValueExact();
                    return new Long(l);
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
            }
        }
        return bigDecimal;
    }
}

