/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.xml.esax.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.xml.esax.ElementContext;
import oracle.javatools.xml.esax.ElementEndContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.ElementHandlerFactory;
import oracle.javatools.xml.esax.ElementStartContext;
import oracle.javatools.xml.esax.Key;
import oracle.javatools.xml.esax.MessageReporter;
import oracle.javatools.xml.esax.XMLLocator;
import oracle.javatools.xml.esax.spi.Stack;
import org.xml.sax.Attributes;

public class DefaultElementContext
implements ElementContext,
ElementStartContext,
ElementEndContext {
    private Attributes _attributes;
    private String _uri;
    private String _name;
    private Stack _elementPathStack = new Stack();
    private Stack _contextMapStack = new Stack();
    private Stack _scopeHandlers = new Stack();
    private Stack _elementText = new Stack();
    private Stack _childHandlers = new Stack();
    private Map _ceChildHandlers = null;
    private XMLLocator _locator;
    private MessageReporter _messageReporter;

    public DefaultElementContext() {
        this._contextMapStack.push(new HashMap());
        this._childHandlers.push(null);
    }

    void setLocator(XMLLocator locator) {
        this._locator = locator;
    }

    @Override
    public String getLocalName() {
        return this._name;
    }

    @Override
    public String getNamespaceURI() {
        return this._uri;
    }

    public String getPath() {
        StringBuffer pathBuffer = new StringBuffer();
        pathBuffer.append("/");
        Iterator i = this._elementPathStack.reverseIterator();
        while (i.hasNext()) {
            pathBuffer.append(String.valueOf(i.next()));
            pathBuffer.append("/");
        }
        return pathBuffer.toString();
    }

    @Override
    public String getParentLocalName() {
        if (!this._elementPathStack.isEmpty()) {
            return (String)this._elementPathStack.peek();
        }
        return "";
    }

    @Override
    public String getText() {
        if (this._elementText.isEmpty()) {
            throw new IllegalStateException("Cannot call getText() prior to end element");
        }
        StringBuffer buffer = (StringBuffer)this._elementText.peek();
        if (buffer == null) {
            return null;
        }
        return buffer.toString();
    }

    @Override
    public String getAttributeValue(String attributeName) {
        if (this._attributes == null) {
            throw new IllegalStateException("Cannot call from handleEndElement");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName must not be null");
        }
        return this._attributes.getValue(attributeName);
    }

    @Override
    public Iterator getAttributeNames() {
        if (this._attributes == null) {
            throw new IllegalStateException();
        }
        final Attributes attributes = this._attributes;
        return new Iterator(){
            private int _currentIndex = 0;

            @Override
            public boolean hasNext() {
                return this._currentIndex < attributes.getLength();
            }

            public Object next() {
                if (this._currentIndex >= attributes.getLength()) {
                    throw new ArrayIndexOutOfBoundsException(String.valueOf(this._currentIndex) + " >= " + attributes.getLength());
                }
                return attributes.getLocalName(this._currentIndex++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Object getValue(Key key) {
        for (Map theMap : this._contextMapStack) {
            Object value;
            if (theMap == null || (value = theMap.get(key)) == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public void putValue(Key key, Object value) {
        HashMap<Key, Object> topMap = (HashMap<Key, Object>)this._contextMapStack.peek();
        if (topMap == null) {
            topMap = new HashMap<Key, Object>();
            this._contextMapStack.replace(topMap);
        }
        topMap.put(key, value);
    }

    @Override
    public void removeValue(Key key) {
        Map topMap = (Map)this._contextMapStack.peek();
        if (topMap != null) {
            topMap.remove(key);
        }
    }

    @Override
    public void registerChildHandler(String namespaceURI, String localName, ElementHandler handler) {
        if (this._ceChildHandlers == null) {
            this._ceChildHandlers = new HashMap();
        }
        this._ceChildHandlers.put(new QualifiedName(namespaceURI, localName), handler);
    }

    @Override
    public void registerScopeHandler(String localElementName, ElementHandler handler) {
        this.registerScopeHandler(null, localElementName, handler);
    }

    @Override
    public void registerScopeHandler(String namespaceURI, String localElementName, ElementHandler handler) {
        if (this._scopeHandlers.isEmpty()) {
            this.registerChildHandler(namespaceURI, localElementName, handler);
            return;
        }
        ScopeHandlerRegistry registry = (ScopeHandlerRegistry)this._scopeHandlers.peek();
        if (registry != null) {
            registry.addStaticHandler(new QualifiedName(namespaceURI, localElementName), handler);
        }
    }

    @Override
    public void registerScopeHandlerFactory(ElementHandlerFactory factory) {
        if (this._scopeHandlers.isEmpty()) {
            throw new IllegalStateException("Cannot register a scope handler factory for the root");
        }
        ScopeHandlerRegistry registry = (ScopeHandlerRegistry)this._scopeHandlers.peek();
        if (registry != null) {
            registry.addFactoryHandler(factory);
        }
    }

    public ElementHandler getScopedHandler() {
        QualifiedName qualified = new QualifiedName(this._uri, this._name);
        QualifiedName unqualified = new QualifiedName(null, this._name);
        ElementHandler handler = null;
        Map childHandlerMap = (Map)this._childHandlers.peek();
        if (childHandlerMap != null) {
            handler = (ElementHandler)childHandlerMap.get(qualified);
            if (handler == null) {
                handler = (ElementHandler)childHandlerMap.get(unqualified);
            }
            if (handler != null) {
                return handler;
            }
        }
        for (ScopeHandlerRegistry registry : this._scopeHandlers) {
            handler = registry.getStaticHandler(qualified);
            if (handler != null) {
                return handler;
            }
            handler = registry.getStaticHandler(unqualified);
            if (handler != null) {
                return handler;
            }
            Iterator j = registry.getFactoryHandlers();
            while (j.hasNext()) {
                ElementHandlerFactory factory = (ElementHandlerFactory)j.next();
                handler = factory.getElementHandler(this._uri, this._name);
                if (handler == null) continue;
                return handler;
            }
        }
        return handler;
    }

    private void setElement(String uri, String name) {
        this._uri = uri;
        this._name = name;
    }

    void beginElement(String uri, String name, Attributes attributes) {
        this.setElement(uri, name);
        this._attributes = attributes;
        this._contextMapStack.push(null);
        this._scopeHandlers.push(new ScopeHandlerRegistry());
        this._childHandlers.push(this._ceChildHandlers);
        this._ceChildHandlers = null;
    }

    void appendCharacters(char[] characters, int start, int length) {
        if (this._elementText.isEmpty()) {
            throw new IllegalStateException();
        }
        StringBuffer buffer = (StringBuffer)this._elementText.peek();
        if (buffer == null) {
            buffer = new StringBuffer();
            this._elementText.replace(buffer);
        }
        buffer.append(characters, start, length);
    }

    void postEndElement() {
        this._scopeHandlers.pop();
        this._contextMapStack.pop();
        this._elementText.pop();
        this._ceChildHandlers = (Map)this._childHandlers.peek();
        this._childHandlers.pop();
        this._name = null;
        this._attributes = null;
        this._uri = null;
    }

    void endElement(String uri, String name) {
        this.setElement(uri, name);
        this._attributes = null;
        this._elementPathStack.pop();
    }

    void postBeginElement() {
        this._elementPathStack.push(this._name);
        this._elementText.push(null);
    }

    @Override
    public XMLLocator getLocator() {
        return this._locator;
    }

    @Override
    public MessageReporter getMessageReporter() {
        if (this._messageReporter == null) {
            this._messageReporter = new NullReporter();
        }
        return this._messageReporter;
    }

    @Override
    public void setMessageReporter(MessageReporter reporter) {
        this._messageReporter = reporter;
    }

    private class QualifiedName {
        private final String _namespaceURI;
        private final String _localName;

        public QualifiedName(String namespaceURI, String localName) {
            this._namespaceURI = namespaceURI;
            this._localName = localName;
        }

        public String getNamespaceURI() {
            return this._namespaceURI;
        }

        public String getLocalName() {
            return this._localName;
        }

        public String toString() {
            return "Namespace: " + String.valueOf(this._namespaceURI) + ", Local Name: " + String.valueOf(this._localName);
        }

        public int hashCode() {
            int code = 213465;
            if (this._namespaceURI != null) {
                code += this._namespaceURI.hashCode();
            }
            if (this._localName != null) {
                code += this._localName.hashCode();
            }
            return code;
        }

        public boolean equals(Object that) {
            if (that instanceof QualifiedName) {
                return String.valueOf(this._namespaceURI).equals(String.valueOf(((QualifiedName)that)._namespaceURI)) && String.valueOf(this._localName).equals(String.valueOf(((QualifiedName)that)._localName));
            }
            return false;
        }
    }

    private class ScopeHandlerRegistry {
        private List _factoryHandlers;
        private Map _staticHandlers;

        private ScopeHandlerRegistry() {
        }

        public Iterator getFactoryHandlers() {
            if (this._factoryHandlers == null) {
                return Collections.EMPTY_LIST.iterator();
            }
            return this._factoryHandlers.iterator();
        }

        public ElementHandler getStaticHandler(QualifiedName name) {
            if (this._staticHandlers == null) {
                return null;
            }
            return (ElementHandler)this._staticHandlers.get(name);
        }

        public void addFactoryHandler(ElementHandlerFactory factory) {
            if (this._factoryHandlers == null) {
                this._factoryHandlers = new ArrayList();
            }
            this._factoryHandlers.add(factory);
        }

        public void addStaticHandler(QualifiedName qn, ElementHandler handler) {
            if (this._staticHandlers == null) {
                this._staticHandlers = new HashMap();
            }
            this._staticHandlers.put(qn, handler);
        }
    }

    private class NullReporter
    implements MessageReporter {
        private NullReporter() {
        }

        @Override
        public void severe(XMLLocator edd, String message, Throwable exception) {
        }

        @Override
        public void error(XMLLocator edd, String message, Throwable exception) {
        }

        @Override
        public void warning(XMLLocator edd, String message) {
        }

        @Override
        public void information(XMLLocator edd, String message) {
        }
    }
}

