/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import net.miginfocom.swing.MigLayout;
import oracle.ide.hover.Hover;
import oracle.javatools.editor.BasicEditorOverviewMark;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.ui.border.RoundedBorderComponent;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.overview.OverviewTipProvider;
import oracle.javatools.util.Pair;

final class BasicEditorOverviewTipProvider
implements OverviewTipProvider<BasicEditorOverviewMark> {
    private final BasicEditorPane editor;
    private final InfoTipStyles infoTipStyles = InfoTipStyles.DEFAULT;
    private static int EXTRA_LINES = 2;

    BasicEditorOverviewTipProvider(BasicEditorPane editor) {
        this.editor = editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JComponent getTipContent(Collection<BasicEditorOverviewMark> marks, Hover hover) {
        assert (marks.size() > 0);
        JPanel content = new JPanel((LayoutManager)new MigLayout("ins 0, gapx 0, gapy 2"));
        Insets insets = this.infoTipStyles.getBorderInsets();
        content.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        content.setOpaque(false);
        this.editor.getTextBuffer().readLock();
        try {
            JComponent marksC;
            Point edLoc = this.editor.getLocationOnScreen();
            Window w = SwingUtilities.windowForComponent(this.editor);
            SwingUtilities.convertPointFromScreen(edLoc, w);
            int edRight = edLoc.x + this.editor.getVisibleRect().width - 60;
            final int maxWidth = Math.min(800, edRight);
            EditorSubView editorSubView = new EditorSubView(this.editor);
            Pair<Integer, Integer> offsets = this.getOffsets(marks);
            editorSubView.setBackground(Color.WHITE);
            JScrollPane sp = new JScrollPane(editorSubView){

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    if (d.width > maxWidth) {
                        d.height = (int)((double)d.height + this.getHorizontalScrollBar().getPreferredSize().getHeight());
                    }
                    return d;
                }
            };
            sp.setBorder(null);
            sp.setBackground(this.editor.getBackground());
            sp.setVerticalScrollBarPolicy(21);
            if (this.createEditorView(editorSubView, offsets)) {
                content.add((Component)RoundedBorderComponent.createRoundedComponent((JComponent)sp, (Color)this.infoTipStyles.getInternalBorderColor()), "grow, wmax " + maxWidth);
            }
            if ((marksC = this.getMarkComponents(marks, hover)) != null) {
                content.add((Component)marksC, "dock north");
            }
        }
        finally {
            this.editor.getTextBuffer().readUnlock();
        }
        return content;
    }

    private Pair<Integer, Integer> getOffsets(Collection<BasicEditorOverviewMark> marks) {
        int startLine = this.editor.getLineCount() - 1;
        int endLine = 0;
        CodeFoldingMargin foldingMargin = (CodeFoldingMargin)this.editor.getProperty("code-folding-margin");
        for (BasicEditorOverviewMark mark : marks) {
            int start = mark.getStartOffset();
            int end = mark.getEndOffset();
            if (foldingMargin != null && foldingMargin.getModel() != null) {
                Object highestFoldedBlock = null;
                CodeFoldingModel foldingModel = foldingMargin.getModel();
                Object block = foldingModel.getSmallestEnclosingBlock(start);
                while (block != null) {
                    if (!foldingModel.isExpanded(block)) {
                        highestFoldedBlock = block;
                    }
                    block = foldingModel.getParent(block);
                }
                if (highestFoldedBlock != null) {
                    int[] offs = foldingModel.getTextOffsets(highestFoldedBlock, null);
                    start = offs[0];
                    end = offs[1];
                }
            }
            int line = this.editor.getLineFromOffset(start);
            startLine = Math.min(startLine, line);
            line = this.editor.getLineFromOffset(end);
            endLine = Math.max(endLine, line);
        }
        startLine = Math.max(0, startLine - EXTRA_LINES);
        endLine = Math.min(this.editor.getLineCount() - 1, endLine + EXTRA_LINES);
        int startOffset = this.editor.getLineStartOffset(startLine);
        int endOffset = this.editor.getLineEndOffset(endLine);
        return new Pair<Integer, Integer>(startOffset, endOffset);
    }

    private Rectangle getViewBounds(Pair<Integer, Integer> offsets) {
        int l = this.editor.getWidth();
        int r = 0;
        int t = 0;
        int b = 0;
        boolean found = false;
        int start = (Integer)offsets.first;
        int end = Math.min((Integer)offsets.first + 1000, (Integer)offsets.second);
        try {
            for (int i = start; i < end; ++i) {
                int r1;
                int b1;
                char c = this.editor.getTextBuffer().getChar(i);
                boolean isWhitespace = Character.isWhitespace(c);
                Rectangle charRect = this.editor.modelToView(i);
                if (!found) {
                    found = true;
                    t = charRect.y;
                    b = charRect.y + charRect.height;
                    if (isWhitespace) continue;
                    l = charRect.x;
                    r = charRect.x + charRect.width;
                    continue;
                }
                if (charRect.y < l) {
                    t = charRect.y;
                }
                if ((b1 = charRect.y + charRect.height) > b) {
                    b = b1;
                }
                if (isWhitespace) continue;
                if (charRect.x < l) {
                    l = charRect.x;
                }
                if ((r1 = charRect.x + charRect.width) <= r) continue;
                r = r1;
            }
        }
        catch (BadLocationException e) {
            Logger.getLogger("global").log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        if (!found) {
            return null;
        }
        return new Rectangle(l, t, Math.max(150, r - l), b - t);
    }

    private boolean createEditorView(EditorSubView editorSubView, Pair<Integer, Integer> offsets) {
        Rectangle r = this.getViewBounds(offsets);
        if (r == null) {
            return false;
        }
        editorSubView.setSubBounds(r);
        return true;
    }

    public OverviewTipProvider.Orientation getOrientation() {
        return OverviewTipProvider.Orientation.LEFT_RIGHT;
    }

    private JComponent getMarkComponents(Collection<BasicEditorOverviewMark> marks, Hover hover) {
        JPanel markComponents = new JPanel((LayoutManager)new MigLayout("wrap 1, ins 0 0 2 0, fill, gapy 1"));
        markComponents.setOpaque(false);
        for (BasicEditorOverviewMark mark : marks) {
            JComponent markC = mark.getTipComponent(hover);
            if (markC == null) continue;
            markComponents.add((Component)markC, "growx 100");
        }
        return markComponents.getComponentCount() == 0 ? null : markComponents;
    }

    private static class EditorSubView
    extends JPanel {
        private SoftReference<Image> _renderImageRef;
        private BasicEditorPane editor;
        private Rectangle rect;
        private final int INTERNAL_PADDING = 10;

        EditorSubView(BasicEditorPane editor) {
            this.setOpaque(true);
            this.editor = editor;
        }

        public void setSubBounds(Rectangle rect) {
            assert (rect != null);
            this.rect = rect;
            this._renderImageRef = null;
            Dimension size = rect.getSize();
            size.width += 10;
            size.height += 10;
            this.setPreferredSize(size);
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.setBackground(Color.WHITE);
            super.paintComponent(g);
            Image image = null;
            if (this._renderImageRef != null) {
                image = this._renderImageRef.get();
            }
            if (image == null) {
                image = this.getImage();
                this._renderImageRef = new SoftReference<Image>(image);
            }
            g.drawImage(image, 5, 5, null);
        }

        private Image getImage() {
            boolean isOpaque = this.editor.isOpaque();
            this.editor.setOpaque(false);
            boolean wasCaretVisible = ((DefaultCaret)this.editor.getCaret()).isActive();
            this.editor.getCaret().setVisible(false);
            int width = Math.max(this.rect.width, this.getWidth());
            Image image = this.editor.createImage(width, this.rect.height);
            Graphics g = image.getGraphics();
            g.setColor(this.editor.getBackground());
            g.setClip(0, 0, width, this.rect.height);
            g.fillRect(0, 0, width, this.rect.height);
            g.translate(-this.rect.x, -this.rect.y);
            this.editor.paint(g);
            this.editor.getCaret().setVisible(wasCaretVisible);
            this.editor.setOpaque(isOpaque);
            g.dispose();
            return image;
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this._renderImageRef = null;
        }
    }
}

