/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.parallelquery;

import java.awt.Dimension;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableAdapter;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelQueryPreferences;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelQuerySettingPanel;
import oracle.dmt.dataminer.workflow.parallelquery.ViewDataProvider;

public class ViewDataParallelPanel
extends JPanel
implements DataminerGUIPanel,
DialogDisplayable,
ViewDataProvider {
    public static final String VIEW_KEY = ViewDataParallelPanel.class.getName();
    public static final String SYSTEM_DETERMINED = "System Determined";
    private ParallelQueryPreferences PQPref;
    private boolean fromParallelEditor;
    private String title;
    private ParallelQuerySettingPanel DOPPanel;
    private JCheckBox cbParallel;
    private JPanel jPanel2;

    public ViewDataParallelPanel(String string) {
        this.initComponents();
        this.title = string;
        this.PQPref = ParallelQueryPreferences.getInstance();
        this.fromParallelEditor = false;
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.DOPPanel = new ParallelQuerySettingPanel();
        this.jPanel2 = new JPanel();
        this.cbParallel = new JCheckBox();
        this.DOPPanel.setPreferredSize(new Dimension(300, 150));
        GroupLayout groupLayout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 27, Short.MAX_VALUE));
        this.cbParallel.setText("Parallel Query On");
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.cbParallel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.DOPPanel, -2, 265, -2).addGap(0, 0, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, -2, -1, -2).addComponent(this.cbParallel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DOPPanel, -1, 105, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        this.cbParallel.setText(DataLrb.get("DATA_VIEWER_PARALLEL_CHECK"));
    }

    @Override
    public void initUI() {
        if (!this.fromParallelEditor) {
            String string = this.PQPref.getViewDataProperty(VIEW_KEY, ParallelQueryPreferences.PROPERTY.IS_PARALLEL);
            String string2 = this.PQPref.getViewDataProperty(VIEW_KEY, ParallelQueryPreferences.PROPERTY.VALUE);
            if (string == null || !Boolean.parseBoolean(string)) {
                this.cbParallel.setSelected(false);
            } else {
                this.cbParallel.setSelected(true);
            }
            if (string2 == null || string2.equalsIgnoreCase(SYSTEM_DETERMINED)) {
                this.DOPPanel.setSystemDetermined();
            } else {
                this.DOPPanel.setDegreeValue(Integer.parseInt(string2));
            }
        }
    }

    public void updatePreferences() {
        this.PQPref.setViewDataProperty(VIEW_KEY, ParallelQueryPreferences.PROPERTY.IS_PARALLEL, Boolean.toString(this.isParallelEnable()));
        if (this.isSystemDetermined()) {
            this.PQPref.setViewDataProperty(VIEW_KEY, ParallelQueryPreferences.PROPERTY.VALUE, SYSTEM_DETERMINED);
        } else {
            String string = this.getDegreeValue();
            this.PQPref.setViewDataProperty(VIEW_KEY, ParallelQueryPreferences.PROPERTY.VALUE, string);
        }
    }

    public boolean isParallelEnable() {
        return this.cbParallel.isSelected();
    }

    public boolean isSystemDetermined() {
        return this.DOPPanel.isSystemDetermined();
    }

    public String getDegreeValue() {
        return this.DOPPanel.getDegreeValue();
    }

    @Override
    public void setParallelEnable(boolean bl) {
        this.cbParallel.setSelected(bl);
    }

    @Override
    public void setSystemDetermined() {
        this.DOPPanel.setSystemDetermined();
    }

    @Override
    public void setDegreeValue(int n) {
        this.DOPPanel.setDegreeValue(n);
    }

    public ParallelQueryPreferences getPQPreferences() {
        return this.PQPref;
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableAdapter(){

            @Override
            public String getTitle() {
                return ViewDataParallelPanel.this.title;
            }

            @Override
            public String getHelpTopic() {
                return "parallel_settings_dop";
            }

            @Override
            public JComponent getContent() {
                return ViewDataParallelPanel.this;
            }
        };
    }
}

