/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.ApplyChainNode;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.preferences.CacheSettingsPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SamplingSettingsType;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public final class SampleNode
extends AbstractTransformNode
implements DataConsumer,
ApplyChainNode {
    private static final Logger theLogger = Logger.getLogger(SampleNode.class.getName());
    public static final String SAMPLING_SETTINGS = "SamplingSettings";
    private TreeMap<String, Integer> _sourceStatisticMap = null;

    public SampleNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
        SampleNodeType sampleNodeType = (SampleNodeType)this.getData();
        if (sampleNodeType == null) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadResult() {
        try (SQLHelper sQLHelper = new SQLHelper();){
            SampleNodeType sampleNodeType = (SampleNodeType)this.getData();
            SampleNodeType.StatisticTable statisticTable = sampleNodeType.getStatisticTable();
            if (statisticTable != null) {
                this._sourceStatisticMap = new TreeMap();
                String string = statisticTable.getName();
                if (string != null) {
                    String string2 = "SELECT ATTRIBUTE_VALUE, COUNT FROM " + string + " ORDER BY ATTRIBUTE_VALUE";
                    sQLHelper.conn = ConnectionFolder.getConnection(this.getContext());
                    sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string2);
                    sQLHelper.pstmt.setFetchSize(100);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    String string3 = null;
                    Integer n = null;
                    while (sQLHelper.rs.next()) {
                        string3 = sQLHelper.rs.getString("ATTRIBUTE_VALUE");
                        n = sQLHelper.rs.getInt("COUNT");
                        this._sourceStatisticMap.put(string3, n);
                    }
                }
            }
        }
    }

    @Override
    protected void initNewInstance(Context context) {
        Number number;
        super.initNewInstance(context);
        SampleNodeType sampleNodeType = (SampleNodeType)this.getData();
        Preferences preferences = Preferences.getPreferences();
        CacheSettingsPanelSettings cacheSettingsPanelSettings = CacheSettingsPanelSettings.getInstance((PropertyStorage)preferences);
        SamplingSettingsType samplingSettingsType = new SamplingSettingsType();
        if (cacheSettingsPanelSettings.isPercent()) {
            number = cacheSettingsPanelSettings.getPercentValue();
            samplingSettingsType.setPercentOfTotal(number);
        } else {
            number = cacheSettingsPanelSettings.getNumberOfRows();
            samplingSettingsType.setNumberOfRows((Long)number);
        }
        number = new SamplingSettingsType.Method();
        if (cacheSettingsPanelSettings.isRandom()) {
            SamplingSettingsType.Method.Random random = new SamplingSettingsType.Method.Random();
            random.setSeed(BigInteger.valueOf(cacheSettingsPanelSettings.getSeed()));
            number.setRandom(random);
        } else {
            SamplingSettingsType.Method.TopN topN = new SamplingSettingsType.Method.TopN();
            number.setTopN(topN);
        }
        samplingSettingsType.setMethod((SamplingSettingsType.Method)number);
        sampleNodeType.setSamplingSettings(samplingSettingsType);
        sampleNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_SAMPLE_NODE_NAME");
    }

    @Override
    public Attributes getAttributes() {
        List<AbstractNode> list = this.findDataNodes();
        if (list.isEmpty()) {
            return new Attributes();
        }
        DataProvider dataProvider = (DataProvider)((Object)list.get(0));
        return dataProvider.getAttributes();
    }

    public List<AttributeType> getCaseAttributes() {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            DataProvider dataProvider = (DataProvider)((Object)abstractNode);
            for (AttributeType attributeType : dataProvider.getAttributes().getAttribute()) {
                if (!DatabaseMetadataUtils.isKeyDataTypeSupported(attributeType.getDataType())) continue;
                arrayList.add(attributeType);
            }
        }
        return arrayList;
    }

    @Override
    public boolean validate(boolean bl) {
        Object object;
        SamplingSettingsType.Method.Stratified stratified;
        Object object2;
        OdmrSDMUndoFilter odmrSDMUndoFilter2;
        boolean bl2 = super.validate(bl);
        SampleNodeType sampleNodeType = (SampleNodeType)this.getData();
        boolean bl3 = false;
        SamplingSettingsType samplingSettingsType = (SamplingSettingsType)MetaDataHelper.copyMetadataObject(sampleNodeType.getSamplingSettings());
        HashMap<CallSite, OdmrSDMUndoFilter> hashMap = new HashMap<CallSite, OdmrSDMUndoFilter>();
        List<AbstractNode> list = this.findDataNodes();
        for (AbstractNode object32 : list) {
            if (!(object32 instanceof DataProvider)) continue;
            for (OdmrSDMUndoFilter odmrSDMUndoFilter2 : ((DataProvider)((Object)object32)).getAttributes().getAttribute()) {
                object2 = odmrSDMUndoFilter2.getAlias();
                String string = (String)(object2 != null && ((String)object2).trim().length() > 0 ? object2 : odmrSDMUndoFilter2.getName()) + "." + odmrSDMUndoFilter2.getDataType();
                hashMap.put((CallSite)((Object)string), odmrSDMUndoFilter2);
            }
        }
        AttributeType attributeType = samplingSettingsType.getCaseAttribute();
        if (attributeType != null) {
            String string = attributeType.getName() + "." + attributeType.getDataType();
            if (!hashMap.containsKey(string)) {
                attributeType.setStatus(AttributeStatus.INVALID);
                this.addMessage("SAMPLE_INVAL_CASEID", MessageEnumType.WARNING, new String[0]);
                bl2 = false;
                bl3 = true;
            } else if (attributeType.getStatus().equals((Object)AttributeStatus.INVALID)) {
                attributeType.setStatus(AttributeStatus.VALID);
                bl3 = true;
            }
        }
        if ((stratified = samplingSettingsType.getMethod().getStratified()) != null) {
            object = stratified.getTargetAttr() + "." + stratified.getDataType();
            if (!hashMap.containsKey(object)) {
                stratified.setStatus(AttributeStatus.INVALID);
                this.addMessage("SAMPLE_INVAL_COLUMN", MessageEnumType.WARNING, new String[0]);
                bl2 = false;
                bl3 = true;
            } else if (stratified.getStatus().equals((Object)AttributeStatus.INVALID)) {
                stratified.setStatus(AttributeStatus.VALID);
                bl3 = true;
            }
        }
        object = new ArrayList();
        odmrSDMUndoFilter2 = (OdmrSDMUndoFilter)this.getUndoFilter();
        if (bl3) {
            object2 = new ComplexProperty(SAMPLING_SETTINGS, samplingSettingsType);
            ((ComplexProperty)object2).setOldData(sampleNodeType.getSamplingSettings());
            object.add(object2);
        }
        object2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        ((ComplexProperty)object2).setOldData(this.getSQLExpression());
        object.add(object2);
        odmrSDMUndoFilter2.prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)object);
        if (bl2) {
            bl2 = this.validateNode();
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    public boolean validateNode() {
        boolean bl = true;
        SampleNodeType sampleNodeType = (SampleNodeType)this.getData();
        List<AbstractNode> list = this.findDataNodes();
        if (list.size() < 1) {
            this.addMessage("SAMPLE_NO_DATA", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        if (sampleNodeType.getSamplingSettings().getMethod().getStratified() != null && sampleNodeType.getSamplingSettings().getMethod().getStratified().getTargetAttr() == null) {
            this.addMessage("SAMPLE_NO_COLUMN", MessageEnumType.ERROR, new String[0]);
            bl = false;
        }
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(true);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validateNodeRemoval(node, true);
    }

    public boolean validateNodeRemoval(Node node, boolean bl) {
        return this.validate(bl);
    }

    @Override
    public String generateSQLExpression() {
        StringBuffer stringBuffer = new StringBuffer(32000);
        StringBuffer stringBuffer2 = new StringBuffer(32000);
        SampleNodeType sampleNodeType = (SampleNodeType)this.getData();
        if (sampleNodeType.getStatus() == NodeStatusType.COMPLETE) {
            return sampleNodeType.getSQLExpression();
        }
        List<AbstractNode> list = this.findDataNodes();
        if (!list.isEmpty()) {
            DataProvider dataProvider = (DataProvider)((Object)list.get(0));
            for (AttributeType attributeType : dataProvider.getAttributes().getAttribute()) {
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(", ");
                }
                stringBuffer2.append("\"" + attributeType.getName() + "\"");
                if (attributeType.getAlias() == null) {
                    stringBuffer2.append("\n");
                    continue;
                }
                stringBuffer2.append(" \"" + attributeType.getAlias() + "\"\n");
            }
            stringBuffer.append("SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + "\n");
            stringBuffer.append(stringBuffer2 + "\n");
            stringBuffer.append("FROM {INPUT_SOURCE}\n");
        }
        return this.wrapExpressionInWithClause(stringBuffer.toString());
    }

    @Override
    public void setProperty(String string, Object object) {
        SampleNodeType sampleNodeType = (SampleNodeType)this.getData();
        if (string.equals(SAMPLING_SETTINGS)) {
            SamplingSettingsType samplingSettingsType = (SamplingSettingsType)object;
            sampleNodeType.setSamplingSettings(samplingSettingsType);
        } else if (string.equals("SQL_EXPRESSION")) {
            if (object != null && object.equals("SQL_EXPRESSION_GENERATE")) {
                sampleNodeType.setSQLExpression(this.generateSQLExpression());
            } else {
                sampleNodeType.setSQLExpression((String)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(SAMPLING_SETTINGS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public Object getProperty(String string) {
        SampleNodeType sampleNodeType = (SampleNodeType)this.getData();
        Object object = null;
        if (string.equals(SAMPLING_SETTINGS)) {
            object = sampleNodeType.getSamplingSettings();
        } else if (string.equals("SQL_EXPRESSION")) {
            object = this.getSQLExpression();
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    public List<AbstractNode> findDataNodes() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            arrayList.add(abstractNode);
        }
        return arrayList;
    }

    public TreeMap<String, Integer> getStatisticLookupMap() {
        if (this._sourceStatisticMap == null) {
            this.loadResult();
        }
        return this._sourceStatisticMap;
    }

    public TreeMap<String, Integer> getStratifiedSampledDistribution(Long l, Double d, boolean bl, SamplingSettingsType.Method.Stratified.Distributions distributions) {
        Integer n;
        String string;
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        if (this._sourceStatisticMap == null) {
            this.loadResult();
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        for (Map.Entry<String, Integer> object : this._sourceStatisticMap.entrySet()) {
            string = object.getKey();
            n = object.getValue();
            n2 += n.intValue();
            if (n < n4) {
                n4 = n;
            }
            ++n3;
            treeMap.put(string, 0);
        }
        if (distributions != null) {
            for (SamplingSettingsType.Method.Stratified.Distributions.Distribution distribution : distributions.getDistribution()) {
                string = distribution.getTargetValue();
                n = distribution.getCount().intValue();
                if (!this._sourceStatisticMap.containsKey(string)) continue;
                treeMap.put(string, n);
            }
        } else {
            for (Map.Entry<String, Integer> entry : this._sourceStatisticMap.entrySet()) {
                string = entry.getKey();
                n = entry.getValue();
                int n5 = 0;
                n5 = bl ? (l != null ? Math.min(n4, Math.max(1, (int)Math.round((double)n4 / (double)(n3 * n4) * (double)Math.min((long)n2, l)))) : Math.min(n4, Math.max(1, (int)Math.round((double)n4 / (double)(n3 * n4) * d / 100.0 * (double)n2)))) : (l != null ? Math.max(1, (int)Math.round((double)n.intValue() / (double)n2 * (double)Math.min((long)n2, l))) : Math.max(1, (int)Math.round((double)n.intValue() * d / 100.0)));
                treeMap.put(string, n5);
            }
        }
        return treeMap;
    }

    @Override
    public String getHelpTopic() {
        return "sample_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_SAMPLE_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_SAMPLE_ICON"));
    }

    @Override
    public void refactorForApply() {
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        OdmrSDMUndoFilter odmrSDMUndoFilter;
        String string;
        String string2;
        SamplingSettingsType.Method.Stratified stratified;
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        SampleNodeType sampleNodeType = (SampleNodeType)this.getData();
        SamplingSettingsType samplingSettingsType = sampleNodeType.getSamplingSettings();
        SamplingSettingsType samplingSettingsType2 = (SamplingSettingsType)MetaDataHelper.copyMetadataObject(samplingSettingsType);
        AttributeType attributeType = samplingSettingsType.getCaseAttribute();
        if (!(attributeType == null || (stratified = map.get(attributeType.getName())) == null || attributeType.getName().equals(stratified.getName()) && attributeType.getDataType().equals(stratified.getDataType()))) {
            string2 = attributeType.getName();
            samplingSettingsType2.getCaseAttribute().setName(stratified.getName());
            samplingSettingsType2.getCaseAttribute().setDataType(stratified.getDataType());
            string = samplingSettingsType2.getCaseAttribute();
            hashMap.put(string2, (AttributeType)string);
        }
        stratified = samplingSettingsType.getMethod().getStratified();
        string2 = null;
        string = null;
        if (stratified != null) {
            string2 = stratified.getTargetAttr();
            string = stratified.getDataType();
            odmrSDMUndoFilter = map.get(string2);
            if (!(odmrSDMUndoFilter == null || string2.equals(odmrSDMUndoFilter.getName()) && string.equals(odmrSDMUndoFilter.getDataType()))) {
                String string3 = string2;
                samplingSettingsType2.getMethod().getStratified().setTargetAttr(odmrSDMUndoFilter.getName());
                samplingSettingsType2.getMethod().getStratified().setDataType(odmrSDMUndoFilter.getDataType());
                AttributeType attributeType2 = new AttributeType();
                attributeType2.setDataType(odmrSDMUndoFilter.getDataType());
                attributeType2.setName(odmrSDMUndoFilter.getName());
                attributeType2.setStatus(AttributeStatus.VALID);
                hashMap.put(string3, attributeType2);
            }
        }
        if (!hashMap.isEmpty()) {
            odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), SAMPLING_SETTINGS, samplingSettingsType2);
            this.refactorChildrenAttributes(this, hashMap);
        }
    }
}

