/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.r;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.ExtensibleBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ExtensibleBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.model.Element;

public class RBuildPIComponentHelper {
    public static Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return null;
        }
        WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = (WorkflowNodePropertyProxyModel)propertyModel;
        Context context = workflowNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    public static AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return null;
        }
        AbstractBuildNode abstractBuildNode = null;
        WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = (WorkflowNodePropertyProxyModel)propertyModel;
        Context context = workflowNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof BuildNodeType) {
            abstractBuildNode = (AbstractBuildNode)workflowNodeInspectorElement.getNode();
        }
        return abstractBuildNode;
    }

    public static boolean isWritable(PropertyModel propertyModel) {
        Context context = RBuildPIComponentHelper.getContext(propertyModel);
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        Workflow workflow = (Workflow)workflowNode.getRepositoryData();
        boolean bl = !workflow.isReadOnly();
        return bl;
    }

    public static boolean getMaps(PropertyModel propertyModel, Map<String, ModelStatusType> map, Map<String, ModelStatusType> map2) {
        ExtensibleBuildNode extensibleBuildNode = (ExtensibleBuildNode)RBuildPIComponentHelper.getTargetNode(propertyModel);
        if (extensibleBuildNode == null) {
            return false;
        }
        List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)extensibleBuildNode.getData());
        for (ModelType modelType : list) {
            map.put(modelType.getId(), ModelStatusType.READY);
        }
        if (extensibleBuildNode.isSupervisedBuildNode()) {
            ModelType modelType;
            ArrayList arrayList = new ArrayList();
            modelType = (ExtensibleBuildNodeType)extensibleBuildNode.getData();
            if (extensibleBuildNode.isRegression()) {
                arrayList.addAll(modelType.getResults().getRegressionResult());
            } else if (extensibleBuildNode.isClassification()) {
                arrayList.addAll(modelType.getResults().getClassificationResult());
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                MiningResultType miningResultType = (MiningResultType)iterator.next();
                if (map.get(miningResultType.getModelId()) == null) continue;
                map2.put(miningResultType.getModelId(), ModelStatusType.READY);
            }
        }
        return true;
    }
}

