/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.columnFilter;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableAdapter;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.cf.GetDependencyCountQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.cf.GetDependencyQuery;
import oracle.dmt.dataminer.core.model.cf.AttributeDependency;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.utils.Strings;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.utils.Formats;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.UITools;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.ADSettingsPreferences;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.DependencyExplorerTableModel;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.DialogsLrb;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;

public class DependencyExplorerPanel
extends JPanel
implements DialogDisplayable {
    private static final ADSettingsPreferences preferences = ADSettingsPreferences.getInstance();
    private DependencyExplorerTableModel tableModel = new DependencyExplorerTableModel();
    private BlockingComponent blockingComponent;
    private ConnectionManager connectionManager;
    private String attrDependencyOutput;
    private List<String> attributeNames;
    private String selectedAttributeName;
    private ButtonGroup buttonGroup1;
    private DataMinerTablePanel dataMinerTablePanel1;
    private JLabel jAttributeLabel;
    private JComboBox jComboAttribute;
    private JLabel jFetchSizeLabel;
    private JSpinner jFetchSizeSpinner;
    private JButton jQueryButton;
    private JRadioButton jRadioButtonAscending;
    private JRadioButton jRadioButtonDescending;
    private JLabel jSortLabel;

    public DependencyExplorerPanel(Context context, List<String> list, String string, String string2) {
        this.connectionManager = ConnectionFolder.getConnectionFolder(context);
        this.attrDependencyOutput = string;
        this.attributeNames = list;
        this.selectedAttributeName = string2;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jFetchSizeLabel = new JLabel();
        this.jFetchSizeSpinner = new JSpinner();
        this.jQueryButton = new JButton();
        this.dataMinerTablePanel1 = new DataMinerTablePanel();
        this.jComboAttribute = new JComboBox();
        this.jRadioButtonAscending = new JRadioButton();
        this.jAttributeLabel = new JLabel();
        this.jRadioButtonDescending = new JRadioButton();
        this.jSortLabel = new JLabel();
        this.jFetchSizeSpinner.setModel(new SpinnerNumberModel((Number)100, Integer.valueOf(0), null, (Number)10));
        this.buttonGroup1.add(this.jRadioButtonAscending);
        this.buttonGroup1.add(this.jRadioButtonDescending);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel1, -1, 641, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addComponent(this.jAttributeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboAttribute, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jSortLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonAscending).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonDescending))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jFetchSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFetchSizeSpinner, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jQueryButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jAttributeLabel).addComponent(this.jFetchSizeLabel).addComponent(this.jFetchSizeSpinner, -2, -1, -2).addComponent(this.jQueryButton).addComponent(this.jComboAttribute, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonAscending).addComponent(this.jRadioButtonDescending).addComponent(this.jSortLabel)).addGap(7, 7, 7).addComponent(this.dataMinerTablePanel1, -1, 271, Short.MAX_VALUE).addContainerGap()));
    }

    public void initUI() {
        this.jRadioButtonDescending.setSelected(true);
        Vector<String> vector = new Vector<String>();
        vector.add(DialogsLrb.get("ALL_COLUMNS"));
        vector.addAll(this.attributeNames);
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(vector);
        this.jComboAttribute.setModel(defaultComboBoxModel);
        if (this.selectedAttributeName.isEmpty()) {
            this.jComboAttribute.setSelectedIndex(0);
        } else {
            this.jComboAttribute.setSelectedItem(this.selectedAttributeName);
        }
        String[] stringArray = new String[]{DialogsLrb.get("AD_EXPLORER_TABLE_COL_NAME_1"), DialogsLrb.get("AD_EXPLORER_TABLE_COL_NAME_2")};
        this.dataMinerTablePanel1.setup((TableModel)((Object)this.tableModel), DialogsLrb.get("AD_EXPLORER_TABLE_TITLE"), stringArray, 0);
        NumberFormat numberFormat = Formats.ModelViewer.getPercentage();
        TableColumn tableColumn = this.dataMinerTablePanel1.getTable().getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new HistogramBarRenderer(1.0, true, numberFormat));
        this.dataMinerTablePanel1.getTable().setColumnSelectorAvailable(true);
        this.dataMinerTablePanel1.getTable().setUpdateSelectionOnSort(true);
        this.dataMinerTablePanel1.getTable().setRowSelectionAllowed(true);
    }

    public void initRes() {
        this.jFetchSizeSpinner.setValue(preferences.getExplorerDependencyFetchSizeValue());
        ResourceUtils.resLabel((JLabel)this.jFetchSizeLabel, (Component)this.jFetchSizeSpinner, (String)ControlsLrb.get("FILTER_FETCH_SIZE"));
        ResourceUtils.resButton((AbstractButton)this.jRadioButtonAscending, (String)SortDirection.ASCENDING.toString());
        ResourceUtils.resButton((AbstractButton)this.jRadioButtonDescending, (String)SortDirection.DESCENDING.toString());
        this.jComboAttribute.addActionListener(new ComboAttributeListener());
        this.jAttributeLabel.setText(DialogsLrb.get("AD_EXPLORER_ATTRIBUTE_FILTER"));
        this.jSortLabel.setText(CommonLrb.get("SORT_BY") + Strings.SEPARATOR + DialogsLrb.get("DEPENDENCY") + ":");
        ResourceUtils.resButton((AbstractButton)this.jQueryButton, (String)CommonLrb.get("QUERY"));
        this.jQueryButton.setIcon(OracleIcons.getIcon((String)"run.png"));
        this.jQueryButton.addActionListener(new QueryButtonListener());
    }

    public void loadDependency(String string, int n, SortDirection sortDirection, boolean bl) {
        LoadDependency loadDependency = new LoadDependency(string, n, sortDirection, bl);
        loadDependency.execute();
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableAdapter(){

            @Override
            public String getTitle() {
                return DialogsLrb.get("DEPENDENCY_EXPLORER");
            }

            @Override
            public String getHelpTopic() {
                return "explore_dependencies";
            }

            @Override
            public JComponent getContent() {
                DependencyExplorerPanel.this.blockingComponent = new BlockingComponent((JComponent)DependencyExplorerPanel.this);
                return DependencyExplorerPanel.this.blockingComponent.getBlockingComponent();
            }

            @Override
            public int getButtonMask() {
                return 20;
            }
        };
    }

    private class ComboAttributeListener
    implements ActionListener {
        private ComboAttributeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SortDirection sortDirection;
            String string = DependencyExplorerPanel.this.jComboAttribute.getSelectedItem().toString();
            SortDirection sortDirection2 = sortDirection = DependencyExplorerPanel.this.jRadioButtonDescending.isSelected() ? SortDirection.DESCENDING : SortDirection.ASCENDING;
            if (string.equals(DialogsLrb.get("ALL_COLUMNS"))) {
                DependencyExplorerPanel.this.loadDependency(null, (Integer)DependencyExplorerPanel.this.jFetchSizeSpinner.getValue(), sortDirection, true);
            } else {
                DependencyExplorerPanel.this.loadDependency(string, (Integer)DependencyExplorerPanel.this.jFetchSizeSpinner.getValue(), sortDirection, false);
            }
        }
    }

    private class QueryButtonListener
    implements ActionListener {
        private QueryButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SortDirection sortDirection;
            String string = DependencyExplorerPanel.this.jComboAttribute.getSelectedItem().toString();
            SortDirection sortDirection2 = sortDirection = DependencyExplorerPanel.this.jRadioButtonDescending.isSelected() ? SortDirection.DESCENDING : SortDirection.ASCENDING;
            if (DialogsLrb.get("ALL_COLUMNS").equals(string)) {
                DependencyExplorerPanel.this.loadDependency(null, (Integer)DependencyExplorerPanel.this.jFetchSizeSpinner.getValue(), sortDirection, true);
            } else {
                DependencyExplorerPanel.this.loadDependency(string, (Integer)DependencyExplorerPanel.this.jFetchSizeSpinner.getValue(), sortDirection, false);
            }
            preferences.setExplorerDependencyFetchSizeValue((Integer)DependencyExplorerPanel.this.jFetchSizeSpinner.getValue());
        }
    }

    private class LoadDependency
    extends ODMrSwingWorker<List<AttributeDependency>, Void> {
        private int rows;
        private int totalFound;
        private boolean showAllColumns;
        private String attributeName;
        private SortDirection sort;
        private SqlDataAccessObject dao;

        public LoadDependency(String string, int n, SortDirection sortDirection, boolean bl) {
            super(DependencyExplorerPanel.this, DependencyExplorerPanel.this.blockingComponent, DependencyExplorerPanel.this.dataMinerTablePanel1.getTable());
            this.attributeName = string;
            this.rows = n;
            this.sort = sortDirection;
            this.showAllColumns = bl;
            this.dao = new SqlDataAccessObject(DependencyExplorerPanel.this.connectionManager);
        }

        @Override
        protected List<AttributeDependency> doInBackground() throws Exception {
            GetDependencyQuery getDependencyQuery = new GetDependencyQuery(DependencyExplorerPanel.this.connectionManager.getDbVersion(), DependencyExplorerPanel.this.attrDependencyOutput, this.attributeName, this.rows, this.sort, this.showAllColumns);
            List list = this.dao.readItems((Query)getDependencyQuery);
            GetDependencyCountQuery getDependencyCountQuery = new GetDependencyCountQuery(DependencyExplorerPanel.this.connectionManager.getDbVersion(), DependencyExplorerPanel.this.attrDependencyOutput, this.attributeName);
            this.totalFound = this.dao.readItem((Query)getDependencyCountQuery).orElse(0);
            return list;
        }

        @Override
        protected void onSuccess(List<AttributeDependency> list) throws Exception {
            TableColumn tableColumn;
            NumberFormat numberFormat = Formats.ModelViewer.getPercentage();
            DependencyExplorerPanel.this.tableModel.setShowAllColumns(this.showAllColumns);
            if (this.showAllColumns) {
                DependencyExplorerPanel.this.tableModel.setColumnIdentifiers(DependencyExplorerTableModel.ALL_COLUMNS);
                tableColumn = DependencyExplorerPanel.this.dataMinerTablePanel1.getTable().getColumnModel().getColumn(2);
            } else {
                DependencyExplorerPanel.this.tableModel.setColumnIdentifiers(DependencyExplorerTableModel.ATTRIBUTE2_DEPENDENCY_COLUMNS);
                tableColumn = DependencyExplorerPanel.this.dataMinerTablePanel1.getTable().getColumnModel().getColumn(1);
            }
            tableColumn.setCellRenderer(new HistogramBarRenderer(1.0, true, numberFormat));
            UITools.setTableModelData(DependencyExplorerPanel.this.dataMinerTablePanel1.getTable(), list);
            DependencyExplorerPanel.this.dataMinerTablePanel1.setTitle(DialogsLrb.format("DEPENDENCIES_DETAIL_TABLE", list.size(), this.totalFound));
        }
    }
}

