/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.extensible.r;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.core.model.extensible.r.RFunction;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.extensible.r.BuildSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.extensible.r.FunctionSelectionPanel;
import oracle.dmt.dataminer.workflow.model.RBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSettingODMType;
import oracle.dmt.dataminer.workflow.xmlschema.RModelType;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;

public class BuildFunctionSelectionPanel
extends FunctionSelectionPanel {
    private RModelType.BuildFunctions functions = new RModelType.BuildFunctions();
    private DefaultComboBoxModel<RFunction> modelA;
    private JCheckBox includeAllSchemasCheckBox;
    private JComboBox<RFunction> jBuildChoice;
    private JTextArea jBuildDefinition;
    private JLabel jBuildDefinitionLabel;
    private JLabel jBuildLabel;
    private JScrollPane jScrollPane1;
    private JButton jSettingsButton;

    public BuildFunctionSelectionPanel(Context context, RBuildNode rBuildNode, RModelType.BuildFunctions buildFunctions) {
        super(context, rBuildNode);
        if (buildFunctions != null) {
            this.cloneBuildFunctions(buildFunctions, this.functions);
        }
        this.determineUseOtherSchemas(this.functions.getPrimaryFunction());
        this.initializeComponents();
        this.initRes();
        this.initUI();
    }

    private void cloneBuildFunctions(RModelType.BuildFunctions buildFunctions, RModelType.BuildFunctions buildFunctions2) {
        buildFunctions2.setPrimaryFunction(buildFunctions.getPrimaryFunction());
        RModelType.BuildFunctions.Settings settings = new RModelType.BuildFunctions.Settings();
        if (buildFunctions.getSettings() != null) {
            settings.setRowWeightColumn(buildFunctions.getSettings().getRowWeightColumn());
            List list = settings.getModelSettingODM();
            buildFunctions.getSettings().getModelSettingODM().forEach(modelSettingODMType -> {
                ModelSettingODMType modelSettingODMType2 = new ModelSettingODMType();
                modelSettingODMType2.setName(modelSettingODMType.getName());
                modelSettingODMType2.setValue(modelSettingODMType.getValue());
                modelSettingODMType2.setType(modelSettingODMType.getType());
                list.add(modelSettingODMType2);
            });
        }
        buildFunctions2.setSettings(settings);
    }

    private void initComponents() {
        this.jBuildLabel = new JLabel();
        this.jBuildChoice = new JComboBox();
        this.jBuildDefinitionLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jBuildDefinition = new JTextArea();
        this.jSettingsButton = new JButton();
        this.includeAllSchemasCheckBox = new JCheckBox();
        this.jBuildLabel.setText("Build Function:");
        this.jBuildDefinitionLabel.setText("Function Definition:");
        this.jBuildDefinition.setColumns(20);
        this.jBuildDefinition.setRows(5);
        this.jScrollPane1.setViewportView(this.jBuildDefinition);
        this.jSettingsButton.setText("Settings...");
        this.includeAllSchemasCheckBox.setText("Include Other Schemas");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jBuildLabel).addComponent(this.jBuildChoice, -2, 300, -2).addComponent(this.jBuildDefinitionLabel)).addGap(116, 116, 116)).addGroup(groupLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.includeAllSchemasCheckBox).addComponent(this.jSettingsButton)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.includeAllSchemasCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBuildLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBuildChoice, -2, -1, -2).addGap(25, 25, 25).addComponent(this.jBuildDefinitionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 102, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSettingsButton).addContainerGap()));
    }

    @Override
    protected void initializeComponents() {
        this.initComponents();
    }

    @Override
    protected void initRes() {
        ResourceUtils.resLabel((JLabel)this.jBuildLabel, this.jBuildChoice, (String)StringUtils.addColon((String)BuildEditorLrb.get("R_BUILD_FUNCTION")));
        ResourceUtils.resLabel((JLabel)this.jBuildDefinitionLabel, (Component)this.jBuildDefinition, (String)StringUtils.addColon((String)BuildEditorLrb.get("R_FUNCTION_DEFINITION")));
        ResourceUtils.resButton((AbstractButton)this.includeAllSchemasCheckBox, (String)BuildEditorLrb.get("R_FUNCTIONS_ALL_SCHEMAS"));
        ResourceUtils.resButton((AbstractButton)this.jSettingsButton, (String)CommonLrb.get("SETTINGS"));
    }

    @Override
    protected void initUI() {
        this.modelA = new DefaultComboBoxModel();
        this.jBuildChoice.setModel(this.modelA);
        this.jBuildChoice.setRenderer(new FunctionSelectionPanel.QualifiedFunctionRenderer(this));
        this.jBuildDefinition.setEditable(false);
        this.includeAllSchemasCheckBox.setSelected(this.isUsingOtherSchemas());
    }

    @Override
    protected void afterSuccess() {
        this.populateComboModels(this.modelA);
        String string = this.functions.getPrimaryFunction();
        this.addActionListeners();
        this.setSelectedFunctionsFromMetaData(string);
    }

    private void addActionListeners() {
        this.jBuildChoice.addActionListener(new BuildFunctionChangeListener(this.modelA, this.jBuildDefinition));
        this.jSettingsButton.addActionListener(new BuildSettingsDialogListener());
        this.includeAllSchemasCheckBox.addActionListener(new BuildFunctionAllSchemaListener());
    }

    private void setSelectedFunctionsFromMetaData(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            this.setSelectedFunction(this.modelA, string);
        }
    }

    @Override
    protected void afterReloadSuccess() {
        this.populateComboModels(this.modelA);
        this.isReloading = false;
        String string = this.functions.getPrimaryFunction();
        this.setSelectedFunctionsFromMetaData(string);
    }

    @Override
    public String getWindowTitle() {
        return BuildEditorLrb.get("R_BUILD_FUNCTION");
    }

    @Override
    public String getWindowHelpTopic() {
        return "r_build_function";
    }

    @Override
    protected boolean validateForm() {
        return StringUtils.isNotEmpty((String)this.functions.getPrimaryFunction());
    }

    @Override
    protected String getValidationErrorMessage() {
        return BuildEditorLrb.get("R_INVALID_BUILD_FUNCTION");
    }

    @Override
    protected void cleanUp() {
        this.functions.setSettings(null);
        this.functions = null;
    }

    private RModelType.BuildFunctions getBuildFunctions() {
        return this.functions;
    }

    public static Optional<RModelType.BuildFunctions> addBuildFunctions(Context context, RBuildNode rBuildNode, RModelType.BuildFunctions buildFunctions) {
        RModelType.BuildFunctions buildFunctions2 = null;
        BuildFunctionSelectionPanel buildFunctionSelectionPanel = new BuildFunctionSelectionPanel(context, rBuildNode, buildFunctions);
        buildFunctionSelectionPanel.load();
        DialogHelper dialogHelper = new DialogHelper(buildFunctionSelectionPanel);
        if (dialogHelper.showAsDialog()) {
            buildFunctions2 = buildFunctionSelectionPanel.getBuildFunctions();
        }
        return Optional.ofNullable(buildFunctions2);
    }

    @Override
    protected void afterFailure() {
        this.modelA = new DefaultComboBoxModel();
        this.modelA.addElement(DEFAULT_OPTION);
        this.jBuildChoice.setModel(this.modelA);
        this.jBuildChoice.setEnabled(false);
    }

    private class BuildFunctionChangeListener
    extends FunctionSelectionPanel.FunctionChangeListener {
        private BuildFunctionChangeListener(DefaultComboBoxModel<RFunction> defaultComboBoxModel, JTextArea jTextArea) {
            super(BuildFunctionSelectionPanel.this, defaultComboBoxModel, jTextArea);
        }

        @Override
        protected void updateMetaData(String string) {
            BuildFunctionSelectionPanel.this.functions.setPrimaryFunction(string);
        }
    }

    private class BuildSettingsDialogListener
    implements ActionListener {
        private BuildSettingsDialogListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RModelType.BuildFunctions.Settings settings = BuildSettingsPanel.addBuildSettings(BuildFunctionSelectionPanel.this.node, BuildFunctionSelectionPanel.this.functions);
            if (settings != null) {
                BuildFunctionSelectionPanel.this.functions.setSettings(settings);
            }
        }
    }

    private class BuildFunctionAllSchemaListener
    extends FunctionSelectionPanel.QueryAllSchemasListener {
        private BuildFunctionAllSchemaListener() {
            super(BuildFunctionSelectionPanel.this);
        }

        @Override
        protected void updateMetaData() {
            RFunction rFunction = (RFunction)BuildFunctionSelectionPanel.this.modelA.getSelectedItem();
            String string = rFunction.getQualifiedName();
            BuildFunctionSelectionPanel.this.functions.setPrimaryFunction(string);
        }
    }
}

