/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ModelEMBuildDataPrepAnalysisPanel;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.Version;

public class ModelEMBuildSettingsPanel
extends AbstractPropertiesPanel {
    private Version _dbVersion = null;
    private boolean isModelPartitioned = false;
    private static final String SYSTEM_DETERMINED = AlgSettingsLrb.get("SYSTEM_DETERMINED");
    private HashMap<String, Object> cacheSettings = new HashMap();
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JComboBox cboLevelOfDetails;
    private JComboBox cboModelSearch;
    private JComboBox cboRemoveSmallComponents;
    private JComboBox jApproximateComputationComboBox;
    private JLabel jApproximateComputationLabel;
    private JRadioButton jClustSystemDeterminedButton;
    private JRadioButton jClustUserSpecifiedButton;
    private JTextField jClustUserSpecifiedTextField;
    private JRadioButton jCompSystemDeterminedButton;
    private JRadioButton jCompUserSpecifiedButton;
    private JTextField jCompUserSpecifiedTextField;
    private JLabel jComponentClusterThresholdLabel;
    private JTextField jComponentClusterThresholdTextField;
    private JCheckBox jComponentClusteringCheckBox;
    private JComboBox jConvergenceCriterionComboBox;
    private JLabel jConvergenceCriterionLabel;
    private JButton jDataPreparationAnalysisButton;
    private JLabel jDataPreparationAnalysisLabel;
    private JCheckBox jGatherClusterStatisticsCheckBox;
    private JComboBox jLinkageFunctionComboBox;
    private JLabel jLinkageFunctionLabel;
    private JLabel jLogLikelihoodImprovementLabel;
    private JTextField jLogLikelihoodImprovementTextField;
    private JLabel jMaxNumOfIterationsLabel;
    private JTextField jMaxNumOfIterationsTextField;
    private JLabel jMinPercentOfAttributeRuleSupportLabel;
    private JTextField jMinPercentOfAttributeRuleSupportTextField;
    private JLabel jNumOfClustersLabel;
    private JLabel jNumberOfComponentsLabel;
    private JComboBox jNumericalDistributionComboBox;
    private JLabel jNumericalDistributionLabel;
    private JLabel lblLevelOfDetails;
    private JLabel lblModelSearch;
    private JLabel lblRandomSeed;
    private JLabel lblRemoveSmallComponents;
    private JTextField txtRandomSeed;

    public ModelEMBuildSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        this._dbVersion = ConnectionFolder.getConnectionFolder(advancedSettingsPanel.getContext()).getDbVersion();
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        PartitionExpressions partitionExpressions = commonSettingDataObject.getParentPanel().getMetadataCopy().getPartitionExpressions();
        if (partitionExpressions != null && partitionExpressions.getPartitionExpression() != null && partitionExpressions.getPartitionExpression().size() > 0) {
            this.isModelPartitioned = true;
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public int getMaxIterationsValue() {
        int n = 20;
        if (DbVersionHelper.isDB11204Up((Version)this._dbVersion)) {
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jNumOfClustersLabel, null, (String)AlgSettingsLrb.get("CLUS_NUM_CLUSTERS"));
        ResourceUtils.resButton((AbstractButton)this.jClustSystemDeterminedButton, (String)AlgSettingsLrb.get("EMCS_SYSTEM_DETERMINED"));
        ResourceUtils.resButton((AbstractButton)this.jClustUserSpecifiedButton, (String)AlgSettingsLrb.get("EMCS_USER_SPECIFIED"));
        ResourceUtils.resButton((AbstractButton)this.jComponentClusteringCheckBox, (String)AlgSettingsLrb.get("EMCS_CLUSTER_COMPONENTS"));
        ResourceUtils.resLabel((JLabel)this.jComponentClusterThresholdLabel, (Component)this.jComponentClusterThresholdTextField, (String)AlgSettingsLrb.get("EMCS_CLUSTER_THRESH"));
        ResourceUtils.resLabel((JLabel)this.jLinkageFunctionLabel, (Component)this.jLinkageFunctionComboBox, (String)AlgSettingsLrb.get("EMCS_LINKAGE_FUNCTION"));
        if (DbVersionHelper.isDB122Up((Version)this._dbVersion)) {
            ResourceUtils.resLabel((JLabel)this.lblLevelOfDetails, (Component)this.cboLevelOfDetails, (String)AlgSettingsLrb.get("LEVEL_DETAILS"));
            ResourceUtils.resLabel((JLabel)this.lblRandomSeed, (Component)this.txtRandomSeed, (String)AlgSettingsLrb.get("EMCS_RANDOM_SEED"));
            ResourceUtils.resLabel((JLabel)this.lblModelSearch, (Component)this.cboModelSearch, (String)AlgSettingsLrb.get("EMCS_MODEL_SEARCH"));
            ResourceUtils.resLabel((JLabel)this.lblRemoveSmallComponents, (Component)this.cboRemoveSmallComponents, (String)AlgSettingsLrb.get("EMCS_REMOVE_COMPONENTS"));
        } else {
            ResourceUtils.resLabel((JLabel)this.jApproximateComputationLabel, (Component)this.jApproximateComputationComboBox, (String)AlgSettingsLrb.get("EMCS_APPROXIMATE_COMPUTATION"));
            ResourceUtils.resLabel((JLabel)this.lblLevelOfDetails, (Component)this.cboLevelOfDetails, (String)AlgSettingsLrb.get("EMCS_CLUSTER_STATISTICS"));
            ResourceUtils.resButton((AbstractButton)this.jGatherClusterStatisticsCheckBox, (String)AlgSettingsLrb.get("EMCS_CLUSTER_STATISTICS"));
        }
        ResourceUtils.resLabel((JLabel)this.jNumberOfComponentsLabel, null, (String)AlgSettingsLrb.get("EMCS_NUM_COMPONENTS"));
        ResourceUtils.resButton((AbstractButton)this.jCompSystemDeterminedButton, (String)AlgSettingsLrb.get("EMCS_SYSTEM_DETERMINED"));
        ResourceUtils.resButton((AbstractButton)this.jCompUserSpecifiedButton, (String)AlgSettingsLrb.get("EMCS_USER_SPECIFIED"));
        ResourceUtils.resLabel((JLabel)this.jMaxNumOfIterationsLabel, (Component)this.jMaxNumOfIterationsTextField, (String)AlgSettingsLrb.get("EMCS_NUM_ITERATIONS"));
        ResourceUtils.resLabel((JLabel)this.jLogLikelihoodImprovementLabel, (Component)this.jLogLikelihoodImprovementTextField, (String)AlgSettingsLrb.get("EMCS_LOGLIKE_IMPROVEMENT"));
        ResourceUtils.resLabel((JLabel)this.jConvergenceCriterionLabel, (Component)this.jConvergenceCriterionComboBox, (String)AlgSettingsLrb.get("EMCS_CONVERGENCE_CRITERION"));
        ResourceUtils.resLabel((JLabel)this.jNumericalDistributionLabel, (Component)this.jNumericalDistributionComboBox, (String)AlgSettingsLrb.get("EMCS_NUM_DISTRIBUTION"));
        ResourceUtils.resLabel((JLabel)this.jMinPercentOfAttributeRuleSupportLabel, (Component)this.jMinPercentOfAttributeRuleSupportTextField, (String)AlgSettingsLrb.get("EMCS_MIN_PCT_ATTR_SUPPORT"));
        ResourceUtils.resLabel((JLabel)this.jDataPreparationAnalysisLabel, (Component)this.jDataPreparationAnalysisButton, (String)AlgSettingsLrb.get("EMCS_DATA_PREP_ANALYSIS"));
        ResourceUtils.resButton((AbstractButton)this.jDataPreparationAnalysisButton, (String)AlgSettingsLrb.get("EMCS_DATA_PREP_ANALYSIS_SETTING"));
    }

    private void initUI() {
        DefaultComboBoxModel<String> defaultComboBoxModel;
        Object object;
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        this.cacheSettings.clear();
        this.jClustUserSpecifiedTextField.setToolTipText(AlgSettingsLrb.get("CLUS_NUM_CLUSTERS_TOOLTIP"));
        this.setDataType(this.jClustUserSpecifiedTextField, Integer.class);
        this.setSigned(this.jClustUserSpecifiedTextField, false);
        this.setLocale(this.jClustUserSpecifiedTextField, commonSettingDataObject.getLocale());
        Number number = commonSettingDataObject.getModelSettingNumValue("CLUS_NUM_CLUSTERS");
        commonSettingDataObject.setBackupValue("CLUS_NUM_CLUSTERS", number);
        this.jClustSystemDeterminedButton.setEnabled(true);
        this.jClustUserSpecifiedButton.setEnabled(true);
        if (number != null) {
            this.jClustUserSpecifiedButton.setSelected(true);
            this.setNumber(this.jClustUserSpecifiedTextField, number);
        } else {
            this.jClustSystemDeterminedButton.setSelected(true);
        }
        this.jComponentClusterThresholdTextField.setToolTipText(AlgSettingsLrb.get("EMCS_CLUSTER_THRESH_TOOLTIP"));
        this.setDataType(this.jComponentClusterThresholdTextField, Double.class);
        ((NumberTextField)this.jComponentClusterThresholdTextField).setDecimal(true, 4);
        this.setSigned(this.jComponentClusterThresholdTextField, false);
        this.setLocale(this.jComponentClusterThresholdTextField, commonSettingDataObject.getLocale());
        String string = commonSettingDataObject.getModelSettingStringValue("EMCS_CLUSTER_COMPONENTS");
        commonSettingDataObject.setBackupValue("EMCS_CLUSTER_COMPONENTS", string);
        boolean bl = string.equals("EMCS_CLUSTER_COMP_ENABLE");
        this.jComponentClusteringCheckBox.setSelected(bl);
        if (bl) {
            number = commonSettingDataObject.getModelSettingNumValue("EMCS_CLUSTER_THRESH");
            commonSettingDataObject.setBackupValue("EMCS_CLUSTER_THRESH", number);
            if (number != null) {
                ((NumberTextField)this.jComponentClusterThresholdTextField).setNumber(number);
            } else {
                ((NumberTextField)this.jComponentClusterThresholdTextField).setNumber((Number)2.0);
            }
        }
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>(new String[]{ServerConstants.ClusteringSetings.toHuman((String)"EMCS_LINKAGE_SINGLE"), ServerConstants.ClusteringSetings.toHuman((String)"EMCS_LINKAGE_AVERAGE"), ServerConstants.ClusteringSetings.toHuman((String)"EMCS_LINKAGE_COMPLETE")});
        this.jLinkageFunctionComboBox.setModel(defaultComboBoxModel2);
        string = commonSettingDataObject.getModelSettingStringValue("EMCS_LINKAGE_FUNCTION");
        commonSettingDataObject.setBackupValue("EMCS_LINKAGE_FUNCTION", string);
        if (string.isEmpty()) {
            string = "EMCS_LINKAGE_SINGLE";
        }
        this.jLinkageFunctionComboBox.setSelectedItem(ServerConstants.ClusteringSetings.toHuman((String)string));
        this.jLinkageFunctionLabel.setLabelFor(this.jLinkageFunctionComboBox);
        if (DbVersionHelper.isDB122Up((Version)this._dbVersion)) {
            this.jApproximateComputationLabel.setVisible(false);
            this.jApproximateComputationComboBox.setVisible(false);
            var6_6 = AlgSettingsLrb.get("EMCS_RANDOM_SEED_TOOLTIP");
            this.txtRandomSeed.setToolTipText((String)var6_6);
            this.setDataType(this.txtRandomSeed, Integer.class);
            this.setSigned(this.txtRandomSeed, false);
            this.setLocale(this.txtRandomSeed, commonSettingDataObject.getLocale());
            number = commonSettingDataObject.getModelSettingNumValue("EMCS_RANDOM_SEED");
            if (number == null) {
                number = 0;
            }
            commonSettingDataObject.setBackupValue("EMCS_RANDOM_SEED", number);
            ((NumberTextField)this.txtRandomSeed).setNumber(number);
            object = new DefaultComboBoxModel<String>(new String[]{ServerConstants.ClusteringSetings.toHuman((String)"EMCS_MODEL_SEARCH_ENABLE"), ServerConstants.ClusteringSetings.toHuman((String)"EMCS_MODEL_SEARCH_DISABLE")});
            this.cboModelSearch.setModel(object);
            string = commonSettingDataObject.getModelSettingStringValue("EMCS_MODEL_SEARCH");
            commonSettingDataObject.setBackupValue("EMCS_MODEL_SEARCH", string);
            if (string.equals("EMCS_MODEL_SEARCH_ENABLE")) {
                this.cboModelSearch.setSelectedIndex(0);
            } else {
                this.cboModelSearch.setSelectedIndex(1);
            }
            this.lblModelSearch.setLabelFor(this.cboModelSearch);
            defaultComboBoxModel = new DefaultComboBoxModel<String>(new String[]{ServerConstants.ClusteringSetings.toHuman((String)"EMCS_REMOVE_COMPS_ENABLE"), ServerConstants.ClusteringSetings.toHuman((String)"EMCS_REMOVE_COMPS_DISABLE")});
            this.cboRemoveSmallComponents.setModel(defaultComboBoxModel);
            string = commonSettingDataObject.getModelSettingStringValue("EMCS_REMOVE_COMPONENTS");
            commonSettingDataObject.setBackupValue("EMCS_REMOVE_COMPONENTS", string);
            if (string.equals("EMCS_REMOVE_COMPS_DISABLE")) {
                this.cboRemoveSmallComponents.setSelectedIndex(1);
            } else {
                this.cboRemoveSmallComponents.setSelectedIndex(0);
            }
            this.lblRemoveSmallComponents.setLabelFor(this.cboRemoveSmallComponents);
        } else {
            this.lblLevelOfDetails.setVisible(false);
            this.cboLevelOfDetails.setVisible(false);
            this.txtRandomSeed.setVisible(false);
            this.lblRandomSeed.setVisible(false);
            this.lblModelSearch.setVisible(false);
            this.cboModelSearch.setVisible(false);
            this.lblRemoveSmallComponents.setVisible(false);
            this.cboRemoveSmallComponents.setVisible(false);
            var6_6 = new DefaultComboBoxModel<String>(new String[]{SYSTEM_DETERMINED, ServerConstants.ClusteringSetings.toHuman((String)"ODMS_APPR_COMP_ENABLE"), ServerConstants.ClusteringSetings.toHuman((String)"ODMS_APPR_COMP_DISABLE")});
            this.jApproximateComputationComboBox.setModel(var6_6);
            string = commonSettingDataObject.getModelSettingStringValue("ODMS_APPROXIMATE_COMPUTATION");
            commonSettingDataObject.setBackupValue("ODMS_APPROXIMATE_COMPUTATION", string);
            if (string.isEmpty()) {
                this.jApproximateComputationComboBox.setSelectedItem(SYSTEM_DETERMINED);
            } else {
                this.jApproximateComputationComboBox.setSelectedItem(ServerConstants.ClusteringSetings.toHuman((String)string));
            }
            this.jApproximateComputationLabel.setLabelFor(this.jApproximateComputationComboBox);
        }
        this.jCompUserSpecifiedTextField.setToolTipText(AlgSettingsLrb.get("EMCS_NUM_COMPONENTS_TOOLTIP"));
        this.setDataType(this.jCompUserSpecifiedTextField, Integer.class);
        this.setSigned(this.jCompUserSpecifiedTextField, false);
        this.setLocale(this.jCompUserSpecifiedTextField, commonSettingDataObject.getLocale());
        number = commonSettingDataObject.getModelSettingNumValue("EMCS_NUM_COMPONENTS");
        commonSettingDataObject.setBackupValue("EMCS_NUM_COMPONENTS", number);
        this.jCompSystemDeterminedButton.setEnabled(true);
        this.jCompUserSpecifiedButton.setEnabled(true);
        if (number != null) {
            this.jCompUserSpecifiedButton.setSelected(true);
            this.setNumber(this.jCompUserSpecifiedTextField, number);
        } else {
            this.jCompSystemDeterminedButton.setSelected(true);
        }
        int n = this.getMaxIterationsValue();
        object = AlgSettingsLrb.get("EMCS_NUM_ITERATIONS_TOOLTIP");
        object = MessageFormat.format((String)object, n);
        this.jMaxNumOfIterationsTextField.setToolTipText((String)object);
        this.setDataType(this.jMaxNumOfIterationsTextField, Integer.class);
        this.setSigned(this.jMaxNumOfIterationsTextField, false);
        this.setLocale(this.jMaxNumOfIterationsTextField, commonSettingDataObject.getLocale());
        number = commonSettingDataObject.getModelSettingNumValue("EMCS_NUM_ITERATIONS");
        commonSettingDataObject.setBackupValue("EMCS_NUM_ITERATIONS", number);
        ((NumberTextField)this.jMaxNumOfIterationsTextField).setNumber(number);
        this.jLogLikelihoodImprovementTextField.setToolTipText(AlgSettingsLrb.get("EMCS_LOGLIKE_IMPROVEMENT_TOOLTIP"));
        this.setDataType(this.jLogLikelihoodImprovementTextField, Double.class);
        ((NumberTextField)this.jLogLikelihoodImprovementTextField).setDecimal(true, 4);
        this.setSigned(this.jLogLikelihoodImprovementTextField, false);
        this.setLocale(this.jLogLikelihoodImprovementTextField, commonSettingDataObject.getLocale());
        number = commonSettingDataObject.getModelSettingNumValue("EMCS_LOGLIKE_IMPROVEMENT");
        commonSettingDataObject.setBackupValue("EMCS_LOGLIKE_IMPROVEMENT", number);
        ((NumberTextField)this.jLogLikelihoodImprovementTextField).setNumber(number);
        defaultComboBoxModel = new DefaultComboBoxModel<String>(new String[]{SYSTEM_DETERMINED, ServerConstants.ClusteringSetings.toHuman((String)"EMCS_CONV_CRIT_BIC"), ServerConstants.ClusteringSetings.toHuman((String)"EMCS_CONV_CRIT_HELDASIDE")});
        this.jConvergenceCriterionComboBox.setModel(defaultComboBoxModel);
        string = commonSettingDataObject.getModelSettingStringValue("EMCS_CONVERGENCE_CRITERION");
        commonSettingDataObject.setBackupValue("EMCS_CONVERGENCE_CRITERION", string);
        if (string.isEmpty()) {
            this.jConvergenceCriterionComboBox.setSelectedItem(SYSTEM_DETERMINED);
        } else {
            this.jConvergenceCriterionComboBox.setSelectedItem(ServerConstants.ClusteringSetings.toHuman((String)string));
        }
        this.jConvergenceCriterionLabel.setLabelFor(this.jConvergenceCriterionComboBox);
        DefaultComboBoxModel<String> defaultComboBoxModel3 = new DefaultComboBoxModel<String>(new String[]{SYSTEM_DETERMINED, ServerConstants.ClusteringSetings.toHuman((String)"EMCS_NUM_DISTR_BERNOULLI"), ServerConstants.ClusteringSetings.toHuman((String)"EMCS_NUM_DISTR_GAUSSIAN")});
        this.jNumericalDistributionComboBox.setModel(defaultComboBoxModel3);
        string = commonSettingDataObject.getModelSettingStringValue("EMCS_NUM_DISTRIBUTION");
        commonSettingDataObject.setBackupValue("EMCS_NUM_DISTRIBUTION", string);
        if (string.equals("EMCS_NUM_DISTR_SYSTEM")) {
            this.jNumericalDistributionComboBox.setSelectedItem(SYSTEM_DETERMINED);
        } else {
            this.jNumericalDistributionComboBox.setSelectedItem(ServerConstants.ClusteringSetings.toHuman((String)string));
        }
        this.jNumericalDistributionLabel.setLabelFor(this.jNumericalDistributionComboBox);
        string = commonSettingDataObject.getModelSettingStringValue("EMCS_CLUSTER_STATISTICS");
        commonSettingDataObject.setBackupValue("EMCS_CLUSTER_STATISTICS", string);
        bl = string.equals("EMCS_CLUS_STATS_ENABLE");
        if (DbVersionHelper.isDB122Up((Version)this._dbVersion)) {
            DefaultComboBoxModel<String> defaultComboBoxModel4 = new DefaultComboBoxModel<String>(new String[]{ServerConstants.ClusteringSetings.toHuman((String)"EMCS_LEVEL_DETAILS_ALL"), ServerConstants.ClusteringSetings.toHuman((String)"EMCS_LEVEL_DETAILS_HIERARCHY")});
            this.cboLevelOfDetails.setModel(defaultComboBoxModel4);
            if (bl) {
                this.cboLevelOfDetails.setSelectedIndex(0);
            } else {
                this.cboLevelOfDetails.setSelectedIndex(1);
            }
            this.cboLevelOfDetails.addActionListener(new LevelDetailsListener());
            this.lblLevelOfDetails.setLabelFor(this.cboLevelOfDetails);
            this.jGatherClusterStatisticsCheckBox.setVisible(false);
        } else {
            this.jGatherClusterStatisticsCheckBox.setSelected(bl);
        }
        this.jMinPercentOfAttributeRuleSupportTextField.setToolTipText(AlgSettingsLrb.get("EMCS_MIN_PCT_ATTR_SUPPORT_TOOLTIP"));
        this.setDataType(this.jMinPercentOfAttributeRuleSupportTextField, Double.class);
        ((NumberTextField)this.jMinPercentOfAttributeRuleSupportTextField).setDecimal(true, 4);
        this.setSigned(this.jMinPercentOfAttributeRuleSupportTextField, false);
        this.setLocale(this.jMinPercentOfAttributeRuleSupportTextField, commonSettingDataObject.getLocale());
        if (bl) {
            number = commonSettingDataObject.getModelSettingNumValue("EMCS_MIN_PCT_ATTR_SUPPORT");
            commonSettingDataObject.setBackupValue("EMCS_MIN_PCT_ATTR_SUPPORT", number);
            if (number != null) {
                ((NumberTextField)this.jMinPercentOfAttributeRuleSupportTextField).setNumber(number);
            } else {
                ((NumberTextField)this.jMinPercentOfAttributeRuleSupportTextField).setNumber((Number)0.1);
            }
        }
        this.jDataPreparationAnalysisButton.setEnabled(true);
        number = commonSettingDataObject.getModelSettingNumValue("EMCS_MAX_NUM_ATTR_2D");
        this.cacheSettings.put("EMCS_MAX_NUM_ATTR_2D", number);
        commonSettingDataObject.setBackupValue("EMCS_MAX_NUM_ATTR_2D", number);
        number = commonSettingDataObject.getModelSettingNumValue("EMCS_NUM_PROJECTIONS");
        this.cacheSettings.put("EMCS_NUM_PROJECTIONS", number);
        commonSettingDataObject.setBackupValue("EMCS_NUM_PROJECTIONS", number);
        number = commonSettingDataObject.getModelSettingNumValue("EMCS_NUM_QUANTILE_BINS");
        this.cacheSettings.put("EMCS_NUM_QUANTILE_BINS", number);
        commonSettingDataObject.setBackupValue("EMCS_NUM_QUANTILE_BINS", number);
        number = commonSettingDataObject.getModelSettingNumValue("EMCS_NUM_TOPN_BINS");
        this.cacheSettings.put("EMCS_NUM_TOPN_BINS", number);
        commonSettingDataObject.setBackupValue("EMCS_NUM_TOPN_BINS", number);
        number = commonSettingDataObject.getModelSettingNumValue("EMCS_NUM_EQUIWIDTH_BINS");
        this.cacheSettings.put("EMCS_NUM_EQUIWIDTH_BINS", number);
        commonSettingDataObject.setBackupValue("EMCS_NUM_EQUIWIDTH_BINS", number);
        string = commonSettingDataObject.getModelSettingStringValue("EMCS_ATTRIBUTE_FILTER");
        this.cacheSettings.put("EMCS_ATTRIBUTE_FILTER", string);
        commonSettingDataObject.setBackupValue("EMCS_ATTRIBUTE_FILTER", string);
        this.enableControls();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jNumOfClustersLabel = new JLabel();
        this.jClustSystemDeterminedButton = new JRadioButton();
        this.jClustUserSpecifiedButton = new JRadioButton();
        this.jClustUserSpecifiedTextField = new NumberTextField();
        this.jComponentClusteringCheckBox = new JCheckBox();
        this.jComponentClusterThresholdLabel = new JLabel();
        this.jComponentClusterThresholdTextField = new NumberTextField();
        this.jLinkageFunctionLabel = new JLabel();
        this.jLinkageFunctionComboBox = new JComboBox();
        this.jApproximateComputationLabel = new JLabel();
        this.jApproximateComputationComboBox = new JComboBox();
        this.jNumberOfComponentsLabel = new JLabel();
        this.jCompSystemDeterminedButton = new JRadioButton();
        this.jCompUserSpecifiedButton = new JRadioButton();
        this.jCompUserSpecifiedTextField = new NumberTextField();
        this.jMaxNumOfIterationsLabel = new JLabel();
        this.jMaxNumOfIterationsTextField = new NumberTextField();
        this.jLogLikelihoodImprovementLabel = new JLabel();
        this.jLogLikelihoodImprovementTextField = new NumberTextField();
        this.jConvergenceCriterionLabel = new JLabel();
        this.jConvergenceCriterionComboBox = new JComboBox();
        this.jNumericalDistributionLabel = new JLabel();
        this.jNumericalDistributionComboBox = new JComboBox();
        this.jGatherClusterStatisticsCheckBox = new JCheckBox();
        this.jMinPercentOfAttributeRuleSupportLabel = new JLabel();
        this.jMinPercentOfAttributeRuleSupportTextField = new NumberTextField();
        this.jDataPreparationAnalysisLabel = new JLabel();
        this.jDataPreparationAnalysisButton = new JButton();
        this.lblLevelOfDetails = new JLabel();
        this.cboLevelOfDetails = new JComboBox();
        this.lblRandomSeed = new JLabel();
        this.txtRandomSeed = new NumberTextField();
        this.lblModelSearch = new JLabel();
        this.cboModelSearch = new JComboBox();
        this.lblRemoveSmallComponents = new JLabel();
        this.cboRemoveSmallComponents = new JComboBox();
        this.jNumOfClustersLabel.setText("Number of Clusters");
        this.buttonGroup1.add(this.jClustSystemDeterminedButton);
        this.jClustSystemDeterminedButton.setText("System determined");
        this.jClustSystemDeterminedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildSettingsPanel.this.jClustSystemDeterminedButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.jClustUserSpecifiedButton);
        this.jClustUserSpecifiedButton.setText("User specified:");
        this.jClustUserSpecifiedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildSettingsPanel.this.jClustUserSpecifiedButtonActionPerformed(actionEvent);
            }
        });
        this.jComponentClusteringCheckBox.setText("Component Clustering");
        this.jComponentClusteringCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jComponentClusteringCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildSettingsPanel.this.jComponentClusteringCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jComponentClusterThresholdLabel.setText("Component Cluster Threshold:");
        this.jLinkageFunctionLabel.setText("Linkage Function:");
        this.jLinkageFunctionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Single"}));
        this.jApproximateComputationLabel.setText("Approximate Computation:");
        this.jApproximateComputationComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"<System Determined>"}));
        this.jNumberOfComponentsLabel.setText("Number of Components");
        this.buttonGroup2.add(this.jCompSystemDeterminedButton);
        this.jCompSystemDeterminedButton.setText("System determined");
        this.jCompSystemDeterminedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildSettingsPanel.this.jCompSystemDeterminedButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup2.add(this.jCompUserSpecifiedButton);
        this.jCompUserSpecifiedButton.setText("User specified:");
        this.jCompUserSpecifiedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildSettingsPanel.this.jCompUserSpecifiedButtonActionPerformed(actionEvent);
            }
        });
        this.jMaxNumOfIterationsLabel.setText("Max Number of Iterations:");
        this.jLogLikelihoodImprovementLabel.setText("Log Likelihood Improvement:");
        this.jConvergenceCriterionLabel.setText("Convergence Criterion:");
        this.jConvergenceCriterionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"<System Determined>"}));
        this.jNumericalDistributionLabel.setText("Numerical Distribution:");
        this.jNumericalDistributionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"<System Determined>"}));
        this.jGatherClusterStatisticsCheckBox.setText("Gather Cluster Statistics (Require for Model Viewer)");
        this.jGatherClusterStatisticsCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jGatherClusterStatisticsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildSettingsPanel.this.jGatherClusterStatisticsCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jMinPercentOfAttributeRuleSupportLabel.setText("Min Percent of Attribute Rule Support:");
        this.jDataPreparationAnalysisLabel.setText("Data Preparation and Analysis:");
        this.jDataPreparationAnalysisButton.setText("Settings...");
        this.jDataPreparationAnalysisButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelEMBuildSettingsPanel.this.jDataPreparationAnalysisButtonActionPerformed(actionEvent);
            }
        });
        this.lblLevelOfDetails.setText("Level of Details:");
        this.lblRandomSeed.setText("Random Seed:");
        this.lblModelSearch.setText("Model Search:");
        this.lblRemoveSmallComponents.setText("Remove Small Components:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jNumberOfComponentsLabel).addComponent(this.jNumOfClustersLabel).addComponent(this.jComponentClusteringCheckBox))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jMinPercentOfAttributeRuleSupportLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jMinPercentOfAttributeRuleSupportTextField)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jConvergenceCriterionLabel).addComponent(this.jNumericalDistributionLabel))).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLogLikelihoodImprovementLabel)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jMaxNumOfIterationsLabel)).addGroup(groupLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCompUserSpecifiedButton).addComponent(this.jCompSystemDeterminedButton))).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jApproximateComputationLabel)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLinkageFunctionLabel)).addGroup(groupLayout.createSequentialGroup().addGap(31, 31, 31).addComponent(this.jComponentClusterThresholdLabel)).addGroup(groupLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jClustUserSpecifiedButton).addComponent(this.jClustSystemDeterminedButton))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jDataPreparationAnalysisLabel).addComponent(this.lblRandomSeed).addComponent(this.lblModelSearch, -2, 149, -2).addComponent(this.lblRemoveSmallComponents).addComponent(this.lblLevelOfDetails)))).addGap(39, 39, 39).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jDataPreparationAnalysisButton).addComponent(this.jComponentClusterThresholdTextField).addComponent(this.jCompUserSpecifiedTextField).addComponent(this.jMaxNumOfIterationsTextField).addComponent(this.jLogLikelihoodImprovementTextField).addComponent(this.jClustUserSpecifiedTextField).addComponent(this.jConvergenceCriterionComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jNumericalDistributionComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jLinkageFunctionComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jApproximateComputationComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.txtRandomSeed).addComponent(this.cboModelSearch, 0, -1, Short.MAX_VALUE).addComponent(this.cboRemoveSmallComponents, 0, -1, Short.MAX_VALUE).addComponent(this.cboLevelOfDetails, 0, -1, Short.MAX_VALUE)))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jGatherClusterStatisticsCheckBox))).addContainerGap(47, Short.MAX_VALUE)));
        groupLayout.linkSize(0, this.jApproximateComputationComboBox, this.jClustUserSpecifiedTextField, this.jCompUserSpecifiedTextField, this.jComponentClusterThresholdTextField, this.jConvergenceCriterionComboBox, this.jLinkageFunctionComboBox, this.jLogLikelihoodImprovementTextField, this.jMaxNumOfIterationsTextField, this.jMinPercentOfAttributeRuleSupportTextField, this.jNumericalDistributionComboBox);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jNumOfClustersLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jClustSystemDeterminedButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jClustUserSpecifiedButton).addComponent(this.jClustUserSpecifiedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComponentClusteringCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComponentClusterThresholdLabel).addComponent(this.jComponentClusterThresholdTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLinkageFunctionLabel).addComponent(this.jLinkageFunctionComboBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jApproximateComputationLabel).addComponent(this.jApproximateComputationComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNumberOfComponentsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCompSystemDeterminedButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCompUserSpecifiedButton).addComponent(this.jCompUserSpecifiedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMaxNumOfIterationsLabel).addComponent(this.jMaxNumOfIterationsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLogLikelihoodImprovementLabel).addComponent(this.jLogLikelihoodImprovementTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jConvergenceCriterionLabel).addComponent(this.jConvergenceCriterionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNumericalDistributionLabel).addComponent(this.jNumericalDistributionComboBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblLevelOfDetails).addComponent(this.cboLevelOfDetails, -2, -1, -2)).addGap(9, 9, 9).addComponent(this.jGatherClusterStatisticsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMinPercentOfAttributeRuleSupportLabel).addComponent(this.jMinPercentOfAttributeRuleSupportTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jDataPreparationAnalysisLabel).addComponent(this.jDataPreparationAnalysisButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblRandomSeed).addComponent(this.txtRandomSeed, -2, -1, -2)).addGap(8, 8, 8).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblModelSearch).addComponent(this.cboModelSearch, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblRemoveSmallComponents).addComponent(this.cboRemoveSmallComponents, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jClustSystemDeterminedButtonActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jCompSystemDeterminedButtonActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jComponentClusteringCheckBoxActionPerformed(ActionEvent actionEvent) {
        Number number;
        boolean bl = this.jComponentClusteringCheckBox.isSelected();
        if (bl && (number = this.getNumber(this.jComponentClusterThresholdTextField)) == null) {
            this.setNumber(this.jComponentClusterThresholdTextField, 2.0);
        }
        this.enableControls();
    }

    private void jClustUserSpecifiedButtonActionPerformed(ActionEvent actionEvent) {
        Number number;
        boolean bl = this.jClustUserSpecifiedButton.isSelected();
        this.jClustUserSpecifiedTextField.setEnabled(bl);
        if (bl && (number = this.getNumber(this.jClustUserSpecifiedTextField)) == null) {
            this.setNumber(this.jClustUserSpecifiedTextField, 10);
        }
        this.enableControls();
    }

    private void jCompUserSpecifiedButtonActionPerformed(ActionEvent actionEvent) {
        Number number;
        boolean bl = this.jCompUserSpecifiedButton.isSelected();
        this.jCompUserSpecifiedTextField.setEnabled(bl);
        if (bl && (number = this.getNumber(this.jCompUserSpecifiedTextField)) == null) {
            this.setNumber(this.jCompUserSpecifiedTextField, 20);
        }
        this.enableControls();
    }

    private void jGatherClusterStatisticsCheckBoxActionPerformed(ActionEvent actionEvent) {
        Number number;
        boolean bl = this.jGatherClusterStatisticsCheckBox.isSelected();
        if (bl && (number = this.getNumber(this.jMinPercentOfAttributeRuleSupportTextField)) == null) {
            this.setNumber(this.jMinPercentOfAttributeRuleSupportTextField, 0.1);
        }
        this.enableControls();
    }

    private void jDataPreparationAnalysisButtonActionPerformed(ActionEvent actionEvent) {
        ModelEMBuildDataPrepAnalysisPanel modelEMBuildDataPrepAnalysisPanel = new ModelEMBuildDataPrepAnalysisPanel(this.getParentPanel().getContext(), this);
        modelEMBuildDataPrepAnalysisPanel.showAsDialog(this);
    }

    private void enableControls() {
        this.jClustUserSpecifiedTextField.setEnabled(this.jClustUserSpecifiedButton.isSelected());
        this.jComponentClusterThresholdTextField.setEnabled(this.jComponentClusteringCheckBox.isSelected());
        this.jCompUserSpecifiedTextField.setEnabled(this.jCompUserSpecifiedButton.isSelected());
        if (DbVersionHelper.isDB122Up((Version)this._dbVersion)) {
            String string = (String)this.cboLevelOfDetails.getSelectedItem();
            this.jMinPercentOfAttributeRuleSupportTextField.setEnabled(string.equals(ServerConstants.ClusteringSetings.EMCS_LEVEL_DETAILS_OPTION.EMCS_LEVEL_DETAILS_ALL.value()));
        } else {
            this.jMinPercentOfAttributeRuleSupportTextField.setEnabled(this.jGatherClusterStatisticsCheckBox.isSelected());
        }
    }

    @Override
    public void processInput() {
        Number number;
        Number number2;
        Object object;
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        commonSettingDataObject.setCommonPerformanceOption();
        Number number3 = null;
        if (this.jClustSystemDeterminedButton.isSelected()) {
            this.setObjectValue("CLUS_NUM_CLUSTERS", null);
        } else {
            number3 = this.getNumber(this.jClustUserSpecifiedTextField);
            if (null == number3 || number3.intValue() < 1) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("CLUS_NUM_CLUSTERS_INVALID"));
                return;
            }
            this.setObjectValue("CLUS_NUM_CLUSTERS", number3);
        }
        boolean bl = false;
        if (this.jComponentClusteringCheckBox.isSelected()) {
            object = this.getNumber(this.jComponentClusterThresholdTextField);
            if (null == object || ((Number)object).doubleValue() < 1.0) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("EMCS_CLUSTER_THRESH_INVALID"));
                return;
            }
            this.setObjectValue("EMCS_CLUSTER_COMPONENTS", "EMCS_CLUSTER_COMP_ENABLE");
            this.setObjectValue("EMCS_CLUSTER_THRESH", object);
            bl = true;
        } else {
            this.setObjectValue("EMCS_CLUSTER_COMPONENTS", "EMCS_CLUSTER_COMP_DISABLE");
            this.setObjectValue("EMCS_CLUSTER_THRESH", null);
        }
        object = (String)this.jLinkageFunctionComboBox.getSelectedItem();
        this.setObjectValue("EMCS_LINKAGE_FUNCTION", ServerConstants.ClusteringSetings.toAlgorithm((String)object));
        if (DbVersionHelper.isDB122Up((Version)this._dbVersion)) {
            if (this.cboLevelOfDetails.getSelectedIndex() > -1) {
                object = (String)this.cboLevelOfDetails.getSelectedItem();
                if (ServerConstants.ClusteringSetings.EMCS_LEVEL_DETAILS_OPTION.EMCS_LEVEL_DETAILS_ALL.value().equals(object)) {
                    object = "EMCS_CLUS_STATS_ENABLE";
                } else if (ServerConstants.ClusteringSetings.EMCS_LEVEL_DETAILS_OPTION.EMCS_LEVEL_DETAILS_HIERARCHY.value().equals(object)) {
                    object = "EMCS_CLUS_STATS_DISABLE";
                }
                this.setObjectValue("EMCS_CLUSTER_STATISTICS", object);
            }
            if (null == (number2 = this.getNumber(this.txtRandomSeed))) {
                number2 = 0;
            }
            if (number2.intValue() < 0) {
                String string = AlgSettingsLrb.get("EMCS_RANDOM_SEED_INVALID");
                this.setValidationErrorObjectValue(string);
                return;
            }
            this.setObjectValue("EMCS_RANDOM_SEED", number2);
            if (this.cboModelSearch.getSelectedIndex() > -1) {
                object = (String)this.cboModelSearch.getSelectedItem();
                if (((String)object).equals(ServerConstants.ClusteringSetings.EMCS_MODEL_SEARCH_OPTION.EMCS_MODEL_SEARCH_ENABLE.value())) {
                    object = "EMCS_MODEL_SEARCH_ENABLE";
                } else if (((String)object).equals(ServerConstants.ClusteringSetings.EMCS_MODEL_SEARCH_OPTION.EMCS_MODEL_SEARCH_DISABLE.value())) {
                    object = "EMCS_MODEL_SEARCH_DISABLE";
                }
                this.setObjectValue("EMCS_MODEL_SEARCH", object);
            }
            if (this.cboRemoveSmallComponents.getSelectedIndex() > -1) {
                object = (String)this.cboRemoveSmallComponents.getSelectedItem();
                if (((String)object).equals(ServerConstants.ClusteringSetings.EMCS_REMOVE_COMPONENTS_OPTION.EMCS_REMOVE_COMPS_ENABLE.value())) {
                    object = "EMCS_REMOVE_COMPS_ENABLE";
                } else if (((String)object).equals(ServerConstants.ClusteringSetings.EMCS_REMOVE_COMPONENTS_OPTION.EMCS_REMOVE_COMPS_DISABLE.value())) {
                    object = "EMCS_REMOVE_COMPS_DISABLE";
                }
                this.setObjectValue("EMCS_REMOVE_COMPONENTS", object);
            }
        } else {
            object = (String)this.jApproximateComputationComboBox.getSelectedItem();
            object = ((String)object).equals(ServerConstants.ClusteringSetings.ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_ENABLE.value()) ? "ODMS_APPR_COMP_ENABLE" : (((String)object).equals(ServerConstants.ClusteringSetings.ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_DISABLE.value()) ? "ODMS_APPR_COMP_DISABLE" : null);
            this.setObjectValue("ODMS_APPROXIMATE_COMPUTATION", object);
        }
        number2 = null;
        if (this.jCompSystemDeterminedButton.isSelected()) {
            this.setObjectValue("EMCS_NUM_COMPONENTS", null);
        } else {
            number2 = this.getNumber(this.jCompUserSpecifiedTextField);
            if (null == number2 || number2.intValue() < 1) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("EMCS_NUM_COMPONENTS_INVALID"));
                return;
            }
            this.setObjectValue("EMCS_NUM_COMPONENTS", number2);
        }
        if (number3 != null && number2 != null) {
            if (bl) {
                if (number3.intValue() > number2.intValue()) {
                    this.setValidationErrorObjectValue(AlgSettingsLrb.get("EMCS_COMPONENTS_GREATER_CLUSTERS_INVALID"));
                    return;
                }
            } else if (number3.intValue() != number2.intValue()) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("EMCS_COMPONENTS_EQUAL_CLUSTERS_INVALID"));
                return;
            }
        }
        if (null == (number = this.getNumber(this.jMaxNumOfIterationsTextField)) || number.intValue() < 1 || number.intValue() > Integer.MAX_VALUE) {
            String string = AlgSettingsLrb.get("EMCS_NUM_ITERATIONS_INVALID");
            string = MessageFormat.format(string, Integer.MAX_VALUE);
            this.setValidationErrorObjectValue(string);
            return;
        }
        this.setObjectValue("EMCS_NUM_ITERATIONS", number);
        number = this.getNumber(this.jLogLikelihoodImprovementTextField);
        if (null == number || !(number.doubleValue() > 0.0) || !(number.doubleValue() < 1.0)) {
            this.setValidationErrorObjectValue(AlgSettingsLrb.get("EMCS_LOGLIKE_IMPROVEMENT_INVALID"));
            return;
        }
        this.setObjectValue("EMCS_LOGLIKE_IMPROVEMENT", number);
        object = (String)this.jConvergenceCriterionComboBox.getSelectedItem();
        this.setObjectValue("EMCS_CONVERGENCE_CRITERION", SYSTEM_DETERMINED.equals(object) ? null : ServerConstants.ClusteringSetings.toAlgorithm((String)object));
        object = (String)this.jNumericalDistributionComboBox.getSelectedItem();
        this.setObjectValue("EMCS_NUM_DISTRIBUTION", SYSTEM_DETERMINED.equals(object) ? "EMCS_NUM_DISTR_SYSTEM" : ServerConstants.ClusteringSetings.toAlgorithm((String)object));
        if (DbVersionHelper.isDB122Up((Version)this._dbVersion)) {
            object = (String)this.cboLevelOfDetails.getSelectedItem();
            if (((String)object).equals(ServerConstants.ClusteringSetings.EMCS_LEVEL_DETAILS_OPTION.EMCS_LEVEL_DETAILS_ALL.value())) {
                number = this.getNumber(this.jMinPercentOfAttributeRuleSupportTextField);
                if (null == number || !(number.doubleValue() > 0.0) || !(number.doubleValue() < 1.0)) {
                    this.setValidationErrorObjectValue(AlgSettingsLrb.get("EMCS_MIN_PCT_ATTR_SUPPORT_INVALID"));
                    return;
                }
                this.setObjectValue("EMCS_MIN_PCT_ATTR_SUPPORT", number);
            } else {
                this.setObjectValue("EMCS_MIN_PCT_ATTR_SUPPORT", null);
            }
        } else if (this.jGatherClusterStatisticsCheckBox.isSelected()) {
            number = this.getNumber(this.jMinPercentOfAttributeRuleSupportTextField);
            if (null == number || !(number.doubleValue() > 0.0) || !(number.doubleValue() < 1.0)) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("EMCS_MIN_PCT_ATTR_SUPPORT_INVALID"));
                return;
            }
            this.setObjectValue("EMCS_CLUSTER_STATISTICS", "EMCS_CLUS_STATS_ENABLE");
            this.setObjectValue("EMCS_MIN_PCT_ATTR_SUPPORT", number);
        } else {
            this.setObjectValue("EMCS_CLUSTER_STATISTICS", "EMCS_CLUS_STATS_DISABLE");
            this.setObjectValue("EMCS_MIN_PCT_ATTR_SUPPORT", null);
        }
        this.setObjectValue("EMCS_MAX_NUM_ATTR_2D", this.cacheSettings.get("EMCS_MAX_NUM_ATTR_2D"));
        this.setObjectValue("EMCS_NUM_PROJECTIONS", this.cacheSettings.get("EMCS_NUM_PROJECTIONS"));
        this.setObjectValue("EMCS_NUM_QUANTILE_BINS", this.cacheSettings.get("EMCS_NUM_QUANTILE_BINS"));
        this.setObjectValue("EMCS_NUM_TOPN_BINS", this.cacheSettings.get("EMCS_NUM_TOPN_BINS"));
        this.setObjectValue("EMCS_NUM_EQUIWIDTH_BINS", this.cacheSettings.get("EMCS_NUM_EQUIWIDTH_BINS"));
        this.setObjectValue("EMCS_ATTRIBUTE_FILTER", this.cacheSettings.get("EMCS_ATTRIBUTE_FILTER"));
    }

    public HashMap<String, Object> getCacheSettings() {
        return this.cacheSettings;
    }

    private class LevelDetailsListener
    implements ActionListener {
        private LevelDetailsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)ModelEMBuildSettingsPanel.this.cboLevelOfDetails.getSelectedItem();
            boolean bl = string.equals(ServerConstants.ClusteringSetings.EMCS_LEVEL_DETAILS_OPTION.EMCS_LEVEL_DETAILS_ALL.value());
            if (bl) {
                Number number = ModelEMBuildSettingsPanel.this.getNumber(ModelEMBuildSettingsPanel.this.jMinPercentOfAttributeRuleSupportTextField);
                if (number == null) {
                    ModelEMBuildSettingsPanel.this.setNumber(ModelEMBuildSettingsPanel.this.jMinPercentOfAttributeRuleSupportTextField, 0.1);
                }
            } else {
                ModelEMBuildSettingsPanel.this.setNumber(ModelEMBuildSettingsPanel.this.jMinPercentOfAttributeRuleSupportTextField, null);
            }
            ModelEMBuildSettingsPanel.this.enableControls();
        }
    }
}

