/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.models.ModelHeuristicRules;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AlgorithmSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditDialog;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildNodeTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.DataUsagePanel;
import oracle.dmt.dataminer.workflow.dialog.build.ModelDataUsageCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.build.ModelEditRecord;
import oracle.dmt.dataminer.workflow.dialog.build.ModelNameCellEditor;
import oracle.dmt.dataminer.workflow.dialog.build.ModelNameChangeValidator;
import oracle.dmt.dataminer.workflow.dialog.build.ModelsTable;
import oracle.dmt.dataminer.workflow.dialog.build.NewModelPanel;
import oracle.dmt.dataminer.workflow.dialog.build.NewRModelPanel;
import oracle.dmt.dataminer.workflow.dialog.build.PerformanceSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.extensible.ExtensibleSettingsPanel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AnomalyDetectionBuildNode;
import oracle.dmt.dataminer.workflow.model.AssociationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClusteringBuildNode;
import oracle.dmt.dataminer.workflow.model.ExplicitFeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.FeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.RBuildNode;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ExtensibleBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.InputMiningDataType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controls.JTabbedPane2;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TransparentPanel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.Version;

public class AdvancedSettingsPanel
extends DialogDisplayer<AbstractBuildNode>
implements ModelNameChangeValidator {
    private static final Logger LOGGER = Logger.getLogger(AdvancedSettingsPanel.class.getName());
    protected BuildNodeType metadataCopy;
    private Map<String, AbstractSettingsPanel> panels = new LinkedHashMap<String, AbstractSettingsPanel>();
    private DataUsagePanel dataUsagePanelRef;
    private boolean isStandalone;
    private boolean isTextDirty;
    private final Map<String, ModelEditRecord> modelEdits;
    private Version dbVersion;
    private Map<String, Object> auxMetadata = new HashMap<String, Object>();
    private Map<String, ModelHeuristicRules> modelRules;
    private JEWTDialog parentDialogRef;
    private ControlledSelectionGenericTable jModelsTable;
    private ModelsTableModel modelsTblModel;
    private JTabbedPane tabs;
    private JButton removeBtn;
    private JButton addBtn;
    private TransparentPanel _jDetailPanel;
    private TransparentPanel _jModelsTablePanel;
    private ComponentWithTitlebar<JComponent> _jModelsToolbar;
    private JSplitPane jSplitter;

    public AdvancedSettingsPanel(Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, List<String> list) {
        super(context, abstractBuildNode);
        this.modelEdits = new HashMap<String, ModelEditRecord>();
        if (buildNodeType != null) {
            this.metadataCopy = buildNodeType;
        } else {
            this.metadataCopy = (BuildNodeType)MetaDataHelper.copyMetadataObject(abstractBuildNode.getData());
            this.isStandalone = true;
        }
        this.jModelsTable = new ControlledSelectionGenericTable(this.metadataCopy, 3);
        this.tabs = new CustomTab();
        this.dbVersion = ConfigUtils.getDatabaseVersion(context);
        this.initComponents();
        this.initRes();
        this.initUI(list);
    }

    public Map getModelEdits() {
        return this.modelEdits;
    }

    private void initComponents() {
        this.jSplitter = new JSplitPane();
        this._jModelsTablePanel = new TransparentPanel();
        this._jModelsToolbar = new ComponentWithTitlebar();
        this._jDetailPanel = new TransparentPanel();
        this.jSplitter.setBorder(null);
        this.jSplitter.setDividerLocation(180);
        this.jSplitter.setDividerSize(3);
        this.jSplitter.setOrientation(0);
        this.jSplitter.setMinimumSize(new Dimension(550, 450));
        this._jModelsToolbar.setPreferredSize(new Dimension(0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this._jModelsTablePanel);
        this._jModelsTablePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jModelsToolbar, -1, 840, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jModelsToolbar, -1, 180, Short.MAX_VALUE));
        this.jSplitter.setLeftComponent((Component)this._jModelsTablePanel);
        GroupLayout groupLayout2 = new GroupLayout((Container)this._jDetailPanel);
        this._jDetailPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 840, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 347, Short.MAX_VALUE));
        this.jSplitter.setRightComponent((Component)this._jDetailPanel);
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitter, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitter, -1, -1, Short.MAX_VALUE));
    }

    public Map<String, ModelHeuristicRules> getCopyOfModelRules() {
        if (this.modelRules == null) {
            this.modelRules = MetaDataHelper.getHeuristicsRulesModels(this._context, this.metadataCopy);
        }
        return new HashMap<String, ModelHeuristicRules>(this.modelRules);
    }

    public boolean isDirty() {
        boolean bl = !this.modelEdits.isEmpty() || this.isTextDirty;
        return bl;
    }

    public AlgorithmSettingsPanel getAlgoSettingsDialog() {
        return (AlgorithmSettingsPanel)this.panels.get(BuildEditorLrb.get("ALGO_SETTINGS"));
    }

    @Override
    protected String getDialogTitle() {
        return BuildEditorLrb.get("ADVANCED_SETTITNGS_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        if (this._data instanceof AssociationBuildNode) {
            return "association_node_edit_adv";
        }
        if (this._data instanceof ClassificationBuildNode) {
            return "classification_node_edit_adv";
        }
        if (this._data instanceof ClusteringBuildNode) {
            return "clustering_node_edit_adv";
        }
        if (this._data instanceof RegressionBuildNode) {
            return "regression_node_edit_adv";
        }
        if (this._data instanceof AnomalyDetectionBuildNode) {
            return "anomaly_node_edit_adv";
        }
        if (this._data instanceof FeatureExtractionBuildNode) {
            return "feature_node_edit_adv";
        }
        if (this._data instanceof ExplicitFeatureExtractionBuildNode) {
            return "esa_node_edit_adv";
        }
        if (this._data instanceof RBuildNode) {
            return "r_node_edit_adv";
        }
        return null;
    }

    @Override
    public void initUI() {
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        UIResourceHelper.setComponentText(hashMap);
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        this.jSplitter.setDividerLocation(120);
    }

    protected void initIconResources() {
    }

    public void setParentDialogRef(JEWTDialog jEWTDialog) {
        this.parentDialogRef = jEWTDialog;
        this.parentDialogRef.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (AdvancedSettingsPanel.this.dataUsagePanelRef != null) {
                    AdvancedSettingsPanel.this.dataUsagePanelRef.resizeTable(AdvancedSettingsPanel.this.getSize());
                }
            }
        });
    }

    protected void initUI(List<String> list) {
        this.initIconResources();
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.jModelsTable));
        this._jModelsToolbar.setComponent((JComponent)jScrollPane);
        this._jModelsToolbar.setLabel(new JLabel(BuildEditorLrb.get("BUILD_MODEL_SETTINGS_LBL")));
        this.installModelActions();
        List<ModelType> list2 = MetaDataHelper.getModelsCollection(this.metadataCopy);
        String[] stringArray = null;
        stringArray = this.metadataCopy instanceof AssociationBuildNodeType ? new String[]{BuildEditorLrb.get("BUILD_MODEL_NAME"), BuildEditorLrb.get("BUILD_MODEL_ALGORITHM"), BuildEditorLrb.get("BUILD_MODEL_LAST_BUILT")} : new String[]{BuildEditorLrb.get("BUILD_MODEL_NAME"), BuildEditorLrb.get("BUILD_MODEL_ALGORITHM"), BuildEditorLrb.get("BUILD_MODEL_LAST_BUILT"), BuildEditorLrb.get("BUILD_MODEL_USAGE"), BuildEditorLrb.get("BUILD_MODEL_EXCLUDED")};
        this.modelsTblModel = new ModelsTableModel(list2, stringArray);
        this.jModelsTable.setModelEditCache(this.modelEdits);
        this.jModelsTable.setModel((TableModel)((Object)this.modelsTblModel));
        this.jModelsTable.setSorted(true);
        this.jModelsTable.setUpdateSelectionOnSort(true);
        this.jModelsTable.getTableHeader().setReorderingAllowed(false);
        this.jModelsTable.setAutoResizeMode(2);
        this.jModelsTable.getColumnModel().getColumn(0).setCellEditor(new ModelNameCellEditor(this._context, this.getWorkflowModel(), this.metadataCopy, this));
        if (stringArray.length > 3) {
            this.jModelsTable.getColumnModel().getColumn(3).setCellRenderer(new ModelDataUsageCellRenderer(false, true, true));
        }
        this.jModelsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                AdvancedSettingsPanel.this.handleModelSelectionChanged(listSelectionModel);
            }
        });
        this._jDetailPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        if (!(this.metadataCopy instanceof AssociationBuildNodeType)) {
            this.dataUsagePanelRef = new DataUsagePanel(this, this._context, (AbstractBuildNode)this._data, this.metadataCopy, this.modelEdits);
            this.panels.put(BuildEditorLrb.get("DATA_USAGE"), this.dataUsagePanelRef);
        }
        if (this.metadataCopy instanceof ExtensibleBuildNodeType) {
            this.panels.put(BuildEditorLrb.get("EXTENSIBLE_SETTINGS"), new ExtensibleSettingsPanel(this, this._context, this._data, (NodeType)this.metadataCopy));
        } else {
            this.panels.put(BuildEditorLrb.get("ALGO_SETTINGS"), new AlgorithmSettingsPanel(this, this._context, (AbstractBuildNode)this._data, this.metadataCopy));
        }
        if (this.metadataCopy instanceof ClassificationBuildNodeType) {
            this.panels.put(BuildEditorLrb.get("PERF_SETTINGS"), new PerformanceSettingsPanel(this, this._context, (AbstractBuildNode)this._data, this.metadataCopy));
        }
        for (String string : this.panels.keySet()) {
            this.tabs.addTab(string, this.panels.get(string));
        }
        this._jDetailPanel.add((Component)this.tabs, (Object)"Center");
        Object object = new int[]{0};
        if (list != null && list.size() > 0) {
            object = new int[list.size()];
            int n = 0;
            for (int i = 0; i < this.modelsTblModel.getSrcData().size(); ++i) {
                ModelType modelType = (ModelType)this.modelsTblModel.getSrcData().get(i);
                if (!list.contains(modelType.getId())) continue;
                object[n++] = i;
            }
        }
        if (!this.modelsTblModel.getSrcData().isEmpty()) {
            this.jModelsTable.setSelectedRowsInModel((int[])object);
        }
    }

    private WorkflowModel getWorkflowModel() {
        WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
        WorkflowModel workflowModel = null;
        try {
            workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return workflowModel;
    }

    public void refreshTable() {
        int[] nArray = this.jModelsTable.getSelectedRowsInModel();
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this.jModelsTable.getModel());
        modelsTableModel.fireTableDataChanged();
        this.jModelsTable.setSelectedRowsInModel(nArray);
    }

    public boolean canProceed() {
        boolean bl = true;
        ListSelectionModel listSelectionModel = this.jModelsTable.getSelectionModel();
        String string = BuildEditorLrb.get("PERF_SETTINGS");
        AbstractSettingsPanel abstractSettingsPanel = this.panels.get(string);
        if (abstractSettingsPanel != null && !abstractSettingsPanel.canProceed(listSelectionModel)) {
            return false;
        }
        for (String string2 : this.panels.keySet()) {
            AbstractSettingsPanel abstractSettingsPanel2 = this.panels.get(string2);
            if (abstractSettingsPanel != null && string2.equals(string) || abstractSettingsPanel2.canProceed(listSelectionModel)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void initMiningAttributeInputs(MiningAttributes miningAttributes, ModelType modelType) {
        Version version = ConnectionFolder.getConnectionFolder(this.getContext()).getDbVersion();
        for (MiningAttributeType miningAttributeType : miningAttributes.getMiningAttribute()) {
            if (AbstractBuildNode.isInputAllowed(miningAttributeType, modelType, version)) continue;
            miningAttributeType.setInput("No");
        }
    }

    private void installModelActions() {
        ControlBar controlBar = new ControlBar();
        this.removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removeBtn.setToolTipText(BuildEditorLrb.get("MODELS_DELETE_TOOLTIP"));
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                int n;
                String string = BuildEditDialog.getModelsDeleteMessage((JTable)((Object)AdvancedSettingsPanel.this.jModelsTable));
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)BuildEditorLrb.get("REMOVE_MODELS_TITLE"), null, (boolean)true)) {
                    return;
                }
                int[] nArray = AdvancedSettingsPanel.this.jModelsTable.getSelectedRows();
                int[] nArray2 = new int[nArray.length];
                for (n = 0; n < nArray.length; ++n) {
                    nArray2[n] = AdvancedSettingsPanel.this.jModelsTable.convertRowIndexToModel(nArray[n]);
                    object = (ModelType)AdvancedSettingsPanel.this.modelsTblModel.getSrcData().get(nArray2[n]);
                    AdvancedSettingsPanel.this.addEditedModelRecord((ModelType)object, 2);
                }
                AdvancedSettingsPanel.this.modelsTblModel.removeRows(nArray2);
                if (AdvancedSettingsPanel.this.modelsTblModel.getSrcData().size() != 0) {
                    n = nArray[0] - 1 < 0 ? 0 : nArray[0] - 1;
                    n = AdvancedSettingsPanel.this.jModelsTable.convertRowIndexToModel(n);
                    object = new int[]{n};
                    AdvancedSettingsPanel.this.jModelsTable.setSelectedRowsInModel((int[])object);
                } else {
                    AdvancedSettingsPanel.this.dataUsagePanelRef.disableAutoSelection();
                }
            }
        });
        controlBar.add((Component)this.removeBtn);
        this.addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addBtn.setToolTipText(BuildEditorLrb.get("MODELS_ADD_TOOLTIP"));
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelType modelType;
                Collection<String> collection = AdvancedSettingsPanel.this.getPendingNewModels();
                Collection<String> collection2 = AdvancedSettingsPanel.this.getPendingRenamedModels();
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(collection);
                arrayList.addAll(collection2);
                ModelType modelType2 = modelType = AdvancedSettingsPanel.this._data instanceof RBuildNode ? NewRModelPanel.addNewModel(AdvancedSettingsPanel.this, AdvancedSettingsPanel.this.metadataCopy, AdvancedSettingsPanel.this.getContext(), (AbstractBuildNode)AdvancedSettingsPanel.this._data, arrayList) : NewModelPanel.addNewModel(AdvancedSettingsPanel.this, AdvancedSettingsPanel.this.metadataCopy, AdvancedSettingsPanel.this.getContext(), (AbstractBuildNode)AdvancedSettingsPanel.this._data, arrayList);
                if (modelType != null) {
                    AdvancedSettingsPanel.this.initMiningAttributeInputs(modelType.getInputMiningData().getMiningAttributes(), modelType);
                    MetaDataHelper.addModel(AdvancedSettingsPanel.this.metadataCopy, modelType);
                    if (AdvancedSettingsPanel.this.dataUsagePanelRef != null) {
                        AdvancedSettingsPanel.this.dataUsagePanelRef.generateUIRulesMessages();
                    }
                    AdvancedSettingsPanel.this.addEditedModelRecord(modelType, 0);
                    int[] nArray = new int[]{AdvancedSettingsPanel.this.modelsTblModel.addModel(modelType)};
                    AdvancedSettingsPanel.this.jModelsTable.setSelectedRowsInModel(nArray);
                }
            }
        });
        controlBar.add((Component)this.addBtn);
        ListSelectionModel listSelectionModel = this.jModelsTable.getSelectionModel();
        this.removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        this._jModelsToolbar.setControlBar(controlBar);
    }

    protected List<ModelType> getSelectedModels() {
        ModelsTableModel modelsTableModel = this.getTableModel();
        List list = modelsTableModel.getSrcData();
        ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
        ModelsTableModel modelsTableModel2 = this.getTableModel();
        if (!modelsTableModel2.getDataVector().isEmpty()) {
            int[] nArray;
            for (int n : nArray = this.jModelsTable.getSelectedRowsInModel()) {
                ModelType modelType = (ModelType)list.get(n);
                arrayList.add(modelType);
            }
        }
        return arrayList;
    }

    public boolean isMultipleSelection() {
        return this.jModelsTable.getSelectedRowCount() > 1;
    }

    @Override
    public boolean doWork() {
        TableCellEditor tableCellEditor;
        if (this.jModelsTable.isEditing() && !(tableCellEditor = this.jModelsTable.getCellEditor()).stopCellEditing()) {
            return false;
        }
        boolean bl = this.canProceed();
        if (!bl) {
            return bl;
        }
        if (!this.isDirty()) {
            return true;
        }
        HashMap<String, ModelType> hashMap = new HashMap<String, ModelType>();
        List<ModelType> list = MetaDataHelper.getModelsCollection((BuildNodeType)((AbstractBuildNode)this._data).getData());
        for (ModelType modelType : list) {
            ModelType modelType2 = MetaDataHelper.findModelById(this.metadataCopy, modelType.getId());
            if (modelType2 == null || modelType2.getName().equals(modelType.getName())) continue;
            hashMap.put(modelType2.getName(), modelType);
        }
        if (this.modelEdits.size() != 0 || this.isTextDirty) {
            Object object;
            Object object2;
            Iterator<Object> iterator = this.modelEdits.entrySet().iterator();
            boolean bl2 = false;
            boolean bl3 = false;
            while (iterator.hasNext()) {
                object2 = (Map.Entry)iterator.next();
                object = (ModelEditRecord)object2.getValue();
                if (((ModelEditRecord)object).isNew()) {
                    bl = MetaDataHelper.addModel(this.metadataCopy, ((ModelEditRecord)object).getModel());
                    bl3 = true;
                } else if (((ModelEditRecord)object).getEditType() == 1) {
                    bl = MetaDataHelper.replaceModel(this.metadataCopy, ((ModelEditRecord)object).getModel(), ((ModelEditRecord)object).getOrigName());
                    bl2 = true;
                } else if (((ModelEditRecord)object).getEditType() == 2) {
                    bl = MetaDataHelper.removeModel(this.metadataCopy, ((ModelEditRecord)object).getModel());
                }
                if (bl) continue;
                break;
            }
            if (bl && this.isStandalone) {
                try {
                    CommandProcessor.getInstance().beginTrans("Edit Data Usage");
                    object2 = (OdmrSDMUndoFilter)((AbstractBuildNode)this._data).getUndoFilter();
                    ((OdmrSDMUndoFilter)((Object)object2)).prepareUndo(this._data, this._context, "nodetype", this.metadataCopy);
                    if (hashMap.size() > 0) {
                        object = MetaDataHelper.getModelsCollection(this.metadataCopy, this._context);
                        HashMap<String, RefModelType> hashMap2 = new HashMap<String, RefModelType>();
                        Iterator iterator2 = object.iterator();
                        while (iterator2.hasNext()) {
                            RefModelType refModelType = (RefModelType)iterator2.next();
                            if (!hashMap.containsKey(refModelType.getName())) continue;
                            hashMap2.put(((ModelType)hashMap.get(refModelType.getName())).getName(), refModelType);
                        }
                        ((AbstractBuildNode)this._data).refactorChildModelReferences(hashMap2, false);
                    }
                    ((AbstractBuildNode)this._data).validateAfterEdit();
                    CommandProcessor.getInstance().endTrans();
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                    bl = false;
                    CommandProcessor.getInstance().abortTrans();
                }
            }
        }
        return bl;
    }

    public ModelType findEditedModel(ModelType modelType) {
        ModelEditRecord modelEditRecord = this.findEditedModelRecord(modelType);
        ModelType modelType2 = null;
        if (modelEditRecord != null) {
            modelType2 = modelEditRecord.getModel();
        }
        return modelType2;
    }

    public void replaceEditedModel(ModelType modelType) {
        ModelEditRecord modelEditRecord = this.findEditedModelRecord(modelType);
        if (modelEditRecord != null) {
            modelEditRecord.setModel(modelType);
        }
    }

    public ModelEditRecord findEditedModelRecord(ModelType modelType) {
        ModelEditRecord modelEditRecord = this.modelEdits.get(modelType.getName());
        return modelEditRecord;
    }

    protected ModelEditRecord addEditedModelRecord(ModelType modelType, int n) {
        ModelEditRecord modelEditRecord = this.findEditedModelRecord(modelType);
        if (modelEditRecord != null && modelEditRecord.isNew() && 2 == n) {
            return this.modelEdits.remove(modelType.getName());
        }
        if (modelEditRecord != null && modelEditRecord.getEditType() == 2) {
            return modelEditRecord;
        }
        if (modelEditRecord != null && modelEditRecord.getEditType() == 1 && 2 == n) {
            this.modelEdits.remove(modelType.getName());
        } else if (modelEditRecord != null) {
            throw new IllegalStateException("ModelEditRecord already present.  Use findEditedModel() prior to adding a new record");
        }
        ModelEditRecord modelEditRecord2 = new ModelEditRecord(n, modelType);
        if (0 == n || modelEditRecord != null && modelEditRecord.isNew()) {
            modelEditRecord2.setIsNew();
        }
        this.modelEdits.put(modelType.getName(), modelEditRecord2);
        return modelEditRecord2;
    }

    private Collection<ModelEditRecord> getNewModelsRecords() {
        ArrayList<ModelEditRecord> arrayList = new ArrayList<ModelEditRecord>();
        for (Map.Entry<String, ModelEditRecord> entry : this.modelEdits.entrySet()) {
            ModelEditRecord modelEditRecord = entry.getValue();
            if (!modelEditRecord.isNew()) continue;
            arrayList.add(modelEditRecord);
        }
        return arrayList;
    }

    private Collection<String> getPendingNewModels() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection<ModelEditRecord> collection = this.getNewModelsRecords();
        for (ModelEditRecord modelEditRecord : collection) {
            arrayList.add(modelEditRecord.getModel().getName());
        }
        return arrayList;
    }

    private Collection<String> getPendingRenamedModels() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, ModelEditRecord> entry : this.modelEdits.entrySet()) {
            ModelEditRecord modelEditRecord = entry.getValue();
            String string = modelEditRecord.getModel().getName();
            if (string.equals(modelEditRecord.getOrigName())) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public boolean validateModelNameChange(String string, String string2) {
        boolean bl = true;
        Collection<String> collection = this.getPendingNewModels();
        Collection<String> collection2 = WorkflowUtils.getInMemoryModelNames(this.getWorkflowModel(), this.metadataCopy);
        collection2.addAll(collection);
        if (!NewModelPanel.validateName(string, this._context, this, collection2, string2)) {
            bl = false;
        }
        return bl;
    }

    protected boolean canHandleModelSelectionChange() {
        boolean bl;
        block1: {
            String string;
            bl = true;
            ListSelectionModel listSelectionModel = this.jModelsTable.getSelectionModel();
            if (listSelectionModel.isSelectionEmpty()) break block1;
            Iterator<String> iterator = this.panels.keySet().iterator();
            while (iterator.hasNext() && (bl = this.panels.get(string = iterator.next()).canHandleModelSelectionChange(this.jModelsTable.getSelectionModel()))) {
            }
        }
        return bl;
    }

    protected boolean handleModelSelectionChanged(ListSelectionModel listSelectionModel) {
        if (listSelectionModel.getValueIsAdjusting()) {
            return false;
        }
        this.removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty());
        if (listSelectionModel.isSelectionEmpty()) {
            for (String string : this.panels.keySet()) {
                this.panels.get(string).loadEmptySelectionUI();
            }
        } else {
            for (String string : this.panels.keySet()) {
                this.panels.get(string).handleModelSelectionChanged(this.jModelsTable.getSelectionModel());
            }
        }
        if (this.dataUsagePanelRef != null) {
            this.dataUsagePanelRef.resizeTable(this.getSize());
        }
        return true;
    }

    protected ModelsTableModel getTableModel() {
        return (ModelsTableModel)((Object)this.jModelsTable.getModel());
    }

    protected GenericTable getModelsTable() {
        return this.jModelsTable;
    }

    public BuildNodeType getMetadataCopy() {
        return this.metadataCopy;
    }

    public Object getAuxMetadata(String string) {
        return this.auxMetadata.get(string);
    }

    public void putAuxMetadata(String string, Object object) {
        this.auxMetadata.put(string, object);
    }

    private class ControlledSelectionGenericTable
    extends ModelsTable {
        public ControlledSelectionGenericTable(BuildNodeType buildNodeType, int n) {
            super(buildNodeType, n);
        }

        public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
            if (AdvancedSettingsPanel.this.canHandleModelSelectionChange()) {
                super.changeSelection(n, n2, bl, bl2);
            }
        }
    }

    public class ModelsTableModel
    extends ODMrTableModel<ModelType>
    implements BuildNodeTableModel {
        public static final int NAME = 0;
        public static final int ALGORITHM = 1;
        public static final int MODEL_CREATED_ON = 2;
        public static final int USAGE = 3;
        public static final int COLUMNS_EXCLUDED = 4;

        public ModelsTableModel(List<ModelType> list, String[] stringArray) {
            super(stringArray, list);
        }

        public int[] getIndexesOf(List<String> list) {
            Vector<Integer> vector = new Vector<Integer>();
            for (String string : list) {
                for (int i = 0; i < this.srcData.size(); ++i) {
                    ModelType modelType = (ModelType)this.srcData.get(i);
                    if (!modelType.getName().equals(string)) continue;
                    vector.add(i);
                }
            }
            if (vector.size() == 0) {
                return new int[0];
            }
            Object object = new int[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                object[i] = (Integer)vector.get(i);
            }
            return object;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 3) {
                return String.class;
            }
            if (n == 2) {
                return XMLGregorianCalendar.class;
            }
            return String.class;
        }

        public void reload(List<ModelType> list) {
            this.srcData = list;
            this.setRowCount(this.srcData.size());
            this.fireTableDataChanged();
        }

        public int addModel(ModelType modelType) {
            this.srcData.add(modelType);
            int n = this.srcData.size() - 1;
            this.setRowCount(this.srcData.size());
            this.fireTableRowsInserted(n, n);
            return this.srcData.size() - 1;
        }

        @Override
        public void removeRows(int[] nArray) {
            ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add((ModelType)this.srcData.get(nArray[i]));
            }
            for (ModelType modelType : arrayList) {
                int n = this.srcData.indexOf(modelType);
                this.fireTableRowsDeleted(n, n);
                this.removeModel(n);
            }
        }

        public void removeModel(int n) {
            this.srcData.remove(n);
            this.setRowCount(this.srcData.size());
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ModelType modelType = (ModelType)this.srcData.get(n);
            Object object = null;
            ModelType modelType2 = AdvancedSettingsPanel.this.findEditedModel(modelType);
            if (modelType2 == null) {
                modelType2 = modelType;
            }
            switch (n2) {
                case 0: {
                    object = modelType2.getName();
                    break;
                }
                case 1: {
                    object = MetaDataHelper.getAlgorithmName(modelType2);
                    break;
                }
                case 2: {
                    XMLGregorianCalendar xMLGregorianCalendar = modelType2.getCreationDate();
                    if (xMLGregorianCalendar != null) {
                        object = TimeUtils.formatDate(xMLGregorianCalendar);
                        break;
                    }
                    object = null;
                    break;
                }
                case 3: {
                    object = modelType2.getInputMiningData().getDataUsage().equals((Object)InputMiningDataType.AUTO) ? "Auto" : "Custom";
                    break;
                }
                case 4: {
                    object = AdvancedSettingsPanel.this.dataUsagePanelRef.getModelRulesCount(modelType2);
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            ModelType modelType = (ModelType)this.srcData.get(n);
            ModelType modelType2 = null;
            ModelEditRecord modelEditRecord = AdvancedSettingsPanel.this.findEditedModelRecord(modelType);
            if (modelEditRecord == null) {
                modelEditRecord = AdvancedSettingsPanel.this.addEditedModelRecord(modelType, 1);
            }
            modelType2 = modelEditRecord.getModel();
            if (n2 == 0) {
                modelType2.setName((String)object);
                if (modelEditRecord.isNew()) {
                    ModelEditRecord modelEditRecord2 = AdvancedSettingsPanel.this.modelEdits.remove(modelType.getName());
                    AdvancedSettingsPanel.this.modelEdits.put((String)object, modelEditRecord2);
                    modelType.setName((String)object);
                }
            }
        }

        @Override
        public String getOriginalModelName(int n) {
            String string = null;
            ModelType modelType = (ModelType)this.srcData.get(n);
            ModelType modelType2 = MetaDataHelper.findModelById((BuildNodeType)((AbstractBuildNode)AdvancedSettingsPanel.this._data).getData(), modelType.getId());
            if (modelType2 != null) {
                string = modelType2.getName();
            }
            return string;
        }

        @Override
        public List<ModelType> getDataList() {
            return this.getSrcData();
        }
    }

    private class CustomTab
    extends JTabbedPane2 {
        private CustomTab() {
        }

        public void setSelectedIndex(int n) {
            if (AdvancedSettingsPanel.this.canHandleModelSelectionChange()) {
                super.setSelectedIndex(n);
                return;
            }
        }
    }

    public static class MenuAction
    extends AbstractAction {
        public MenuAction(String string, String string2) {
            super(string);
            this.putValue("ActionCommandKey", string2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

