/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EnumSet;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;
import oracle.dmt.dataminer.dprofiler.DataProfilePanelSettings;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;

public class Formats {
    private static final ModelViewerPreferenceSettings mvPrefs = ModelViewerPreferenceSettings.getInstance();
    private static final DataProfilePanelSettings dataProfileSettings = DataProfilePanelSettings.getInstance();

    public static final NumberFormat getInteger() {
        NumberFormat numberFormat = NumericFormat.getInstance((boolean)true, (int)0, (int)0, (int)1);
        return numberFormat;
    }

    public static final NumberFormat getScientific() {
        NumberFormat numberFormat = ModelViewer.getPercentage();
        StringBuilder stringBuilder = new StringBuilder("0.");
        for (int i = 0; i < numberFormat.getMaximumFractionDigits(); ++i) {
            stringBuilder.append("#");
        }
        stringBuilder.append("E0");
        numberFormat = new DecimalFormat(stringBuilder.toString());
        numberFormat.setMinimumIntegerDigits(1);
        return numberFormat;
    }

    public static class ModelViewer {
        public static final NumberFormat getPercentage() {
            NumberFormat numberFormat = ModelViewer.getPercentage(EnumSet.of(Options.MAX, Options.MIN), 1);
            return numberFormat;
        }

        private static final NumberFormat getPercentage(EnumSet<Options> enumSet, int n) {
            assert (!enumSet.isEmpty());
            boolean bl = true;
            int n2 = enumSet.contains((Object)Options.MAX) ? mvPrefs.getPercentagePrecisionLevel() : 0;
            int n3 = enumSet.contains((Object)Options.MIN) ? mvPrefs.getPercentagePrecisionLevel() : 0;
            NumberFormat numberFormat = NumericFormat.getInstance((boolean)bl, (int)n2, (int)n3, (int)n);
            return numberFormat;
        }

        public static final NumberFormat getNumeric() {
            NumberFormat numberFormat = ModelViewer.getNumeric(EnumSet.of(Options.MAX, Options.MIN), 1);
            return numberFormat;
        }

        public static final NumberFormat getNumeric(EnumSet<Options> enumSet, int n) {
            assert (!enumSet.isEmpty());
            boolean bl = true;
            int n2 = enumSet.contains((Object)Options.MAX) ? mvPrefs.getNumericalPrecisionLevel() : 0;
            int n3 = enumSet.contains((Object)Options.MIN) ? mvPrefs.getNumericalPrecisionLevel() : 0;
            NumberFormat numberFormat = NumericFormat.getInstance((boolean)bl, (int)n2, (int)n3, (int)n);
            return numberFormat;
        }
    }

    public static enum Type {
        PERCENTAGE,
        NUMERICAL;

    }

    public static enum Options {
        MIN,
        MAX;

    }

    public static class DataExplore {
        public static final NumberFormat getPercentage() {
            boolean bl = true;
            int n = dataProfileSettings.getPercentagePrecisionLevel();
            NumberFormat numberFormat = NumericFormat.getInstance((boolean)bl, (int)n, (int)n, (int)1);
            return numberFormat;
        }

        public static final NumberFormat getNumeric() {
            boolean bl = true;
            int n = dataProfileSettings.getNumericalPrecisionLevel();
            NumberFormat numberFormat = NumericFormat.getInstance((boolean)bl, (int)n, (int)n, (int)1);
            return numberFormat;
        }
    }
}

