/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.roc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataDisplay;
import oracle.dmt.dataminer.controls.GraphPanel2;
import oracle.dmt.dataminer.controls.Reloadable;
import oracle.dmt.dataminer.controls.renderers.ColorCellRenderer;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.TestResultsSelectorPanel;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.TestViewerPartitionToolbar;
import oracle.dmt.dataminer.tviewer.roc.ROCData;
import oracle.dmt.dataminer.tviewer.roc.ROCDetailPanel;
import oracle.dmt.dataminer.tviewer.roc.ROCEditor;
import oracle.dmt.dataminer.tviewer.roc.ROCTabPanelState;
import oracle.dmt.dataminer.tviewer.roc.ThresholdPanel;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;

public class ROCTabPanel
extends DataMinerViewGUI
implements GraphDataDisplay,
Reloadable {
    private GraphPanel2 _graphPanel;
    private ROCTabPanelState _state;
    private boolean _loading;
    private DataMinerTablePanel dataMinerTablePanel;
    private JButton jCustomROCButton;
    private JPanel jRocGraphPanel;
    private JSplitPane jSplitPane1;
    private JComboBox<String> jTargetComb;
    private JLabel jTargetLbl;
    private TestViewerPartitionToolbar testViewerPartitionToolbar1;
    private JButton jDetailBtn;
    private JButton _jBT_AddOrRemove;

    public ROCTabPanel(ROCEditor rOCEditor, Context context) {
        super(rOCEditor, context);
        this._state = new ROCTabPanelState(rOCEditor.getCachedLegendState());
        boolean bl = false;
        List<TestResult> list = this._state.getParentTestViewerState().getTestResults();
        boolean bl2 = this._state.getParentTestViewerState().isEnabledPartitioning();
        for (TestResult testResult : list) {
            if (!((ClassTestResult)testResult).rocResultExists(bl2)) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.initComponents();
            this.initGraph();
            this.initRes();
            this.initUI();
        }
    }

    private void initGraph() {
        this._graphPanel = new GraphPanel2(this, new DefaultGraphDataModel(null, null, null, null, null));
    }

    private boolean isEnabledPartitioning() {
        ROCEditor rOCEditor = (ROCEditor)this.getEditor();
        return rOCEditor.getCachedLegendState().isEnabledPartitioning();
    }

    public void setSelectedPartition() {
        String string = this.testViewerPartitionToolbar1.getSelectedPartitionID();
        ROCEditor rOCEditor = (ROCEditor)this.getEditor();
        rOCEditor.getCachedLegendState().setSelectedPartition(string);
    }

    private void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTargetLbl, this.jTargetComb, (String)TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleName(TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("TARGET_VALUE_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jCustomROCButton, (String)TestViewerLrb.get("ROC_CUSTOM_BTN"));
        this.jCustomROCButton.getAccessibleContext().setAccessibleName(TestViewerLrb.get("ROC_CUSTOM_BTN"));
        this.jCustomROCButton.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("ROC_CUSTOM_BTN_ADA"));
    }

    private void initUI() {
        this.dataMinerTablePanel.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ROCTabPanel.this.showDetails();
                }
            }
        });
        this.installROCSummaryActions();
        this.dataMinerTablePanel.setTitle(CommonLrb.get("MODELS"));
        this.initializeControls();
        this.jSplitPane1.setDividerLocation(0.75);
        this.jSplitPane1.setResizeWeight(0.75);
        this.jTargetComb.addActionListener(new TargetComboActionListener());
        this.jCustomROCButton.addActionListener(new CustomROCActionListener());
    }

    @Override
    public void load() {
        LoadWorker loadWorker = new LoadWorker();
        loadWorker.execute();
    }

    private void initializeControls() {
        this.dataMinerTablePanel.getTable().setSelectionMode(0);
        this.jTargetComb.setModel(new DefaultComboBoxModel<String>(new String[]{CommonLrb.get("LOADING")}));
        ListSelectionModel listSelectionModel = this.dataMinerTablePanel.getTable().getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ROCTabPanel.this._loading || listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ROCTabPanel.this.jROCSummaryTableValueChanged(listSelectionEvent);
                ROCTabPanel.this.jDetailBtn.setEnabled(ROCTabPanel.this.dataMinerTablePanel.getTable().getSelectedRowCount() > 0);
            }
        });
    }

    public void jROCSummaryTableValueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
            String string = (String)this._state.getRocTableModel().getValueAt(nArray[0], this._state.getMODEL());
            this._state.setSelectedTestResult(string);
            this.fireViewPropertySelectionChange(this, string);
        }
    }

    public ROCData getROCData() {
        ROCData rOCData;
        String string = this._state.getSelectedTestResult();
        if (string == null) {
            int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
            if (nArray.length > 0 && -1 != nArray[0]) {
                string = (String)this._state.getRocTableModel().getValueAt(nArray[0], this._state.getMODEL());
                this._state.setSelectedTestResult(string);
            }
            if (string == null) {
                return null;
            }
        }
        int n = this._state.getStatisticsData().get(string).getMaxOverallAccuracyIdx();
        List<ROCData> list = this._state.getROCData().get(string);
        ROCData rOCData2 = rOCData = list != null && list.size() > 0 ? this._state.getROCData().get(string).get(n) : null;
        if (rOCData != null) {
            rOCData.setLabel(string);
        }
        return rOCData;
    }

    private void initComponents() {
        this.jTargetLbl = new JLabel();
        this.jTargetComb = new JComboBox();
        this.jCustomROCButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jRocGraphPanel = new JPanel();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.testViewerPartitionToolbar1 = new TestViewerPartitionToolbar();
        this.jTargetLbl.setText("Target Value:");
        this.jCustomROCButton.setText("Edit Custom Operating Point...");
        this.jSplitPane1.setDividerLocation(390);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jRocGraphPanel.setMinimumSize(new Dimension(100, 100));
        this.jRocGraphPanel.setPreferredSize(new Dimension(652, 389));
        this.jRocGraphPanel.setLayout(new BorderLayout());
        this.jSplitPane1.setTopComponent(this.jRocGraphPanel);
        this.jSplitPane1.setRightComponent(this.dataMinerTablePanel);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -2, 0, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTargetLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetComb, 0, 144, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 95, Short.MAX_VALUE).addComponent(this.jCustomROCButton, -1, 267, Short.MAX_VALUE)).addComponent(this.testViewerPartitionToolbar1, GroupLayout.Alignment.TRAILING, -1, 575, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.testViewerPartitionToolbar1, -2, -1, -2).addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLbl).addComponent(this.jCustomROCButton).addComponent(this.jTargetComb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 468, Short.MAX_VALUE).addContainerGap()));
    }

    private void installROCSummaryActions() {
        this.dataMinerTablePanel.removeSearchField();
        this.jDetailBtn = new JButton(OracleIcons.getIcon((String)"lov.png"));
        this.jDetailBtn.setDisabledIcon(OracleIcons.getIcon((String)"lov.png"));
        this.jDetailBtn.setToolTipText(TestViewerLrb.get("ROC_DETAIL_DIALOG"));
        this.jDetailBtn.addActionListener(new DetailsActionListener());
        if (this._state.getParentTestViewerState().getAllTestResults().size() > 1) {
            this._jBT_AddOrRemove = new JButton(OracleIcons.getIcon((String)"compare.png"));
            this._jBT_AddOrRemove.setDisabledIcon(OracleIcons.getIcon((String)"compare.png"));
            this._jBT_AddOrRemove.setToolTipText(DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TITLE"));
            this._jBT_AddOrRemove.addActionListener(new AddRemoveModelsActionListener());
            this.dataMinerTablePanel.addControlBarComponents(this.jDetailBtn, this._jBT_AddOrRemove);
        } else {
            this.dataMinerTablePanel.addControlBarComponents(this.jDetailBtn);
        }
    }

    @Override
    public void reload() {
        ROCEditor rOCEditor = (ROCEditor)this.getEditor();
        this._state = new ROCTabPanelState(rOCEditor.getCachedLegendState());
        this.setContext(rOCEditor.getContext());
        this._state.setSelectedTargetValue((String)this.jTargetComb.getSelectedItem());
        this.load();
    }

    public Object getCachedPropertyState() {
        return this._state;
    }

    @Override
    public void showData(Object object) {
        this.showDetails();
    }

    private void showDetails() {
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        String string = (String)this._state.getRocTableModel().getValueAt(nArray[0], this._state.getMODEL());
        ROCDetailPanel rOCDetailPanel = new ROCDetailPanel(this.getContext(), string, this._state.getROCData().get(string));
        rOCDetailPanel.showAsDialog(this);
    }

    private void updateRocGraph() {
        this.jRocGraphPanel.removeAll();
        this.jRocGraphPanel.add((Component)this._graphPanel, "Center");
        this.jRocGraphPanel.updateUI();
    }

    private void setupModelsTable() {
        this.dataMinerTablePanel.getTable().setFixedColumns(1, 165);
        this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)this._state.getRocTableModel()));
        this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
        this.dataMinerTablePanel.getTable().setSorted(true);
        TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getModelViewerPercentRenderer();
        TableCellRenderer tableCellRenderer2 = FormatTableCellRenderer.getModelViewerNumericRenderer();
        ColorCellRenderer colorCellRenderer = new ColorCellRenderer(new ColorCellRenderer.ColorChooser(){

            @Override
            public Color getColorFor(Object object) {
                String string = (String)object;
                return ROCTabPanel.this._state.getParentTestViewerState().getTestResultGraphColor(string);
            }
        });
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getFullColumnModel();
        tableColumnModel.getColumn(this._state.getMODEL()).setCellRenderer(colorCellRenderer);
        tableColumnModel.getColumn(this._state.getAREA_UNDER_CURVE()).setCellRenderer(tableCellRenderer2);
        tableColumnModel.getColumn(this._state.getCURRENT()).setCellRenderer(tableCellRenderer);
        tableColumnModel.getColumn(this._state.getCUSTOM()).setCellRenderer(tableCellRenderer);
        tableColumnModel.getColumn(this._state.getMAX_AVG()).setCellRenderer(tableCellRenderer);
        tableColumnModel.getColumn(this._state.getMAX_OVERALL()).setCellRenderer(tableCellRenderer);
        this.dataMinerTablePanel.getTable().autoSizeColumnsToFit();
    }

    private void updateSelectedModelOnTable() {
        String string = this._state.getSelectedTestResult();
        int n = 0;
        if (string == null) {
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < this.dataMinerTablePanel.getTable().getRowCount(); ++i) {
                d = (Double)this._state.getRocTableModel().getValueAt(i, this._state.getAREA_UNDER_CURVE());
                if (!(d2 < d)) continue;
                d2 = d;
                n = i;
            }
        } else {
            for (int i = 0; i < this.dataMinerTablePanel.getTable().getRowCount(); ++i) {
                Object object = this._state.getRocTableModel().getValueAt(i, this._state.getMODEL());
                if (!string.equals(object)) continue;
                n = i;
            }
        }
        this.dataMinerTablePanel.getTable().setRowSelectionInterval(n, n);
    }

    private class TargetComboActionListener
    implements ActionListener {
        private TargetComboActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ROCTabPanel.this._loading) {
                return;
            }
            ROCTabPanel.this._state.setSelectedTargetValue((String)ROCTabPanel.this.jTargetComb.getSelectedItem());
            CalculateRocDataWorker calculateRocDataWorker = new CalculateRocDataWorker();
            calculateRocDataWorker.execute();
        }
    }

    private class CustomROCActionListener
    implements ActionListener {
        private CustomROCActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ThresholdPanel thresholdPanel = new ThresholdPanel(ROCTabPanel.this._state);
            if (thresholdPanel.showAsDialog(ROCTabPanel.this)) {
                ROCTabPanel.this._state.refreshCustomThresholdData();
                CalculateRocDataWorker calculateRocDataWorker = new CalculateRocDataWorker();
                calculateRocDataWorker.execute();
            }
        }
    }

    private class LoadWorker
    extends ODMrSwingWorker<Void, Void> {
        public LoadWorker() {
            super(ROCTabPanel.this, ROCTabPanel.this.overLayPanel, ROCTabPanel.this.dataMinerTablePanel.getTable());
            ROCTabPanel.this._loading = true;
        }

        @Override
        protected void beforeExecute() {
            ROCTabPanel.this.jRocGraphPanel.removeAll();
            ROCTabPanel.this.jRocGraphPanel.add((Component)new JTextArea(CommonLrb.get("LOADING")), "Center");
        }

        @Override
        protected Void doInBackground() throws Exception {
            ROCTabPanel.this.testViewerPartitionToolbar1.load(ROCTabPanel.this.getEditor());
            ROCTabPanel.this.setSelectedPartition();
            ROCTabPanel.this._state.load(ROCTabPanel.this.isEnabledPartitioning());
            ROCTabPanel.this._graphPanel.initGraph(ROCTabPanel.this._state.getRocGraphModel());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            ROCTabPanel.this.updateRocGraph();
            ROCTabPanel.this.setupModelsTable();
            ROCTabPanel.this.updateSelectedModelOnTable();
            this.updateTargetCombo();
        }

        private void updateTargetCombo() {
            String[] stringArray = new String[ROCTabPanel.this._state.getTargetValues().size()];
            ROCTabPanel.this.jTargetComb.setModel(new DefaultComboBoxModel<String>(ROCTabPanel.this._state.getTargetValues().toArray(stringArray)));
            ROCTabPanel.this.jTargetComb.setSelectedItem(ROCTabPanel.this._state.getSelectedTargetValue());
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(ROCTabPanel.this.getEditor().getContext(), throwable, TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
        }

        @Override
        protected void onFinally() {
            ROCTabPanel.this._loading = false;
        }
    }

    private class DetailsActionListener
    implements ActionListener {
        private DetailsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ROCTabPanel.this.showDetails();
        }
    }

    private class AddRemoveModelsActionListener
    implements ActionListener {
        private AddRemoveModelsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TestResultsSelectorPanel testResultsSelectorPanel = new TestResultsSelectorPanel(ROCTabPanel.this.getContext(), ROCTabPanel.this._state.getParentTestViewerState());
            if (testResultsSelectorPanel.showAsDialog(ROCTabPanel.this)) {
                List<TestResult> list = testResultsSelectorPanel.getSelectedTestResults();
                ROCTabPanel.this._state.getParentTestViewerState().setTestResults(list);
                ROCTabPanel.this.load();
            }
        }
    }

    private class CalculateRocDataWorker
    extends ODMrSwingWorker<Void, Void> {
        public CalculateRocDataWorker() {
            super(ROCTabPanel.this, ROCTabPanel.this.overLayPanel, ROCTabPanel.this.dataMinerTablePanel.getTable());
            ROCTabPanel.this._loading = true;
        }

        @Override
        protected void beforeExecute() {
            ROCTabPanel.this.jRocGraphPanel.removeAll();
            ROCTabPanel.this.jRocGraphPanel.add((Component)new JTextArea(CommonLrb.get("LOADING")), "Center");
        }

        @Override
        protected Void doInBackground() throws Exception {
            ROCTabPanel.this._state.refreshROCStatData(ROCTabPanel.this.isEnabledPartitioning());
            ROCTabPanel.this._graphPanel.initGraph(ROCTabPanel.this._state.getRocGraphModel());
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            ROCTabPanel.this.updateRocGraph();
            ROCTabPanel.this.setupModelsTable();
            ROCTabPanel.this.updateSelectedModelOnTable();
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(ROCTabPanel.this.getEditor().getContext(), throwable, TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
        }

        @Override
        protected void onFinally() {
            ROCTabPanel.this._loading = false;
        }
    }
}

