/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.profit;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import oracle.bali.share.nls.StringUtils;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.dal.sql.mapping.clas.common.GetProfitResultsMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.common.GetLiftResultsQuery;
import oracle.dmt.dataminer.core.model.clas.common.ProfitInfo;
import oracle.dmt.dataminer.core.model.common.build.partition.CompareMode;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.BaseTestViewerState;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.workflow.dialog.test.TuneState;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;

public class ProfitTabState
extends BaseTestViewerState {
    private Map<String, Map<String, List<ProfitInfo>>> profitdata;
    private int selectedQuantileValue;
    private int selectedBudgetQuantileValue;
    private double customThresholdValue;
    private ProfitTableModel profitTableModel;
    private DefaultGraphDataModel profitGraphModel;
    private int thresholdSeries;
    private double minCumProfit;
    private double maxCumProfit;
    private double startupost;
    private double incRevenue;
    private double incCost;
    private double population;
    private double budget;
    private int maxQuantileCount;

    public ProfitTabState(SharedTestEditorState sharedTestEditorState) {
        super(sharedTestEditorState);
        this.targetValues = new ArrayList();
        this.profitdata = new HashMap<String, Map<String, List<ProfitInfo>>>();
        this.selectedQuantileValue = 20;
        this.selectedBudgetQuantileValue = 0;
        this.profitGraphModel = new DefaultGraphDataModel(null, 61, null, null, null);
        this.startupost = 1.0;
        this.incRevenue = 1.0;
        this.incCost = 1.0;
        this.population = 100.0;
        this.budget = 1.0;
    }

    public int getRESULT_NAME() {
        return this.profitTableModel.getRESULT_NAME();
    }

    public int getTUNE() {
        return ((ProfitTuneTableModel)this.profitTableModel).getTUNE();
    }

    public int getPROFIT() {
        return this.profitTableModel.getPROFIT();
    }

    public int getROI() {
        return this.profitTableModel.getROI();
    }

    public int getPERCENTAGE_RECORDS_CUMULATIVE() {
        return this.profitTableModel.getPERCENTAGE_RECORDS_CUMULATIVE();
    }

    public int getTARGET_DENSITY_CUMULATIVE() {
        return this.profitTableModel.getTARGET_DENSITY_CUMULATIVE();
    }

    public int getMAX_PROFIT() {
        return this.profitTableModel.getMAX_PROFIT();
    }

    public int getMAX_PROFIT_POPULATION() {
        return this.profitTableModel.getMAX_PROFIT_POPULATION();
    }

    public int getALGORITHM() {
        return this.profitTableModel.getALGORITHM();
    }

    public int getBUILD_ROWS() {
        return this.profitTableModel.getBUILD_ROWS();
    }

    public int getTEST_ROWS() {
        return this.profitTableModel.getTEST_ROWS();
    }

    public int getCREATION_DATE() {
        return this.profitTableModel.getCREATION_DATE();
    }

    public void load(CompareMode compareMode) throws ODMrDAOException {
        boolean bl = CompareMode.isPartitioned((CompareMode)compareMode);
        this.targetValues.clear();
        this.testResults = this.parentState.getTestResults();
        for (TestResult testResult : this.testResults) {
            List<String> list = ((ClassTestResult)testResult).getTargetValues(bl);
            for (String string : list) {
                if (this.targetValues.contains(string)) continue;
                this.targetValues.add(string);
            }
        }
        Object object = null;
        object = bl ? ((ClassTestResult)this.testResults.get(0)).getLeastTargetValue(true, this.parentState.getSelectedPartition()) : ((ClassTestResult)this.testResults.get(0)).getLeastTargetValue(false, null);
        if (object == null || !this.targetValues.contains(object)) {
            object = (String)this.targetValues.get(0);
        }
        this.setSelectedTargetValue((String)object);
        this.loadProfitData(compareMode);
        this.loadProfitGraph();
    }

    public void refreshProfitData(CompareMode compareMode) throws ODMrDAOException {
        this.loadProfitData(compareMode);
        this.loadProfitGraph();
    }

    private void loadProfitData(CompareMode compareMode) throws ODMrDAOException {
        boolean bl = CompareMode.isPartitioned((CompareMode)compareMode);
        if (bl) {
            this.loadProfitDataPartitioned(compareMode);
        } else {
            this.loadProfitDataNonPartitioned(compareMode);
        }
    }

    private void loadProfitDataNonPartitioned(CompareMode compareMode) throws ODMrDAOException {
        TreeMap<String, List<ProfitInfo>> treeMap = new TreeMap<String, List<ProfitInfo>>();
        for (TestResult testResult : this.testResults) {
            GetProfitResultsMapper getProfitResultsMapper;
            List list;
            String string = ((ClassTestResult)testResult).geLiftResultTable(this.getSelectedTargetValue(), false);
            if (string == null) continue;
            String string2 = testResult.toString();
            Map<String, List<ProfitInfo>> map = this.profitdata.get(this.getSelectedTargetValue());
            if (map == null) {
                map = new HashMap<String, List<ProfitInfo>>();
                this.profitdata.put(this.getSelectedTargetValue(), map);
            }
            if ((list = map.get(string2)) == null) {
                getProfitResultsMapper = new GetProfitResultsMapper(testResult.getMiningAlgorithm(), testResult.getCreationTime());
                GetLiftResultsQuery getLiftResultsQuery = new GetLiftResultsQuery(this.connManager.getDbVersion(), (SqlMapper)getProfitResultsMapper, compareMode, string);
                list = this.dao.readItems((Query)getLiftResultsQuery);
                ProfitInfo profitInfo = (ProfitInfo)list.get(list.size() - 1);
                int n = profitInfo.getQuantile();
                while (n < 100) {
                    ProfitInfo profitInfo2 = new ProfitInfo(profitInfo);
                    profitInfo2.setQuantile(Integer.valueOf(++n));
                    list.add(profitInfo2);
                }
                profitInfo = new ProfitInfo();
                list.add(0, profitInfo);
                map.put(string2, list);
            }
            getProfitResultsMapper = map.get(string2);
            treeMap.put(string2, (List<ProfitInfo>)getProfitResultsMapper);
        }
        TuneState tuneState = (TuneState)this.context.getProperty("TUNE_STATE");
        this.profitTableModel = tuneState == null ? new ProfitTableModel(treeMap, false) : new ProfitTuneTableModel(tuneState, treeMap, false);
        double d = (this.getBudget() - this.getStartupCost()) * 100.0 / (this.getPopulation() * this.getIncCost());
        d = Math.min(100.0, Math.max(1.0, d));
        this.setSelectedBudgetQuantileValue((int)d);
        if (this.getSelectedQuantileValue() == 0) {
            int n;
            double d2 = 0.0;
            double d3 = 0.0;
            int n2 = 0;
            for (n = 0; n < treeMap.size(); ++n) {
                d2 = (Double)this.profitTableModel.getValueAt(n, this.getMAX_PROFIT());
                if (!(d3 < d2)) continue;
                d3 = d2;
                n2 = n;
            }
            this.setSelectedTestResult((String)this.profitTableModel.getValueAt(n2, this.getRESULT_NAME()));
            n = (Integer)this.profitTableModel.getValueAt(n2, this.getMAX_PROFIT_POPULATION());
            this.setSelectedQuantileValue(n);
        }
    }

    private void loadProfitDataPartitioned(CompareMode compareMode) throws ODMrDAOException {
        TreeMap<String, List<ProfitInfo>> treeMap = new TreeMap<String, List<ProfitInfo>>();
        String string = this.parentState.getSelectedPartition();
        Map<String, Integer> map = this.parentState.getBuildRowsCount(string, CompareMode.isPartitioned((CompareMode)compareMode));
        for (TestResult testResult : this.testResults) {
            Object object;
            List list;
            ClassTestResult classTestResult;
            ClassTestResult classTestResult2 = classTestResult = testResult instanceof ClassTestResult ? (ClassTestResult)testResult : null;
            if (classTestResult == null) continue;
            Integer n = classTestResult.getTestRows(true, string);
            String string2 = classTestResult.geLiftResultTable(this.getSelectedTargetValue(), true);
            if (string2 == null) continue;
            String string3 = testResult.toString();
            Map<String, List<ProfitInfo>> map2 = this.profitdata.get(this.getSelectedTargetValue());
            if (map2 == null) {
                map2 = new HashMap<String, List<ProfitInfo>>();
                this.profitdata.put(this.getSelectedTargetValue(), map2);
            }
            if ((list = map2.get(string3)) == null) {
                object = map.get(testResult.getName());
                GetProfitResultsMapper getProfitResultsMapper = new GetProfitResultsMapper(testResult.getMiningAlgorithm(), testResult.getCreationTime(), (Integer)object, n);
                GetLiftResultsQuery getLiftResultsQuery = new GetLiftResultsQuery(this.connManager.getDbVersion(), (SqlMapper)getProfitResultsMapper, compareMode, string2);
                getLiftResultsQuery.setPartitionId(string);
                list = this.dao.readItems((Query)getLiftResultsQuery);
                ProfitInfo profitInfo = (ProfitInfo)list.get(list.size() - 1);
                int n2 = profitInfo.getQuantile();
                while (n2 < 100) {
                    ProfitInfo profitInfo2 = profitInfo != null ? new ProfitInfo(profitInfo) : new ProfitInfo(Integer.valueOf(++n2), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), null, null);
                    profitInfo2.setQuantile(Integer.valueOf(n2));
                    list.add(profitInfo2);
                }
                profitInfo = new ProfitInfo(Integer.valueOf(0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), null, null);
                list.add(0, profitInfo);
                map2.put(string3, list);
            }
            object = map2.get(string3);
            treeMap.put(string3, (List<ProfitInfo>)object);
        }
        TuneState tuneState = (TuneState)this.context.getProperty("TUNE_STATE");
        this.profitTableModel = tuneState == null ? new ProfitTableModel(treeMap, true) : new ProfitTuneTableModel(tuneState, treeMap, false);
        double d = (this.getBudget() - this.getStartupCost()) * 100.0 / (this.getPopulation() * this.getIncCost());
        d = Math.min(100.0, Math.max(1.0, d));
        this.setSelectedBudgetQuantileValue((int)d);
        if (this.getSelectedQuantileValue() == 0) {
            int n;
            double d2 = 0.0;
            double d3 = 0.0;
            int n3 = 0;
            for (n = 0; n < treeMap.size(); ++n) {
                d2 = (Double)this.profitTableModel.getValueAt(n, this.getMAX_PROFIT());
                if (!(d3 < d2)) continue;
                d3 = d2;
                n3 = n;
            }
            this.setSelectedTestResult((String)this.profitTableModel.getValueAt(n3, this.getRESULT_NAME()));
            n = (Integer)this.profitTableModel.getValueAt(n3, this.getMAX_PROFIT_POPULATION());
            this.setSelectedQuantileValue(n);
        }
    }

    private void loadProfitGraph() {
        double d;
        Map<String, List<ProfitInfo>> map = this.profitdata.get(this.getSelectedTargetValue());
        this.profitGraphModel.clear();
        this.maxQuantileCount = 0;
        this.maxCumProfit = -1.0 * this.getStartupCost();
        this.minCumProfit = -1.0 * this.getStartupCost();
        ArrayList<Color> arrayList = new ArrayList<Color>();
        int n = 0;
        for (TestResult testResult : this.testResults) {
            String string = testResult.toString();
            List<ProfitInfo> list = map.get(string);
            if (list == null) continue;
            int n2 = list.size();
            if (this.maxQuantileCount < n2) {
                this.maxQuantileCount = n2;
            }
            ++n;
        }
        Object[][] objectArray = new Object[this.maxQuantileCount * 2][n + 2];
        Object[] objectArray2 = new Object[n + 2];
        Object[] objectArray3 = new Object[n + 2];
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getSelectedQuantileValue();
        for (TestResult testResult : this.testResults) {
            String string = testResult.toString();
            List<ProfitInfo> list = map.get(string);
            if (list == null) continue;
            n4 = 0;
            for (int i = 0; i < list.size(); ++i) {
                objectArray[n4++][n3] = (double)i;
                this.setSelectedQuantileValue(i);
                Double d2 = (Double)this.profitTableModel.getValueAt(n3, this.getPROFIT());
                objectArray[n4++][n3] = d2;
                if (d2 > this.maxCumProfit) {
                    this.maxCumProfit = d2;
                }
                if (!(d2 < this.minCumProfit)) continue;
                this.minCumProfit = d2;
            }
            string = (String)this.profitTableModel.getValueAt(n3, this.getRESULT_NAME());
            objectArray2[n3] = "Profit: " + string;
            objectArray3[n3] = 0;
            ++n3;
            Color color = this.parentState.getTestResultGraphColor(string);
            arrayList.add(color);
        }
        this.setSelectedQuantileValue(n5);
        n4 = 0;
        double d3 = this.getSelectedQuantileValue();
        double d4 = this.getSelectedQuantileValue();
        double d5 = this.minCumProfit;
        double d6 = this.maxCumProfit;
        objectArray[n4++][n3] = d3;
        objectArray[n4++][n3] = d5;
        objectArray[n4++][n3] = d4;
        objectArray[n4++][n3] = d6;
        objectArray2[n3] = TestViewerLrb.get("PROFIT_GRAPH_DATA_THRESHOLD");
        objectArray3[n3] = 0;
        this.thresholdSeries = n3++;
        n4 = 0;
        d3 = d = (double)this.getSelectedBudgetQuantileValue();
        d4 = d;
        d5 = this.minCumProfit;
        d6 = this.maxCumProfit;
        objectArray[n4++][n3] = d3;
        objectArray[n4++][n3] = d5;
        objectArray[n4++][n3] = d4;
        objectArray[n4][n3] = d6;
        objectArray2[n3] = TestViewerLrb.get("PROFIT_GRAPH_DATA_BUDGET");
        objectArray3[n3] = 0;
        this.profitGraphModel.addRowLabels(objectArray2);
        this.profitGraphModel.addRowMarkerShapes(objectArray3);
        this.profitGraphModel.addGraphData(objectArray);
        this.profitGraphModel.setLegendVisible(true);
        this.profitGraphModel.setLegendSeriesStart(n);
        this.profitGraphModel.setLegendSeriesCount(2);
        Object[] objectArray4 = new Object[this.maxQuantileCount * 2];
        for (int i = 0; i < objectArray4.length; ++i) {
            objectArray4[i] = "";
        }
        this.profitGraphModel.addColumnLabels(objectArray4);
        arrayList.add(SharedTestEditorState.PROFIT_POPULATION_LINE);
        arrayList.add(SharedTestEditorState.PROFIT_BUDGET_LINE);
        this.profitGraphModel.addRowColors(arrayList.toArray(new Color[arrayList.size()]));
        this.profitGraphModel.setX1(TestViewerLrb.get("X_POPULATION"), this.maxQuantileCount - 1);
        this.profitGraphModel.setY1(TestViewerLrb.get("Y_PROFIT"), this.minCumProfit, this.maxCumProfit);
    }

    public void refreshCustomThresholdData() {
        Object[][] objectArray = this.profitGraphModel.getGraphData();
        this.profitGraphModel.clearGraphData();
        int n = 0;
        double d = this.getSelectedQuantileValue();
        double d2 = this.getSelectedQuantileValue();
        double d3 = this.minCumProfit;
        double d4 = this.maxCumProfit;
        objectArray[n++][this.thresholdSeries] = d;
        objectArray[n++][this.thresholdSeries] = d3;
        objectArray[n++][this.thresholdSeries] = d2;
        objectArray[n][this.thresholdSeries] = d4;
        this.profitGraphModel.addGraphData(objectArray);
        this.profitTableModel.fireTableDataChanged();
    }

    public Map<String, List<ProfitInfo>> getProfitData() {
        return this.profitdata.get(this.getSelectedTargetValue());
    }

    public ProfitTableModel getProfitTableModel() {
        return this.profitTableModel;
    }

    public DefaultGraphDataModel getProfitGraphModel() {
        return this.profitGraphModel;
    }

    public TestResult getSelectedTestResultObj() {
        for (TestResult testResult : this.testResults) {
            if (!testResult.toString().equals(this.getSelectedTestResult())) continue;
            return testResult;
        }
        return null;
    }

    public void setSelectedQuantileValue(int n) {
        this.selectedQuantileValue = n;
    }

    public int getSelectedQuantileValue() {
        return this.selectedQuantileValue;
    }

    public void setCustomThresholdValue(double d) {
        this.customThresholdValue = d;
    }

    public double getCustomThresholdValue() {
        return this.customThresholdValue;
    }

    public void setStartupCost(double d) {
        this.startupost = d;
    }

    public double getStartupCost() {
        return this.startupost;
    }

    public void setIncRevenue(double d) {
        this.incRevenue = d;
    }

    public double getIncRevenue() {
        return this.incRevenue;
    }

    public void setIncCost(double d) {
        this.incCost = d;
    }

    public double getIncCost() {
        return this.incCost;
    }

    public void setPopulation(double d) {
        this.population = d;
    }

    public double getPopulation() {
        return this.population;
    }

    public void setBudget(double d) {
        this.budget = d;
    }

    public double getBudget() {
        return this.budget;
    }

    public void setSelectedBudgetQuantileValue(int n) {
        this.selectedBudgetQuantileValue = n;
    }

    public int getSelectedBudgetQuantileValue() {
        return this.selectedBudgetQuantileValue;
    }

    public int getMaxQuantileCnt() {
        return this.maxQuantileCount;
    }

    public class ProfitTableModel
    extends SimpleBaseTableModel {
        private int _start = 0;
        private int RESULT_NAME = this._start++;
        private int PROFIT = this._start++;
        private int ROI = this._start++;
        private int PERCENTAGE_RECORDS_CUMULATIVE = this._start++;
        private int TARGET_DENSITY_CUMULATIVE = this._start++;
        private int MAX_PROFIT = this._start++;
        private int MAX_PROFIT_POPULATION = this._start++;
        private int ALGORITHM = this._start++;
        private int BUILD_ROWS = -1;
        private int TEST_ROWS = -1;
        private int CREATION_DATE = -1;
        protected Vector<String> _colNames;
        protected Map<String, List<ProfitInfo>> _profitData;
        protected Map<String, ProfitDetail> _maxprofit;

        protected int getRESULT_NAME() {
            return this.RESULT_NAME;
        }

        protected int getPROFIT() {
            return this.PROFIT;
        }

        protected int getROI() {
            return this.ROI;
        }

        protected int getPERCENTAGE_RECORDS_CUMULATIVE() {
            return this.PERCENTAGE_RECORDS_CUMULATIVE;
        }

        protected int getTARGET_DENSITY_CUMULATIVE() {
            return this.TARGET_DENSITY_CUMULATIVE;
        }

        protected int getMAX_PROFIT() {
            return this.MAX_PROFIT;
        }

        protected int getMAX_PROFIT_POPULATION() {
            return this.MAX_PROFIT_POPULATION;
        }

        protected int getALGORITHM() {
            return this.ALGORITHM;
        }

        protected int getBUILD_ROWS() {
            return this.BUILD_ROWS;
        }

        protected int getTEST_ROWS() {
            return this.TEST_ROWS;
        }

        protected int getCREATION_DATE() {
            return this.CREATION_DATE;
        }

        public ProfitTableModel() {
            this(null, false);
        }

        protected void createColumns(boolean bl) {
            if (bl) {
                this._colNames = new Vector();
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("RESULT_NAME")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("PROFIT")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("ROI")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("MAX_PROFIT")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("MAX_PROFIT_POPULATION")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("ALGORITHM")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("BUILD_ROWS")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("TEST_ROWS")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("CREATION_DATE")));
            } else {
                this._colNames = new Vector();
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("RESULT_NAME")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("PROFIT")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("ROI")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("MAX_PROFIT")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("MAX_PROFIT_POPULATION")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("ALGORITHM")));
                this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("CREATION_DATE")));
            }
        }

        protected void updateColumnIndices(boolean bl) {
            if (bl) {
                this.BUILD_ROWS = this._start++;
                this.TEST_ROWS = this._start++;
            }
            this.CREATION_DATE = this._start++;
        }

        public ProfitTableModel(Map<String, List<ProfitInfo>> map, boolean bl) {
            this.createColumns(bl);
            this.updateColumnIndices(bl);
            this.setColumnIdentifiers(this._colNames);
            this._profitData = map;
            if (this._profitData != null) {
                this._maxprofit = new HashMap<String, ProfitDetail>();
                this.findMaxProfit();
                this.setRowCount(this._profitData.size());
            } else {
                this.setRowCount(1);
            }
            this.setColumnCount(this._colNames.size());
        }

        public String getColumnName(int n) {
            return this._colNames.get(n);
        }

        public void findMaxProfit() {
            Object[] objectArray = this._profitData.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                double d = Double.NEGATIVE_INFINITY;
                int n = 1;
                List<ProfitInfo> list = this._profitData.get(objectArray[i]);
                int n2 = list.size();
                double d2 = list.get(n2 - 1).getTargetCum() + list.get(n2 - 1).getNonTargetCum();
                for (int j = 1; j < n2; ++j) {
                    double d3 = list.get(j).getTargetCum();
                    double d4 = list.get(j).getNonTargetCum();
                    double d5 = -1.0 * ProfitTabState.this.getStartupCost() + (ProfitTabState.this.getIncRevenue() * d3 - ProfitTabState.this.getIncCost() * (d3 + d4)) * ProfitTabState.this.getPopulation() / d2;
                    if (!(d < d5)) continue;
                    d = d5;
                    n = list.get(j).getQuantile();
                }
                this._maxprofit.put((String)objectArray[i], new ProfitDetail(d, n));
            }
        }

        public Object getValueAt(int n, int n2) {
            Object[] objectArray = this._profitData.keySet().toArray();
            List<ProfitInfo> list = this._profitData.get(objectArray[n]);
            String string = (String)objectArray[n];
            int n3 = ProfitTabState.this.selectedQuantileValue;
            int n4 = list.size();
            double d = list.get(n4 - 1).getTargetCum() + list.get(n4 - 1).getNonTargetCum();
            double d2 = list.get(n3).getTargetCum();
            double d3 = list.get(n3).getNonTargetCum();
            if (n2 == this.getRESULT_NAME()) {
                return string;
            }
            if (n2 == this.getPROFIT()) {
                double d4 = ProfitTabState.this.getIncRevenue() * d2;
                double d5 = ProfitTabState.this.getIncCost() * (d2 + d3);
                if (d == 0.0) {
                    return 0.0;
                }
                double d6 = -1.0 * ProfitTabState.this.getStartupCost() + (d4 - d5) * ProfitTabState.this.getPopulation() / d;
                return d6;
            }
            if (n2 == this.getROI()) {
                double d7 = ProfitTabState.this.getIncRevenue() * d2;
                double d8 = ProfitTabState.this.getIncCost() * (d2 + d3);
                if (d8 == 0.0) {
                    return 0.0;
                }
                double d9 = (d7 - d8) / d8 * 100.0;
                return d9;
            }
            if (n2 == this.getPERCENTAGE_RECORDS_CUMULATIVE()) {
                return list.get(n3).getPercentRecordsCum();
            }
            if (n2 == this.getTARGET_DENSITY_CUMULATIVE()) {
                return list.get(n3).getTargetDensityCum();
            }
            if (n2 == this.getMAX_PROFIT()) {
                return this._maxprofit.get((Object)string)._maxProfit;
            }
            if (n2 == this.getMAX_PROFIT_POPULATION()) {
                return this._maxprofit.get((Object)string)._maxProfitQuantile;
            }
            if (n2 == this.getALGORITHM()) {
                return list.get(n3).getAlgorithm();
            }
            if (n2 == this.getCREATION_DATE()) {
                return list.get(n3).getCreationDate();
            }
            if (n2 == this.getBUILD_ROWS()) {
                return list.get(n3).getBuildRows();
            }
            if (n2 == this.getTEST_ROWS()) {
                return list.get(n3).getTestRows();
            }
            return "Undefined";
        }

        private class ProfitDetail {
            double _maxProfit;
            int _maxProfitQuantile;

            public ProfitDetail(double d, int n) {
                this._maxProfit = d;
                this._maxProfitQuantile = n;
            }
        }
    }

    public class ProfitTuneTableModel
    extends ProfitTableModel {
        private int _start;
        private int RESULT_NAME;
        private int TUNE;
        private int PROFIT;
        private int ROI;
        private int PERCENTAGE_RECORDS_CUMULATIVE;
        private int TARGET_DENSITY_CUMULATIVE;
        private int MAX_PROFIT;
        private int MAX_PROFIT_POPULATION;
        private int ALGORITHM;
        private int BUILD_ROWS;
        private int TEST_ROWS;
        private int CREATION_DATE;
        private TuneState _tuneState;
        private String TUNE_NONE;
        private String TUNE_BENEFIT;
        private String TUNE_COST;
        private String TUNE_ROC;
        private String TUNE_LIFT;
        private String TUNE_PROFIT;

        @Override
        protected int getRESULT_NAME() {
            return this.RESULT_NAME;
        }

        protected int getTUNE() {
            return this.TUNE;
        }

        @Override
        protected int getPROFIT() {
            return this.PROFIT;
        }

        @Override
        protected int getROI() {
            return this.ROI;
        }

        @Override
        protected int getPERCENTAGE_RECORDS_CUMULATIVE() {
            return this.PERCENTAGE_RECORDS_CUMULATIVE;
        }

        @Override
        protected int getTARGET_DENSITY_CUMULATIVE() {
            return this.TARGET_DENSITY_CUMULATIVE;
        }

        @Override
        protected int getMAX_PROFIT() {
            return this.MAX_PROFIT;
        }

        @Override
        protected int getMAX_PROFIT_POPULATION() {
            return this.MAX_PROFIT_POPULATION;
        }

        @Override
        protected int getALGORITHM() {
            return this.ALGORITHM;
        }

        @Override
        protected int getBUILD_ROWS() {
            return this.BUILD_ROWS;
        }

        @Override
        protected int getTEST_ROWS() {
            return this.TEST_ROWS;
        }

        @Override
        protected int getCREATION_DATE() {
            return this.CREATION_DATE;
        }

        public ProfitTuneTableModel(TuneState tuneState, Map<String, List<ProfitInfo>> map, boolean bl) {
            super(map, bl);
            this._start = 0;
            this.RESULT_NAME = this._start++;
            this.TUNE = this._start++;
            this.PROFIT = this._start++;
            this.ROI = this._start++;
            this.PERCENTAGE_RECORDS_CUMULATIVE = this._start++;
            this.TARGET_DENSITY_CUMULATIVE = this._start++;
            this.MAX_PROFIT = this._start++;
            this.MAX_PROFIT_POPULATION = this._start++;
            this.ALGORITHM = this._start++;
            this.BUILD_ROWS = -1;
            this.TEST_ROWS = -1;
            this.CREATION_DATE = -1;
            this.TUNE_NONE = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_NONE");
            this.TUNE_BENEFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_BENEFIT");
            this.TUNE_COST = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_COST");
            this.TUNE_ROC = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_ROC");
            this.TUNE_LIFT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_LIFT");
            this.TUNE_PROFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_PROFIT");
            this._colNames = new Vector();
            this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("RESULT_NAME")));
            this._colNames.add(PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE"));
            this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("PROFIT")));
            this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("ROI")));
            this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE")));
            this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE")));
            this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("MAX_PROFIT")));
            this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("MAX_PROFIT_POPULATION")));
            this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("ALGORITHM")));
            this._colNames.add(StringUtils.stripMnemonic((String)TestViewerLrb.get("CREATION_DATE")));
            if (bl) {
                this.BUILD_ROWS = this._start++;
                this.TEST_ROWS = this._start++;
            }
            this.CREATION_DATE = this._start++;
            this.setColumnIdentifiers(this._colNames);
            this._tuneState = tuneState;
        }

        @Override
        public String getColumnName(int n) {
            return (String)this._colNames.get(n);
        }

        @Override
        protected void updateColumnIndices(boolean bl) {
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == this.getRESULT_NAME()) {
                return super.getValueAt(n, this.getRESULT_NAME());
            }
            if (n2 == this.getPROFIT()) {
                return super.getValueAt(n, this.getPROFIT());
            }
            if (n2 == this.getROI()) {
                return super.getValueAt(n, this.getROI());
            }
            if (n2 == this.getPERCENTAGE_RECORDS_CUMULATIVE()) {
                return super.getValueAt(n, this.getPERCENTAGE_RECORDS_CUMULATIVE());
            }
            if (n2 == this.getTARGET_DENSITY_CUMULATIVE()) {
                return super.getValueAt(n, this.getTARGET_DENSITY_CUMULATIVE());
            }
            if (n2 == this.getMAX_PROFIT()) {
                return super.getValueAt(n, this.getMAX_PROFIT());
            }
            if (n2 == this.getMAX_PROFIT_POPULATION()) {
                return super.getValueAt(n, this.getMAX_PROFIT_POPULATION());
            }
            if (n2 == this.getALGORITHM()) {
                return super.getValueAt(n, this.getALGORITHM());
            }
            if (n2 == this.getCREATION_DATE()) {
                return super.getValueAt(n, this.getCREATION_DATE());
            }
            if (n2 == this.TUNE) {
                if (this._profitData != null) {
                    Object[] objectArray = this._profitData.keySet().toArray();
                    String string = (String)objectArray[n];
                    if (this._tuneState.isTuningNone(string)) {
                        return this.TUNE_NONE;
                    }
                    if (this._tuneState.isTuningBenefit(string)) {
                        return this.TUNE_BENEFIT;
                    }
                    if (this._tuneState.isTuningCost(string)) {
                        return this.TUNE_COST;
                    }
                    if (this._tuneState.isTuningCustomROC(string)) {
                        return this.TUNE_ROC;
                    }
                    if (this._tuneState.isTuningCustomLift(string)) {
                        return this.TUNE_LIFT;
                    }
                    if (this._tuneState.isTuningCustomProfit(string)) {
                        return this.TUNE_PROFIT;
                    }
                }
            } else if (n2 == this.getBUILD_ROWS() || n2 == this.getTEST_ROWS()) {
                return "";
            }
            return null;
        }
    }
}

