/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.matrix;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.BaseCostMatrixTable;
import oracle.dmt.dataminer.controls.BaseCostMatrixTableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.legend.LegendEvent;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.TestResultsSelectorPanel;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.TestViewerPartitionToolbar;
import oracle.dmt.dataminer.tviewer.matrix.PMatrixEditor;
import oracle.dmt.dataminer.tviewer.matrix.PMatrixSummaryTableModel;
import oracle.dmt.dataminer.tviewer.matrix.PMatrixTabState;
import oracle.dmt.dataminer.tviewer.matrix.PMatrixTableModel;
import oracle.dmt.dataminer.tviewer.matrix.PMatrixTargetCompareTableModel;
import oracle.dmt.dataminer.tviewer.performance.PerformanceMetric;
import oracle.dmt.dataminer.utils.Formats;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;

public class PMatrixPanel
extends DataMinerViewGUI {
    private static final Logger theLogger = Logger.getLogger(PMatrixPanel.class.getName());
    private PMatrixTabState pMatrixTabState;
    private NumberFormat percentageFormat;
    private DataMinerTablePanel dataMinerTablePanel;
    private JComboBox<String> jCBMeasure;
    private JCheckBox jCB_showTotalsAndCost;
    private JComboBox<Object> jCB_testResults;
    private JPanel jCompareResultsPanel;
    private JSplitPane jCompareResultsSplitPane;
    private JComboBox<String> jDisplayCmb;
    private JLabel jDisplayLbl;
    private JLabel jLBMeasure;
    private JLabel jLBTargetDetails;
    private JLabel jLBV_avgAccuracy;
    private JLabel jLBV_overallAccuracy;
    private JLabel jLBV_totalCost;
    private JLabel jLB_PMatrix;
    private JLabel jLB_RowsCols;
    private JLabel jLB_avgAccuracy;
    private JLabel jLB_overallAccuracy;
    private JLabel jLB_testResults;
    private JLabel jLB_totalCost;
    private DataMinerTable jNT_PMatrixDetails;
    private DataMinerTable jNT_PMatrixSummary;
    private GenericTable jNT_TargetDetails;
    private JPanel jPMatrixDetailsPanel;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jSP_PMatrixDetails;
    private JScrollPane jSP_PMatrixSummary;
    private JScrollPane jSP_TargetDeatils;
    private JSeparator jSeparator;
    private JSplitPane jShowDetailSplitPane;
    private JPanel jTargetDetailsPane;
    private TestViewerPartitionToolbar partitionToolbar;
    private JButton jBT_AddOrRemove;

    public PMatrixPanel(PMatrixEditor pMatrixEditor, Context context) {
        super(pMatrixEditor, context);
        this.pMatrixTabState = new PMatrixTabState(pMatrixEditor.getCachedLegendState());
        this.percentageFormat = Formats.ModelViewer.getPercentage();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initRes() {
        ResourceUtils.resLabel((JLabel)this.jDisplayLbl, this.jDisplayCmb, (String)TestViewerLrb.get("LOADING"));
        ResourceUtils.resLabel((JLabel)this.jLB_testResults, this.jCB_testResults, (String)(TestViewerLrb.get("PMATRIX_TEST_RESULTS") + ":"));
        ResourceUtils.resLabel((JLabel)this.jLB_avgAccuracy, (Component)this.jLBV_avgAccuracy, (String)(TestViewerLrb.get("PMATRIX_AVG_ACCURACY") + ":"));
        ResourceUtils.resLabel((JLabel)this.jLB_overallAccuracy, (Component)this.jLBV_overallAccuracy, (String)(TestViewerLrb.get("PMATRIX_OVERALL_ACCURACY") + ":"));
        ResourceUtils.resLabel((JLabel)this.jLB_totalCost, (Component)this.jLBV_totalCost, (String)(TestViewerLrb.get("PMATRIX_TOTAL_COST") + ":"));
        this.jLB_PMatrix.setText(TestViewerLrb.get("PMATRIX") + ":");
        this.jLB_RowsCols.setText(TestViewerLrb.get("PMATRIX_ROWS_COLS") + ":");
        this.jCB_showTotalsAndCost.setText(TestViewerLrb.get("PMATRIX_SHOW_TOTALS_COST") + ":");
        this.jDisplayCmb.removeAllItems();
        this.jDisplayCmb.addItem(TestViewerLrb.get("PMATRIX_DISPLAY_COMPARE"));
        this.jDisplayCmb.addItem(TestViewerLrb.get("PMATRIX_DISPLAY_DETAILS"));
        this.jCBMeasure.removeAllItems();
        this.jCBMeasure.addItem(TestViewerLrb.get("PMATRIX_CORRECT_PREDICTIONS"));
        this.jCBMeasure.addItem(TestViewerLrb.get("PMATRIX_COST"));
        this.jLBTargetDetails.setText(TestViewerLrb.get("TEST_VIEWER_TARGET_VALUE_DETAILS"));
        ResourceUtils.resLabel((JLabel)this.jLBMeasure, this.jCBMeasure, (String)CommonLrb.get("MEASURE"));
    }

    private void initUI() {
        this.jPMatrixDetailsPanel.setVisible(false);
        this.jCompareResultsPanel.setVisible(false);
        this.jDisplayCmb.setVisible(false);
        this.jCB_testResults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = PMatrixPanel.this.jCB_testResults.getSelectedIndex();
                PMatrixPanel.this.displaySelectedTestResults(n);
            }
        });
        this.jCB_showTotalsAndCost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((PMatrixTable)PMatrixPanel.this.jNT_PMatrixDetails).setTotalsAndCostVisible(PMatrixPanel.this.jCB_showTotalsAndCost.isSelected());
            }
        });
        this.jDisplayCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PMatrixPanel.this.jDisplayCmb.getSelectedIndex() == 0) {
                    PMatrixPanel.this.jPMatrixDetailsPanel.setVisible(false);
                    PMatrixPanel.this.jCompareResultsPanel.setVisible(true);
                } else {
                    PMatrixPanel.this.jPMatrixDetailsPanel.setVisible(true);
                    PMatrixPanel.this.jCompareResultsPanel.setVisible(false);
                }
            }
        });
        this.jCBMeasure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PMatrixPanel.this.setCompareModel();
            }
        });
        this.dataMinerTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (PMatrixPanel.this.isLoading()) {
                    return;
                }
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    int[] nArray = PMatrixPanel.this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
                    Vector<String> vector = new Vector<String>();
                    if (nArray != null && nArray.length != 0) {
                        for (int i = 0; i < nArray.length; ++i) {
                            String string = (String)PMatrixPanel.this.pMatrixTabState.getCompareSummaryModel().getValueAt(nArray[i], 0);
                            vector.add(string);
                        }
                        PMatrixPanel.this.pMatrixTabState.setCurrentSelectedTestResults(vector);
                        PMatrixPanel.this.setCompareModel();
                    }
                }
            }
        });
        this.installPMatrixSummaryActions();
        this.jShowDetailSplitPane.setDividerLocation(0.5);
        this.jShowDetailSplitPane.setResizeWeight(0.5);
        this.jCompareResultsSplitPane.setDividerLocation(0.5);
        this.jCompareResultsSplitPane.setResizeWeight(0.5);
    }

    @Override
    public void load() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    @Override
    public void reload() {
        PMatrixEditor pMatrixEditor = (PMatrixEditor)this.getEditor();
        this.pMatrixTabState = new PMatrixTabState(pMatrixEditor.getCachedLegendState());
        this.setContext(pMatrixEditor.getContext());
        this.load();
    }

    private void installPMatrixSummaryActions() {
        this.dataMinerTablePanel.removeSearchField();
        if (this.pMatrixTabState.getParentTestViewerState().getAllTestResults().size() > 1) {
            this.jBT_AddOrRemove = new JButton(OracleIcons.getIcon((String)"compare.png"));
            this.jBT_AddOrRemove.setDisabledIcon(OracleIcons.getIcon((String)"compare.png"));
            this.jBT_AddOrRemove.setToolTipText(DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TITLE"));
            this.jBT_AddOrRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PMatrixPanel.this.addOrRemoveTestResults();
                }
            });
            this.dataMinerTablePanel.addControlBarComponents(this.jBT_AddOrRemove);
        }
    }

    private void addOrRemoveTestResults() {
        TestResultsSelectorPanel testResultsSelectorPanel = new TestResultsSelectorPanel(this.getEditor().getContext(), this.pMatrixTabState.getParentTestViewerState());
        if (testResultsSelectorPanel.showAsDialog(this)) {
            List<TestResult> list = testResultsSelectorPanel.getSelectedTestResults();
            this.pMatrixTabState.getParentTestViewerState().setTestResults(list);
            this.load();
        }
    }

    private void setCompareModel() {
        int n = Integer.MAX_VALUE;
        switch (this.jCBMeasure.getSelectedIndex()) {
            case 1: {
                PMatrixTargetCompareTableModel pMatrixTargetCompareTableModel = this.pMatrixTabState.createPMatrixTargetCompareModel(3);
                this.jNT_TargetDetails.setModel((TableModel)((Object)pMatrixTargetCompareTableModel));
                n = pMatrixTargetCompareTableModel.getTotalValue();
                break;
            }
            default: {
                this.jNT_TargetDetails.setModel((TableModel)((Object)this.pMatrixTabState.createPMatrixTargetCompareModel(5)));
                n = 100;
            }
        }
        this.jNT_TargetDetails.setSorted(true);
        this.jNT_TargetDetails.autoSizeColumnsToFit();
        for (int i = 1; i < this.jNT_TargetDetails.getColumnModel().getColumnCount(); ++i) {
            TableColumn tableColumn = this.jNT_TargetDetails.getColumnModel().getColumn(i);
            tableColumn.setCellRenderer(new HistogramBarRenderer(n, true, this.percentageFormat));
        }
    }

    public void setLegendState(LegendEvent legendEvent) {
        if (this.isLoading() || legendEvent.getTarget() != this.getEditor() || !"LEGEND_ADD_EVENT".equals(legendEvent.getAction())) {
            theLogger.log(Level.FINEST, "In the Add event code");
        }
        this.load();
    }

    private void initComponents() {
        this.jDisplayLbl = new JLabel();
        this.jDisplayCmb = new JComboBox();
        this.jSeparator = new JSeparator();
        this.jPMatrixDetailsPanel = new JPanel();
        this.jLB_avgAccuracy = new JLabel();
        this.jLB_testResults = new JLabel();
        this.jCB_testResults = new JComboBox();
        this.jLBV_avgAccuracy = new JLabel();
        this.jLBV_overallAccuracy = new JLabel();
        this.jLB_overallAccuracy = new JLabel();
        this.jLB_totalCost = new JLabel();
        this.jLBV_totalCost = new JLabel();
        this.jShowDetailSplitPane = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jSP_PMatrixSummary = new JScrollPane();
        this.jNT_PMatrixSummary = new DataMinerTable();
        this.jPanel3 = new JPanel();
        this.jLB_PMatrix = new JLabel();
        this.jLB_RowsCols = new JLabel();
        this.jCB_showTotalsAndCost = new JCheckBox();
        this.jSP_PMatrixDetails = new JScrollPane();
        this.jNT_PMatrixDetails = new PMatrixTable();
        this.jCompareResultsPanel = new JPanel();
        this.jCompareResultsSplitPane = new JSplitPane();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.jTargetDetailsPane = new JPanel();
        this.jLBTargetDetails = new JLabel();
        this.jLBMeasure = new JLabel();
        this.jCBMeasure = new JComboBox();
        this.jSP_TargetDeatils = new JScrollPane();
        this.jNT_TargetDetails = new GenericTable();
        this.partitionToolbar = new TestViewerPartitionToolbar();
        this.jDisplayLbl.setText("Display:");
        this.jLB_avgAccuracy.setText("Average Accuracy:");
        this.jLB_testResults.setText("Test Results:");
        this.jLBV_avgAccuracy.setText("avg");
        this.jLBV_overallAccuracy.setText("overall");
        this.jLB_overallAccuracy.setText("Overall Accuracy:");
        this.jLB_totalCost.setText("Total Cost:");
        this.jLBV_totalCost.setText("cost");
        this.jShowDetailSplitPane.setDividerLocation(100);
        this.jShowDetailSplitPane.setOrientation(0);
        this.jShowDetailSplitPane.setResizeWeight(0.5);
        this.jShowDetailSplitPane.setMinimumSize(new Dimension(0, 0));
        this.jShowDetailSplitPane.setOneTouchExpandable(true);
        this.jSP_PMatrixSummary.setViewportView((Component)((Object)this.jNT_PMatrixSummary));
        GroupLayout groupLayout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 575, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSP_PMatrixSummary, GroupLayout.Alignment.TRAILING, -1, 575, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 99, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSP_PMatrixSummary, -1, 99, Short.MAX_VALUE)));
        this.jShowDetailSplitPane.setTopComponent(this.jPanel2);
        this.jLB_PMatrix.setText("Performance Matrix:");
        this.jLB_RowsCols.setText("Rows=Actual, Columns=Predicted");
        this.jCB_showTotalsAndCost.setText("Show totals and cost");
        this.jCB_showTotalsAndCost.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jSP_PMatrixDetails.setViewportView((Component)((Object)this.jNT_PMatrixDetails));
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSP_PMatrixDetails, GroupLayout.Alignment.TRAILING, -1, 656, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jLB_PMatrix).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLB_RowsCols).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCB_showTotalsAndCost).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLB_PMatrix).addComponent(this.jLB_RowsCols).addComponent(this.jCB_showTotalsAndCost)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSP_PMatrixDetails, -1, 88, Short.MAX_VALUE)));
        this.jShowDetailSplitPane.setRightComponent(this.jPanel3);
        GroupLayout groupLayout3 = new GroupLayout(this.jPMatrixDetailsPanel);
        this.jPMatrixDetailsPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jShowDetailSplitPane, -1, -1, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jLB_testResults).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCB_testResults, -2, 180, -2)).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLB_avgAccuracy).addComponent(this.jLB_overallAccuracy).addComponent(this.jLB_totalCost)).addGap(16, 16, 16).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLBV_overallAccuracy).addComponent(this.jLBV_totalCost).addComponent(this.jLBV_avgAccuracy)))).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCB_testResults, -2, -1, -2).addComponent(this.jLB_testResults)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLB_avgAccuracy).addComponent(this.jLBV_avgAccuracy)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLB_overallAccuracy).addComponent(this.jLBV_overallAccuracy)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLB_totalCost).addComponent(this.jLBV_totalCost)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jShowDetailSplitPane, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jCompareResultsSplitPane.setDividerLocation(110);
        this.jCompareResultsSplitPane.setOrientation(0);
        this.jCompareResultsSplitPane.setResizeWeight(0.4);
        this.jCompareResultsSplitPane.setMinimumSize(new Dimension(0, 0));
        this.jCompareResultsSplitPane.setOneTouchExpandable(true);
        this.jCompareResultsSplitPane.setLeftComponent(this.dataMinerTablePanel);
        this.jLBTargetDetails.setText("Target Value Details:");
        this.jLBMeasure.setText("Measure:");
        this.jNT_TargetDetails.setAutoResizeMode(4);
        this.jSP_TargetDeatils.setViewportView((Component)this.jNT_TargetDetails);
        GroupLayout groupLayout4 = new GroupLayout(this.jTargetDetailsPane);
        this.jTargetDetailsPane.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSP_TargetDeatils, -1, 632, Short.MAX_VALUE).addGroup(groupLayout4.createSequentialGroup().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLBTargetDetails, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout4.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLBMeasure, -2, 58, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCBMeasure, -2, 180, -2))).addContainerGap(303, Short.MAX_VALUE)))));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.jLBTargetDetails).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLBMeasure).addComponent(this.jCBMeasure, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSP_TargetDeatils, -1, 118, Short.MAX_VALUE).addContainerGap()));
        this.jCompareResultsSplitPane.setBottomComponent(this.jTargetDetailsPane);
        GroupLayout groupLayout5 = new GroupLayout(this.jCompareResultsPanel);
        this.jCompareResultsPanel.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.jCompareResultsSplitPane, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.jCompareResultsSplitPane, -1, 306, Short.MAX_VALUE)));
        GroupLayout groupLayout6 = new GroupLayout(this);
        this.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPMatrixDetailsPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout6.createSequentialGroup().addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jCompareResultsPanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.partitionToolbar, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout6.createSequentialGroup().addComponent(this.jDisplayLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jDisplayCmb, -2, 162, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jSeparator, GroupLayout.Alignment.LEADING)))).addContainerGap()));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addGap(6, 6, 6).addComponent(this.partitionToolbar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jDisplayLbl).addComponent(this.jDisplayCmb, -2, -1, -2)).addGap(5, 5, 5).addComponent(this.jSeparator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPMatrixDetailsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCompareResultsPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void displaySelectedTestResults(int n) {
        TestResult testResult = (TestResult)this.jCB_testResults.getItemAt(n);
        BigDecimal bigDecimal = testResult.getId();
        PerformanceMetric performanceMetric = this.pMatrixTabState.getPerformanceMetric(bigDecimal);
        PMatrixTableModel pMatrixTableModel = this.pMatrixTabState.getPerformanceMatrixModel(bigDecimal);
        PMatrixSummaryTableModel pMatrixSummaryTableModel = this.pMatrixTabState.getPerformanceMatrixSummaryModel(bigDecimal);
        if (performanceMetric.getAvgAccuracyOrRoorMeanSqrtErr() != null) {
            this.jLBV_avgAccuracy.setText(this.percentageFormat.format(performanceMetric.getAvgAccuracyOrRoorMeanSqrtErr().doubleValue()));
        }
        if (performanceMetric.getOverallAccuracyOrMeanAbsErr() != null) {
            this.jLBV_overallAccuracy.setText(this.percentageFormat.format(performanceMetric.getOverallAccuracyOrMeanAbsErr().doubleValue()));
        }
        if (performanceMetric.getCostOrMeanPredictValue() == null) {
            this.jLB_totalCost.setVisible(false);
            this.jLBV_totalCost.setVisible(false);
        } else {
            this.jLB_totalCost.setVisible(true);
            this.jLBV_totalCost.setVisible(true);
            if (performanceMetric.getCostOrMeanPredictValue() != null) {
                this.jLBV_totalCost.setText(this.percentageFormat.format(performanceMetric.getCostOrMeanPredictValue().doubleValue()));
            }
        }
        this.jNT_PMatrixSummary.setModel((TableModel)((Object)pMatrixSummaryTableModel));
        this.jNT_PMatrixSummary.setSorted(true);
        this.jNT_PMatrixSummary.setAutoResizeMode(0);
        TableColumnModel tableColumnModel = this.jNT_PMatrixSummary.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(165);
        tableColumnModel.getColumn(1).setPreferredWidth(130);
        tableColumnModel.getColumn(2).setPreferredWidth(130);
        tableColumnModel.getColumn(3).setPreferredWidth(75);
        tableColumnModel.getColumn(4).setPreferredWidth(75);
        TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getIntegerRenderer();
        TableCellRenderer tableCellRenderer2 = FormatTableCellRenderer.getModelViewerNumericRenderer();
        TableCellRenderer tableCellRenderer3 = FormatTableCellRenderer.getModelViewerPercentRenderer();
        tableColumnModel.getColumn(1).setCellRenderer(tableCellRenderer);
        tableColumnModel.getColumn(2).setCellRenderer(tableCellRenderer3);
        tableColumnModel.getColumn(3).setCellRenderer(tableCellRenderer2);
        tableColumnModel.getColumn(4).setCellRenderer(tableCellRenderer3);
        ((PMatrixTable)this.jNT_PMatrixDetails).setModel(pMatrixTableModel);
        ((PMatrixTable)this.jNT_PMatrixDetails).setTotalsAndCostVisible(this.jCB_showTotalsAndCost.isSelected());
        this.jNT_PMatrixDetails.setSorted(false);
        this.jNT_PMatrixDetails.setAutoResizeMode(0);
        this.jNT_PMatrixDetails.setColumnSelectorAvailable(false);
        tableColumnModel = this.jNT_PMatrixDetails.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(70);
        }
    }

    private boolean isEnabledPartitioning() {
        PMatrixEditor pMatrixEditor = (PMatrixEditor)this.getEditor();
        return pMatrixEditor.getCachedLegendState().isEnabledPartitioning();
    }

    public void setSelectedPartition() {
        if (!this.partitionToolbar.isVisible()) {
            return;
        }
        String string = this.partitionToolbar.getSelectedPartitionID();
        PMatrixEditor pMatrixEditor = (PMatrixEditor)this.getEditor();
        pMatrixEditor.getCachedLegendState().setSelectedPartition(string);
    }

    private class LoadUI
    extends ODMrSwingWorker<Void, Void> {
        public LoadUI() {
            super(PMatrixPanel.this, PMatrixPanel.this.overLayPanel);
            PMatrixPanel.this.setLoading(true);
        }

        @Override
        protected Void doInBackground() throws Exception {
            PMatrixPanel.this.partitionToolbar.load(PMatrixPanel.this.getEditor());
            PMatrixPanel.this.setSelectedPartition();
            if (PMatrixPanel.this.isEnabledPartitioning()) {
                PMatrixPanel.this.pMatrixTabState.loadPartitioned(PMatrixPanel.this.partitionToolbar.getCompareMode());
            } else {
                PMatrixPanel.this.pMatrixTabState.load(PMatrixPanel.this.partitionToolbar.getCompareMode());
            }
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            Object[] objectArray = PMatrixPanel.this.pMatrixTabState.getParentTestViewerState().getTestResults().toArray();
            PMatrixPanel.this.jCB_testResults.setModel(new DefaultComboBoxModel<Object>(objectArray));
            PMatrixPanel.this.jCB_testResults.setSelectedIndex(0);
            PMatrixPanel.this.jDisplayLbl.setText(TestViewerLrb.get("PMATRIX_DISPLAY") + ":");
            PMatrixPanel.this.jDisplayCmb.setVisible(true);
            PMatrixPanel.this.dataMinerTablePanel.getTable().setFixedColumns(1, 165);
            PMatrixPanel.this.dataMinerTablePanel.getTable().setSelectionMode(2);
            PMatrixPanel.this.dataMinerTablePanel.getTable().setModel((TableModel)PMatrixPanel.this.pMatrixTabState.getCompareSummaryModel());
            PMatrixPanel.this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
            PMatrixPanel.this.dataMinerTablePanel.getTable().setSorted(true);
            TableColumnModel tableColumnModel = PMatrixPanel.this.dataMinerTablePanel.getTable().getFullColumnModel();
            tableColumnModel.getColumn(1).setPreferredWidth(300);
            tableColumnModel.getColumn(2).setPreferredWidth(150);
            tableColumnModel.getColumn(3).setPreferredWidth(110);
            tableColumnModel.getColumn(4).setPreferredWidth(80);
            TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getIntegerRenderer();
            TableCellRenderer tableCellRenderer2 = FormatTableCellRenderer.getModelViewerNumericRenderer();
            tableColumnModel.getColumn(1).setCellRenderer(new HistogramBarRenderer(100.0, true, PMatrixPanel.this.percentageFormat));
            tableColumnModel.getColumn(2).setCellRenderer(tableCellRenderer);
            tableColumnModel.getColumn(3).setCellRenderer(tableCellRenderer);
            tableColumnModel.getColumn(4).setCellRenderer(tableCellRenderer2);
            if (PMatrixPanel.this.jDisplayCmb.getSelectedIndex() == 0) {
                PMatrixPanel.this.jPMatrixDetailsPanel.setVisible(false);
                PMatrixPanel.this.jCompareResultsPanel.setVisible(true);
            } else {
                PMatrixPanel.this.jPMatrixDetailsPanel.setVisible(true);
                PMatrixPanel.this.jCompareResultsPanel.setVisible(false);
            }
            if (objectArray.length <= 1) {
                PMatrixPanel.this.jLB_testResults.setVisible(false);
                PMatrixPanel.this.jCB_testResults.setVisible(false);
                PMatrixPanel.this.jDisplayLbl.setVisible(false);
                PMatrixPanel.this.jDisplayCmb.setVisible(false);
                PMatrixPanel.this.jSeparator.setVisible(false);
                PMatrixPanel.this.jPMatrixDetailsPanel.setVisible(true);
                PMatrixPanel.this.jCompareResultsPanel.setVisible(false);
            }
            PMatrixPanel.this.jNT_PMatrixDetails.setAutoResizeMode(0);
            PMatrixPanel.this.setCompareModel();
            PMatrixPanel.this.setLoaded(true);
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(PMatrixPanel.this.getEditor().getContext(), throwable, TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"));
        }

        @Override
        protected void onFinally() {
            PMatrixPanel.this.setLoading(false);
        }
    }

    private static class PMatrixTable
    extends BaseCostMatrixTable {
        boolean totalsAndCostVisible;
        private PMatrixTableModel _model;

        private PMatrixTable() {
        }

        @Override
        public void setModel(BaseCostMatrixTableModel baseCostMatrixTableModel) {
            super.setModel(baseCostMatrixTableModel);
            this._model = (PMatrixTableModel)baseCostMatrixTableModel;
            this.setHighlights(this._model.getTotalAndCostColumnIndexes(), this._model.getTotalAndCostRowIndexes(), new int[][]{{this._model.getTotalAndCostRowIndexes()[0], this._model.getTotalAndCostColumnIndexes()[0]}});
        }

        public synchronized void setTotalsAndCostVisible(boolean bl) {
            int[] nArray;
            int n;
            this._model.hide(!bl);
            int[] nArray2 = this._model.getTotalAndCostColumnIndexes();
            TableColumn[] tableColumnArray = this._model.getHiddenColumns();
            int n2 = this.getColumnModel().getColumnCount();
            if (tableColumnArray == null) {
                n = n2 - nArray2.length;
                ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
                for (int i = 0; i < nArray2.length; ++i) {
                    if (nArray2[i] < n) continue;
                    TableColumn tableColumn = this.getColumnModel().getColumn(nArray2[i]);
                    arrayList.add(tableColumn);
                }
                if (!arrayList.isEmpty()) {
                    tableColumnArray = arrayList.toArray(new TableColumn[arrayList.size()]);
                }
                this._model.setHiddenColumns(tableColumnArray);
            }
            if (bl) {
                if (!this.totalsAndCostVisible) {
                    for (n = 0; n < nArray2.length; ++n) {
                        this.setColumnVisible(tableColumnArray[n], nArray2[n], true);
                    }
                    this.setHiddenColumns(new int[0]);
                }
            } else if (n2 > 1 && ((nArray = this.getHiddenColumns()) == null || nArray.length == 0)) {
                this.setHiddenColumns(nArray2);
            }
            this.totalsAndCostVisible = bl;
        }
    }
}

