/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.property;

import java.util.ArrayList;
import javax.swing.JPanel;
import oracle.dmt.dataminer.DataMinerViewEvent;
import oracle.dmt.dataminer.DataMinerViewListener;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.property.PropertyEvent;
import oracle.dmt.dataminer.property.PropertyImplementer;
import oracle.dmt.dataminer.property.PropertyListener;

public abstract class PropertyWindowGUI
extends JPanel
implements PropertyImplementer,
DataminerGUIPanel,
DataMinerViewListener {
    private Object _propertyListenerLock = new Object();
    protected ArrayList<PropertyListener> _propertyListeners = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyListener(PropertyListener propertyListener) {
        Object object = this._propertyListenerLock;
        synchronized (object) {
            if (this._propertyListeners == null) {
                this._propertyListeners = new ArrayList();
            }
            this._propertyListeners.add(propertyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyListener(PropertyListener propertyListener) {
        Object object = this._propertyListenerLock;
        synchronized (object) {
            this._propertyListeners.remove(propertyListener);
        }
    }

    private void fireEvent(PropertyListenerHandler propertyListenerHandler, PropertyEvent propertyEvent) {
        ArrayList<PropertyListener> arrayList = this.cloneToAvoidConcurrentModificationException(this._propertyListeners);
        for (PropertyListener propertyListener : arrayList) {
            propertyListenerHandler.handle(propertyListener, propertyEvent);
        }
    }

    private ArrayList<PropertyListener> cloneToAvoidConcurrentModificationException(ArrayList<PropertyListener> arrayList) {
        return (ArrayList)arrayList.clone();
    }

    protected void firePropertyEvent(PropertyEvent propertyEvent) {
        try {
            this.fireEvent(new PropertyListenerHandler(){

                @Override
                public void handle(PropertyListener propertyListener, PropertyEvent propertyEvent) {
                    propertyListener.selectionEvent(propertyEvent);
                }
            }, propertyEvent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void viewPropertySelectionChange(DataMinerViewEvent dataMinerViewEvent) {
    }

    private static interface PropertyListenerHandler {
        public void handle(PropertyListener var1, PropertyEvent var2);
    }
}

