/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.features;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.mviewer.features.FeatureCoefficientsPanel;
import oracle.dmt.dataminer.mviewer.features.FeatureFilterPanel;
import oracle.dmt.dataminer.mviewer.features.FeatureViewerState;
import oracle.dmt.dataminer.navigator.modelnodes.AbstractModelNode;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.Context;
import oracle.ide.editor.Editor;

public class FeatureViewerMainPanel
extends DataMinerViewGUI {
    private JSplitPane splitPane;
    private FeatureViewerState state;
    private FeatureFilterPanel filterPanel;
    private FeatureCoefficientsPanel coefficientsPanel;

    public FeatureViewerMainPanel(Editor editor, Context context) {
        super(editor, context);
        this.state = new FeatureViewerState(context);
        this.initComponents();
        this.addListeners();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.filterPanel = new FeatureFilterPanel(this.state, this.getEditor());
        this.coefficientsPanel = new FeatureCoefficientsPanel(this.state);
        this.splitPane = new JSplitPane(0, this.filterPanel, this.coefficientsPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(400);
        this.add((Component)this.splitPane, "Center");
    }

    private void addListeners() {
        this.filterPanel.addQueryListener(new FeatureQueryListener());
        this.filterPanel.addPropertyChangeListener(new TagCloudFilterListener());
        this.filterPanel.addListSelectionListenerToFeatureGrid(new FeatureSelectionListener());
        this.coefficientsPanel.addRefreshAction(new CoefficientQueryListener());
    }

    @Override
    public void load() {
        LoadWorker loadWorker = new LoadWorker();
        loadWorker.execute();
    }

    private void fireCoefficientQueryWorker() {
        CoefficientQueryWorker coefficientQueryWorker = new CoefficientQueryWorker();
        coefficientQueryWorker.execute();
    }

    private class FeatureQueryListener
    implements ActionListener {
        private FeatureQueryListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FeatureQueryWorker featureQueryWorker = new FeatureQueryWorker();
            featureQueryWorker.execute();
        }
    }

    private class TagCloudFilterListener
    implements PropertyChangeListener {
        private TagCloudFilterListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            FeatureViewerMainPanel.this.coefficientsPanel.enableTagCloudFilter(bl);
        }
    }

    private class FeatureSelectionListener
    implements ListSelectionListener {
        private FeatureSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            if (FeatureViewerMainPanel.this.filterPanel.getSelectedFeature() != null && !FeatureViewerMainPanel.this.filterPanel.getSelectedFeature().equals(FeatureViewerMainPanel.this.state.getSelectedFeature())) {
                FeatureViewerMainPanel.this.state.setSelectedFeature(FeatureViewerMainPanel.this.filterPanel.getSelectedFeature());
                FeatureViewerMainPanel.this.fireCoefficientQueryWorker();
            }
        }
    }

    private class CoefficientQueryListener
    implements ActionListener {
        private CoefficientQueryListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FeatureViewerMainPanel.this.fireCoefficientQueryWorker();
        }
    }

    private class LoadWorker
    extends ODMrSwingWorker<Void, Void> {
        public LoadWorker() {
            super(FeatureViewerMainPanel.this, FeatureViewerMainPanel.this.overLayPanel, FeatureViewerMainPanel.this.filterPanel.getFilterTable(), FeatureViewerMainPanel.this.filterPanel.getResultTable());
            FeatureViewerMainPanel.this.coefficientsPanel.clearTagCloud();
        }

        @Override
        protected Void doInBackground() throws Exception {
            FeatureViewerMainPanel.this.filterPanel.loadPartitionToolbar();
            this.loadInputAttributesIntoState();
            String string = FeatureViewerMainPanel.this.filterPanel.getPartitionId();
            FeatureViewerMainPanel.this.filterPanel.updateRenderingQueriesPartitionId(string);
            FeatureViewerMainPanel.this.state.loadPartitionData(string);
            return null;
        }

        private void loadInputAttributesIntoState() throws ODMrDAOException {
            AbstractModelNode abstractModelNode = (AbstractModelNode)FeatureViewerMainPanel.this.getContext().getNode().getData();
            Object object = abstractModelNode.getRepositoryData();
            List<MiningAttributeType> list = object instanceof ModelType ? this.getInputAttributesFromMetaData((ModelType)object) : FeatureViewerMainPanel.this.state.getInputAttributesFromDB();
            FeatureViewerMainPanel.this.state.setInputAttributes(list);
        }

        private List<MiningAttributeType> getInputAttributesFromMetaData(ModelType modelType) {
            return modelType.getInputMiningData().getMiningAttributes().getMiningAttribute();
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            FeatureViewerMainPanel.this.filterPanel.enableFilters();
            FeatureViewerMainPanel.this.filterPanel.afterLoad();
        }
    }

    private class CoefficientQueryWorker
    extends ODMrSwingWorker<Void, Void> {
        private CoefficientQueryWorker() {
            super(FeatureViewerMainPanel.this, FeatureViewerMainPanel.this.overLayPanel, FeatureViewerMainPanel.this.coefficientsPanel.getCoefficientsTable());
        }

        @Override
        protected Void doInBackground() throws Exception {
            FeatureViewerMainPanel.this.state.loadSelectedFeatureCoefficients();
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            FeatureViewerMainPanel.this.coefficientsPanel.clearTagCloud();
            FeatureViewerMainPanel.this.coefficientsPanel.drawTagCloud();
        }
    }

    private class FeatureQueryWorker
    extends ODMrSwingWorker<Void, Void> {
        private FeatureQueryWorker() {
            super(FeatureViewerMainPanel.this, FeatureViewerMainPanel.this.overLayPanel, FeatureViewerMainPanel.this.filterPanel.getResultTable());
        }

        @Override
        protected Void doInBackground() throws Exception {
            String string = FeatureViewerMainPanel.this.filterPanel.getPartitionId();
            FeatureViewerMainPanel.this.state.loadPartitionData(string);
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            FeatureViewerMainPanel.this.filterPanel.afterLoad();
            FeatureViewerMainPanel.this.coefficientsPanel.clearTagCloud();
        }
    }
}

