/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import java.awt.Component;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.models.SingleColumnTableModel;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.clus.em.GetComponentsQuery;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.ide.Context;

public class ClusterComponentPane
extends JPanel {
    private static final int COMPONENT_ID = 0;
    private ClusTreeNode treeNode;
    private ConnectionManager connManager;
    private SqlDataAccessObject dao;
    private ModelDescriptor modelDesc;
    private SingleColumnTableModel<String> tableModel;
    private JScrollPane scrollPane;
    private DataMinerTable valuesTable;

    public ClusterComponentPane(ClusTreeNode clusTreeNode, String string) {
        this.treeNode = clusTreeNode;
        Context context = this.treeNode.getModel().getContext();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        this.connManager = connectionFolder;
        this.dao = new SqlDataAccessObject(this.connManager);
        this.initModelDesc(connectionFolder, context, string);
        this.initComponents();
        this.initUI();
        this.loadClusterComponents();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.valuesTable = new DataMinerTable();
        this.valuesTable.setModel(new DefaultTableModel(new Object[][]{{null}, {null}, {null}, {null}}, new String[]{"Component ID"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class};
                this.canEdit = new boolean[]{false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.scrollPane.setViewportView((Component)((Object)this.valuesTable));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 475, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, GroupLayout.Alignment.TRAILING, -1, 132, Short.MAX_VALUE));
    }

    private void initModelDesc(ConnectionFolder connectionFolder, Context context, String string) {
        this.modelDesc = new ModelDescriptor(connectionFolder.getUserAccountName(), context.getNode().getShortLabel(), string);
    }

    private void initUI() {
        this.initTable();
    }

    private void initTable() {
        this.tableModel = new SingleColumnTableModel(ClusteringTreeEditorLrb.get("COMPONENT_ID_COLUMN"));
        this.valuesTable.setModel((TableModel)((Object)this.tableModel));
        this.valuesTable.setSortColumn(0, true);
        this.valuesTable.setAutoResizeMode(3);
        this.valuesTable.setRolloverHighlightingEnabled(false);
        this.valuesTable.setDragEnabled(true);
    }

    private void loadClusterComponents() {
        Worker worker = new Worker();
        worker.execute();
    }

    private List<String> getClusterComponents() throws ODMrDAOException {
        List list = this.treeNode.findAllChildNodes().stream().map(clusTreeNode -> clusTreeNode.getData().getId().toString()).collect(Collectors.toList());
        list.add(this.treeNode.getData().getId().toString());
        GetComponentsQuery getComponentsQuery = new GetComponentsQuery(this.connManager.getDbVersion(), this.modelDesc, list);
        return this.dao.readItems((Query)getComponentsQuery);
    }

    private class Worker
    extends ODMrSwingWorker<List<String>, Void> {
        private Worker() {
            super(ClusterComponentPane.this, null, ClusterComponentPane.this.valuesTable);
        }

        @Override
        public List<String> doInBackground() throws Exception {
            List<String> list = ClusterComponentPane.this.getClusterComponents();
            return list;
        }

        @Override
        protected void onSuccess(List<String> list) throws Exception {
            ClusterComponentPane.this.tableModel.setSrcData(list);
            ClusterComponentPane.this.valuesTable.setNoEntryInstructionText(ClusteringTreeEditorLrb.get("NO_COMPONENTS_FOUND"));
        }
    }
}

