/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules.rules;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.ar.Rule;
import oracle.dmt.dataminer.core.model.ar.RuleAggregateData;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.core.utils.comparator.NumberComparator;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.core.utils.res.ARLrb;
import oracle.javatools.util.Version;

public class ARRulesViewerTableModel
extends ODMrTableModel<Rule> {
    static final String[] COLUMN_NAMES = new String[]{CoreCommonLrb.get((String)"ID"), ARLrb.get((String)"ANTECEDENT"), ARLrb.get((String)"CONSEQUENT"), ARLrb.get((String)"LIFT"), ARLrb.get((String)"CONFIDENCE_PERCENT"), ARLrb.get((String)"SUPPORT_PERCENT"), ARLrb.get((String)"ITEMS_IN_RULE"), ARLrb.get((String)"ANTECENT_SUPPORT_PERCENT"), ARLrb.get((String)"CONSEQUENT_SUPPORT_PERCENT")};
    static final String[] COLUMN_NAMES_12_2 = new String[]{CoreCommonLrb.get((String)"ID"), ARLrb.get((String)"ANTECEDENT"), ARLrb.get((String)"CONSEQUENT"), ARLrb.get((String)"LIFT"), ARLrb.get((String)"CONFIDENCE_PERCENT"), ARLrb.get((String)"SUPPORT_PERCENT"), ARLrb.get((String)"ITEMS_IN_RULE"), ARLrb.get((String)"ANTECENT_SUPPORT_PERCENT"), ARLrb.get((String)"CONSEQUENT_SUPPORT_PERCENT"), ARLrb.get((String)"REV_CONFIDENCE")};
    static final int RULE_ID = 0;
    static final int ANTECEDENT = 1;
    static final int CONSEQUENT = 2;
    static final int LIFT = 3;
    static final int CONFIDENCE = 4;
    static final int SUPPORT = 5;
    static final int NUMBER_OF_ITEMS = 6;
    static final int ANTECEDENT_SUPPPORT = 7;
    static final int CONSEQUENT_SUPPORT = 8;
    static final int REVERSE_CONFIDENCE = 9;
    static final int AGGREGATES_INFO_LENGTH = 8;
    private List<String> aggregates = Collections.emptyList();
    private int lastColumnIndex;

    public ARRulesViewerTableModel(Version version) {
        if (DbVersionHelper.isDB122Up((Version)version)) {
            this.setColumnIdentifiers(COLUMN_NAMES_12_2);
        } else {
            this.setColumnIdentifiers(COLUMN_NAMES);
        }
        this.lastColumnIndex = this.getColumnCount();
    }

    public ARRulesViewerTableModel(Version version, List<String> list) {
        this(version);
        this.aggregates = list;
        this.setAggregateColumns();
    }

    private void setAggregateColumns() {
        for (String string : this.aggregates) {
            this.addColumn(MessageFormat.format(ARLrb.get((String)"AGGREGATE_FOR_RULE"), string));
            this.addColumn(MessageFormat.format(ARLrb.get((String)"AGGREGATE_FOR_ANTECEDENT"), string));
            this.addColumn(MessageFormat.format(ARLrb.get((String)"AGGREGATE_FOR_CONSEQUENT"), string));
            this.addColumn(MessageFormat.format(ARLrb.get((String)"AGGREGATE_FOR_ANTECEDENT_ITEMSET"), string));
            this.addColumn(MessageFormat.format(ARLrb.get((String)"AGGREGATE_FOR_CONSEQUENT_ITEMSET"), string));
            this.addColumn(MessageFormat.format(ARLrb.get((String)"AGGREGATE_FOR_RULE_AVG"), string));
            this.addColumn(MessageFormat.format(ARLrb.get((String)"AGGREGATE_FOR_ANTECEDENT_AVG"), string));
            this.addColumn(MessageFormat.format(ARLrb.get((String)"AGGREGATE_FOR_CONSEQUENT_AVG"), string));
        }
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        Rule rule = (Rule)this.srcData.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = rule.getId();
                break;
            }
            case 1: {
                object = rule.getFullAntecedent();
                break;
            }
            case 2: {
                object = rule.getFullConsequent();
                break;
            }
            case 3: {
                object = rule.getLift();
                break;
            }
            case 4: {
                if (rule.getConfidence() == null) break;
                object = rule.getConfidence() * 100.0;
                break;
            }
            case 5: {
                if (rule.getSupport() == null) break;
                object = rule.getSupport() * 100.0;
                break;
            }
            case 6: {
                object = rule.getNumberOfItems();
                break;
            }
            case 7: {
                if (rule.getAntecedentSupport() == null) break;
                object = rule.getAntecedentSupport() * 100.0;
                break;
            }
            case 8: {
                if (rule.getConsequentSupport() == null) break;
                object = rule.getConsequentSupport() * 100.0;
                break;
            }
            case 9: {
                if (rule.getReverseConfidence() == null) break;
                object = rule.getReverseConfidence() * 100.0;
                break;
            }
            default: {
                int n3 = (n2 - this.lastColumnIndex) / 8;
                int n4 = (n2 - this.lastColumnIndex) % 8;
                String string = this.aggregates.get(n3);
                object = this.getAggregateColumnData(n4, rule.getAggregateData(string));
            }
        }
        return object == null ? "NULL" : object;
    }

    private Double getAggregateColumnData(int n, RuleAggregateData ruleAggregateData) {
        Double d = 0.0;
        switch (n) {
            case 0: {
                d = ruleAggregateData.getRule();
                break;
            }
            case 1: {
                d = ruleAggregateData.getAntecedentRule();
                break;
            }
            case 2: {
                d = ruleAggregateData.getConsequentRule();
                break;
            }
            case 3: {
                d = ruleAggregateData.getAntecedentItemset();
                break;
            }
            case 4: {
                d = ruleAggregateData.getConsequentItemset();
                break;
            }
            case 5: {
                d = ruleAggregateData.getRuleAvg();
                break;
            }
            case 6: {
                d = ruleAggregateData.getAntecedentRuleAvg();
                break;
            }
            case 7: {
                d = ruleAggregateData.getConsequentRuleAvg();
                break;
            }
            default: {
                assert (false) : "Invalid option";
                break;
            }
        }
        return d;
    }

    public Comparator getColumnSortComparator(int n) {
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return NumberComparator.getComparator();
            }
        }
        return super.getColumnSortComparator(n);
    }

    int getLastColumnIndex() {
        return this.lastColumnIndex;
    }
}

