/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.res.CoreCommonLrb;
import oracle.dmt.dataminer.mviewer.arrules.ARMetricDetailsType;
import oracle.dmt.dataminer.mviewer.arrules.ARObjectDetailsExporter;
import oracle.dmt.dataminer.mviewer.arrules.ARPreferences;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.arrules.formatters.ARObjectAbstractFormatter;
import oracle.dmt.dataminer.utils.UITools;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.Ellipses;

public abstract class ARSaveObjectPanel<O>
extends JPanel
implements DataminerGUIPanel,
DialogDisplayable {
    private static ARPreferences preferences = ARPreferences.getInstance();
    protected List<O> selectedItems;
    private File selectedFile;
    private DataMinerTable srcTable;
    private boolean hasAggregates;
    protected JRadioButton jAllItemsRadio;
    protected JLabel jDestinationLbl;
    private ButtonGroup jDestinationRadioGroup;
    protected JComboBox<ARMetricDetailsType> jMetricDetailsCombo;
    protected JLabel jMetricDetailsLbl;
    protected JLabel jObjectLbl;
    private ButtonGroup jRulesRadioGroup;
    protected JRadioButton jSelectedItemsRadio;
    protected JRadioButton jToClipboarsRadio;
    protected JRadioButton jToFileRadio;
    private JLabel jToFileUrlLbl;

    public ARSaveObjectPanel() {
        this.initComponents();
    }

    public ARSaveObjectPanel(DataMinerTable dataMinerTable, boolean bl) {
        this.srcTable = dataMinerTable;
        this.selectedItems = this.getSelectedItems();
        this.hasAggregates = bl;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private List<O> getSelectedItems() {
        int[] nArray = this.srcTable.getSelectedRowsInModel();
        List list = ((ODMrTableModel)((Object)this.srcTable.getModel())).getSrcData();
        ArrayList arrayList = new ArrayList();
        for (int n : nArray) {
            arrayList.add(list.get(n));
        }
        return arrayList;
    }

    private void initComponents() {
        this.jRulesRadioGroup = new ButtonGroup();
        this.jDestinationRadioGroup = new ButtonGroup();
        this.jMetricDetailsLbl = new JLabel();
        this.jMetricDetailsCombo = new JComboBox();
        this.jObjectLbl = new JLabel();
        this.jAllItemsRadio = new JRadioButton();
        this.jSelectedItemsRadio = new JRadioButton();
        this.jDestinationLbl = new JLabel();
        this.jToClipboarsRadio = new JRadioButton();
        this.jToFileRadio = new JRadioButton();
        this.jToFileUrlLbl = new JLabel();
        this.jMetricDetailsLbl.setText("Metric Details");
        this.jObjectLbl.setText("Rules");
        this.jRulesRadioGroup.add(this.jAllItemsRadio);
        this.jAllItemsRadio.setText("All Rules");
        this.jRulesRadioGroup.add(this.jSelectedItemsRadio);
        this.jSelectedItemsRadio.setText("Selected Rules");
        this.jDestinationLbl.setText("Destination");
        this.jDestinationRadioGroup.add(this.jToClipboarsRadio);
        this.jToClipboarsRadio.setSelected(true);
        this.jToClipboarsRadio.setText("To Clipboard");
        this.jDestinationRadioGroup.add(this.jToFileRadio);
        this.jToFileRadio.setText("To File");
        this.jToFileUrlLbl.setText("(C:\\Documents ... Rules.html)");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jMetricDetailsLbl, -2, 218, -2).addComponent(this.jObjectLbl, -2, 218, -2).addComponent(this.jDestinationLbl, -2, 218, -2).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMetricDetailsCombo, 0, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedItemsRadio, GroupLayout.Alignment.TRAILING, -2, 208, -2).addComponent(this.jAllItemsRadio, -2, 208, -2).addComponent(this.jToClipboarsRadio, -2, 208, -2).addComponent(this.jToFileRadio, -2, 208, -2))))).addComponent(this.jToFileUrlLbl, -2, 193, -2)).addGap(6, 6, 6)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jMetricDetailsLbl, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jMetricDetailsCombo, -2, -1, -2).addGap(6, 6, 6).addComponent(this.jObjectLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAllItemsRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectedItemsRadio).addGap(6, 6, 6).addComponent(this.jDestinationLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToClipboarsRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToFileRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToFileUrlLbl).addGap(13, 13, 13)));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jMetricDetailsLbl, this.jMetricDetailsCombo, (String)ARRulesLrb.get("SAVE_OBJECT_METRIC_DETAILS"));
        DefaultComboBoxModel<ARMetricDetailsType> defaultComboBoxModel = new DefaultComboBoxModel<ARMetricDetailsType>(ARMetricDetailsType.values());
        this.jMetricDetailsCombo.setModel(defaultComboBoxModel);
        ResourceUtils.resLabel((JLabel)this.jToFileUrlLbl, null, (String)"");
        ResourceUtils.resLabel((JLabel)this.jDestinationLbl, null, (String)ARRulesLrb.get("SAVE_OBJECT_DESTINATION"));
        ResourceUtils.resButton((AbstractButton)this.jToClipboarsRadio, (String)ARRulesLrb.get("SAVE_OBJECT_TO_CLIPBOARD"));
        ResourceUtils.resButton((AbstractButton)this.jToFileRadio, (String)ARRulesLrb.get("SAVE_OBJECT_TO_FILE"));
    }

    @Override
    public void initUI() {
        boolean bl = this.selectedItems.isEmpty();
        boolean bl2 = !this.hasAggregates;
        this.setPreviouslySelectedValues();
        if (bl) {
            this.jSelectedItemsRadio.setEnabled(false);
            this.jAllItemsRadio.setSelected(true);
        }
        if (bl2) {
            this.jMetricDetailsLbl.setVisible(false);
            this.jMetricDetailsCombo.setVisible(false);
        }
        Ellipses.setEllipsesLocation((JLabel)this.jToFileUrlLbl, (int)0);
        this.jToFileRadio.addActionListener(new ToFileActionListener());
        this.jToClipboarsRadio.addActionListener(new ToClipboardActionListener());
    }

    private void setPreviouslySelectedValues() {
        boolean bl = preferences.getSaveRulesSelectedAllRules();
        this.jSelectedItemsRadio.setSelected(!bl);
        this.jAllItemsRadio.setSelected(bl);
        this.jMetricDetailsCombo.setSelectedItem((Object)preferences.getSaveRulesSelectedMetricDetails());
    }

    private void saveSelectionToPreferences() {
        preferences.setSaveRulesSelectedAllRules(this.jAllItemsRadio.isSelected());
        preferences.setSaveRulesSelectedMetricDetails((ARMetricDetailsType)((Object)this.jMetricDetailsCombo.getSelectedItem()));
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public void onOK() throws DialogExecutionException {
                List list = this.getItemsToExport();
                ARObjectDetailsExporter aRObjectDetailsExporter = new ARObjectDetailsExporter(list, ARSaveObjectPanel.this.getSelectedFormatter());
                if (ARSaveObjectPanel.this.jToClipboarsRadio.isSelected()) {
                    aRObjectDetailsExporter.exportToClipboard();
                } else {
                    aRObjectDetailsExporter.exportToFile(ARSaveObjectPanel.this.selectedFile);
                }
                ARSaveObjectPanel.this.saveSelectionToPreferences();
                MessageDialog.optionalInformation((String)"EXPORT_AR_ITEMS", (Component)ARSaveObjectPanel.this, (Object)ARSaveObjectPanel.this.getSuccessExportMessage(), (String)ARSaveObjectPanel.this.getSuccessExportTitle(), null);
            }

            private List<O> getItemsToExport() {
                return ARSaveObjectPanel.this.jAllItemsRadio.isSelected() ? ((ODMrTableModel)((Object)ARSaveObjectPanel.this.srcTable.getModel())).getSrcData() : ARSaveObjectPanel.this.selectedItems;
            }

            @Override
            public String getTitle() {
                return ARSaveObjectPanel.this.getDialogTile();
            }

            @Override
            public String getHelpTopic() {
                return null;
            }

            @Override
            public JComponent getContent() {
                return ARSaveObjectPanel.this;
            }

            @Override
            public int getButtonMask() {
                return 3;
            }

            @Override
            public void customizeDialogProperties(JEWTDialog jEWTDialog) {
                jEWTDialog.setResizable(false);
            }
        };
    }

    protected abstract String getDialogTile();

    protected abstract ARObjectAbstractFormatter<O> getSelectedFormatter();

    protected abstract String getSuccessExportTitle();

    protected abstract String getSuccessExportMessage();

    private class ToFileActionListener
    implements ActionListener {
        private URLFileChooser fileChooser;

        private ToFileActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.createFileChooser();
            this.launchFileChooser();
            this.checkSelectedFile();
            this.updateToFileLabel();
        }

        private void createFileChooser() {
            this.fileChooser = new URLFileChooser();
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(ARRulesLrb.get("SAVE_OBJECT_TO_FILE_FLTER_DESC"), "html");
            this.fileChooser.setFileFilter((FileFilter)fileNameExtensionFilter);
            if (ARSaveObjectPanel.this.selectedFile != null) {
                this.fileChooser.setSelectedFile(ARSaveObjectPanel.this.selectedFile);
            }
            this.fileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ToFileActionListener.this.fileChooser.checkIfFileExists()) {
                        MessageDialog.confirm((Component)ARSaveObjectPanel.this, (Object)CoreCommonLrb.get((String)"MSG_OVERWRITE_FILE_WARNING"), (String)CoreCommonLrb.get((String)"WARNING"), null);
                    }
                }
            });
        }

        private void launchFileChooser() {
            int n = this.fileChooser.showSaveDialog((Component)ARSaveObjectPanel.this);
            if (n == 0) {
                ARSaveObjectPanel.this.selectedFile = this.fileChooser.getSelectedFile();
                this.checkHtmlExtension();
            }
        }

        private void checkHtmlExtension() {
            boolean bl;
            boolean bl2 = bl = ARSaveObjectPanel.this.selectedFile.getName().endsWith(".html") || ARSaveObjectPanel.this.selectedFile.getName().endsWith(".htm");
            if (!bl) {
                ARSaveObjectPanel.this.selectedFile = new File(ARSaveObjectPanel.this.selectedFile.getPath() + ".html");
            }
        }

        private void checkSelectedFile() {
            boolean bl = true;
            if (this.invalidFile()) {
                ARSaveObjectPanel.this.selectedFile = null;
                bl = false;
            }
            UITools.getParentDialog(ARSaveObjectPanel.this).setOKButtonEnabled(bl);
        }

        private boolean invalidFile() {
            if (ARSaveObjectPanel.this.selectedFile == null) {
                return true;
            }
            if (ARSaveObjectPanel.this.selectedFile.exists()) {
                return !MessageDialog.confirm((Component)ARSaveObjectPanel.this, (Object)CoreCommonLrb.get((String)"MSG_OVERWRITE_FILE_WARNING"), (String)CommonLrb.get("WARNING"), null);
            }
            return false;
        }

        private void updateToFileLabel() {
            if (ARSaveObjectPanel.this.selectedFile != null) {
                ARSaveObjectPanel.this.jToFileUrlLbl.setText(String.format("(%s)", ARSaveObjectPanel.this.selectedFile.getAbsolutePath()));
            }
        }
    }

    private class ToClipboardActionListener
    implements ActionListener {
        private ToClipboardActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UITools.getParentDialog(ARSaveObjectPanel.this).setOKButtonEnabled(true);
        }
    }
}

