/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.dprofiler;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.dprofiler.DataProfileViewPanel2;
import oracle.dmt.dataminer.teditor.AbstractDataEditor;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.BlockingComponent;

public class DataProfilerEditor
extends AbstractDataEditor {
    private static final String DEFAULT_FILTER_TEXT = DataLrb.get("DATA_VIEWER_FILTER_WHERE_CLAUSE");
    private JLabel filterLabel = new JLabel();
    private JTextField filter = new JTextField(DEFAULT_FILTER_TEXT);

    public DataProfilerEditor() {
        this.filter.setForeground(this.filter.getDisabledTextColor());
        ResourceUtils.resLabel((JLabel)this.filterLabel, (Component)this.filter, (String)DataLrb.get("DATA_VIEWER_FILTER_LABEL"));
        this.filterLabel.getAccessibleContext().setAccessibleDescription(DataLrb.get("DATA_VIEWER_FILTER_LABEL_ADA"));
        this.filterLabel.setToolTipText(DataLrb.get("DATA_VIEWER_FILTER_LABEL_ADA"));
        this.filter.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (DataProfilerEditor.this.filter.getText().trim().toUpperCase().equals(DEFAULT_FILTER_TEXT.toUpperCase())) {
                    DataProfilerEditor.this.filter.setText("");
                    DataProfilerEditor.this.filter.setForeground(DataProfilerEditor.this.filter.getCaretColor());
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (StringUtils.isEmpty((String)DataProfilerEditor.this.filter.getText())) {
                    DataProfilerEditor.this.filter.setText(DEFAULT_FILTER_TEXT);
                    DataProfilerEditor.this.filter.setForeground(DataProfilerEditor.this.filter.getDisabledTextColor());
                }
            }
        });
    }

    @Override
    protected DataMinerViewGUI getViewer() {
        return new DataProfileViewPanel2(this, this.getContext());
    }

    @Override
    public void refresh() {
        if (this._overLayPanel != null) {
            this._overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        super.refresh();
        if (this._gui != null) {
            this._gui.reload();
        }
    }

    @Override
    public HelpInfo getHelpInfo() {
        assert (this._gui != null) : "getHelpInfo can not be called if _gui has not been loaded.";
        return new HelpInfo("data_profile_viewer_statistics");
    }

    @Override
    public void close() {
        if (this._gui != null) {
            ((DataProfileViewPanel2)this._gui).clear();
        }
    }
}

