/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls.editors;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.javatools.icons.OracleIcons;

public class OutputBooleanCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private boolean currentValue;
    private JButton editButton;
    private static final String EDIT = "edit";

    public OutputBooleanCellEditor() {
        this.initUI();
    }

    private void initUI() {
        this.editButton = new JButton();
        this.editButton.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
        this.editButton.addActionListener(new EditButtonActionListener());
        this.editButton.setActionCommand(EDIT);
        this.editButton.setBorderPainted(false);
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentValue;
    }

    public void commitChange(boolean bl) {
        this.currentValue = bl;
        this.fireEditingStopped();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        boolean bl2 = this.currentValue = (Boolean)object == false;
        if (this.currentValue) {
            this.editButton.setIcon(DataMinerIcons.get(Icons.ATTR_INCLUDE));
        } else {
            this.editButton.setIcon(DataMinerIcons.get(Icons.ATTR_IGNORE));
        }
        return this.editButton;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= 2;
        }
        return true;
    }

    private class EditButtonActionListener
    implements ActionListener {
        private EditButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (OutputBooleanCellEditor.EDIT.equals(actionEvent.getActionCommand())) {
                OutputBooleanCellEditor.this.fireEditingStopped();
            }
        }
    }
}

