/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata;

import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.grammar.GrammarMetadataProvider;

public class MetadataSchemaRegistry {
    private volatile SchemaGrammarProvider _gp;
    private GrammarResolver _gr;
    private MetadataProvider _mp;
    private CopyOnWriteArraySet _schemas;
    private Set<URL> _indexing;
    private Set<URL> _indexingFuncs;
    private Object _gpLock = new Object();
    private static final MetadataSchemaRegistry _sInstance = new MetadataSchemaRegistry();
    private static final Logger _LOGGER = Logger.getLogger("oracle.bali.xml.metadata");

    public static MetadataSchemaRegistry getInstance() {
        return _sInstance;
    }

    public MetadataProvider getMetadataProvider() {
        if (this._mp == null) {
            GrammarProvider grammarProvider = this.getMetadataGrammars();
            GrammarResolver grammarResolver = new GrammarResolver(grammarProvider);
            this._mp = new GrammarMetadataProvider(grammarResolver);
        }
        return this._mp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrammarProvider getMetadataGrammars() {
        if (this._gp == null) {
            Object object = this._gpLock;
            synchronized (object) {
                if (this._gp == null) {
                    this._gp = new SchemaGrammarProvider();
                    if (this._schemas != null) {
                        for (URL schemaURL : this._schemas) {
                            this._addSchemaToGrammarProvider(schemaURL);
                        }
                    }
                }
            }
        }
        return this._gp;
    }

    public GrammarResolver getMetadataGrammarResolver() {
        if (this._gr == null) {
            this._gr = new GrammarResolver(this.getMetadataGrammars());
        }
        return this._gr;
    }

    public void registerSchema(URL url, String extension) {
        this.registerSchema(url);
    }

    public void registerSchema(URL url) {
        if (url != null) {
            if (this._schemas == null) {
                this._schemas = new CopyOnWriteArraySet();
            }
            if (!this._schemas.contains(url)) {
                this._schemas.add(url);
                if (this._gp != null) {
                    this._addSchemaToGrammarProvider(url);
                }
            }
        } else {
            _LOGGER.log(Level.WARNING, "Null schema location passed to MetadataSchemaRegistry.registerSchema().  Please file a bug against the calling code.");
        }
    }

    public void registerIndexingMetadata(URL url) {
        if (url != null) {
            if (this._indexing == null) {
                this._indexing = new LinkedHashSet<URL>();
            }
            this._indexing.add(url);
        } else {
            _LOGGER.log(Level.WARNING, "Null metadata location passed to MetadataSchemaRegistry.registerIndexingMetadata().  Please file a bug against the calling code.");
        }
    }

    public Set<URL> getIndexingMetadata() {
        return this._indexing;
    }

    public void registerIndexingFunctionMD(URL url) {
        if (url != null) {
            if (this._indexingFuncs == null) {
                this._indexingFuncs = new LinkedHashSet<URL>();
            }
            this._indexingFuncs.add(url);
        } else {
            _LOGGER.log(Level.WARNING, "Null metadata location passed to MetadataSchemaRegistry.registerIndexingFunctions().  Please file a bug against the calling code.");
        }
    }

    public Set<URL> getIndexingFunctionMD() {
        return this._indexingFuncs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addSchemaToGrammarProvider(URL schemaURL) {
        try {
            Object object = this._gpLock;
            synchronized (object) {
                this._gp.addSchema(schemaURL);
            }
        }
        catch (GrammarException e) {
            LogRecord rec = new LogRecord(Level.WARNING, "Exception loading schema {0}");
            rec.setParameters(new Object[]{schemaURL});
            rec.setThrown(e);
            _LOGGER.log(rec);
        }
    }

    private MetadataSchemaRegistry() {
        this.registerSchema(this.getClass().getResource("XmlMetadata.xsd"));
        this.registerIndexingMetadata(this.getClass().getResource("XmlMetadata-metadata.xml"));
    }
}

