/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;

public abstract class LayeredMetadataProvider
implements MetadataProvider {
    private Logger _logger = Logger.getLogger("oracle.bali.xml.metadata.MetadataProvider");
    private MetadataProvider _base = null;

    public LayeredMetadataProvider() {
        this(null);
    }

    public LayeredMetadataProvider(MetadataProvider base) {
        this._base = base;
    }

    @Override
    public final Map getMetadata(Object key) {
        HashMap combinedMetadata = new HashMap();
        try {
            if (this._base != null) {
                Map baseMetadata = this._base.getMetadata(key);
                combinedMetadata.putAll(baseMetadata);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Map layerMetadata = this.getLayerMetadata(key);
            if (layerMetadata != null) {
                combinedMetadata.putAll(layerMetadata);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return combinedMetadata;
    }

    @Override
    public final Object getMetadataItem(Object key, Object itemKey) {
        Object metadataItem = null;
        try {
            metadataItem = this.getLayerMetadataItem(key, itemKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (metadataItem == null && this._base != null) {
            metadataItem = this._base.getMetadataItem(key, itemKey);
        }
        return metadataItem;
    }

    @Override
    public final Object getFunction(String prefix, String name) {
        Object function = null;
        try {
            function = this.getLayerFunction(prefix, name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (function == null && this._base != null) {
            function = this._base.getFunction(prefix, name);
        }
        return function;
    }

    @Override
    public final List<StructuredMetadataBean> getGlobalMetadata(QualifiedName globalItemName) {
        List<StructuredMetadataBean> baseList;
        List<StructuredMetadataBean> layerList;
        try {
            layerList = this.getLayerGlobalMetadata(globalItemName);
        }
        catch (Exception e) {
            e.printStackTrace();
            layerList = Collections.emptyList();
        }
        if (this._base != null) {
            try {
                baseList = this._base.getGlobalMetadata(globalItemName);
            }
            catch (Exception e) {
                e.printStackTrace();
                baseList = Collections.emptyList();
            }
        } else {
            baseList = Collections.emptyList();
        }
        if (layerList.isEmpty()) {
            return baseList;
        }
        if (baseList.isEmpty()) {
            return layerList;
        }
        ArrayList<StructuredMetadataBean> combinedList = new ArrayList<StructuredMetadataBean>();
        combinedList.addAll(layerList);
        combinedList.addAll(baseList);
        return combinedList;
    }

    @Override
    public final Collection getPseudoXmlKeys(Object baseKey) {
        Collection basePseudoKeys = Collections.EMPTY_LIST;
        if (this._base != null) {
            basePseudoKeys = this._base.getPseudoXmlKeys(baseKey);
        }
        Collection layerPseudoKeys = this.getLayerPseudoXmlKeys(baseKey);
        if (basePseudoKeys.isEmpty()) {
            return layerPseudoKeys;
        }
        if (layerPseudoKeys.isEmpty()) {
            return basePseudoKeys;
        }
        LinkedList combinedKeys = new LinkedList();
        combinedKeys.addAll(basePseudoKeys);
        combinedKeys.addAll(layerPseudoKeys);
        return Collections.unmodifiableCollection(combinedKeys);
    }

    public Logger getLogger() {
        return this._logger;
    }

    protected abstract Map getLayerMetadata(Object var1);

    protected abstract Object getLayerMetadataItem(Object var1, Object var2);

    protected abstract Object getLayerFunction(String var1, String var2);

    protected List<StructuredMetadataBean> getLayerGlobalMetadata(QualifiedName globalItemName) {
        return Collections.emptyList();
    }

    protected abstract Collection getLayerPseudoXmlKeys(Object var1);
}

