/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.instance;

import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarIdentifier;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.GrammarProviderEvent;
import oracle.bali.xml.grammar.LayeredGrammarProvider;
import oracle.bali.xml.grammar.instance.XmlInstanceDtdCreator;
import oracle.bali.xml.grammar.remote.DefaultGrammarLoadingPolicy;
import oracle.bali.xml.grammar.remote.GrammarLoadingPolicy;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XmlInstanceGrammarProvider
extends LayeredGrammarProvider {
    private Grammar _dtd = null;
    private Map _dtdMap = Collections.EMPTY_MAP;
    private final SchemaGrammarProvider _schemaProvider;
    private GrammarLoadingPolicy _grammarLoadingPolicy = new DefaultGrammarLoadingPolicy();
    private Set _processedSchemaIdentifiers = Collections.EMPTY_SET;
    private boolean _currentlyLoadingRemoteSchema = false;
    private GrammarIdentifier _processedDtdIdentifier = null;
    private boolean _fixedDtd = false;
    private XmlInstanceDtdCreator _dtdCreator = null;
    private static final Logger _sLogger = Logger.getLogger("oracle.bali.xml.grammar");
    public static final String REMOTE_XML_XSD_LOCATION = "http://www.w3.org/2001/xml.xsd";
    public static final String LOCAL_XML_XSD_LOCATION = "/META-INF/schemas/xml.xsd";

    public XmlInstanceGrammarProvider() {
        this(null);
    }

    public XmlInstanceGrammarProvider(GrammarProvider base) {
        super(new SchemaGrammarProvider(base));
        this._schemaProvider = (SchemaGrammarProvider)super.getBaseGrammarProvider();
        this._schemaProvider.setEntityResolver(new OurEntityResolver());
        this._grammarLoadingPolicy = new DefaultGrammarLoadingPolicy();
    }

    public void setGrammarLoadingPolicy(GrammarLoadingPolicy grammarLoadingPolicy) {
        if (grammarLoadingPolicy != null) {
            this._grammarLoadingPolicy = grammarLoadingPolicy;
        }
    }

    public GrammarLoadingPolicy getGrammarLoadingPolicy() {
        return this._grammarLoadingPolicy;
    }

    @Deprecated
    public boolean setSchemaIdentifiers(Set grammarIdentifiers, Set<String> externallyValidatedRemoteUrls) {
        boolean forceReload = false;
        if (externallyValidatedRemoteUrls != null) {
            forceReload = true;
            if (this._grammarLoadingPolicy instanceof LegacySetBasedGrammarLoadingPolicy) {
                LegacySetBasedGrammarLoadingPolicy legacyPolicy = (LegacySetBasedGrammarLoadingPolicy)this._grammarLoadingPolicy;
                legacyPolicy.setExternallyValidatedRemoteUrls(externallyValidatedRemoteUrls);
            } else {
                this._grammarLoadingPolicy = new LegacySetBasedGrammarLoadingPolicy(this._grammarLoadingPolicy, externallyValidatedRemoteUrls);
            }
        }
        return this.setSchemaIdentifiers(grammarIdentifiers, forceReload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSchemaIdentifiers(Set grammarIdentifiers, boolean forceReload) {
        boolean grammarProviderChanged = false;
        if (!this._processedSchemaIdentifiers.equals(grammarIdentifiers) || forceReload) {
            grammarProviderChanged = true;
            this._processedSchemaIdentifiers = grammarIdentifiers;
            this._schemaProvider.clearSchemas();
            Set locations = this._getSchemaLocations(grammarIdentifiers);
            locations = this._removeExistingGrammarLocations(locations);
            for (String location : locations) {
                GrammarLoadingPolicy.Policy policy;
                URL schemaLocation = null;
                try {
                    schemaLocation = new URL(location);
                }
                catch (MalformedURLException e) {
                    schemaLocation = null;
                }
                if (schemaLocation == null || (policy = this._grammarLoadingPolicy.getPolicy(schemaLocation, GrammarLoadingPolicy.Type.XML_SCHEMA)) != GrammarLoadingPolicy.Policy.LOAD) continue;
                try {
                    this._currentlyLoadingRemoteSchema = this._grammarLoadingPolicy.isRemote(schemaLocation);
                    this._schemaProvider.addSchema(schemaLocation);
                }
                catch (Exception e) {
                    XmlInstanceGrammarProvider._getLogger().log(Level.WARNING, "Attempt to load schema file referenced in instance document failed:" + schemaLocation);
                    XmlInstanceGrammarProvider._getLogger().log(Level.FINER, "Underlying exception preventing schema loading:", e);
                }
                finally {
                    this._currentlyLoadingRemoteSchema = false;
                }
            }
        }
        return grammarProviderChanged;
    }

    public boolean setDtdIdentifier(GrammarIdentifier dtdIdentifier) {
        if (!(this._dtdCreator == null || this._fixedDtd || this._processedDtdIdentifier != null && this._processedDtdIdentifier.equals(dtdIdentifier))) {
            GrammarProviderEvent event = this.createEvent();
            this._processedDtdIdentifier = dtdIdentifier;
            if (this._dtd != null) {
                event.notifyGrammarRemoved(this._dtd);
                this._dtd = null;
                this._dtdMap = Collections.EMPTY_MAP;
            }
            Set locations = this._getDtdLocation(dtdIdentifier);
            locations = this._removeExistingGrammarLocations(locations);
            for (String location : locations) {
                GrammarLoadingPolicy.Policy policy;
                URL dtdLocation = null;
                try {
                    dtdLocation = new URL(location);
                }
                catch (MalformedURLException e) {
                    dtdLocation = null;
                }
                if (dtdLocation == null || (policy = this._grammarLoadingPolicy.getPolicy(dtdLocation, GrammarLoadingPolicy.Type.DTD)) != GrammarLoadingPolicy.Policy.LOAD) continue;
                Grammar dtdGrammar = null;
                try {
                    dtdGrammar = this._dtdCreator.createDtd(dtdLocation);
                }
                catch (Exception ge) {
                    dtdGrammar = null;
                }
                if (dtdGrammar == null) continue;
                this._dtd = dtdGrammar;
                this._dtdMap = Collections.singletonMap(this._dtd.getTargetNamespace(), this._dtd);
                event.notifyGrammarAdded(this._dtd);
                break;
            }
            this.fireEvent(event);
            return !event.isEmpty();
        }
        return false;
    }

    public void setDTD(Grammar newDTD) {
        this._fixedDtd = true;
        GrammarProviderEvent event = this.createEvent();
        if (this._dtd != null) {
            event.notifyGrammarRemoved(this._dtd);
        }
        this._dtd = newDTD;
        if (this._dtd != null) {
            this._dtdMap = Collections.singletonMap(this._dtd.getTargetNamespace(), this._dtd);
            event.notifyGrammarAdded(this._dtd);
        } else {
            this._dtdMap = Collections.EMPTY_MAP;
        }
        this.fireEvent(event);
    }

    public void setDtdCreator(XmlInstanceDtdCreator dtdCreator) {
        this._dtdCreator = dtdCreator;
    }

    @Override
    protected Map getLayerGrammarMap() {
        return this._dtdMap;
    }

    private Set _getDtdLocation(GrammarIdentifier dtdIdentifier) {
        if (dtdIdentifier != null) {
            String publicId;
            String location = dtdIdentifier.getLocation();
            if (location == null && (publicId = dtdIdentifier.getPublicId()) != null) {
                location = this._dtdCreator.getSystemId(publicId);
            }
            if (location != null) {
                location = this._dtdCreator.getLocationAlias(location);
                return Collections.singleton(location);
            }
        }
        return Collections.EMPTY_SET;
    }

    private Set _getSchemaLocations(Set schemaIdentifiers) {
        HashSet<String> locations = new HashSet<String>();
        for (GrammarIdentifier id : schemaIdentifiers) {
            String locationId = id.getLocation();
            if (locationId == null) continue;
            String locationAlias = this.getSchemaLocationAlias(locationId);
            locations.add(locationAlias);
        }
        return locations;
    }

    private Set _removeExistingGrammarLocations(Set locations) {
        Collection currentGrammars = this.getGrammars();
        for (Grammar g : currentGrammars) {
            URL gURL;
            GrammarIdentifier id = g.getGrammarIdentifier();
            String gLocation = id.getLocation();
            if (gLocation == null && (gURL = g.getLocation()) != null) {
                gLocation = gURL.toExternalForm();
            }
            if (gLocation == null) continue;
            locations.remove(gLocation);
        }
        return locations;
    }

    public String getSchemaLocationAlias(URL url) {
        return this.getSchemaLocationAlias(url.toExternalForm());
    }

    protected String getSchemaLocationAlias(String location) {
        if (REMOTE_XML_XSD_LOCATION.equals(location)) {
            return this.getClass().getResource(LOCAL_XML_XSD_LOCATION).toExternalForm();
        }
        return location;
    }

    private static Logger _getLogger() {
        return _sLogger;
    }

    private class OurEntityResolver
    implements EntityResolver {
        private OurEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (systemId != null) {
                String alias = XmlInstanceGrammarProvider.this.getSchemaLocationAlias(systemId);
                if (alias == null) {
                    alias = systemId;
                }
                if (!XmlInstanceGrammarProvider.this._currentlyLoadingRemoteSchema && alias.startsWith("http:") && !DefaultGrammarLoadingPolicy.shouldLoadRemoteSchemasByDefault()) {
                    if (alias.endsWith(".xsd")) {
                        XmlInstanceGrammarProvider._getLogger().log(Level.WARNING, "Ignoring remote included or imported .xsd file:  " + systemId);
                        return new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"windows-1252\" ?><schema xmlns=\"http://www.w3.org/2001/XMLSchema\" />"));
                    }
                    XmlInstanceGrammarProvider._getLogger().log(Level.WARNING, "Ignoring reference to remote file:  " + systemId);
                    return new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"windows-1252\" ?>"));
                }
                if (!systemId.equals(alias)) {
                    return new InputSource(alias);
                }
            }
            return null;
        }
    }

    private class LegacySetBasedGrammarLoadingPolicy
    extends GrammarLoadingPolicy {
        private final GrammarLoadingPolicy _base;
        private Set<String> _externallyValidatedRemoteUrls;

        public LegacySetBasedGrammarLoadingPolicy(GrammarLoadingPolicy base, Set<String> externallyValidatedRemoteUrls) {
            this._base = base;
            this._externallyValidatedRemoteUrls = externallyValidatedRemoteUrls;
        }

        @Override
        public GrammarLoadingPolicy.Policy getPolicy(URL url, GrammarLoadingPolicy.Type type) {
            String urlString;
            if (this._externallyValidatedRemoteUrls != null && url != null && type == GrammarLoadingPolicy.Type.XML_SCHEMA && (urlString = url.toExternalForm()) != null && this._externallyValidatedRemoteUrls.contains(urlString)) {
                return GrammarLoadingPolicy.Policy.LOAD;
            }
            return this._base.getPolicy(url, type);
        }

        @Override
        public boolean isRemote(URL url) {
            return this._base.isRemote(url);
        }

        public void setExternallyValidatedRemoteUrls(Set<String> externallyValidatedRemoteUrls) {
            this._externallyValidatedRemoteUrls = externallyValidatedRemoteUrls;
        }
    }
}

