/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import org.eclipse.core.runtime.FileLocator;

public class BundleEntryURLFileSystemHelper
extends URLFileSystemHelper {
    public static final String BUNDLEENTRY_PROTOCOL = "bundleentry";
    public static final String BUNDLERESOURCE_PROTOCOL = "bundleresource";
    public static final BundleEntryURLFileSystemHelper INSTANCE = new BundleEntryURLFileSystemHelper();

    private static URL resolve(URL url) {
        URL resolvedURL = null;
        try {
            resolvedURL = FileLocator.resolve((URL)url);
            if (resolvedURL.getProtocol().equals(BUNDLEENTRY_PROTOCOL) || resolvedURL.getProtocol().equals(BUNDLERESOURCE_PROTOCOL)) {
                Logger.getLogger("oracle.ide.osgi").severe("protocal handler registered only for protocols bundleentry and bundleresource URL passed in was " + url);
            }
        }
        catch (IOException e) {
            Logger.getLogger("oracle.ide.osgi").throwing("BundleEntryURLFileSystemHelper", "resolve(URL)", e);
        }
        return resolvedURL;
    }

    public boolean exists(URL url) {
        URL resolvedURL = BundleEntryURLFileSystemHelper.resolve(url);
        return resolvedURL != null ? URLFileSystem.exists((URL)resolvedURL) : super.exists(url);
    }

    public boolean isDirectory(URL url) {
        URL resolvedURL = BundleEntryURLFileSystemHelper.resolve(url);
        return resolvedURL != null ? URLFileSystem.isDirectory((URL)resolvedURL) : super.isDirectory(url);
    }

    public URL[] list(URL url) {
        URL resolvedURL = BundleEntryURLFileSystemHelper.resolve(url);
        return resolvedURL != null ? URLFileSystem.list((URL)resolvedURL) : super.list(url);
    }

    public InputStream openInputStream(URL url) throws IOException {
        URL resolvedURL = BundleEntryURLFileSystemHelper.resolve(url);
        return resolvedURL != null ? URLFileSystem.openInputStream((URL)resolvedURL) : super.openInputStream(url);
    }

    public boolean isBaseURLFor(URL url1, URL url2) {
        URL resolvedURL1 = BundleEntryURLFileSystemHelper.resolve(url1);
        URL resolvedURL2 = BundleEntryURLFileSystemHelper.resolve(url2);
        return resolvedURL1 != null && resolvedURL2 != null ? URLFileSystem.isBaseURLFor((URL)resolvedURL1, (URL)resolvedURL2) : super.isBaseURLFor(url1, url2);
    }

    public URL canonicalize(URL url) {
        return url;
    }

    public boolean isLocal(URL url) {
        URL resolvedURL = BundleEntryURLFileSystemHelper.resolve(url);
        return resolvedURL != null ? URLFileSystem.isLocal((URL)resolvedURL) : super.isLocal(url);
    }

    public long lastModified(URL url) {
        URL resolvedURL = BundleEntryURLFileSystemHelper.resolve(url);
        return resolvedURL != null ? URLFileSystem.lastModified((URL)resolvedURL) : super.lastModified(url);
    }

    public String getFileName(URL url) {
        URL resolvedURL = BundleEntryURLFileSystemHelper.resolve(url);
        return resolvedURL != null ? URLFileSystem.getFileName((URL)resolvedURL) : super.getFileName(url);
    }

    public String getPath(URL url) {
        URL resolvedURL = BundleEntryURLFileSystemHelper.resolve(url);
        return resolvedURL != null ? URLFileSystem.getPath((URL)resolvedURL) : super.getPath(url);
    }

    public URL getParent(URL url) {
        URL resolvedURL = BundleEntryURLFileSystemHelper.resolve(url);
        return resolvedURL != null ? URLFileSystem.getParent((URL)resolvedURL) : super.getParent(url);
    }

    public boolean isHidden(URL url) {
        URL resolvedURL = BundleEntryURLFileSystemHelper.resolve(url);
        return resolvedURL != null ? URLFileSystem.isHidden((URL)resolvedURL) : super.isHidden(url);
    }

    public boolean isReadOnly(URL url) {
        return true;
    }

    public boolean isRegularFile(URL url) {
        URL resolvedURL = BundleEntryURLFileSystemHelper.resolve(url);
        return resolvedURL != null ? URLFileSystem.isRegularFile((URL)resolvedURL) : super.isRegularFile(url);
    }

    public long getLength(URL url) {
        URL resolvedURL = BundleEntryURLFileSystemHelper.resolve(url);
        return resolvedURL != null ? URLFileSystem.getLength((URL)resolvedURL) : super.getLength(url);
    }

    public String toRelativeSpec(URL url, URL base) {
        URL resolvedURL = BundleEntryURLFileSystemHelper.resolve(url);
        return resolvedURL != null ? URLFileSystem.toRelativeSpec((URL)resolvedURL, (URL)base) : super.toRelativeSpec(url, base);
    }

    public String toRelativeSpec(URL url, URL base, boolean mustConsumeBase) {
        URL resolvedURL = BundleEntryURLFileSystemHelper.resolve(url);
        URL baseResolvedURL = BundleEntryURLFileSystemHelper.resolve(base);
        return resolvedURL != null && baseResolvedURL != null ? URLFileSystem.toRelativeSpec((URL)resolvedURL, (URL)baseResolvedURL, (boolean)mustConsumeBase) : super.toRelativeSpec(url, base, mustConsumeBase);
    }
}

