/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.extension;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.net.URIFactory;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;

public class BundleJARExtensionSource
implements ExtensionSource {
    private static final Logger LOGGER = Logger.getLogger(BundleJARExtensionSource.class.getName());
    private static final String MANIFEST_ENTRY = "META-INF/extension.xml";
    private final Bundle m_bundle;
    private URI m_jarURI = null;
    private URI m_manifestURI;

    public BundleJARExtensionSource(Bundle bundle) {
        assert (bundle != null);
        this.m_bundle = bundle;
    }

    public final URI getURI() {
        if (this.m_jarURI == null) {
            try {
                URL rootFolder = this.m_bundle.getEntry("/");
                if (rootFolder != null) {
                    this.m_jarURI = rootFolder.toURI();
                }
            }
            catch (URISyntaxException e) {
                LOGGER.log(Level.SEVERE, "Failed to convert " + this.getName() + " to URI", e);
            }
        }
        return this.m_jarURI;
    }

    public final URI getClasspathEntry() {
        return this.m_jarURI;
    }

    public URI getManifestURI() {
        if (this.m_manifestURI == null) {
            try {
                URL m_manifestURL = this.m_bundle.getEntry(MANIFEST_ENTRY);
                if (m_manifestURL != null) {
                    this.m_manifestURI = m_manifestURL.toURI();
                } else {
                    LOGGER.log(Level.SEVERE, this.getName() + " did not contain a manifest entry, META-INF/extension.xml");
                }
            }
            catch (URISyntaxException e) {
                LOGGER.log(Level.SEVERE, this.getName() + " did not contain a valid manifest entry, META-INF/extension.xml", e);
            }
            return this.m_manifestURI;
        }
        return this.m_manifestURI;
    }

    public URI resolvePath(Extension extension, String path) {
        File f = new File(path);
        if (f.isAbsolute() && f.exists()) {
            return URIFactory.newFileURI((File)f);
        }
        if (path.startsWith("..")) {
            File bundleFile = null;
            try {
                bundleFile = FileLocator.getBundleFile((Bundle)this.m_bundle);
                return BundleJARExtensionSource.getURI(URLDecoder.decode(bundleFile.getParent(), "UTF-8"), path);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.SEVERE, path + " was not found in bundle " + this.m_bundle.getSymbolicName(), ioe);
            }
        }
        try {
            URL resourceUrl = this.m_bundle.getEntry(path);
            if (resourceUrl != null) {
                return resourceUrl.toURI();
            }
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, path + " was not a valid path within " + this.getName() + " extension " + extension.getID(), e);
        }
        try {
            File file = FileLocator.getBundleFile((Bundle)this.m_bundle);
            if (file != null) {
                return BundleJARExtensionSource.getURI(URLDecoder.decode(file.getParent(), "UTF-8"), path);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static URI getURI(String parent, String path) {
        URI parentURI = URIFactory.newFileURI((String)parent);
        return URIFactory.newURI((URI)parentURI, (String)path);
    }

    public InputStream getInputStream() throws IOException {
        if (this.m_manifestURI != null) {
            return this.m_manifestURI.toURL().openStream();
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.m_bundle.getSymbolicName();
    }

    public final Bundle getBundle() {
        return this.m_bundle;
    }
}

