/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.stripe;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.event.ChangeListener;
import oracle.ide.util.Assert;
import oracle.jdevimpl.deploy.stripe.MonitoredStream;

class MonitoredInputStream
extends FilterInputStream
implements MonitoredStream {
    MonitoredStream.ListenerSupport listenerSupport = new MonitoredStream.ListenerSupport();
    MonitoredStream.StatusSupport status_ = new MonitoredStream.StatusSupport(this.listenerSupport, this);
    boolean dirty_ = false;

    MonitoredInputStream(InputStream in) {
        super(in);
        this.status_.setStatus(1);
    }

    MonitoredInputStream() {
        this(null);
        this.status_.setStatus(0);
    }

    public void setStreamAndStatus(InputStream in, int status) {
        Assert.check((status != 0 ? 1 : 0) != 0, (String)"Cannot set UNDEFINED status on initial stream");
        this.in = in;
        this.status_.setStatus(status);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listenerSupport.addListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    @Override
    public int getStatus() {
        return this.status_.getStatus();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.dirty_) {
            this.dirty_ = true;
        }
        return super.read(b, off, len);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.dirty_) {
            this.dirty_ = true;
        }
        super.reset();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (!this.dirty_) {
            this.dirty_ = true;
        }
        return super.read(b);
    }

    @Override
    public int read() throws IOException {
        if (!this.dirty_) {
            this.dirty_ = true;
        }
        return super.read();
    }

    @Override
    public long skip(long n) throws IOException {
        if (!this.dirty_) {
            this.dirty_ = true;
        }
        return super.skip(n);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.status_.setStatus(3);
    }

    @Override
    public boolean isDirty() {
        return this.dirty_;
    }
}

