/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.hook;

import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.util.MetaClass;
import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.spi.HashDependableReader;
import oracle.jdeveloper.deploy.spi.HashDependableWriter;
import oracle.jdeveloper.deploy.spi.hook.HashDependableIO;
import oracle.jdeveloper.deploy.spi.providers.AbstractHashDependableIOProvider;
import oracle.jdeveloper.deploy.tk.ToolkitBuildException;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;
import oracle.jdevimpl.deploy.hook.BaseElementVisitor;

public class HashDependableIOHandler
extends BaseElementVisitor
implements ElementVisitorFactory {
    static final ElementName EN_HASHDEPENDABLE_IO_PROVIDERS = HashDependableIOHandler.e("hash-dependable-io-providers");
    static final ElementName EN_HASHDEPENDABLE_IO_PROVIDER = HashDependableIOHandler.e("hash-dependable-io-provider");
    static final ElementName EN_HASHDEPENDABLE_IO_ID = HashDependableIOHandler.e("id");
    static final ElementName EN_HASHDEPENDABLE_IO_DEPENDABLE_CLASS = HashDependableIOHandler.e("dependable-class");
    static final ElementName EN_HASHDEPENDABLE_IO_IO_CLASS = HashDependableIOHandler.e("io-class");

    public void start(ElementStartContext context) {
        ElementName name = context.getElementName();
        if (EN_HASHDEPENDABLE_IO_PROVIDERS.equals((Object)name)) {
            context.registerVisitorFactory((ElementVisitorFactory)this);
        } else if (EN_HASHDEPENDABLE_IO_PROVIDER.equals((Object)name)) {
            context.getScopeData().put(LazyHashDependableIOToolkitProvider.class, new LazyHashDependableIOToolkitProvider());
        }
    }

    public void end(ElementEndContext context) {
        ElementName name = context.getElementName();
        if (EN_HASHDEPENDABLE_IO_PROVIDERS.equals((Object)name)) {
            return;
        }
        LazyHashDependableIOToolkitProvider tkProvider = (LazyHashDependableIOToolkitProvider)context.getScopeData().get(LazyHashDependableIOToolkitProvider.class);
        assert (tkProvider != null);
        if (EN_HASHDEPENDABLE_IO_PROVIDER.equals((Object)name)) {
            if (!ModelUtil.hasLength((String)tkProvider.id)) {
                context.getLogger().severe(String.format("Missing %s in hook %s (%s)", EN_HASHDEPENDABLE_IO_ID, EN_HASHDEPENDABLE_IO_PROVIDER, context.getExtension().getName()));
                Assert.printStackTrace();
                return;
            }
            if (!ModelUtil.hasLength((String)tkProvider.dependableClassName)) {
                context.getLogger().severe(String.format("Missing %s in hook %s (%s)", EN_HASHDEPENDABLE_IO_DEPENDABLE_CLASS, EN_HASHDEPENDABLE_IO_PROVIDER, context.getExtension().getName()));
                Assert.printStackTrace();
                return;
            }
            if (tkProvider.ioClass == null) {
                context.getLogger().severe(String.format("Missing % in hook %s (%s)", EN_HASHDEPENDABLE_IO_IO_CLASS, EN_HASHDEPENDABLE_IO_PROVIDER, context.getExtension().getName()));
                Assert.printStackTrace();
                return;
            }
            HashDependableIOHandler.registerToolkit(HashDependableReader.class.getName(), tkProvider);
            HashDependableIOHandler.registerToolkit(HashDependableWriter.class.getName(), tkProvider);
        } else {
            String text = context.getText().trim();
            assert (ModelUtil.hasLength((String)text));
            if (EN_HASHDEPENDABLE_IO_ID.equals((Object)name)) {
                tkProvider.id = text;
            } else if (EN_HASHDEPENDABLE_IO_DEPENDABLE_CLASS.equals((Object)name)) {
                tkProvider.dependableClassName = text;
            } else if (EN_HASHDEPENDABLE_IO_IO_CLASS.equals((Object)name)) {
                MetaClass ioClass;
                tkProvider.ioClass = ioClass = HashDependableIOHandler.makeMetaClass((ElementContext)context, text);
            }
        }
    }

    public ElementVisitor getVisitor(ElementName name) {
        return this;
    }

    private static class LazyHashDependableIOToolkitProvider
    extends AbstractHashDependableIOProvider {
        private MetaClass<HashDependableIO> ioClass;
        private String id = null;
        private String dependableClassName = null;
        private HashDependableIO hashDependableIO = null;

        private LazyHashDependableIOToolkitProvider() {
        }

        @Override
        protected boolean canRead(Element element, HashStructure hash, ToolkitContext tkContext, Cookie cookie) {
            if (this.id.equals(hash.getString("adapterClass"))) {
                return this.io().canRead(element, hash, tkContext, cookie);
            }
            return false;
        }

        @Override
        protected boolean canWrite(Element element, Dependable dependable, ToolkitContext tkContext, Cookie cookie) {
            if (dependable.getClass().getName().equals(this.dependableClassName)) {
                return this.io().canWrite(element, dependable, tkContext, cookie);
            }
            return false;
        }

        @Override
        protected Dependable read(Element element, HashStructure hash, Cookie cookie) {
            return this.io().read(element, hash, cookie);
        }

        @Override
        protected void write(Element element, Dependable dependable, HashStructure hash, Cookie cookie) {
            this.io().write(element, dependable, hash, cookie);
            if (!this.id.equals(hash.getString("adapterClass"))) {
                throw new IllegalStateException("HashDependableIO implementation returned an invalid hash.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HashDependableIO io() {
            MetaClass<HashDependableIO> metaClass = this.ioClass;
            synchronized (metaClass) {
                if (this.hashDependableIO == null || this.ioClass != null) {
                    try {
                        this.hashDependableIO = (HashDependableIO)this.ioClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        this.reportException(e);
                    }
                    catch (IllegalAccessException e) {
                        this.reportException(e);
                    }
                    catch (ClassNotFoundException e) {
                        this.reportException(e);
                    }
                }
                return this.hashDependableIO;
            }
        }

        private void reportException(Exception e) {
            throw new ToolkitBuildException("Unable to instantiate HashDependableIO implementation class", e);
        }
    }
}

