/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.spi;

import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.spi.DeployShellFactory;

public class DefaultDeployShellFactory
implements DeployShellFactory {
    private static DefaultDeployShellFactory instance_ = null;
    final ArrayList<Configurator> configurators_ = new ArrayList();

    @Deprecated
    public DeployShell create(int deploySequenceId, Context context, DeployShell parent) throws DeployException {
        Context ctx = new Context(context);
        DeployShellFactory.SpiData spi = DeployShellFactory.SpiData.getInstance(ctx);
        spi.setParentShell(parent);
        return this.createShell(ctx.getElement(), ctx);
    }

    public static synchronized DefaultDeployShellFactory getInstance() {
        if (instance_ == null) {
            instance_ = new DefaultDeployShellFactory();
        }
        return instance_;
    }

    @Override
    public DeployShell createShell(Element element, Context context) {
        DeployShellFactory.SpiData spi = DeployShellFactory.SpiData.getInstance(context);
        DeployShell parent = spi.getParentShell();
        try {
            DeployShell newShell;
            if (parent != null) {
                newShell = new DeployShell(parent);
                if (context != null) {
                    newShell.setContext(context);
                }
            } else {
                Assert.check((context != null ? 1 : 0) != 0, (String)"Root DeployShell cannot be created with a null Context");
                Logger deployLogger = Logger.getLogger("oracle.jdeveloper.deploy");
                newShell = new DeployShell(context, deployLogger);
            }
            this.configure(newShell);
            return newShell;
        }
        catch (DeployException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConfigurator(Configurator configurator) {
        ArrayList<Configurator> arrayList = this.configurators_;
        synchronized (arrayList) {
            this.configurators_.add(configurator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterConfigurator(Configurator configurator) {
        ArrayList<Configurator> arrayList = this.configurators_;
        synchronized (arrayList) {
            return this.configurators_.remove(configurator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(DeployShell shell) throws DeployException {
        ArrayList<Configurator> arrayList = this.configurators_;
        synchronized (arrayList) {
            for (Configurator c : this.configurators_) {
                c.configure(shell);
            }
        }
    }

    private DefaultDeployShellFactory() {
    }

    public static interface Configurator {
        public void configure(DeployShell var1) throws DeployException;
    }
}

