/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.util.HashMap;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.StateException;
import oracle.jdeveloper.deploy.Stateful;
import oracle.jdeveloper.deploy.StatefulDeployer;
import oracle.jdeveloper.deploy.contrib.Listener;
import oracle.jdeveloper.deploy.eventhub.EventHandler;
import oracle.jdeveloper.deploy.eventhub.EventHub;
import oracle.jdeveloper.deploy.eventhub.spi.AbstractHandle;
import oracle.jdeveloper.deploy.events.DeployerStateChange;
import oracle.jdeveloper.deploy.events.DeploymentStateChange;
import oracle.jdeveloper.deploy.shell.ShellAdapter;

public class StatefulDeployment
implements Stateful {
    private static final String KEY = StatefulDeployment.class.getName();
    private boolean initialized = false;
    private EventHub hub = EventHub.createPrivateHub();
    private int interestedParties = 0;
    private int stateListenersEnabled = 0;
    private boolean internalStateListenersEnabled = false;
    private HashMap<Object, StatefulDeployer.Handle> deployerListeners = new HashMap();
    final DeployShell shell;
    final int sequence;
    StatefulDeployer topLevelDeployer;
    StatefulDeployer.Handle topLevelDeployerListenerHandle;

    private StatefulDeployment(int sequence, DeployShell shell) {
        this.sequence = sequence;
        this.shell = shell;
    }

    public boolean isStatefulDeployment() {
        return this.interestedParties > 0;
    }

    public static StatefulDeployment getOrCreateStatefulDeployment(int sequence, DeployShell shell) {
        StatefulDeployment state = StatefulDeployment.getStatefulDeployment(shell);
        if (state == null) {
            state = new StatefulDeployment(sequence, shell);
        }
        return state;
    }

    public static StatefulDeployment findStatefulDeployment(DeployShell shell) {
        StatefulDeployment state = (StatefulDeployment)shell.find(KEY);
        return state;
    }

    public static StatefulDeployment getStatefulDeployment(DeployShell shell) {
        StatefulDeployment state = (StatefulDeployment)shell.get(KEY);
        return state;
    }

    private Object stateLockObject() {
        return this;
    }

    public StatefulDeployer getDeployer() {
        return this.topLevelDeployer;
    }

    private void incrementInterests() {
        ++this.interestedParties;
        if (this.interestedParties == 1) {
            this.shell.put(KEY, this);
            ShellAdapter.getInstance(this.shell).setStatefulDeployment(true);
        }
    }

    private void decrementInterests() {
        --this.interestedParties;
        if (this.interestedParties == 0) {
            this.shell.remove(KEY);
            ShellAdapter.getInstance(this.shell).setStatefulDeployment(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeState() throws StateException {
        Object object = this.stateLockObject();
        synchronized (object) {
            this.incrementInterests();
            boolean saved = this.internalStateListenersEnabled;
            this.disableInternalStateListeners();
            try {
                this.topLevelDeployer = (StatefulDeployer)DeploymentManager.createDeployer(this.sequence, this.shell);
                this.topLevelDeployerListenerHandle = this.topLevelDeployer.attachDisabledStateChangeListener(new DeployerListener());
            }
            catch (Exception e) {
                throw new StateException("Unable to create a Deployer", e);
            }
            this.topLevelDeployer.initializeState();
            this.fireStateChanged();
            if (saved) {
                this.enableInternalStateListeners();
            }
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateState() {
        Object object = this.stateLockObject();
        synchronized (object) {
            boolean saved = this.internalStateListenersEnabled;
            this.disableInternalStateListeners();
            this.topLevelDeployer.invalidateState();
            if (saved) {
                this.enableInternalStateListeners();
            }
            this.fireStateInvalidated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseState() {
        Object object = this.stateLockObject();
        synchronized (object) {
            boolean saved = this.internalStateListenersEnabled;
            this.disableInternalStateListeners();
            this.topLevelDeployer.releaseState();
            this.topLevelDeployer = null;
            this.topLevelDeployerListenerHandle = null;
            this.decrementInterests();
            if (saved) {
                this.enableInternalStateListeners();
            }
            this.fireStateReleased();
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Handle attachStateChangeListener(Listener<DeploymentStateChange> listener) {
        Handle handle = this.attachDisabledStateChangeListener(listener);
        handle.enable();
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handle attachDisabledStateChangeListener(Listener<DeploymentStateChange> listener) {
        Object object = this.stateLockObject();
        synchronized (object) {
            EventHub.Handle handle = this.hub.attachDisabled(DeploymentStateChange.class, listener);
            this.incrementInterests();
            return new HandleImpl(handle, false);
        }
    }

    private void decrementStateListenersEnabled() {
        --this.stateListenersEnabled;
        if (this.stateListenersEnabled == 0) {
            this.disableInternalStateListeners();
        }
    }

    private void incrementStateListenersEnabled() {
        ++this.stateListenersEnabled;
        if (this.stateListenersEnabled == 1) {
            this.enableInternalStateListeners();
        }
    }

    private boolean isStateListenersEnabled() {
        return this.stateListenersEnabled > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableInternalStateListeners() {
        Object object = this.stateLockObject();
        synchronized (object) {
            if (this.topLevelDeployerListenerHandle != null) {
                this.topLevelDeployerListenerHandle.enable();
            }
            this.internalStateListenersEnabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableInternalStateListeners() {
        Object object = this.stateLockObject();
        synchronized (object) {
            if (this.topLevelDeployerListenerHandle != null) {
                this.topLevelDeployerListenerHandle.disable();
            }
            this.internalStateListenersEnabled = false;
        }
    }

    private void fireStateChanged() {
        if (!this.isStateListenersEnabled()) {
            return;
        }
        DeploymentStateChange dispatcher = this.hub.getDispatcher(DeploymentStateChange.class);
        dispatcher.stateChanged(this);
    }

    private void fireStateInvalidated() {
        if (!this.isStateListenersEnabled()) {
            return;
        }
        DeploymentStateChange dispatcher = this.hub.getDispatcher(DeploymentStateChange.class);
        dispatcher.stateInvalidated(this);
    }

    private void fireStateReleased() {
        if (!this.isStateListenersEnabled()) {
            return;
        }
        DeploymentStateChange dispatcher = this.hub.getDispatcher(DeploymentStateChange.class);
        dispatcher.stateReleased(this);
    }

    private class DeployerListener
    implements Listener<DeployerStateChange> {
        private DeployerListener() {
        }

        @EventHandler
        public void onStateChanged(Object source) {
            StatefulDeployment.this.fireStateChanged();
        }

        @EventHandler
        public void onStateInvalidated(Object source) {
            StatefulDeployment.this.fireStateInvalidated();
        }

        @EventHandler
        public void onStateReleased(Object source) {
            assert (false);
        }
    }

    public static interface Handle
    extends EventHub.Handle {
    }

    private class HandleImpl
    extends AbstractHandle
    implements Handle {
        private HandleImpl(EventHub.Handle delegate, boolean isEnabled) {
            super(delegate, isEnabled);
        }

        @Override
        protected void handleEnabled() {
            StatefulDeployment.this.incrementStateListenersEnabled();
        }

        @Override
        protected void handleDisabled() {
            StatefulDeployment.this.decrementStateListenersEnabled();
        }

        @Override
        public void release() {
            StatefulDeployment.this.decrementInterests();
            super.release();
        }
    }
}

