/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.DependableOperationException;
import oracle.jdeveloper.deploy.DependencyStorage;
import oracle.jdeveloper.deploy.InvalidDependableException;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.ToolkitFactory;
import oracle.jdeveloper.deploy.common.Interdependency;
import oracle.jdeveloper.deploy.common.NodeDependable;
import oracle.jdeveloper.deploy.common.ProfileDependable;
import oracle.jdeveloper.deploy.spi.DataElement;
import oracle.jdeveloper.deploy.spi.DependableReader;
import oracle.jdeveloper.deploy.spi.DependableWriter;
import oracle.jdevimpl.jar.JarNode;

public class DependencyConfiguration
implements ToolkitFactory {
    private volatile DependableReader[] readers_;
    private volatile DependableWriter[] writers_;
    final Element element_;
    final Context context_;

    private DependencyConfiguration(Element element, Context context) {
        this.element_ = element;
        this.context_ = context;
    }

    public static DependencyConfiguration getInstance(DependencyStorage storage) {
        return DependencyConfiguration.getInstance(storage, Context.newIdeContext());
    }

    public static DependencyConfiguration getInstance(DependencyStorage storage, Context context) {
        return new DependencyConfiguration(DependencyConfiguration.makeElement(storage), context);
    }

    private synchronized DependableReader[] getReaders() {
        if (this.readers_ == null) {
            this.readers_ = ToolkitFactory.Utils.build(this.element_, this.context_, DependableReader.class, new DependableReader[0]);
        }
        return this.readers_;
    }

    private synchronized DependableWriter[] getWriters() {
        if (this.writers_ == null) {
            this.writers_ = ToolkitFactory.Utils.build(this.element_, this.context_, DependableWriter.class, new DependableWriter[0]);
        }
        return this.writers_;
    }

    private synchronized void invalidateReaders() {
        this.readers_ = null;
    }

    public void add(Dependable Dependable2) throws InvalidDependableException, DependableOperationException {
        for (DependableWriter w : this.getWriters()) {
            if (!w.write(Dependable2)) continue;
            this.invalidateReaders();
            return;
        }
        throw new InvalidDependableException("No Dependable writer found");
    }

    public boolean remove(Dependable dependable) {
        for (DependableWriter w : this.getWriters()) {
            if (!w.remove(dependable)) continue;
            return true;
        }
        return false;
    }

    public void removeAll() {
        for (DependableWriter w : this.getWriters()) {
            w.removeAll();
        }
    }

    public Dependable[] getDependables() {
        ArrayList<Dependable> dependables = new ArrayList<Dependable>();
        for (DependableReader r : this.getReaders()) {
            dependables.addAll(r.getAllDependables());
        }
        return dependables.toArray(new Dependable[0]);
    }

    public void setDependables(Dependable[] dependables) {
        this.removeAll();
        block0: for (Dependable p : dependables) {
            for (DependableWriter w : this.getWriters()) {
                if (!w.write(p)) continue;
                this.invalidateReaders();
                continue block0;
            }
        }
    }

    public Iterator<Dependable> iterator() {
        DependableReader[] readers = this.getReaders();
        return new DependableIterator(readers);
    }

    private static Element makeElement(DependencyStorage storage) {
        if (storage instanceof Element) {
            return (Element)storage;
        }
        return new DCDependencyStorage(storage);
    }

    public static <T extends Dependable> T[] getDependables(Interdependency interDep, Class<T> type) {
        List<Dependable> deps = DependencyConfiguration.getDependablesList(interDep, type);
        Dependable[] ret = (Dependable[])Array.newInstance(type, deps.size());
        return deps.toArray(ret);
    }

    public static ProfileDependable[] getProfileDependables(Profile profile, Class<? extends Profile> sourceClass) {
        ArrayList<ProfileDependable> ret = new ArrayList<ProfileDependable>();
        for (ProfileDependable profileDep : (ProfileDependable[])DependencyConfiguration.getDependables((Interdependency)profile, ProfileDependable.class)) {
            Profile source;
            if (!profileDep.doesExist() || !sourceClass.isAssignableFrom((source = profileDep.getProfile()).getClass())) continue;
            ret.add(profileDep);
        }
        return ret.toArray(new ProfileDependable[ret.size()]);
    }

    public static NodeDependable[] getJarDependables(Interdependency profile) {
        NodeDependable[] nodeDependables = (NodeDependable[])DependencyConfiguration.getDependables((Interdependency)profile, NodeDependable.class);
        ArrayList<NodeDependable> jarNodeDependables = new ArrayList<NodeDependable>();
        for (NodeDependable nodeDep : nodeDependables) {
            if (!(nodeDep.getNode() instanceof JarNode)) continue;
            jarNodeDependables.add(nodeDep);
        }
        return jarNodeDependables.toArray(new NodeDependable[jarNodeDependables.size()]);
    }

    public static NodeDependable[] getAllJarDependables(Interdependency interdep) {
        ArrayList<NodeDependable> seen = new ArrayList<NodeDependable>();
        ArrayList<Object> visitedNodes = new ArrayList<Object>();
        return DependencyConfiguration.getAllJarDependablesImpl(interdep, seen, visitedNodes);
    }

    private static NodeDependable[] getAllJarDependablesImpl(Interdependency interdep, ArrayList<NodeDependable> seen, ArrayList<Object> visitedNodes) {
        Dependable[] dependables;
        NodeDependable[] jarDependables;
        for (NodeDependable jarNodeDep : jarDependables = DependencyConfiguration.getJarDependables(interdep)) {
            if (seen.contains(jarNodeDep)) continue;
            seen.add(jarNodeDep);
        }
        for (Dependable dep : dependables = DependencyConfiguration.getDependables((Interdependency)interdep, Dependable.class)) {
            Element src = dep.getSource();
            if (src instanceof Interdependency && visitedNodes.contains(src)) continue;
        }
        return seen.toArray(new NodeDependable[seen.size()]);
    }

    public static <T extends Dependable> List<T> getDependablesList(Interdependency interDep, Class<T> type) {
        ArrayList<Dependable> deps = new ArrayList<Dependable>();
        Iterator<Dependable> iter = interDep.getDependencies();
        while (iter.hasNext()) {
            Dependable dep = iter.next();
            if (!type.isAssignableFrom(dep.getClass())) continue;
            deps.add(dep);
        }
        return deps;
    }

    public static void setDependencies(Interdependency interDep, Dependable[] dependables) {
        DependencyConfiguration.setDependencies((Interdependency)interDep, (Dependable[])dependables, Dependable.class);
    }

    public static <T extends Dependable> T[] setDependencies(Interdependency interDep, T[] dependables, Class<T> clazz) {
        Assert.check((interDep != null ? 1 : 0) != 0, (String)"InterDep cannot be null");
        Assert.check((dependables != null ? 1 : 0) != 0, (String)"Dependables cannot be null, use clearDependables() instead");
        Dependable[] cleared = DependencyConfiguration.clearDependencies((Interdependency)interDep, clazz);
        for (T dep : dependables) {
            interDep.addDependency((Dependable)dep);
        }
        return cleared;
    }

    public static <T extends Dependable> T[] clearDependencies(Interdependency interDep, Class<T> clazz) {
        Dependable[] allDependants;
        for (Dependable dep : allDependants = DependencyConfiguration.getDependables((Interdependency)interDep, clazz)) {
            interDep.removeDependency(dep);
        }
        return allDependants;
    }

    private static class DependableIterator
    implements Iterator {
        final DependableReader[] readers_;
        int index_ = 0;
        Dependable Dependable_ = null;
        boolean read_ = false;
        boolean resetIter_ = true;
        Iterator<Dependable> iter_ = null;

        DependableIterator(DependableReader[] readers) {
            this.readers_ = readers;
        }

        @Override
        public boolean hasNext() {
            if (!this.read_) {
                this.read_ = this.read();
            }
            return this.read_;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("Iteration error");
            }
            Dependable t = this.Dependable_;
            this.Dependable_ = null;
            this.read_ = false;
            return t;
        }

        @Override
        public void remove() {
        }

        boolean read() {
            while (this.index_ < this.readers_.length) {
                if (this.resetIter_) {
                    this.iter_ = this.readers_[this.index_].iterator();
                    this.resetIter_ = false;
                }
                if (this.iter_.hasNext()) {
                    this.Dependable_ = this.iter_.next();
                    return true;
                }
                ++this.index_;
                this.resetIter_ = true;
            }
            return false;
        }
    }

    private static class DCDependencyStorage
    extends DataElement
    implements DependencyStorage {
        DCDependencyStorage(DependencyStorage storage) {
            super(storage);
        }

        @Override
        public HashStructure getHashStructure() {
            return ((DependencyStorage)this.getData()).getHashStructure();
        }
    }
}

