/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.transform;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.transform.HereFunctionDOMXPath;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XSTransformer;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.util.XPathException;
import org.jaxen.JaxenException;
import org.jaxen.dom.NamespaceNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XPathFilter
extends XSTransformer {
    private static final boolean xmlDebugXPath = System.getProperty("xml.debug.xpath") != null;
    private Node param;
    private Node xpNode;
    private String xpString;

    public XPathFilter(XSAlgorithmIdentifier trans) {
        super(trans);
        if (!"http://www.w3.org/TR/1999/REC-xpath-19991116".equals(trans.getAlgorithm())) {
            throw new IllegalArgumentException("XPath filter Transform required");
        }
        NodeList pList = trans.getParameters();
        if (pList.getLength() != 1) {
            throw new IllegalArgumentException("Illegal Transform parameter");
        }
        this.param = pList.item(0);
        this.xpString = XMLUtils.collectText(this.param).trim();
        if (this.xpString == null || this.xpString.length() == 0) {
            throw new IllegalArgumentException("Bad or missing XPath filter expression");
        }
        NodeList xpList = this.param.getChildNodes();
        int x = xpList.getLength();
        for (int i = 0; i < x && this.xpNode == null; ++i) {
            Node n = xpList.item(i);
            if (n.getNodeType() != 3) continue;
            this.xpNode = this.param.getFirstChild();
        }
    }

    public String getXPath() {
        return this.xpString;
    }

    public static Set applyXPath(String xpathStr, Set nodeSet, Node nsNode, Node xpathNode) throws XPathException {
        boolean USE_OLDC14N;
        boolean bl = USE_OLDC14N = System.getProperty("osdt.useOldC14n") != null;
        if (xmlDebugXPath) {
            System.err.println("\n+++ XPathFilter.applyXPath(String xpathStr, NodeList nodes, Node nsNode, Node ownerNode)");
        }
        if (nodeSet == null) {
            throw new XPathException("Missing input");
        }
        if (nodeSet.size() == 0) {
            return new LinkedHashSet(0);
        }
        if (xmlDebugXPath) {
            System.err.println("+++    BEGIN input node-set");
            System.err.println(XMLUtils.toStringNodes(nodeSet).replace(',', '\n'));
            System.err.println("+++    END   input node-set");
            System.err.println("+++    BEGIN XPath predicate");
            System.err.println(xpathStr);
            System.err.println("+++    END   XPath predicate");
        }
        LinkedHashSet<Node> result = new LinkedHashSet<Node>();
        try {
            HereFunctionDOMXPath xpath = new HereFunctionDOMXPath(xpathStr);
            xpath.setNamespaceContext(XMLUtils.createNamespaceContext(nsNode));
            xpath.setXPathNode(xpathNode);
            for (Node context : nodeSet) {
                Attr attr;
                String attrName;
                if (USE_OLDC14N && context.getNodeType() == 2 && (attrName = (attr = (Attr)context).getName()).startsWith("xmlns")) {
                    String attrValue = attr.getValue();
                    String nsPrefix = attrName.equals("xmlns") ? "" : QName.getLocalPart(attrName);
                    Element parent = attr.getOwnerElement();
                    if (parent == null) {
                        throw new XPathException("Bad or missing parent for attribute " + XMLUtils.toStringNode(attr));
                    }
                    context = new NamespaceNode((Node)parent, nsPrefix, attrValue);
                }
                boolean include = xpath.booleanValueOf(context);
                if (xmlDebugXPath && include) {
                    System.err.println("include " + XMLUtils.toStringNode(context) + "\n    xpath=" + xpath.selectNodes(context));
                }
                if (!include) continue;
                result.add(context);
            }
        }
        catch (JaxenException ex) {
            throw new XPathException(ex);
        }
        if (xmlDebugXPath) {
            System.err.println("+++    BEGIN result node-set");
            System.err.println(XMLUtils.toStringNodes(result).replace(',', '\n'));
            System.err.println("+++    END   result node-set");
        }
        return result;
    }

    @Override
    public String getAlgorithmURI() {
        return "http://www.w3.org/TR/1999/REC-xpath-19991116";
    }

    @Override
    public XMLContainer transform(XMLContainer source) throws TransformationException {
        try {
            Set nodeSet = source.getNodeSet();
            if (nodeSet != null) {
                return new XMLContainer(XPathFilter.applyXPath(this.xpString, nodeSet, this.param, this.xpNode));
            }
            return new XMLContainer();
        }
        catch (IOException ex) {
            throw new TransformationException(ex);
        }
        catch (SAXException ex) {
            throw new TransformationException(ex);
        }
        catch (XPathException ex) {
            throw new TransformationException(ex);
        }
    }
}

