/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.enc.XECipherException;
import oracle.security.xmlsec.keys.KeyDerivationParams;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.URIManager;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PBKDF2params
extends KeyDerivationParams {
    private static final String[] nsURIs = new String[]{"http://www.w3.org/2009/xmlenc11#", "http://www.w3.org/2009/xmlenc11#", "http://www.w3.org/2009/xmlenc11#", "http://www.w3.org/2009/xmlenc11#"};
    private static final String[] localNames = new String[]{"Salt", "IterationCount", "KeyLength", "PRF"};

    public PBKDF2params(Document owner, String systemId) throws DOMException {
        super(owner, "http://www.w3.org/2009/xmlenc11#", "PBKDF2-params", systemId);
    }

    public PBKDF2params(Document owner) throws DOMException {
        this(owner, null);
    }

    public PBKDF2params(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public PBKDF2params(Element element) throws DOMException {
        super(element);
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2009/xmlenc11#pbkdf2";
    }

    public int getIterationCount() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2009/xmlenc11#", "IterationCount");
        if (nList.getLength() != 0) {
            return Integer.parseInt(XMLUtils.collectText(nList.item(0)));
        }
        return 0;
    }

    public void setIterationCount(int val) {
        XMLUtils.insertChildElementWithText(this, "http://www.w3.org/2009/xmlenc11#", "IterationCount", nsURIs, localNames, Integer.toString(val), true);
    }

    public int getKeyLength() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2009/xmlenc11#", "KeyLength");
        if (nList.getLength() != 0) {
            return Integer.parseInt(XMLUtils.collectText(nList.item(0)));
        }
        return 0;
    }

    public void setKeyLength(int val) {
        XMLUtils.insertChildElementWithText(this, "http://www.w3.org/2009/xmlenc11#", "KeyLength", nsURIs, localNames, Integer.toString(val), true);
    }

    public byte[] getSalt() {
        Element saltElem;
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2009/xmlenc11#", "Salt");
        if (nList.getLength() != 0 && (nList = XMLElement.getChildElementsByTagNameNS(saltElem = (Element)nList.item(0), "http://www.w3.org/2009/xmlenc11#", "Specified")).getLength() != 0) {
            return Base64.fromBase64(XMLUtils.collectText(nList.item(0)));
        }
        return null;
    }

    public void setSalt(byte[] val) {
        Document doc = this.getOwnerDocument();
        Element saltElem = doc.createElementNS("http://www.w3.org/2009/xmlenc11#", "Salt");
        Element specifiedElem = doc.createElementNS("http://www.w3.org/2009/xmlenc11#", "Specified");
        saltElem.appendChild(specifiedElem);
        specifiedElem.appendChild(doc.createTextNode(Base64.toBase64(val, false)));
        XMLUtils.copyNSPrefix((Element)this.getNode(), saltElem);
        XMLUtils.copyNSPrefix((Element)this.getNode(), specifiedElem);
        XMLUtils.removeChildren((Element)this.getNode(), "http://www.w3.org/2009/xmlenc11#", "Salt");
        XMLUtils.insertChild((Element)this.getNode(), saltElem, nsURIs, localNames);
    }

    public XSAlgorithmIdentifier getPRF() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2009/xmlenc11#", "PRF");
        if (nList.getLength() != 0) {
            Element prfElem = (Element)nList.item(0);
            return new XSAlgorithmIdentifier((Element)nList.item(0), this.systemId);
        }
        return null;
    }

    public void setPRF(String prf) {
        this.setPRF(new XSAlgorithmIdentifier(this.getOwnerDocument(), "http://www.w3.org/2009/xmlenc11#", "PRF", prf));
    }

    public void setPRF(XSAlgorithmIdentifier prf) {
        XMLUtils.copyNSPrefix((Element)this.getNode(), prf.getElement());
        XMLUtils.removeChildren((Element)this.getNode(), "http://www.w3.org/2009/xmlenc11#", "PRF");
        XMLUtils.insertChild((Element)this.getNode(), prf.getElement(), nsURIs, localNames);
    }

    @Override
    public byte[] deriveKey(byte[] secret, int dkLen) throws XECipherException {
        Mac md;
        try {
            md = Mac.getInstance(URIManager.getURIManager().getJCEAlgorithm(this.getPRF().getAlgorithm()));
            md.init(new SecretKeySpec(secret, "HMAC"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new XECipherException(e);
        }
        catch (InvalidKeyException e) {
            throw new XECipherException(e);
        }
        int hLen = md.getMacLength();
        int l = (dkLen + hLen - 1) / hLen;
        int r = dkLen - (l - 1) * hLen;
        int c = this.getIterationCount();
        byte[] generatedKey = new byte[dkLen];
        for (int i = 0; i < l; ++i) {
            byte[] T = null;
            for (int j = 0; j < c; ++j) {
                if (j == 0) {
                    md.update(this.getSalt());
                    md.update(Utils.wordToBytes((int)i));
                } else {
                    md.update(T);
                }
                T = md.doFinal();
            }
            if (i < l - 1) {
                System.arraycopy(T, 0, generatedKey, i * hLen, hLen);
                continue;
            }
            System.arraycopy(T, 0, generatedKey, i * hLen, r);
        }
        return generatedKey;
    }

    @Override
    public void setToDefaultParameters() {
        SecureRandom sr = new SecureRandom();
        byte[] nonce = new byte[16];
        sr.nextBytes(nonce);
        this.setSalt(nonce);
        this.setIterationCount(2000);
        this.setKeyLength(16);
        this.setPRF("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256");
    }
}

