/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.util.MetaClass;
import oracle.ide.javaxide.Util;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryProperty;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.history.HistoryFilter;
import oracle.jdeveloper.history.HistoryProvider;

public final class HistoryProviderHook
extends ExtensionHook {
    public static final String HISTORY_PROVIDER_HOOK = "history-provider-hook";
    private static final String NS = "http://xmlns.oracle.com/ide/extension";
    private static final ElementName PROVIDER_CLASS = new ElementName("http://xmlns.oracle.com/ide/extension", "provider-class");
    private static final ElementName PROVIDER_IDENTIFIER = new ElementName("http://xmlns.oracle.com/ide/extension", "provider-identifer");
    private static final String KEY_PROVIDER = "history-provider";
    private final ElementVisitor _providerClassHandler = new ProviderClassHandler();
    private final ElementVisitor _providerIdentifierHandler = new ProviderIdentifierHandler();
    private Collection<HistoryProvider> _providers = new ArrayList<HistoryProvider>();

    public void start(ElementStartContext context) {
        context.registerChildVisitor(PROVIDER_IDENTIFIER, this._providerIdentifierHandler);
        context.registerChildVisitor(PROVIDER_CLASS, this._providerClassHandler);
        context.getScopeData().put(KEY_PROVIDER, new Pair());
    }

    public void end(ElementEndContext context) {
        Pair provider = (Pair)context.getScopeData().get(KEY_PROVIDER);
        this._providers.add(new MetaClassHistoryProvider((String)provider.getFirst(), (MetaClass)provider.getSecond()));
    }

    public Collection<HistoryProvider> getProviders() {
        return this._providers;
    }

    private final class ProviderClassHandler
    extends MetaClassVisitor {
        private ProviderClassHandler() {
        }

        protected void metaClass(ElementContext context, MetaClass mc) {
            Pair provider = (Pair)context.getScopeData().get(HistoryProviderHook.KEY_PROVIDER);
            provider.setSecond((Object)mc);
        }
    }

    private static class ProviderIdentifierHandler
    extends ElementVisitor {
        private ProviderIdentifierHandler() {
        }

        public void end(ElementEndContext context) {
            Pair provider = (Pair)context.getScopeData().get(HistoryProviderHook.KEY_PROVIDER);
            provider.setFirst((Object)context.getText());
        }
    }

    private final class MetaClassHistoryProvider
    extends HistoryProvider {
        private final MetaClass _metaClass;
        private final String _id;
        private HistoryProvider _delegate;

        MetaClassHistoryProvider(String id, MetaClass metaClass) {
            this._id = id;
            this._metaClass = metaClass;
        }

        @Override
        public String getIdentifer() {
            this.createDelegate();
            return this._delegate.getIdentifer();
        }

        @Override
        public HistoryEntry[] getEntries(URL url, HistoryFilter filter) {
            this.createDelegate();
            return this._delegate.getEntries(url, filter);
        }

        @Override
        public HistoryProperty[] getProperties() {
            this.createDelegate();
            return this._delegate.getProperties();
        }

        @Override
        public HistoryFilter getTypeFilter() {
            this.createDelegate();
            return this._delegate.getTypeFilter();
        }

        @Override
        public boolean isProviderFor(URL url) {
            this.createDelegate();
            return this._delegate.isProviderFor(url);
        }

        @Override
        public HistoryFilter[] getPredefinedFilters() {
            this.createDelegate();
            return this._delegate.getPredefinedFilters();
        }

        private final void createDelegate() {
            if (this._delegate != null) {
                return;
            }
            this._delegate = (HistoryProvider)Util.createInstance((MetaClass)this._metaClass, HistoryProvider.class);
            if (this._delegate == null) {
                this._delegate = new HistoryProvider(){

                    @Override
                    public HistoryEntry[] getEntries(URL url, HistoryFilter filter) {
                        return new HistoryEntry[0];
                    }

                    @Override
                    public HistoryProperty[] getProperties() {
                        return new HistoryProperty[0];
                    }

                    @Override
                    public HistoryFilter getTypeFilter() {
                        return null;
                    }

                    @Override
                    public boolean isProviderFor(URL url) {
                        return false;
                    }

                    @Override
                    public HistoryFilter[] getPredefinedFilters() {
                        return super.getPredefinedFilters();
                    }
                };
            } else {
                this._delegate.setIdentifier(this._id);
            }
        }
    }
}

