/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

public class ByteOrderMarkSkippingReader
extends FilterReader {
    private final PushbackReader _pushbackReader;
    private volatile boolean _initialized = false;
    private Object _initializationLock = new Object();
    private static final char _BOM_BE = '\ufeff';
    private static final char _BOM_LE = '\ufffe';

    public static Reader createByteOrderMarkSkippingReader(Reader reader) {
        PushbackReader pushbackReader = new PushbackReader(reader, 1);
        return new ByteOrderMarkSkippingReader(pushbackReader);
    }

    @Override
    public int read() throws IOException {
        this._checkInit();
        return super.read();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this._checkInit();
        return super.read(cbuf, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this._checkInit();
        return super.skip(n);
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this._checkInit();
        super.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this._initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _checkInit() throws IOException {
        if (!this._initialized) {
            Object object = this._initializationLock;
            synchronized (object) {
                if (!this._initialized) {
                    char[] firstChar = new char[1];
                    int charsRead = this._pushbackReader.read(firstChar, 0, 1);
                    if (charsRead == 1 && !this._isBOMChar(firstChar[0])) {
                        this._pushbackReader.unread(firstChar, 0, 1);
                    }
                    this._initialized = true;
                }
            }
        }
    }

    private final boolean _isBOMChar(char c) {
        return '\ufeff' == c || '\ufffe' == c;
    }

    private ByteOrderMarkSkippingReader(PushbackReader pushbackReader) {
        super(pushbackReader);
        this._pushbackReader = pushbackReader;
    }
}

